/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.QuickdrawTextFunctions;
import com.apple.mrj.macos.generated.TERecStruct;
import com.apple.mrj.macos.generated.TEStyleRecStruct;
import com.apple.mrj.macos.generated.TextEditConstants;
import com.apple.mrj.macos.generated.TextEditFunctions;
import com.apple.mrj.macos.toolbox.CharsHandle;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.Handle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.StringPtr;
import com.apple.mrj.macos.toolbox.ToolboxObject;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.WindowRef;

public class TEHandle
implements ToolboxObject,
TextEditConstants {
    TERecStruct data;
    Object owner;
    private boolean visible = true;
    private static Object theTENewLock = new Object();

    TERecStruct getTEHandle() {
        return this.data;
    }

    int getHandleValue() {
        return this.data.getHandle();
    }

    public Rect getDestRect() {
        return new Rect(this.data.getDestRect());
    }

    public void setDestRect(Rect rect) {
        this.data.setDestRect(rect.getRect());
    }

    public Rect getViewRect() {
        return new Rect(this.data.getViewRect());
    }

    public void setViewRect(Rect rect) {
        this.data.setViewRect(rect.getRect());
    }

    public Rect getSelRect() {
        return new Rect(this.data.getSelRect());
    }

    public short getLineHeight() {
        return this.data.getLineHeight();
    }

    public short getFontAscent() {
        return this.data.getFontAscent();
    }

    public short getSelStart() {
        return this.data.getSelStart();
    }

    public short getSelEnd() {
        return this.data.getSelEnd();
    }

    public short getTeLength() {
        return this.data.getTeLength();
    }

    public short getTxSize() {
        return this.data.getTxSize();
    }

    public WindowRef getWindowRef() {
        return new WindowRef(this.data.getInPort());
    }

    public short getNLines() {
        return this.data.getNLines();
    }

    public boolean hitTest(Point point) {
        return this.getViewRect().contains(point);
    }

    public DataPointer getLineStarts() {
        return new DataPointer(this.data.getLineStarts(0), this.getNLines());
    }

    public short getLineStart(int n) {
        return this.data.getLineStarts(n);
    }

    private static TERecStruct safeNew(Rect rect, Rect rect2, boolean bl, WindowRef windowRef) {
        int n;
        Object object = theTENewLock;
        synchronized (object) {
            windowRef.setPort();
            n = bl ? TextEditFunctions.TEStyleNew(rect.getRect(), rect2.getRect()) : TextEditFunctions.TENew(rect.getRect(), rect2.getRect());
        }
        return new TERecStruct(n);
    }

    private static TERecStruct safeNew(Rect rect, boolean bl, WindowRef windowRef) {
        Rect rect2 = new Rect(rect);
        rect2.inset((short)4, (short)-1);
        return TEHandle.safeNew(rect2, rect, bl, windowRef);
    }

    public TEHandle(Rect rect, Rect rect2, boolean bl, WindowRef windowRef) {
        this(TEHandle.safeNew(rect, rect2, bl, windowRef));
    }

    public TEHandle(Rect rect, boolean bl, WindowRef windowRef) {
        this(TEHandle.safeNew(rect, bl, windowRef));
    }

    protected TEHandle(TERecStruct tERecStruct) {
        this.data = tERecStruct;
    }

    public void dispose() {
        if (this.owner == null && this.getTEHandle() != null && this.getHandleValue() != 0) {
            TextEditFunctions.TEDispose(this.getTEHandle());
        }
        this.data = null;
    }

    public void activate() {
        TextEditFunctions.TEActivate(this.getTEHandle());
    }

    public void deactivate() {
        TextEditFunctions.TEDeactivate(this.getTEHandle());
    }

    public void key(short s) {
        TextEditFunctions.TEKey(s, this.getTEHandle());
    }

    public void setText(byte[] byArray, int n) {
        TextEditFunctions.TESetText(byArray, n, this.getTEHandle());
    }

    public void setText(String string) {
        this.setText(TranslateString.asBytes(string), string.length());
    }

    public CharsHandle getText() {
        return new CharsHandle(TextEditFunctions.TEGetText(this.getTEHandle()));
    }

    public String getTextAsString() {
        CharsHandle charsHandle = this.getText();
        return new String(charsHandle.getBytes(), 0, 0, (int)this.getTeLength());
    }

    public void setStyleHandle(TEStyleRecStruct tEStyleRecStruct) {
        TextEditFunctions.TESetStyleHandle(tEStyleRecStruct, this.getTEHandle());
    }

    public TEStyleRecStruct getStyleHandle() {
        return new TEStyleRecStruct(TextEditFunctions.TEGetStyleHandle(this.getTEHandle()));
    }

    public void idle() {
        TextEditFunctions.TEIdle(this.getTEHandle());
    }

    public void click(Point point, boolean bl) {
        TextEditFunctions.TEClick(point.getPoint(), bl, this.getTEHandle());
    }

    public void setSelect(int n, int n2) {
        TextEditFunctions.TESetSelect(n, n2, this.getTEHandle());
    }

    public void setAlignment(short s) {
        TextEditFunctions.TESetAlignment(s, this.getTEHandle());
    }

    public void update(Rect rect) {
        TextEditFunctions.TEUpdate(rect.getRect(), this.getTEHandle());
    }

    public void update(Region region) {
        this.update(region.getBounds());
    }

    public void draw() {
        this.update(this.getViewRect());
    }

    public static void textBox(StringPtr stringPtr, int n, Rect rect, short s) {
        TEHandle.textBox(stringPtr.getBytes(), n, rect, s);
    }

    public static void textBox(byte[] byArray, int n, Rect rect, short s) {
        TextEditFunctions.TETextBox(byArray, n, rect.getRect(), s);
    }

    public void calText() {
        TextEditFunctions.TECalText(this.getTEHandle());
    }

    public int getHeight(int n, int n2) {
        return TextEditFunctions.TEGetHeight(n, n2, this.getTEHandle());
    }

    public void scroll(short s, short s2) {
        TextEditFunctions.TEScroll(s, s2, this.getTEHandle());
    }

    public void pinScroll(short s, short s2) {
        TextEditFunctions.TEPinScroll(s, s2, this.getTEHandle());
    }

    public void autoView(boolean bl) {
        TextEditFunctions.TEAutoView(bl, this.getTEHandle());
    }

    public void selView() {
        TextEditFunctions.TESelView(this.getTEHandle());
    }

    public void delete() {
        TextEditFunctions.TEDelete(this.getTEHandle());
    }

    public void insert(byte[] byArray, int n) {
        TextEditFunctions.TEInsert(byArray, n, this.getTEHandle());
    }

    public void insert(String string) {
        this.insert(TranslateString.asBytes(string), string.length());
    }

    public void cut() {
        TextEditFunctions.TECut(this.getTEHandle());
    }

    public void copy() {
        TextEditFunctions.TECopy(this.getTEHandle());
    }

    public void paste() {
        TextEditFunctions.TEPaste(this.getTEHandle());
    }

    public void stylePaste() {
        TextEditFunctions.TEStylePaste(this.getTEHandle());
    }

    public static short toScrap() {
        return TextEditFunctions.TEToScrap();
    }

    public static short fromScrap() {
        return TextEditFunctions.TEFromScrap();
    }

    public static Handle getScrapHandle() {
        return new Handle(TextEditFunctions.TEScrapHandle(), null);
    }

    public static int getScrapLength() {
        return TextEditFunctions.TEGetScrapLength();
    }

    public static void setScrapLength(int n) {
        TextEditFunctions.TESetScrapLength(n);
    }

    public short getOffset(Point point) {
        return TextEditFunctions.TEGetOffset(point.getPoint(), this.getTEHandle());
    }

    public short featureFlag(short s, short s2) {
        return TextEditFunctions.TEFeatureFlag(s, s2, this.getTEHandle());
    }

    public Point getOrigin() {
        return this.getViewRect().topLeft();
    }

    public Rect getBounds() {
        return this.getViewRect();
    }

    public void setBounds(Rect rect) {
        Rect rect2 = this.getViewRect();
        Rect rect3 = this.getDestRect();
        this.getWindowRef().inval(rect2);
        rect3.offset((short)(rect.getLeft() - rect2.getLeft()), (short)(rect.getTop() - rect2.getTop()));
        rect3.setBottom(rect3.getBottom() + (rect.getHeight() - rect2.getHeight()));
        rect3.setRight(rect3.getRight() + (rect.getWidth() - rect2.getWidth()));
        rect2.set(rect);
        this.setViewRect(rect2);
        this.setDestRect(rect3);
        this.calText();
        this.getWindowRef().valid(rect2);
        this.draw();
    }

    public void move(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().inval(rect);
        rect.erase();
        rect.offset(s, s2);
        rect2.offset(s, s2);
        this.getWindowRef().valid(rect);
        this.draw();
    }

    public void size(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().inval(rect);
        if (s != 0) {
            rect.setRight(rect.getRight() + s);
            rect2.setRight(rect2.getRight() + s);
        }
        if (s2 != 0) {
            rect.setBottom(rect.getRight() + s2);
            rect2.setBottom(rect2.getRight() + s2);
        }
        this.calText();
        this.getWindowRef().valid(rect);
        this.draw();
    }

    public int calcMaxWidth() {
        CharsHandle charsHandle = this.getText();
        int n = this.getNLines();
        short s = 0;
        charsHandle.hLock();
        DataPointer dataPointer = charsHandle.getPtr(charsHandle.getSize());
        int n2 = 0;
        while (n2 < n) {
            short s2 = this.getLineStart(n2);
            short s3 = n2 < n ? this.getLineStart(n2 + 1) : this.getTeLength();
            short s4 = QuickdrawTextFunctions.TextWidth(dataPointer.getPointer(), s2, (short)(s3 - s2));
            if (s4 > s) {
                s = s4;
            }
            ++n2;
        }
        charsHandle.hUnlock();
        return s + 10;
    }

    public void isVisible(boolean bl) {
        if (!bl && this.visible) {
            this.getViewRect().erase();
        }
        if (bl && !this.visible) {
            this.draw();
        }
        this.visible = bl;
    }

    public void isHilited(boolean bl) {
        if (bl) {
            this.activate();
        } else {
            this.deactivate();
        }
    }
}

