/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.ByteArrayStruct;
import com.apple.mrj.macos.generated.QuickdrawTextFunctions;
import com.apple.mrj.macos.generated.StringCompareFunctions;
import com.apple.mrj.macos.generated.TextUtilFunctions;
import com.apple.mrj.macos.generated.TypesFunctions;
import com.apple.mrj.macos.toolbox.Handle;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.TextUtilities;
import com.apple.mrj.macos.toolbox.TranslateString;

public class StringPtr
extends ByteArrayStruct {
    private short scriptCode = TextUtilities.SystemFontScript;

    public StringPtr(int n) {
        super(n > 256 ? 256 : n);
    }

    public StringPtr(String string) {
        this(TranslateString.asPascalBytes(string));
    }

    public StringPtr(String string, boolean bl) {
        this(TranslateString.asPascalBytes(string, new short[1], bl));
    }

    public StringPtr(String string, short[] sArray, boolean bl) {
        this(TranslateString.asPascalBytes(string, sArray, bl));
        this.scriptCode = sArray[0];
    }

    protected StringPtr(String string, int n, boolean bl) {
        this(n);
        this.setString(string, bl);
    }

    protected StringPtr(String string, short[] sArray, int n, boolean bl) {
        this(n);
        this.scriptCode = TranslateString.setStringPtr(this, string, sArray, bl);
    }

    protected StringPtr(StringPtr stringPtr, int n) {
        this(Math.max(n, stringPtr.length()));
        this.setBytesAt(0, stringPtr.bytes);
        this.scriptCode = stringPtr.scriptCode;
    }

    public StringPtr(byte[] byArray) {
        super(byArray.length);
        this.setBytesAt(0, byArray);
    }

    public final int length() {
        return this.bytes[0];
    }

    public final void setLengthByte(byte by) {
        byte[] byArray = this.getByteArray();
        byArray[0] = by;
    }

    public final void putByteAt(int n, byte by) {
        byte[] byArray = this.getByteArray();
        byArray[n] = by;
    }

    public void setScript(short s) {
        this.scriptCode = s;
    }

    public short getScript() {
        return this.scriptCode;
    }

    public final String asString() {
        return TranslateString.asString(this.bytes, (short)1, (short)(this.bytes[0] + 1), this.scriptCode);
    }

    public final String toString() {
        return this.asString();
    }

    public final void setString(String string, boolean bl) {
        this.scriptCode = TranslateString.setStringPtr(this, string, bl);
    }

    public void draw() {
        QuickdrawTextFunctions.DrawString(this.bytes);
    }

    public void debugStr() {
        TypesFunctions.DebugStr(this.bytes);
    }

    public int width() {
        return QuickdrawTextFunctions.StringWidth(this.bytes);
    }

    public boolean equalString(Str255 str255, boolean bl, boolean bl2) {
        return StringCompareFunctions.EqualString(this.getBytes(), str255.getBytes(), bl, bl2);
    }

    public short identicalString(Str255 str255, Handle handle) {
        return StringCompareFunctions.IUEqualPString(this.getBytes(), str255.getBytes(), handle.getHandle());
    }

    public short stringOrder(Str255 str255, short s, short s2, short s3, short s4) {
        return StringCompareFunctions.IUStringOrder(this.getBytes(), str255.getBytes(), s, s2, s3, s4);
    }

    public short relString(Str255 str255, boolean bl, boolean bl2) {
        return StringCompareFunctions.RelString(this.getBytes(), str255.getBytes(), bl, bl2);
    }

    public short compareString(Str255 str255, Handle handle) {
        return StringCompareFunctions.IUCompPString(this.getBytes(), str255.getBytes(), handle.getHandle());
    }

    public void upperString(boolean bl) {
        TextUtilFunctions.UpperString(this.getByteArray(), bl);
    }

    public short truncString(short s, short s2) {
        return TextUtilFunctions.TruncString(s, this.getByteArray(), s2);
    }
}

