/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ControlActionClosureUPP;
import com.apple.mrj.macos.toolbox.ActionUPP;
import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.ScrollPaneComponent;
import com.apple.mrj.macos.toolbox.Str255;

class ScrollPane {
    protected ControlHandle hScroll;
    protected ControlHandle vScroll;
    protected boolean hasBorder;
    protected Rect boundsRect;
    protected ControlActionClosureUPP hActionUPP;
    protected ControlActionClosureUPP vActionUPP;
    protected ScrollPaneComponent myComponent;

    ScrollPane(ScrollPaneComponent scrollPaneComponent, Rect rect, boolean bl, boolean bl2, ControlActionClosureUPP controlActionClosureUPP, ControlActionClosureUPP controlActionClosureUPP2, boolean bl3) {
        this.myComponent = scrollPaneComponent;
        this.hasBorder = bl3;
        this.boundsRect = new Rect(rect);
        if (bl) {
            this.createHScrollBar(controlActionClosureUPP);
        }
        if (bl2) {
            this.createVScrollBar(controlActionClosureUPP2);
        }
    }

    ScrollPane(ScrollPaneComponent scrollPaneComponent, Rect rect, boolean bl, boolean bl2, boolean bl3) {
        this(scrollPaneComponent, rect, bl, bl2, null, null, bl3);
    }

    public boolean hasHScroll() {
        return this.hScroll != null;
    }

    public boolean hasVScroll() {
        return this.vScroll != null;
    }

    public void isHilited(boolean bl) {
        if (this.hasHScroll()) {
            this.hScroll.isHilited(bl);
        }
        if (this.hasVScroll()) {
            this.vScroll.isHilited(bl);
        }
    }

    public void isVisible(boolean bl) {
        if (this.hasHScroll()) {
            this.hScroll.isVisible(bl);
        }
        if (this.hasVScroll()) {
            this.vScroll.isVisible(bl);
        }
    }

    protected short vScrollValue() {
        return this.hasVScroll() ? this.vScroll.getValue() : (short)0;
    }

    protected void vScrollValue(short s) {
        if (this.hasVScroll()) {
            this.vScroll.setValue(s);
        }
    }

    protected short hScrollValue() {
        return this.hasHScroll() ? this.hScroll.getValue() : (short)0;
    }

    protected void hScrollValue(short s) {
        if (this.hasHScroll()) {
            this.hScroll.setValue(s);
        }
    }

    public void drawBorder() {
        if (this.hasBorder) {
            this.myComponent.getWindowRef().frame(this.boundsRect);
        }
    }

    public void draw() {
        this.drawBorder();
        if (this.hasHScroll()) {
            this.hScroll.draw();
        }
        if (this.hasVScroll()) {
            this.vScroll.draw();
        }
    }

    public boolean hitTest(Point point) {
        return this.boundsRect.contains(point);
    }

    private Rect calcHScrollBoundsFor(Rect rect) {
        Rect rect2 = new Rect(rect);
        if (this.hasVScroll() || this.myComponent.getWindowRef().inGrowZone(rect.bottomRight())) {
            rect2.setRight((short)(rect2.getRight() - 15));
            rect2.setBottom(rect2.getBottom());
        }
        rect2.setTop((short)(rect2.getBottom() - 16));
        return rect2;
    }

    private Rect calcVScrollBoundsFor(Rect rect) {
        Rect rect2 = new Rect(rect);
        if (this.hasHScroll() || this.myComponent.getWindowRef().inGrowZone(rect.bottomRight())) {
            rect2.setBottom((short)(rect2.getBottom() - 15));
            rect2.setRight(rect2.getRight());
        }
        rect2.setLeft((short)(rect2.getRight() - 16));
        return rect2;
    }

    public Rect getBounds() {
        return this.boundsRect;
    }

    public Rect setBounds(Rect rect) {
        this.boundsRect.erase();
        this.boundsRect.set(rect);
        if (this.hasVScroll()) {
            this.vScroll.setBounds(this.calcVScrollBoundsFor(rect));
        }
        if (this.hasHScroll()) {
            this.hScroll.setBounds(this.calcHScrollBoundsFor(rect));
        }
        return this.calcViewRect();
    }

    protected void adjustScrollBar(ControlHandle controlHandle, boolean bl, boolean bl2) {
        int n;
        Rect rect = this.myComponent.getViewRect();
        Rect rect2 = this.myComponent.getDestRect();
        short s = controlHandle.getValue();
        short s2 = controlHandle.getMaximum();
        int n2 = this.myComponent.getScrollMax(rect, rect2, bl);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != s2) {
            controlHandle.setMaximum((short)n2);
        }
        if ((n = bl ? rect.getTop() - rect2.getTop() : rect.getLeft() - rect2.getLeft()) < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        if (n != s) {
            controlHandle.setValue((short)n);
        }
        if (bl2) {
            controlHandle.draw();
        }
    }

    public Rect calcViewRect() {
        Rect rect = new Rect(this.boundsRect);
        rect.inset((short)1, (short)1);
        if (this.hasHScroll()) {
            rect.setBottom(rect.getBottom() - 15);
        }
        if (this.hasVScroll()) {
            rect.setRight(rect.getRight() - 15);
        }
        return rect;
    }

    public void click(Point point) {
        if (this.hasHScroll() && this.hScroll.hitTest(point)) {
            this.hScroll.track(point, this.hActionUPP);
        } else if (this.hasVScroll() && this.vScroll.hitTest(point)) {
            this.vScroll.track(point, this.vActionUPP);
        }
        this.myComponent.adjustContentsForScrollBars(this.hScroll, this.vScroll);
    }

    protected void createHScrollBar(ControlActionClosureUPP controlActionClosureUPP) {
        Rect rect = this.calcHScrollBoundsFor(this.boundsRect);
        this.hScroll = new ControlHandle(this.myComponent.getWindowRef(), rect, false, 0, 0, 0, this.myComponent.getIdentifier());
        this.hActionUPP = controlActionClosureUPP == null ? new ControlActionClosureUPP(new ActionUPP(this.myComponent, this.hScroll, true)) : controlActionClosureUPP;
        this.hScroll.setAction(this.hActionUPP);
        if (this.hasVScroll()) {
            this.vScroll.setBounds(this.calcVScrollBoundsFor(rect));
        }
        this.myComponent.size((short)0, (short)-15);
        this.adjustScrollBar(this.hScroll, false, false);
        this.hScroll.show();
    }

    protected void createVScrollBar(ControlActionClosureUPP controlActionClosureUPP) {
        Rect rect = this.calcVScrollBoundsFor(this.boundsRect);
        this.vScroll = new ControlHandle(this.myComponent.getWindowRef(), rect, new Str255(), false, 0, 0, 0, 16, this.myComponent.getIdentifier());
        this.vActionUPP = controlActionClosureUPP == null ? new ControlActionClosureUPP(new ActionUPP(this.myComponent, this.vScroll, true)) : controlActionClosureUPP;
        this.vScroll.setAction(this.vActionUPP);
        if (this.hasHScroll()) {
            this.hScroll.setBounds(this.calcHScrollBoundsFor(rect));
        }
        this.myComponent.size((short)-15, (short)0);
        this.adjustScrollBar(this.vScroll, true, false);
        this.vScroll.show();
    }

    public void dispose() {
        if (this.hasVScroll()) {
            this.vScroll.dispose();
        }
        if (this.hasHScroll()) {
            this.hScroll.dispose();
        }
        this.hScroll = null;
        this.vScroll = null;
    }
}

