/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.generated.RegionStruct;
import com.apple.mrj.macos.toolbox.Pattern;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Shape;

public class Region
implements Shape {
    private RegionStruct data;

    public RegionStruct getRegion() {
        return this.data;
    }

    public int getRegionHandle() {
        return this.data.getHandle();
    }

    public Region() {
        this.data = new RegionStruct(0);
    }

    public Region(Rect rect) {
        this();
        this.setRect(rect);
    }

    Region(RegionStruct regionStruct) {
        this.data = regionStruct;
    }

    public Region(int n) {
        this.data = new RegionStruct(n);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[bounds '" + this.getBounds() + "]";
    }

    public Rect getBounds() {
        return new Rect(this.data.getRgnBBox());
    }

    public void copy(Region region) {
        QuickdrawFunctions.CopyRgn(region.getRegion(), this.getRegion());
    }

    public void setRect(Rect rect) {
        QuickdrawFunctions.RectRgn(this.getRegion(), rect.getRect());
    }

    public void diff(Region region, Region region2) {
        QuickdrawFunctions.DiffRgn(this.getRegion(), region.getRegion(), region2.getRegion());
    }

    public void diff(Region region) {
        this.diff(region, this);
    }

    public void sect(Region region, Region region2) {
        QuickdrawFunctions.SectRgn(this.getRegion(), region.getRegion(), region2.getRegion());
    }

    public void sect(Region region) {
        this.sect(region, this);
    }

    public void union(Region region, Region region2) {
        QuickdrawFunctions.UnionRgn(this.getRegion(), region.getRegion(), region2.getRegion());
    }

    public void union(Region region) {
        this.union(region, this);
    }

    public boolean contains(Point point) {
        return QuickdrawFunctions.PtInRgn(point.getPoint(), this.getRegion());
    }

    public boolean contains(Rect rect) {
        return QuickdrawFunctions.RectInRgn(rect.getRect(), this.getRegion());
    }

    public boolean equal(Region region) {
        return QuickdrawFunctions.EqualRgn(this.getRegion(), region.getRegion());
    }

    public boolean empty() {
        return QuickdrawFunctions.EmptyRgn(this.getRegion());
    }

    public void moveTo(short s, short s2) {
        Rect rect = this.getBounds();
        QuickdrawFunctions.OffsetRgn(this.getRegion(), (short)(s - rect.getLeft()), (short)(s2 - rect.getTop()));
    }

    public void offset(short s, short s2) {
        QuickdrawFunctions.OffsetRgn(this.getRegion(), s, s2);
    }

    public void frame() {
        QuickdrawFunctions.FrameRgn(this.getRegion());
    }

    public void paint() {
        QuickdrawFunctions.PaintRgn(this.getRegion());
    }

    public void fill(Pattern pattern) {
        QuickdrawFunctions.FillRgn(this.getRegion(), pattern.getPattern());
    }

    public void invert() {
        QuickdrawFunctions.InvertRgn(this.getRegion());
    }

    public void erase() {
        QuickdrawFunctions.EraseRgn(this.getRegion());
    }
}

