/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ProcessConstants;
import com.apple.mrj.macos.generated.ProcessFunctions;
import com.apple.mrj.macos.generated.ProcessSerialNumberStruct;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.ProcessInfoRec;

public class ProcessSerialNumber
implements ProcessConstants {
    ProcessSerialNumberStruct data;

    ProcessSerialNumberStruct getProcessSerialNumber() {
        return this.data;
    }

    long getPSN() {
        return this.data.getValue();
    }

    void setPSN(long l) {
        this.data.setHighLongOfPSN((int)(l >> 32));
        this.data.setLowLongOfPSN((int)(l & 0xFFFFL));
    }

    public ProcessSerialNumber(long l) {
        this.data = new ProcessSerialNumberStruct();
        this.setPSN(l);
    }

    public ProcessSerialNumber(ProcessSerialNumberStruct processSerialNumberStruct) {
        this.data = processSerialNumberStruct;
    }

    public ProcessSerialNumber() {
        this(2L);
    }

    public boolean isValidProcess() {
        return this.getPSN() != 0L;
    }

    public void getNextProcess() throws MacOSError {
        MacOSError.checkResult(ProcessFunctions.GetNextProcess(this.getProcessSerialNumber()));
    }

    public void getProcessInformation(ProcessInfoRec processInfoRec) throws MacOSError {
        MacOSError.checkResult(ProcessFunctions.GetProcessInformation(this.getProcessSerialNumber(), processInfoRec.getProcessInfoRec()));
    }

    public ProcessInfoRec getProcessInformation() throws MacOSError {
        ProcessInfoRec processInfoRec = new ProcessInfoRec();
        this.getProcessInformation(processInfoRec);
        return processInfoRec;
    }

    public String toString() {
        return this.getProcessInformation().getName();
    }

    public int getProcessType() {
        return this.getProcessInformation().getProcessType();
    }

    public int getProcessCreator() {
        return this.getProcessInformation().getProcessSignature();
    }

    public int getProcessMode() {
        return this.getProcessInformation().getProcessMode();
    }

    public int getProcessSize() {
        return this.getProcessInformation().getProcessSize();
    }

    public int getProcessFreeMem() {
        return this.getProcessInformation().getProcessFreeMem();
    }

    public ProcessSerialNumber getLauncher() {
        return this.getProcessInformation().getProcessLauncher();
    }

    public static ProcessSerialNumber findProcess(int n) {
        ProcessSerialNumber processSerialNumber = new ProcessSerialNumber(0L);
        do {
            ProcessFunctions.GetNextProcess(processSerialNumber.getProcessSerialNumber());
            if (processSerialNumber.getProcessCreator() != n) continue;
            return processSerialNumber;
        } while (processSerialNumber.getPSN() != 0L);
        return null;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[8];
        long l = this.getPSN();
        int n = 0;
        while (n < 8) {
            byArray[7 - n] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n;
        }
        return byArray;
    }
}

