/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.AppearanceFunctions;
import com.apple.mrj.macos.generated.CellStruct;
import com.apple.mrj.macos.generated.ControlConstants;
import com.apple.mrj.macos.generated.ListSearchClosureUPP;
import com.apple.mrj.macos.generated.ListSearchInterface;
import com.apple.mrj.macos.generated.LowMemFunctions;
import com.apple.mrj.macos.generated.PointStruct;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.toolbox.Cell;
import com.apple.mrj.macos.toolbox.ControlFontStyle;
import com.apple.mrj.macos.toolbox.ControlRef;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.EventRecord;
import com.apple.mrj.macos.toolbox.GrafPtr;
import com.apple.mrj.macos.toolbox.ListBounds;
import com.apple.mrj.macos.toolbox.ListHandle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.QuickdrawFont;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.TextUtilities;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ListBox
extends ListHandle
implements ControlConstants {
    Rect fFullBounds;
    Rect fListCellRect;
    Rect fFrameBounds;
    QuickdrawFont fFont;
    public static final short kFocusInset = 5;
    boolean fVisible = true;
    boolean fIsEnabled = true;
    boolean fHasFocus = false;
    boolean fDrawingMode = true;
    boolean isOneDimensional;
    boolean allowExtendedSelections = false;
    private static short kMaxKeyThresh = (short)120;
    private Str255 gListNavigateString = new Str255();
    private int gLength = 0;
    private int gLastKeyTime;
    private int gTSThresh;
    private static final byte kHomeKey = 115;
    private static final byte kEndKey = 119;
    private static final byte kPageUpKey = 116;
    private static final byte kPageDownKey = 121;

    public final Rect getBounds() {
        return this.fFullBounds;
    }

    public ListBox(Rect rect, ListBounds listBounds, Point point, short s, WindowRef windowRef, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(rect, listBounds, point, s, windowRef, bl, bl2, bl3, bl4);
        this.initialize();
    }

    public ListBox(int n, Object object) {
        super(n, object);
        this.initialize();
    }

    protected void initialize() {
        this.isOneDimensional = this.getColumnCount() == 1;
        this.fFrameBounds = this.getRView();
        if (this.getVScroll() != null) {
            this.fFrameBounds.setWidth((short)(this.fFrameBounds.getWidth() + 15));
        }
        if (this.getHScroll() != null) {
            this.fFrameBounds.setHeight((short)(this.fFrameBounds.getHeight() + 15));
        }
        this.fFullBounds = new Rect();
        this.fListCellRect = new Rect();
        this.updateBounds();
    }

    public void setDrawingMode(boolean bl) {
        this.fDrawingMode = bl;
        super.setDrawingMode(bl);
    }

    public short addColumn(short s, short s2) {
        this.isOneDimensional = false;
        return super.addColumn(s, s2);
    }

    public void delColumn(short s, short s2) {
        super.delColumn(s, s2);
        this.isOneDimensional = this.getColumnCount() == 1;
    }

    public void activate(boolean bl) {
        super.activate(bl);
        if (this.fIsEnabled != bl) {
            this.fIsEnabled = bl;
            if (this.fVisible) {
                this.drawListBorder();
            }
        }
    }

    public boolean isActive() {
        return this.fIsEnabled;
    }

    public void update(Region region) {
        if (!this.fVisible) {
            return;
        }
        QuickdrawFont quickdrawFont = null;
        if (this.fFont != null) {
            GrafPtr grafPtr = new GrafPtr(GrafPtr.getPort());
            quickdrawFont = grafPtr.currentFont();
            this.fFont.install();
        }
        if (this.fIsEnabled != this.getLActive()) {
            this.activate(this.fIsEnabled);
        }
        QuickdrawFunctions.EraseRect(this.fListCellRect.getRect());
        super.update(region);
        this.drawListBorder();
        if (quickdrawFont != null) {
            quickdrawFont.install();
        }
    }

    public boolean click(PointStruct pointStruct, short s) {
        return super.click(pointStruct, this.allowExtendedSelections ? s : (short)0);
    }

    public boolean hitTest(Point point) {
        return this.getBounds().contains(point);
    }

    public void setFontStyle(ControlFontStyle controlFontStyle) {
        if (this.fFont == null) {
            this.fFont = new QuickdrawFont(controlFontStyle);
        } else {
            this.fFont.set(controlFontStyle);
        }
    }

    public void draw(CellStruct cellStruct) {
        if (!this.fVisible) {
            return;
        }
        QuickdrawFont quickdrawFont = null;
        if (this.fFont != null) {
            GrafPtr grafPtr = new GrafPtr(GrafPtr.getPort());
            quickdrawFont = grafPtr.currentFont();
            this.fFont.install();
        }
        this.fListCellRect.erase();
        super.draw(cellStruct);
        this.drawListBorder();
        if (quickdrawFont != null) {
            quickdrawFont.install();
        }
    }

    public void draw() {
        this.update(this.getWindowRef().getClipRgn());
    }

    public void drawInCurrentPort() {
        byte by;
        int n = this.getListRec().getPort();
        int n2 = GrafPtr.getPort();
        this.getListRec().setPort(n2);
        AppearanceFunctions.DrawThemeListBoxFrame(this.fFrameBounds.getRect(), this.fIsEnabled ? 1 : 0);
        if (this.fHasFocus && this.fIsEnabled) {
            AppearanceFunctions.DrawThemeFocusRect(this.fFrameBounds.getRect(), true);
        }
        ControlRef controlRef = this.getHScroll();
        ControlRef controlRef2 = this.getVScroll();
        this.setHScroll(null);
        this.setVScroll(null);
        boolean bl = this.fDrawingMode;
        if (!bl) {
            this.setDrawingMode(true);
        }
        this.draw();
        if (controlRef != null) {
            by = controlRef.getContrlHilite();
            if (!this.fIsEnabled) {
                controlRef.setContrlHilite((byte)-2);
            } else if (by == 254) {
                controlRef.setContrlHilite((byte)-1);
            } else if (by != 255) {
                controlRef.setContrlHilite((byte)0);
            }
            controlRef.drawInCurrentPort();
        }
        if (controlRef2 != null) {
            by = controlRef2.getControl().getContrlHilite();
            if (!this.fIsEnabled) {
                controlRef2.setContrlHilite((byte)-2);
            } else if (by == 254) {
                controlRef2.setContrlHilite((byte)-1);
            } else if (by != 255) {
                controlRef2.setContrlHilite((byte)0);
            }
            controlRef2.drawInCurrentPort();
        }
        this.setHScroll(controlRef);
        this.setVScroll(controlRef2);
        if (!bl) {
            this.setDrawingMode(false);
        }
        this.getListRec().setPort(n);
    }

    public void isVisible(boolean bl) {
        if (!this.fVisible) {
            this.setDrawingMode(bl);
        }
        this.fVisible = bl;
    }

    public void allowExtendedSelections(boolean bl) {
        this.allowExtendedSelections = bl;
    }

    public void size(short s, short s2) {
        short s3;
        if (this.fVisible) {
            this.fFullBounds.erase();
        }
        boolean bl = this.getHScroll() != null;
        short s4 = s2;
        if (bl) {
            s4 = (short)(s4 - 15);
        }
        if ((s3 = (short)(s4 % this.getCellSize().getV())) != 0) {
            s2 = (short)(s2 - s3);
        }
        this.fFrameBounds.setWidth(s);
        this.fFrameBounds.setHeight(s2);
        this.updateBounds();
        super.size(this.fListCellRect.getWidth(), this.fListCellRect.getHeight());
        if (this.isOneDimensional) {
            Point point = this.getCellSize();
            point.setH(this.fListCellRect.getWidth());
            this.cellSize(point);
        }
        if (this.fVisible) {
            this.drawListBorder();
        }
    }

    public void move(short s, short s2) {
        int n = s - this.fFullBounds.getLeft();
        int n2 = s2 - this.fFullBounds.getTop();
        if (n == 0 && n2 == 0) {
            return;
        }
        this.fFullBounds.erase();
        this.fFrameBounds.offset((short)n, (short)n2);
        this.updateBounds();
        boolean bl = this.fDrawingMode;
        if (this.fVisible && bl) {
            this.setDrawingMode(false);
        }
        Rect rect = new Rect(this.fListCellRect);
        rect.setBottom(rect.getBottom() - 1);
        rect.setRight(rect.getRight() - 1);
        this.setRView(rect);
        super.size(this.fListCellRect.getWidth(), this.fListCellRect.getHeight());
        if (this.fVisible && bl) {
            this.setDrawingMode(true);
        }
    }

    public void setKeyboardFocus(boolean bl) {
        if (this.fHasFocus != bl) {
            this.fHasFocus = bl;
            this.draw();
        }
    }

    public void show() {
        if (!this.fVisible) {
            this.fVisible = true;
            this.setDrawingMode(this.fVisible);
        }
    }

    public void hide() {
        if (this.fVisible) {
            this.fVisible = false;
            this.setDrawingMode(this.fVisible);
        }
    }

    public void setPort(int n) {
        if (n != this.data.getPort()) {
            if (n == 0) {
                throw new IllegalArgumentException("Can't set list's port to null");
            }
            this.data.setPort(n);
            ControlRef controlRef = this.getHScroll();
            if (controlRef != null) {
                controlRef.setContrlOwner(n);
            }
            if ((controlRef = this.getVScroll()) != null) {
                controlRef.setContrlOwner(n);
            }
        }
    }

    public final Point getOrigin() {
        return this.getRView().topLeft();
    }

    public static ListBox createVerticallyScrollingList(WindowRef windowRef, Rect rect, short s, short s2) {
        ListBounds listBounds = new ListBounds();
        Point point = new Point();
        listBounds.set((short)0, (short)0, s, (short)0);
        point.set(0, 0);
        Rect rect2 = new Rect(rect);
        if (rect2.empty()) {
            rect2.set((short)0, (short)0, (short)75, (short)75);
        }
        Rect rect3 = new Rect(rect2);
        rect3.inset((short)-5, (short)-5);
        rect.set(rect2);
        rect.setRight((short)(rect.getRight() - 15));
        ListBox listBox = new ListBox(rect, listBounds, point, s2, windowRef, false, false, false, true);
        listBox.fFullBounds = rect3;
        listBox.fListCellRect = rect;
        listBox.fFrameBounds = rect2;
        return listBox;
    }

    private void updateBounds() {
        this.fFullBounds.set(this.fFrameBounds);
        this.fFullBounds.inset((short)-5, (short)-5);
        this.fListCellRect.set(this.fFrameBounds);
        if (this.getVScroll() != null) {
            this.fListCellRect.setRight((short)(this.fListCellRect.getRight() - 15));
        }
        if (this.getHScroll() != null) {
            this.fListCellRect.setBottom((short)(this.fListCellRect.getBottom() - 15));
        }
    }

    public void drawListBorder() {
        if (this.fDrawingMode) {
            AppearanceFunctions.DrawThemeListBoxFrame(this.fFrameBounds.getRect(), this.fIsEnabled ? 1 : 0);
            AppearanceFunctions.DrawThemeFocusRect(this.fFrameBounds.getRect(), this.fHasFocus && this.fIsEnabled);
        }
    }

    public void addItemsFromStringList(short s) {
        Str255 str255 = new Str255();
        Cell cell = new Cell();
        short s2 = this.getDataBounds().getBottom();
        short s3 = 1;
        do {
            str255.getIndString(s, s3);
            if (str255.length() > 0) {
                s2 = this.addRow((short)1, s2);
                cell.set(0, (int)s2);
                this.setCell(str255.toString(), cell);
            }
            s2 = (short)(s2 + 1);
            s3 = (short)(s3 + 1);
        } while (str255.length() > 0);
    }

    public boolean getFirstSelectedCell(Cell cell) {
        cell.set(0, 0);
        return this.getSelect(true, cell);
    }

    public void getLastSelectedCell(Cell cell) {
        Cell cell2 = new Cell();
        if (this.getFirstSelectedCell(cell2)) {
            do {
                cell = cell2;
                boolean bl = this.nextCell(true, true, cell2);
            } while (this.getSelect(true, cell2));
        }
    }

    public void selectOneCell(Cell cell) {
        Cell cell2 = new Cell();
        if (this.getFirstSelectedCell(cell2)) {
            while (this.getSelect(true, cell2)) {
                if (cell2.getH() != cell.getH() || cell2.getV() != cell.getV()) {
                    this.setSelect(false, cell2);
                    continue;
                }
                boolean bl = this.nextCell(true, true, cell2);
            }
        }
        this.setSelect(true, cell);
    }

    public void makeCellVisible(Cell cell) {
        int n = 0;
        int n2 = 0;
        Rect rect = this.getVisible();
        if (!rect.contains(cell)) {
            short s = cell.getH();
            short s2 = cell.getV();
            short s3 = rect.getRight();
            short s4 = rect.getLeft();
            short s5 = rect.getTop();
            short s6 = rect.getBottom();
            if (s > s3 - 1) {
                n = s - s3 + 1;
            } else if (s < s4) {
                n = s - s4;
            }
            if (s2 > s6 - 1) {
                n2 = s2 - s6 + 1;
            } else if (s2 < s5) {
                n2 = s2 - s5;
            }
            this.scroll((short)n, (short)n2);
        }
    }

    public boolean handleKey(short s, short s2, short s3) {
        if (s2 >= 28 && s2 <= 31) {
            this.arrowKeyInList((char)s2, s3);
            return true;
        }
        if (s >= 115 && s <= 121) {
            this.extendedKeyInList((char)s);
            return true;
        }
        return false;
    }

    public void extendedKeyInList(char c) {
        int n = 0;
        int n2 = 0;
        Rect rect = this.getVisible();
        Rect rect2 = this.getDataBounds();
        if (c == 't') {
            n2 -= rect.getHeight();
        }
        if (c == 'y') {
            n2 += rect.getHeight();
        }
        if (c == 's') {
            n2 = -rect.getTop();
            n = -rect.getLeft();
        }
        if (c == 'w') {
            n2 = rect2.getBottom() - rect.getBottom();
            n = rect2.getRight() - rect.getRight();
        }
        if (n != 0 || n2 != 0) {
            this.scroll((short)n, (short)n2);
        }
    }

    public void resetTypeSelection() {
        this.gLength = 0;
        this.gLastKeyTime = 0;
        this.gTSThresh = 2 * LowMemFunctions.LMGetKeyThresh();
        if (this.gTSThresh > kMaxKeyThresh) {
            this.gTSThresh = kMaxKeyThresh;
        }
    }

    public void keySearchInList(char c, int n) {
        Cell cell = new Cell();
        MatchNextAlphabetically matchNextAlphabetically = new MatchNextAlphabetically();
        ListSearchClosureUPP listSearchClosureUPP = new ListSearchClosureUPP(matchNextAlphabetically);
        byte by = (byte)c;
        if (n - this.gLastKeyTime >= this.gTSThresh || this.gLength == 255) {
            this.resetTypeSelection();
        }
        this.gLastKeyTime = n;
        this.gListNavigateString.putByteAt(this.gLength, by);
        ++this.gLength;
        cell.set(0, 0);
        if (this.search(this.gListNavigateString.getBytes(), (short)this.gLength, listSearchClosureUPP, cell)) {
            this.selectOneCell(cell);
            this.makeCellVisible(cell);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void findNewCellLoc(Cell cell, Cell cell2, char c, boolean bl) {
        Rect rect = this.getDataBounds();
        int n = rect.getBottom() - rect.getTop();
        int n2 = rect.getRight() - rect.getLeft();
        cell2.set(cell);
        if (bl) {
            switch ((byte)c) {
                case 30: {
                    cell2.setV(0);
                    return;
                }
                case 31: {
                    cell2.setV(n - 1);
                    return;
                }
                case 28: {
                    cell2.setH(0);
                    return;
                }
                case 29: {
                    cell2.setH(n2 - 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch ((byte)c) {
            case 30: {
                if (cell.getV() == 0) return;
                cell2.setV(cell.getV() - 1);
                break;
            }
            case 31: {
                if (cell.getV() == n - 1) return;
                cell2.setV(cell.getV() + 1);
                break;
            }
            case 28: {
                if (cell.getH() == 0) return;
                cell2.setH(cell.getH() - 1);
                break;
            }
            case 29: {
                if (cell.getH() == n2 - 1) return;
                cell2.setH(cell.getH() + 1);
            }
        }
    }

    public void arrowKeyMoveSelection(char c, boolean bl) {
        Cell cell = new Cell();
        Cell cell2 = new Cell();
        if (this.getFirstSelectedCell(cell)) {
            if (c == '\u001d' || c == '\u001f') {
                this.getLastSelectedCell(cell);
            }
            this.findNewCellLoc(cell, cell2, c, bl);
            this.selectOneCell(cell2);
            this.makeCellVisible(cell2);
        }
    }

    public void arrowKeyExtendSelection(char c, boolean bl) {
        Cell cell = new Cell();
        Cell cell2 = new Cell();
        if (this.getFirstSelectedCell(cell)) {
            if (c == '\u001d' || c == '\u001f') {
                this.getLastSelectedCell(cell);
            }
            this.findNewCellLoc(cell, cell2, c, bl);
            if (!this.getSelect(false, cell2)) {
                this.getSelect(true, cell2);
            }
            this.makeCellVisible(cell2);
        }
    }

    public void arrowKeyInList(char c, short s) {
        if (!this.allowExtendedSelections || EventRecord.shiftKeyDown(s)) {
            this.arrowKeyMoveSelection(c, EventRecord.cmdKeyDown(s));
        } else {
            this.arrowKeyExtendSelection(c, EventRecord.cmdKeyDown(s));
        }
    }

    public class SearchPartialMatch
    implements ListSearchInterface {
        public short ListSearch(int n, int n2, short s, short s2) {
            DataPointer dataPointer = new DataPointer(n, s);
            DataPointer dataPointer2 = new DataPointer(n2, s2);
            if (s > 0 && s >= s2) {
                return TextUtilities.identicalText(dataPointer, dataPointer2, s2, s2);
            }
            return 1;
        }
    }

    public class MatchNextAlphabetically
    implements ListSearchInterface {
        public short ListSearch(int n, int n2, short s, short s2) {
            short s3 = 1;
            DataPointer dataPointer = new DataPointer(n, s);
            DataPointer dataPointer2 = new DataPointer(n2, s2);
            if (s > 0) {
                if (TextUtilities.identicalText(dataPointer, dataPointer2, s2, s2) == 0) {
                    s3 = 0;
                } else if (TextUtilities.compareText(dataPointer, dataPointer2, s, s2) == 1) {
                    s3 = 0;
                }
            }
            return s3;
        }
    }
}

