/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ControlActionClosureUPP;
import com.apple.mrj.macos.generated.ControlConstants;
import com.apple.mrj.macos.generated.ControlFunctions;
import com.apple.mrj.macos.generated.ControlRecordStruct;
import com.apple.mrj.macos.generated.PointStruct;
import com.apple.mrj.macos.generated.RectStruct;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.RGBColor;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.ToolboxObject;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ControlHandle
implements ToolboxObject,
ControlConstants {
    ControlRecordStruct data;
    Object owner;
    public static final short kScrollBarWidth = 15;
    public static final short kButtonScroll = 4;

    public ControlRecordStruct getControl() {
        return this.data;
    }

    public int getHandleValue() {
        return this.data.getHandle();
    }

    public static ControlHandle GetOwnedControl(int n, Object object) {
        if (n != 0) {
            return new ControlHandle(n, object);
        }
        return null;
    }

    public ControlHandle(int n, Object object) {
        this.data = new ControlRecordStruct(n);
        this.owner = object;
    }

    public ControlHandle(int n) {
        this(n, null);
    }

    public ControlHandle(short s, WindowRef windowRef) {
        this(ControlFunctions.GetNewControl(s, windowRef.getWindowPointer()));
    }

    public ControlHandle(WindowRef windowRef, Rect rect, Str255 str255, boolean bl, short s, short s2, short s3, short s4, int n) {
        this(windowRef.getWindowPointer(), rect.getRect(), str255.getBytes(), bl, s, s2, s3, s4, n);
    }

    public ControlHandle(int n, RectStruct rectStruct, byte[] byArray, boolean bl, short s, short s2, short s3, short s4, int n2) {
        this(ControlFunctions.NewControl(n, rectStruct, byArray, bl, s, s2, s3, s4, n2));
    }

    public ControlHandle(WindowRef windowRef, Rect rect, Str255 str255, boolean bl, short s) {
        this(windowRef, rect, str255, bl, 0, 0, 1, s, 0);
    }

    public ControlHandle(WindowRef windowRef, Rect rect, boolean bl, short s, short s2, short s3, int n) {
        this(windowRef, rect, new Str255(), bl, s, s2, s3, 16, n);
    }

    public static int maxControlValue() {
        return Short.MAX_VALUE;
    }

    public final void setContrlVis(byte by) {
        this.getControl().setContrlVis(by);
    }

    public final int getNextControl() {
        return this.getControl().getNextControl();
    }

    public final void setNextControl(int n) {
        this.getControl().setNextControl(n);
    }

    public final byte getContrlHilite() {
        return this.getControl().getContrlHilite();
    }

    public final void setContrlHilite(byte by) {
        this.getControl().setContrlHilite(by);
    }

    public final int getContrlOwner() {
        return this.getControl().getContrlOwner();
    }

    public final void setContrlOwner(int n) {
        this.getControl().setContrlOwner(n);
    }

    public WindowRef getWindowRef() {
        return new WindowRef(this.getControl().getContrlOwner(), true);
    }

    public Rect getBounds() {
        return new Rect(this.getControl().getContrlRect());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[label '" + this.getTitle() + "', min " + this.getMinimum() + ", max " + this.getMaximum() + ", value " + this.getValue() + "]";
    }

    public void isVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void isHilited(boolean bl) {
        this.hilite((short)(bl ? 0 : 255));
    }

    public void show() {
        ControlFunctions.ShowControl(this.getControl());
    }

    public void update(Region region) {
        this.draw();
    }

    public void draw() {
        ControlFunctions.Draw1Control(this.getControl());
    }

    public short find(Point point) {
        return this.find(point.getPoint());
    }

    public short find(PointStruct pointStruct) {
        int[] nArray = new int[1];
        return this.find(pointStruct, this.getWindowRef(), nArray);
    }

    public short find(Point point, WindowRef windowRef, int[] nArray) {
        return this.find(point.getPoint(), windowRef, nArray);
    }

    public short find(PointStruct pointStruct, WindowRef windowRef, int[] nArray) {
        return ControlFunctions.FindControl(pointStruct, windowRef.getWindowPointer(), nArray);
    }

    public short track(Point point, ControlActionClosureUPP controlActionClosureUPP) {
        return this.track(point.getPoint(), controlActionClosureUPP);
    }

    public short track(Point point) {
        return this.track(point, null);
    }

    public short track(PointStruct pointStruct, ControlActionClosureUPP controlActionClosureUPP) {
        return ControlFunctions.TrackControl(this.getControl(), pointStruct, controlActionClosureUPP);
    }

    public short test(Point point) {
        return this.test(point.getPoint());
    }

    public short test(PointStruct pointStruct) {
        return ControlFunctions.TestControl(this.getControl(), pointStruct);
    }

    public boolean hitTest(Point point) {
        return this.getBounds().contains(point);
    }

    public short setForeColor(RGBColor rGBColor) {
        return 0;
    }

    public short setBackColor(RGBColor rGBColor) {
        return 0;
    }

    public void setValue(short s) {
        ControlFunctions.SetControlValue(this.getControl(), s);
    }

    public void setMinimum(short s) {
        ControlFunctions.SetControlMinimum(this.getControl(), s);
    }

    public void setMaximum(short s) {
        ControlFunctions.SetControlMaximum(this.getControl(), s);
    }

    public void setTitle(String string) {
        ControlFunctions.SetControlTitle(this.getControl(), TranslateString.asPascalBytes(string));
    }

    public void setTitle(byte[] byArray) {
        ControlFunctions.SetControlTitle(this.getControl(), byArray);
    }

    public void hide() {
        ControlFunctions.HideControl(this.getControl());
    }

    public void move(short s, short s2) {
        ControlFunctions.MoveControl(this.getControl(), s, s2);
    }

    public void size(short s, short s2) {
        ControlFunctions.SizeControl(this.getControl(), s, s2);
    }

    public void hilite(short s) {
        ControlFunctions.HiliteControl(this.getControl(), s);
    }

    public void drag(Point point, Rect rect, Rect rect2, short s) {
        ControlFunctions.DragControl(this.getControl(), point.getPoint(), rect.getRect(), rect2.getRect(), s);
    }

    public void setAction(ControlActionClosureUPP controlActionClosureUPP) {
        ControlFunctions.SetControlAction(this.getControl(), controlActionClosureUPP);
    }

    public void setActionNone() {
        ControlFunctions.SetControlAction(this.getControl().getHandle(), -1);
    }

    public void setBounds(Rect rect) {
        this.move(rect.getLeft(), rect.getTop());
        this.size(rect.getWidth(), rect.getHeight());
    }

    public Point getOrigin() {
        return this.getBounds().topLeft();
    }

    public short getValue() {
        return ControlFunctions.GetControlValue(this.getControl());
    }

    public short getMinimum() {
        return ControlFunctions.GetControlMinimum(this.getControl());
    }

    public short getMaximum() {
        return ControlFunctions.GetControlMaximum(this.getControl());
    }

    public String getTitle() {
        Str255 str255 = new Str255();
        ControlFunctions.GetControlTitle(this.getControl(), str255.getByteArray());
        return str255.toString();
    }

    public int getReference() {
        return ControlFunctions.GetControlReference(this.getControl());
    }

    public void setReference(int n) {
        ControlFunctions.SetControlReference(this.getControl(), n);
    }

    public int getData() {
        return this.getControl().getContrlData();
    }

    public short getVariant() {
        return ControlFunctions.GetControlVariant(this.getControl());
    }

    public void dispose() {
        if (this.owner == null && this.getControl() != null && this.getHandleValue() != 0) {
            ControlFunctions.DisposeControl(this.getControl());
        }
        this.data = null;
    }

    protected void finalize() {
        if (this.data != null && this.owner == null) {
            System.err.println("Warning!!! Control not disposed properly!!!");
            this.data = null;
        }
    }
}

