/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.internal.bindery;

import com.apple.mrj.internal.vfs.VFSFileDescriptor;
import com.apple.mrj.internal.vfs.VFSStat;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.VFSZipFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipFD
implements VFSFileDescriptor {
    ZipFile itsFile;
    ZipEntry itsEntry;
    VFSZipFile itsVFSZipFile;
    int itsPos;
    int itsSize;
    static boolean debug = false;

    ZipFD(ZipFile zipFile, ZipEntry zipEntry, int n) throws IOException {
        this.itsFile = zipFile;
        this.itsEntry = zipEntry;
        this.itsPos = 0;
        this.itsSize = (int)zipEntry.getSize();
        this.itsVFSZipFile = new VFSZipFile(this.itsFile, this.itsEntry);
        this.itsVFSZipFile.readLOC();
        if (debug) {
            System.out.println("Constructed a ZipFD: " + this.itsEntry.getName() + ", entry size = " + this.itsSize);
        }
    }

    public int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (debug) {
            System.out.println("Reading " + n2 + " bytes at offsfet " + n);
        }
        if ((n2 = Math.min(n2, this.itsSize - this.itsPos)) > 0) {
            if ((n2 = this.itsVFSZipFile.read(this.itsPos, byArray, n, n2)) > 0) {
                this.itsPos += n2;
            } else {
                n2 = 0;
            }
            if (debug) {
                System.out.println("readBytes: " + n2 + " bytes actually read.");
            }
        }
        return n2;
    }

    public int writeBytes(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("Read Only File System");
    }

    public void setPos(int n, int n2) throws IOException {
        switch (n2) {
            case 1: {
                this.itsPos = n;
                break;
            }
            case 2: {
                this.itsPos = this.itsSize - n;
                break;
            }
            case 3: {
                this.itsPos += n;
                break;
            }
        }
        if (debug) {
            System.out.println("New pos: " + this.itsPos);
        }
        if (this.itsPos < 0 || this.itsPos > this.itsSize) {
            throw new EOFException("setPos beyond end of file");
        }
    }

    public int getPos() {
        return this.itsPos;
    }

    public int getAvail() {
        return this.itsPos - this.itsSize;
    }

    public void close() {
        this.itsFile = null;
        this.itsEntry = null;
        this.itsVFSZipFile = null;
        this.itsPos = 0;
    }

    public int getEOF() {
        return this.itsSize;
    }

    public void setEOF(int n) throws IOException {
        throw new IOException("Read Only File System");
    }

    public void flush() {
    }

    public VFSStat statFile() {
        return new VFSStat(this.itsSize, this.itsSize == 0, ((Object)this.itsEntry).hashCode(), (int)this.itsEntry.getTime(), (int)this.itsEntry.getTime());
    }
}

