/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.AudioWatcher;
import com.apple.mrj.JManager.ConditionVariable;
import com.apple.mrj.JManager.ULAWConverter;
import com.apple.mrj.macos.toolbox.SoundHeader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import sun.audio.NativeAudioStream;

public class ULAWAudioBuffer
implements Runnable {
    URL itsURL;
    byte[] itsRawData;
    SoundHeader itsSoundHeader;
    ConditionVariable itsReady;
    static final int kDefaultBufferSize = 16384;

    public ULAWAudioBuffer(URL uRL) {
        this.itsURL = uRL;
        this.itsReady = new ConditionVariable();
        this.itsRawData = null;
        new Thread(AudioWatcher.getMainThreadGroup(), this, "Audio Buffer:  Fetching " + uRL.toString()).start();
    }

    public ULAWAudioBuffer(URL uRL, byte[] byArray) {
        this.itsURL = uRL;
        this.itsReady = new ConditionVariable();
        this.itsRawData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.itsRawData, 0, byArray.length);
        new Thread(AudioWatcher.getMainThreadGroup(), this, "Audio Buffer:  Fetching " + uRL.toString()).start();
    }

    public void run() {
        try {
            if (this.itsRawData == null) {
                int n;
                InputStream inputStream = null;
                URLConnection uRLConnection = this.itsURL.openConnection();
                uRLConnection.setAllowUserInteraction(true);
                inputStream = uRLConnection.getInputStream();
                NativeAudioStream nativeAudioStream = new NativeAudioStream(inputStream);
                int n2 = nativeAudioStream.getLength();
                this.itsRawData = new byte[n2];
                for (int i = 0; i < n2; i += n) {
                    n = inputStream.read(this.itsRawData, i, n2 - i);
                    if (n != -1) {
                        continue;
                    }
                    throw new IOException("InputStream.read returned -1");
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            ULAWConverter.toLinear(this.itsRawData);
            this.itsSoundHeader = new SoundHeader(this.itsRawData, this.itsRawData.length, 524288000);
        }
        catch (IOException iOException) {
            System.out.println("Got IOException fetching sound: " + iOException);
            iOException.printStackTrace();
        }
        this.itsReady.Notify();
    }

    public synchronized SoundHeader getSound() {
        this.itsReady.Wait();
        return this.itsSoundHeader;
    }

    public URL getURL() {
        return this.itsURL;
    }
}

