/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.JMReferenced;
import com.apple.mrj.JManager.JMSessionImpl;
import com.apple.mrj.JManager.JMText;
import com.apple.mrj.JManager.JManagerException;
import com.apple.mrj.JManager.JManagerImpl;
import com.apple.mrj.JManager.JManagerImpl_StubNativeMethods;
import com.apple.mrj.macos.generated.TextCommonConstants;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharMacRoman;
import sun.io.ByteToCharMacTEC;
import sun.io.ByteToCharUTF8;
import sun.io.ByteToCharUnicodeBig;
import sun.io.CharToByteMacRoman;
import sun.io.CharToByteMacTEC;
import sun.io.CharToByteUTF8;
import sun.io.CharToByteUnicodeBigUnmarked;
import sun.io.MalformedInputException;

class JMTextImpl
extends JMReferenced
implements JMText,
TextCommonConstants {
    String itsString;
    int itsRefForFinalization;
    private static final int kTextEncodingFormatShiftBits = 26;
    private static final int kTextEncodingFormatSourceMask = 15;
    private static final int kTextEncodingFormatMask = 0x3C000000;

    public JMTextImpl(String string) throws JManagerException {
        super(0);
        if (string == null) {
            string = "";
        }
        this.itsString = string;
        this.setRef(JManagerImpl_StubNativeMethods.jmNewTextRefFromExisting(JMSessionImpl.theSessionRef, this));
    }

    protected JMTextImpl(int n, String string) {
        super(n);
        this.itsRefForFinalization = n;
        this.itsString = string;
    }

    protected JMTextImpl(int n, int n2, byte[] byArray) {
        super(n);
        this.itsRefForFinalization = n;
        this.itsString = this.newStringFromBytes(n2, byArray);
    }

    protected JMTextImpl(int n, JMTextImpl jMTextImpl) {
        super(n);
        this.itsRefForFinalization = n;
        this.itsString = jMTextImpl.itsString;
    }

    public int getTextRef() {
        return this.itsRef;
    }

    public int getTextLength() throws JManagerException {
        return this.itsString.length();
    }

    public int getTextLengthInBytes(int n) throws JManagerException {
        byte[] byArray = null;
        Object object = null;
        if (((long)n & 0xFF00L) == 256L) {
            int n2 = (n & 0x3C000000) >> 26;
            object = n2 == 2 ? new CharToByteUTF8() : new CharToByteUnicodeBigUnmarked();
        } else if (n == 126) {
            object = new CharToByteUnicodeBigUnmarked();
        } else {
            try {
                object = new CharToByteMacTEC(n);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new CharToByteMacRoman();
            }
        }
        try {
            byArray = object.convertAll(this.itsString.toCharArray());
        }
        catch (MalformedInputException malformedInputException) {
            byArray = null;
        }
        if (byArray == null) {
            byArray = this.itsString.getBytes();
        }
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    public int getTextBytes(int n, byte[] byArray, int n2, int n3) throws JManagerException {
        int[] nArray = new int[1];
        JManagerException.checkError(JManagerImpl.JMGetTextBytes(this.itsRef, n, byArray, n3, nArray));
        return nArray[0];
    }

    public String toString() {
        return JManagerImpl_StubNativeMethods.JMTextToJavaString(this.itsRef);
    }

    protected void finalize() throws Throwable {
        JManagerImpl.JMDisposeTextRef(this.itsRefForFinalization);
        super.finalize();
    }

    int getTextBytes(int n, byte[] byArray) {
        int n2;
        byte[] byArray2 = null;
        Object object = null;
        if (((long)n & 0xFF00L) == 256L) {
            n2 = (n & 0x3C000000) >> 26;
            object = n2 == 2 ? new CharToByteUTF8() : new CharToByteUnicodeBigUnmarked();
        } else if (n == 126) {
            object = new CharToByteUnicodeBigUnmarked();
        } else {
            try {
                object = new CharToByteMacTEC(n);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new CharToByteMacRoman();
            }
        }
        try {
            byArray2 = object.convertAll(this.itsString.toCharArray());
        }
        catch (MalformedInputException malformedInputException) {
            byArray2 = null;
        }
        if (byArray2 == null) {
            byArray2 = this.itsString.getBytes();
        }
        if (byArray2 == null) {
            return 0;
        }
        n2 = byArray2.length;
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return n2;
    }

    int getTextBytes(byte[] byArray) {
        byte[] byArray2 = this.itsString.getBytes();
        if (byArray2 == null) {
            return 0;
        }
        int n = byArray2.length;
        if (n > byArray.length) {
            n = byArray.length;
        }
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return n;
    }

    String getJavaString() {
        return this.itsString;
    }

    void lowercaseString() {
        this.itsString = this.itsString.toLowerCase();
    }

    String newStringFromBytes(int n, byte[] byArray) {
        Object object = null;
        if (((long)n & 0xFF00L) == 256L) {
            int n2 = (n & 0x3C000000) >> 26;
            object = n2 == 2 ? new ByteToCharUTF8() : new ByteToCharUnicodeBig();
        } else if (n == 126) {
            object = new ByteToCharUnicodeBig();
        } else {
            try {
                object = new ByteToCharMacTEC(n);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new ByteToCharMacRoman();
            }
        }
        String string = null;
        if (object != null) {
            try {
                string = new String(object.convertAll(byArray));
            }
            catch (MalformedInputException malformedInputException) {
                string = null;
            }
        }
        if (string == null) {
            string = new String(byArray);
        }
        return string;
    }

    protected void setRef(int n) {
        super.setRef(n);
        if (n != 0) {
            this.itsRefForFinalization = n;
        }
    }
}

