/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.JMAWTContextImpl;
import com.apple.mrj.JManager.JMAppletClassLoader;
import com.apple.mrj.JManager.JMAppletPage;
import com.apple.mrj.JManager.JMAppletSecurity;
import com.apple.mrj.JManager.JMAppletSecurityExc;
import com.apple.mrj.JManager.JMAppletViewerImpl;
import com.apple.mrj.JManager.JMProxyInfoOld;
import com.apple.mrj.JManager.JMThreadGroup;
import com.apple.mrj.JManager.MEventDispatcher;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.IdentityScope;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;

public class JMAppletSecurityOld
extends SecurityManager {
    private static boolean debug = false;
    private static final int PRIVELEGED_PORT = 1024;
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    IdentityScope scope;
    Hashtable loadedClasses;

    static JMAppletSecurityOld getSecurity() {
        JMAppletSecurityOld jMAppletSecurityOld = (JMAppletSecurityOld)System.getSecurityManager();
        if (jMAppletSecurityOld == null) {
            jMAppletSecurityOld = new JMAppletSecurityOld();
        }
        return jMAppletSecurityOld;
    }

    public JMAppletSecurityOld() {
        this.reset();
    }

    public synchronized void reset() {
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope instanceof IdentityDatabase) {
            this.scope = (IdentityDatabase)identityScope;
            this.debug("installing " + identityScope + " as the scope for signers.");
        } else {
            this.debug("no signer scope found.");
        }
        this.loadedClasses = new Hashtable();
    }

    boolean fromApplet() {
        return this.classLoaderDepth() == 1;
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    protected boolean assessTrust(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            SystemIdentity systemIdentity;
            if (objectArray[n] instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)objectArray[n]).isTrusted() : objectArray[n] instanceof SystemSigner && (systemIdentity = (SystemSigner)objectArray[n]).isTrusted()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getSecurityContext() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return null;
        }
        if (classLoader instanceof JMAppletClassLoader) {
            JMAppletClassLoader jMAppletClassLoader = (JMAppletClassLoader)((Object)classLoader);
            return jMAppletClassLoader.getCodeBase();
        }
        throw new JMAppletSecurityExc("getsecuritycontext.unknown");
    }

    public void checkCreateClassLoader() {
        if (this.classLoaderDepth() == 2) {
            throw new JMAppletSecurityExc("classloader");
        }
    }

    private JMAppletPage findPage(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup instanceof MEventDispatcher) {
                return ((MEventDispatcher)((Object)threadGroup)).getPage();
            }
            threadGroup = threadGroup.getParent();
        }
        return null;
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof JMAppletClassLoader) {
            Object object;
            JMAppletClassLoader jMAppletClassLoader = (JMAppletClassLoader)((Object)classLoader);
            JMAppletPage jMAppletPage = jMAppletClassLoader.getPage();
            boolean bl = false;
            Hashtable hashtable = jMAppletPage.getPossibleGroups();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object = (ThreadGroup)enumeration.nextElement();
                if (!((ThreadGroup)object).parentOf(threadGroup)) continue;
                bl = true;
                break;
            }
            if (!bl && (object = this.findPage(threadGroup)) != null) {
                if (object == jMAppletPage) {
                    bl = true;
                } else {
                    Hashtable hashtable2;
                    Hashtable hashtable3 = object.getPossibleClassLoaders();
                    if (hashtable3 == (hashtable2 = object.getPossibleClassLoaders())) {
                        bl = true;
                    } else {
                        Enumeration enumeration2 = hashtable3.keys();
                        while (enumeration2.hasMoreElements()) {
                            if (!hashtable2.containsKey(enumeration2.nextElement())) continue;
                            bl = true;
                            break;
                        }
                    }
                }
            }
            return bl;
        }
        return false;
    }

    protected boolean inThreadGroup(Thread thread) {
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null && !thread.isAlive()) {
            return true;
        }
        return this.inThreadGroup(threadGroup);
    }

    void parseACL(Vector vector, String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("~")) {
                vector.addElement(String.valueOf(System.getProperty("user.home")) + string4.substring(1));
                continue;
            }
            if (string4.equals("+")) {
                if (string2 == null) continue;
                this.parseACL(vector, string2, null);
                continue;
            }
            vector.addElement(string4);
        }
    }

    String[] parseACL(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("*")) {
            return null;
        }
        Vector vector = new Vector();
        this.parseACL(vector, string, string2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    public synchronized void checkAccess(Thread thread) {
        if (this.classLoaderDepth() == 3 && !this.inThreadGroup(thread)) {
            throw new JMAppletSecurityExc("checkaccess.thread");
        }
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.classLoaderDepth() == 4 && !this.inThreadGroup(threadGroup)) {
            throw new JMAppletSecurityExc("checkaccess.threadgroup", threadGroup.toString());
        }
    }

    public void xxxxcheckAccess(Thread thread) {
        if (this.classLoaderDepth() == 2 && !(thread.getThreadGroup() instanceof JMThreadGroup)) {
            throw new JMAppletSecurityExc("thread");
        }
    }

    public void xxxcheckAccess(ThreadGroup threadGroup) {
        if (this.classLoaderDepth() == 4 && !(threadGroup instanceof JMThreadGroup)) {
            throw new JMAppletSecurityExc("threadgroup", threadGroup.toString());
        }
    }

    public void checkExit(int n) {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("checkexit", String.valueOf(n));
        }
    }

    public void checkExec(String string) {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("checkexec", string);
        }
    }

    public void checkLink(String string) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                throw new JMAppletSecurityExc("checklink", string);
            }
        }
    }

    public void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new JMAppletSecurityExc("checkpropertiesaccess");
        }
    }

    public void checkPropertyAccess(String string) {
        if (this.classLoaderDepth() == 2) {
            String string2 = System.getProperty(String.valueOf(string) + ".applet");
            boolean bl = new Boolean(string2);
            if (bl) {
                return;
            }
            throw new JMAppletSecurityExc("checkpropsaccess.key", string);
        }
    }

    public void checkRead(String string) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return;
        }
        if (!(classLoader instanceof JMAppletClassLoader)) {
            throw new JMAppletSecurityExc("checkread.unknown", string);
        }
        JMAppletClassLoader jMAppletClassLoader = (JMAppletClassLoader)((Object)classLoader);
        this.checkRead(string, jMAppletClassLoader.getCodeBase());
    }

    public void checkRead(String string, URL uRL) {
        if (this.inApplet() && uRL != null) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.readACL.length == 0) {
                switch (this.getFileSystemSecurity()) {
                    case 1: {
                        if (uRL != null && uRL.getProtocol().equals("file")) break;
                    }
                    case 0: {
                        throw new JMAppletSecurityExc("file.read", string);
                    }
                }
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new JMAppletSecurityExc("checkread.exception1", iOException.getMessage(), string);
            }
            int n = this.readACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.readACL[n])) continue;
                return;
            }
            if (uRL.getProtocol().equals("file")) {
                String string3 = null;
                try {
                    string3 = new File(uRL.getFile()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new JMAppletSecurityExc("checkread.exception2", iOException.toString());
                }
                if (string2.startsWith(string3)) {
                    return;
                }
            }
            throw new JMAppletSecurityExc("checkread", string, string2);
        }
    }

    public void checkRead(String string, Object object) {
        this.checkRead(string, (URL)object);
    }

    public void checkWrite(String string) {
        if (this.inApplet()) {
            this.checkWrite(string, (URL)this.getSecurityContext());
        }
    }

    public void checkWrite(String string, URL uRL) {
        if (this.inApplet()) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.writeACL.length == 0) {
                switch (this.getFileSystemSecurity()) {
                    case 1: {
                        if (uRL != null && uRL.getProtocol().equals("file")) break;
                    }
                    case 0: {
                        throw new JMAppletSecurityExc("file.write", string);
                    }
                }
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new JMAppletSecurityExc("checkwrite.exception", iOException.getMessage(), string);
            }
            int n = this.writeACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.writeACL[n])) continue;
                return;
            }
            throw new JMAppletSecurityExc("checkwrite", String.valueOf(string) + string2);
        }
    }

    public synchronized void checkDelete(String string) {
        this.checkWrite(string);
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid()) {
            throw new JMAppletSecurityExc("checkfd.read");
        }
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid()) {
            throw new JMAppletSecurityExc("checkwrite.fd");
        }
    }

    public synchronized void checkListen(int n) {
        if (this.inApplet() && n > 0 && n < 1024) {
            throw new JMAppletSecurityExc("checklisten", String.valueOf(n));
        }
    }

    public synchronized void checkAccept(String string, int n) {
        if (this.inApplet() && n < 1024) {
            throw new JMAppletSecurityExc("checkaccept", String.valueOf(string) + ":" + String.valueOf(n));
        }
        this.checkConnect(string, n);
    }

    public void xxxxcheckListen(int n) {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("socket.listen", String.valueOf(n));
        }
    }

    public void xxxxcheckAccept(String string, int n) {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("socket.accept", String.valueOf(string) + ":" + String.valueOf(n));
        }
    }

    public void checkConnect(String string, int n) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return;
        }
        int n2 = this.classDepth("sun.net.www.http.HttpClient");
        if (n2 > 0) {
            return;
        }
        if (!(classLoader instanceof JMAppletClassLoader)) {
            throw new JMAppletSecurityExc("checkconnect.unknown");
        }
        JMAppletClassLoader jMAppletClassLoader = (JMAppletClassLoader)((Object)classLoader);
        this.checkConnect(jMAppletClassLoader.getCodeBase(), string);
    }

    public void checkConnect(URL uRL, String string) {
        if (uRL.getProtocol().equals("file")) {
            return;
        }
        this.checkConnect(uRL.getHost(), string);
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
        if (object != null) {
            this.checkConnect((URL)object, string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkConnect(String string, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        switch (this.getNetworkSecurity()) {
            case 0: {
                if (string.equals(string2)) {
                    return;
                }
                throw new JMAppletSecurityExc("socket.connect", String.valueOf(string) + "->" + string2);
            }
            case 1: {
                try {
                    this.inCheck = true;
                    if (!string.equals(string2)) {
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string2);
                            InetAddress inetAddress2 = InetAddress.getByName(string);
                            if (inetAddress2.equals(inetAddress)) {
                                Object var5_7 = null;
                                this.inCheck = false;
                                return;
                            }
                            throw new JMAppletSecurityExc("Couldn't connect to " + string2 + " with origin from " + string);
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw new JMAppletSecurityExc("Couldn't resolve IP for host " + string2 + " or for " + string + ".");
                        }
                    }
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (bl) {
                            Object var5_9 = null;
                            this.inCheck = false;
                            return;
                        }
                        throw new JMAppletSecurityExc("Could not resolve IP for host " + string2 + ". See the trustProxy property.");
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    this.inCheck = false;
                    throw throwable;
                }
                Object var5_8 = null;
                this.inCheck = false;
                return;
            }
            case 2: {
                return;
            }
        }
        throw new JMAppletSecurityExc("checkconnect", String.valueOf(string) + "->" + string2);
    }

    public void checkConnect(String string, String string2) {
        this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
    }

    public boolean checkTopLevelWindow(Object object) {
        return !this.inClassLoader();
    }

    private void checkForPackageStuff(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string3 = string3 == null ? string4 : String.valueOf(string3) + "." + string4;
            if (!Boolean.getBoolean(String.valueOf(string) + string3)) continue;
            throw new SecurityException(string2);
        }
    }

    public void checkPackageAccess(String string) {
        if (this.getAccessRestrict() && this.inClassLoader()) {
            this.checkForPackageStuff("package.restrict.access.", string);
        }
    }

    public void checkPackageDefinition(String string) {
        if (this.getDefineRestrict() && this.inClassLoader()) {
            this.checkForPackageStuff("package.restrict.definition.", string);
        }
    }

    public void checkSetFactory() {
        if (this.inApplet() && !this.inClass("sun.net.www.MimeTable")) {
            throw new JMAppletSecurityExc("cannotsetfactory");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
            throw new JMAppletSecurityExc("checkmemberaccess");
        }
    }

    public void checkPrintJobAccess() {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        throw new JMAppletSecurityExc("checkawteventqueueaccess");
    }

    public void checkSecurityAccess(String string) {
        if (this.inApplet()) {
            throw new JMAppletSecurityExc("checksecurityaccess", string);
        }
    }

    public ThreadGroup getThreadGroup() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null && classLoader instanceof JMAppletClassLoader) {
            JMAppletClassLoader jMAppletClassLoader = (JMAppletClassLoader)((Object)classLoader);
            JMAppletPage jMAppletPage = jMAppletClassLoader.getPage();
            return jMAppletPage.getGroupForCurrentLoaderAndContext(jMAppletClassLoader);
        }
        return super.getThreadGroup();
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    JMProxyInfoOld getProxyProps(String string) {
        JMProxyInfoOld jMProxyInfoOld = new JMProxyInfoOld();
        jMProxyInfoOld.itsSet = Boolean.getBoolean(String.valueOf(string) + "Set");
        jMProxyInfoOld.itsName = System.getProperty(String.valueOf(string) + "Host", "");
        jMProxyInfoOld.itsPort = Integer.parseInt(System.getProperty(String.valueOf(string) + "Port", "80").trim());
        return jMProxyInfoOld;
    }

    void setProxyProps(String string, JMProxyInfoOld jMProxyInfoOld) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put(String.valueOf(string) + "Set", new Boolean(jMProxyInfoOld.itsSet).toString());
        ((Hashtable)properties).put(String.valueOf(string) + "Host", jMProxyInfoOld.itsName);
        ((Hashtable)properties).put(String.valueOf(string) + "Port", new Integer(jMProxyInfoOld.itsPort).toString());
    }

    JMProxyInfoOld getProxyInfo() {
        return this.getProxyProps("proxy");
    }

    void setProxyInfo(JMProxyInfoOld jMProxyInfoOld) {
        this.setProxyProps("proxy", jMProxyInfoOld);
    }

    JMProxyInfoOld getFirewallInfo() {
        return this.getProxyProps("firewall");
    }

    void setFirewallInfo(JMProxyInfoOld jMProxyInfoOld) {
        this.setProxyProps("firewall", jMProxyInfoOld);
    }

    JMProxyInfoOld getFTPInfo() {
        return this.getProxyProps("ftpProxy");
    }

    void setFTPInfo(JMProxyInfoOld jMProxyInfoOld) {
        this.setProxyProps("ftpProxy", jMProxyInfoOld);
    }

    synchronized int getNetworkSecurity() {
        JMAppletSecurity jMAppletSecurity = this.getSecurityOptions();
        if (jMAppletSecurity != null) {
            return jMAppletSecurity.getNetworkAccess();
        }
        return 1;
    }

    synchronized int getFileSystemSecurity() {
        JMAppletSecurity jMAppletSecurity = this.getSecurityOptions();
        if (jMAppletSecurity != null) {
            return jMAppletSecurity.getFilesystemAccess();
        }
        return 1;
    }

    synchronized boolean getAccessRestrict() {
        JMAppletSecurity jMAppletSecurity = this.getSecurityOptions();
        if (jMAppletSecurity != null) {
            return jMAppletSecurity.getRestrictSystemAccess();
        }
        return true;
    }

    synchronized boolean getDefineRestrict() {
        JMAppletSecurity jMAppletSecurity = this.getSecurityOptions();
        if (jMAppletSecurity != null) {
            return jMAppletSecurity.getRestrictSystemDefine();
        }
        return true;
    }

    JMAppletSecurity getSecurityOptions() {
        JMAppletSecurity jMAppletSecurity = null;
        try {
            JMThreadGroup jMThreadGroup = (JMThreadGroup)this.getThreadGroup();
            JMAWTContextImpl jMAWTContextImpl = JMAWTContextImpl.getContextFromRef(jMThreadGroup.getContext());
            JMAppletViewerImpl jMAppletViewerImpl = jMAWTContextImpl.getAppletViewer().getViewerImpl();
            jMAppletSecurity = jMAppletViewerImpl.getAppletSecurity();
        }
        catch (Throwable throwable) {}
        return jMAppletSecurity;
    }
}

