/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.JMAppletClassEntry;
import com.apple.mrj.JManager.JMAppletClassLoader_IMPL;
import com.apple.mrj.JManager.JMAppletSecurityExc;
import com.apple.mrj.JManager.ULAWAudioBuffer;
import com.apple.mrj.JManager.ULAWAudioClip;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Identity;
import java.security.IdentityScope;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import sun.awt.image.URLImageSource;
import sun.tools.jar.JarImageSource;
import sun.tools.jar.JarVerifierStream;
import sun.tools.jar.Manifest;

public class JMAppletResourceLoader {
    static boolean debug = false;
    static boolean verboseResourceLoading = false;
    private static String aClassFileString = new String("A CLASS FILE");
    private static Hashtable imgHash = new Hashtable();
    private static Hashtable audioHash = new Hashtable();
    private static Hashtable resourceHash = new Hashtable();
    private static Hashtable mimeHash = new Hashtable();
    JMAppletClassLoader_IMPL loader;
    IdentityScope scope;

    private void verbose(String string) {
        if (verboseResourceLoading) {
            System.out.println(string);
        }
    }

    static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static void debug(String string, Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
        System.out.println("sun.applet.AppletResourceLoader:::" + string);
    }

    public JMAppletResourceLoader(JMAppletClassLoader_IMPL jMAppletClassLoader_IMPL) {
        this.loader = jMAppletClassLoader_IMPL;
        this.scope = IdentityScope.getSystemScope();
    }

    void loadJar(URL uRL, String string) throws IOException {
        JMAppletResourceLoader.debug("jarLoader: loading jar " + uRL + "/" + string);
        URL uRL2 = new URL(uRL, string);
        JarVerifierStream jarVerifierStream = null;
        Hashtable<Object, Manifest> hashtable = new Hashtable<Object, Manifest>();
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                jarVerifierStream = new JarVerifierStream(uRL2.openStream());
                ZipEntry zipEntry = null;
                while ((zipEntry = jarVerifierStream.getNextEntry()) != null) {
                    Object object4;
                    int n;
                    object3 = zipEntry.getName();
                    object2 = null;
                    object = null;
                    byteArrayOutputStream.reset();
                    while ((n = jarVerifierStream.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    int n2 = byArray2.length;
                    if (object2 == null) {
                        object2 = this.guessManifestType((String)object3);
                    }
                    if (object2 == null) {
                        object4 = new ByteArrayInputStream(byArray2);
                        object2 = URLConnection.guessContentTypeFromStream((InputStream)object4);
                    }
                    if (object2 == null) {
                        object2 = "input-stream/input-stream";
                    }
                    if (debug) {
                        JMAppletResourceLoader.debug("loading " + (String)object3 + " (most likely guessed mime-type: " + (String)object2 + ")");
                    }
                    if (((String)object2).startsWith("image")) {
                        this.putLocalResource(new URL(uRL, (String)object3), byArray2, (String)object2);
                    } else if (((String)object2).startsWith("audio")) {
                        this.putLocalResource(new URL(uRL, (String)object3), byArray2, (String)object2);
                    } else if (((String)object2).startsWith("input-stream")) {
                        this.putLocalResource(new URL(uRL, (String)object3), byArray2, (String)object2);
                        object4 = new ByteArrayInputStream(byArray2);
                        object = object4;
                    } else if (((String)object2).startsWith("application/java-vm")) {
                        this.markLocalClass(new URL(uRL, (String)object3), (String)object2);
                        object4 = ((String)object3).substring(0, ((String)object3).length() - 6).replace('/', '.');
                        object = this.loader.defineClassFromBytes((String)object4, byArray2, 0, byArray2.length);
                        ((JMAppletClassEntry)object).ids = jarVerifierStream.getIdentities((String)object3);
                    } else if (!((String)object2).equals("manifest/manifest") && !((String)object2).equals("manifest/signature-bin")) {
                        this.putLocalResource(new URL(uRL, (String)object3), byArray2, (String)object2);
                    }
                    if (object == null) continue;
                    hashtable.put(object3, (Manifest)object);
                    object = null;
                }
                object3 = jarVerifierStream.getBlocks();
                object2 = jarVerifierStream.getNameToHash();
                object = jarVerifierStream.getManifest();
                if (object3 != null) {
                    this.signObjects(jarVerifierStream.getVerifiedSignatures(), hashtable);
                } else {
                    JMAppletResourceLoader.debug("BLOCK is null");
                }
            }
            catch (IOException iOException) {
                JMAppletResourceLoader.debug("IOException loading archive: " + iOException);
            }
            Object var9_17 = null;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            JMAppletResourceLoader.debug("Closing jar input stream");
            if (jarVerifierStream != null) {
                jarVerifierStream.close();
            }
            throw throwable;
        }
        JMAppletResourceLoader.debug("Closing jar input stream");
        if (jarVerifierStream != null) {
            jarVerifierStream.close();
        }
    }

    private void signObjects(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            JMAppletClassEntry jMAppletClassEntry;
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            Object v = hashtable2.get(string);
            Object[] objectArray = new Identity[vector.size()];
            vector.copyInto(objectArray);
            if (!(v instanceof JMAppletClassEntry) || (jMAppletClassEntry = (JMAppletClassEntry)this.loader.rawClasses.get(v)) == null || jMAppletClassEntry != v) continue;
            jMAppletClassEntry.ids = objectArray;
        }
    }

    String guessManifestType(String string) {
        if ((string = string.toUpperCase()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("META-INF/")) {
            return null;
        }
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return "manifest/manifest";
        }
        if (string.endsWith("DSA") || string.endsWith("PK7") || string.endsWith("PGP")) {
            return "manifest/signature-bin";
        }
        if (string.endsWith("SF")) {
            return "manifest/signature-asc";
        }
        return null;
    }

    static synchronized AudioClip getAudioClipFromCache(URL uRL) {
        ULAWAudioBuffer uLAWAudioBuffer;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
        }
        if ((uLAWAudioBuffer = (ULAWAudioBuffer)audioHash.get(uRL)) == null) {
            Object v = resourceHash.get(uRL);
            Object v2 = mimeHash.get(uRL);
            uLAWAudioBuffer = v != null && v2 != null && ((String)v2).startsWith("audio") ? new ULAWAudioBuffer(uRL, (byte[])v) : new ULAWAudioBuffer(uRL);
            audioHash.put(uRL, uLAWAudioBuffer);
        }
        return new ULAWAudioClip(uLAWAudioBuffer);
    }

    public AudioClip getAudioClip(URL uRL) {
        return JMAppletResourceLoader.getAudioClipFromCache(uRL);
    }

    public static void flushAudio() {
        audioHash = new Hashtable();
    }

    static synchronized Image getImageFromHash(URL uRL) {
        Image image;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
        }
        if ((image = (Image)imgHash.get(uRL)) == null) {
            Object v = resourceHash.get(uRL);
            Object v2 = mimeHash.get(uRL);
            URLImageSource uRLImageSource = null;
            uRLImageSource = v != null && v2 != null && ((String)v2).startsWith("image") ? new JarImageSource(uRL, (byte[])v, (String)v2) : new URLImageSource(uRL);
            image = Toolkit.getDefaultToolkit().createImage(uRLImageSource);
            imgHash.put(uRL, image);
        }
        return image;
    }

    public Image getImage(URL uRL) {
        return JMAppletResourceLoader.getImageFromHash(uRL);
    }

    public static void flushImages() {
        imgHash = new Hashtable();
    }

    private void markLocalClass(URL uRL, String string) {
        resourceHash.put(uRL, aClassFileString);
        mimeHash.put(uRL, string);
    }

    private void putLocalResource(URL uRL, byte[] byArray, String string) {
        resourceHash.put(uRL, byArray);
        mimeHash.put(uRL, string);
    }

    public static synchronized Object getLocalResource(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        Object object = mimeHash.get(uRL);
        if (object == null) {
            return null;
        }
        String string = (String)object;
        if (string.startsWith("audio") && (object = JMAppletResourceLoader.getAudioClipFromCache(uRL)) != null) {
            return object;
        }
        object = resourceHash.get(uRL);
        if (object instanceof String) {
            throw new JMAppletSecurityExc("getresource.noclassaccess", uRL.toString());
        }
        byte[] byArray = (byte[])object;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        if (string.startsWith("image")) {
            JarImageSource jarImageSource = new JarImageSource(uRL, byArray, string);
            return jarImageSource;
        }
        return bufferedInputStream;
    }

    public static InputStream getLocalResourceStream(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        BufferedInputStream bufferedInputStream = null;
        Object v = resourceHash.get(uRL);
        bufferedInputStream = (BufferedInputStream)v;
        if (v != null) {
            if (bufferedInputStream instanceof String) {
                throw new JMAppletSecurityExc("getresource.noclassaccess", uRL.toString());
            }
            byte[] byArray = (byte[])bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            return bufferedInputStream;
        }
        return null;
    }

    public String getResourceAsName(String string) {
        URL uRL;
        this.verbose("JMAppletResourceLoader.getResourceAsName for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        Object v = resourceHash.get(uRL);
        if (v != null) {
            this.verbose("Found resource: " + string + " in some jar archive for base: " + uRL2);
            try {
                uRL = new URL("appletresource", uRL2.getHost(), uRL2.getPort(), "/" + uRL2.toExternalForm() + "/+/" + string);
                return uRL.toExternalForm();
            }
            catch (Exception exception) {
                this.verbose("Exception " + exception + " while building a resource URL");
                return null;
            }
        }
        return uRL.toExternalForm();
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL;
        this.verbose("JMAppletResourceLoader.getResourceAsStream for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        InputStream inputStream = JMAppletResourceLoader.getLocalResourceStream(uRL);
        if (inputStream != null) {
            this.verbose("Found resource: " + string + " in jar archive file");
            return inputStream;
        }
        this.verbose("Opening stream to: " + uRL + " to get resource " + string);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    inputStream = uRL.openStream();
                }
                if (n >= 400) {
                    inputStream = null;
                }
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return inputStream;
    }

    void resetLocalResources() {
        resourceHash.clear();
    }
}

