/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.JMReferenced;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JMAppletLocator
extends JMReferenced
implements Runnable {
    URL itsDoc;
    Vector itsAttrs;
    int itsStatus = 0;
    String itsHtmlText;
    String encoding;
    int c;
    private String[][] theUpdateTable = new String[][]{{"archive", "zipbase"}};
    static String[] knownStrings = new String[]{"zipbase", "archive", "codebase", "code", "object", "width", "height", "name"};

    public JMAppletLocator(int n, String string, String string2) {
        super(n);
        this.itsAttrs = new Vector();
        try {
            this.itsDoc = new URL(string);
        }
        catch (Exception exception) {
            this.checkStartupException(exception);
            this.signalCompletion(this.getRef(), this.itsStatus);
            return;
        }
        this.itsHtmlText = string2;
    }

    public JMAppletLocator(int n, String string, Hashtable hashtable) {
        super(n);
        this.itsAttrs = new Vector();
        this.updateTags(hashtable);
        this.itsAttrs.addElement(hashtable);
        try {
            this.itsDoc = new URL(string);
        }
        catch (Exception exception) {
            this.itsDoc = null;
            this.checkStartupException(exception);
        }
        if (this.itsDoc == null && this.itsStatus == 0) {
            this.itsStatus = 4;
        }
    }

    public void startLocating() {
        if (this.itsHtmlText != null) {
            try {
                try {
                    this.parse(new StringReader(this.itsHtmlText));
                }
                catch (Exception exception) {
                    this.checkStartupException(exception);
                }
                Object var2_2 = null;
                this.itsHtmlText = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.itsHtmlText = null;
                throw throwable;
            }
            this.signalCompletion(this.getRef(), this.itsStatus);
        } else {
            new Thread(this).start();
        }
    }

    private native void signalCompletion(int var1, int var2);

    private void checkStartupException(Exception exception) {
        this.itsStatus = 4;
        try {
            throw exception;
        }
        catch (UnknownHostException unknownHostException) {
            this.itsStatus = 1;
        }
        catch (MalformedURLException malformedURLException) {
            this.itsStatus = 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.itsStatus = 2;
        }
        catch (IOException iOException) {
            this.itsStatus = 2;
        }
        catch (Exception exception2) {
            this.itsStatus = 4;
        }
    }

    public synchronized void run() {
        try {
            Object object;
            Object object2;
            URLConnection uRLConnection = this.itsDoc.openConnection();
            String string = uRLConnection.getContentType();
            if (string != null) {
                object2 = new StringTokenizer(string, "\"", true);
                block2: while (this.encoding == null && ((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (((String)object).equals("\"")) {
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            object = ((StringTokenizer)object2).nextToken();
                            if (((String)object).equals("\"")) continue block2;
                        }
                        continue;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, "; \r\n\t");
                    while (this.encoding == null && stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!string2.startsWith("charset=") || string2.length() <= 8) continue;
                        this.encoding = string2.substring(8);
                    }
                }
            }
            if (this.encoding == null) {
                this.encoding = "8859_1";
            }
            object2 = uRLConnection.getInputStream();
            object = this.makeReader((InputStream)object2, this.encoding);
            this.parse((Reader)object);
        }
        catch (Exception exception) {
            this.checkStartupException(exception);
        }
        this.signalCompletion(this.getRef(), this.itsStatus);
    }

    public int getStatus() {
        return this.itsStatus;
    }

    void skipSpace(Reader reader) throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13)) {
            this.c = reader.read();
        }
    }

    String scanIdentifier(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.c >= 97 && this.c <= 122 || this.c >= 65 && this.c <= 90 || this.c >= 48 && this.c <= 57 || this.c == 95) {
            stringBuffer.append((char)this.c);
            this.c = reader.read();
        }
        return stringBuffer.toString();
    }

    Hashtable scanTag(Reader reader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.skipSpace(reader);
        while (this.c >= 0 && this.c != 62) {
            String string = this.scanIdentifier(reader);
            String string2 = "";
            this.skipSpace(reader);
            if (this.c == 61) {
                int n = -1;
                this.c = reader.read();
                this.skipSpace(reader);
                if (this.c == 39 || this.c == 34) {
                    n = this.c;
                    this.c = reader.read();
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (this.c > 0 && (n < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || n >= 0 && this.c != n)) {
                    stringBuffer.append((char)this.c);
                    this.c = reader.read();
                }
                if (this.c == n) {
                    this.c = reader.read();
                }
                this.skipSpace(reader);
                string2 = stringBuffer.toString();
            }
            if (string.equalsIgnoreCase("applet")) continue;
            if (string2.length() == 0 && this.c != 62) {
                do {
                    this.c = reader.read();
                } while (this.c == 32 || this.c == 9);
            }
            hashtable.put(string.toLowerCase(), string2);
            this.skipSpace(reader);
        }
        return hashtable;
    }

    private void fixup(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        try {
            int n = string2.indexOf(37);
            if (n > 0) {
                int n2 = Integer.parseInt(string2 = string2.substring(0, n));
                if (n2 < 0) {
                    throw new NumberFormatException("percent value too small");
                }
                double d = 0.0;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                d = string.equals("width") ? (double)dimension.width : (double)dimension.height;
                d *= 0.75;
                if ((d *= (double)n2 / 100.0) < 0.0) {
                    throw new NumberFormatException("calculated percent value too small");
                }
                hashtable.put(string, Integer.toString((int)d));
                return;
            }
            int n3 = string2.length();
            int n4 = 0;
            while (n4 < n3) {
                char c = string2.charAt(n4);
                if (c < '0' || c > '9') {
                    hashtable.put(string, string2.substring(0, n4));
                    break;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            hashtable.put(string, "250");
        }
    }

    private void fixupNumerics(Hashtable hashtable) {
        this.fixup(hashtable, "width");
        this.fixup(hashtable, "height");
    }

    private void updateTags(Hashtable hashtable) {
        int n = 0;
        while (n < this.theUpdateTable.length) {
            Object v = hashtable.get(this.theUpdateTable[n][0]);
            if (v != null) {
                hashtable.put(this.theUpdateTable[n][1], v);
            }
            ++n;
        }
    }

    private Reader makeReader(InputStream inputStream, String string) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
        }
        return bufferedReader;
    }

    void parse(Reader reader) throws IOException {
        Hashtable hashtable = null;
        this.c = reader.read();
        block0: while (this.c >= 0) {
            if (this.c == 60) {
                Hashtable hashtable2;
                String string;
                this.c = reader.read();
                if (this.c == 47) {
                    this.c = reader.read();
                    string = this.scanIdentifier(reader);
                    if (!string.equalsIgnoreCase("applet")) continue;
                    if (hashtable != null) {
                        this.fixupNumerics(hashtable);
                        this.updateTags(hashtable);
                        this.itsAttrs.addElement(hashtable);
                    }
                    hashtable = null;
                    continue;
                }
                if (this.c == 33) {
                    this.c = reader.read();
                    if (this.c != 45) continue;
                    this.c = reader.read();
                    if (this.c != 45) continue;
                    int n = 0;
                    while (true) {
                        this.c = reader.read();
                        if (this.c < 0 || this.c == 62 && n >= 2) continue block0;
                        if (this.c == 45) {
                            ++n;
                            continue;
                        }
                        n = 0;
                    }
                }
                string = this.scanIdentifier(reader);
                if (string.equalsIgnoreCase("param")) {
                    hashtable2 = this.scanTag(reader);
                    String string2 = (String)hashtable2.get("name");
                    if (string2 == null) {
                        System.out.println("Warning: <param name=... value=...> tag requires name attribute.");
                        continue;
                    }
                    String string3 = (String)hashtable2.get("value");
                    if (string3 == null) {
                        System.out.println("Warning: <param name=... value=...> tag requires value attribute.");
                        continue;
                    }
                    if (hashtable != null) {
                        hashtable.put(string2.toLowerCase(), string3);
                        continue;
                    }
                    System.out.println("Warning: <param> tag outside <applet> ... </applet>.");
                    continue;
                }
                if (string.equalsIgnoreCase("applet")) {
                    hashtable = this.scanTag(reader);
                    if (hashtable.get("code") == null && hashtable.get("object") == null) {
                        System.out.println("Warning: <applet> tag requires code or object attribute.");
                        hashtable = null;
                        continue;
                    }
                    if (hashtable.get("width") == null) {
                        System.out.println("Warning: <applet> tag requires width attribute.");
                        hashtable = null;
                        continue;
                    }
                    if (hashtable.get("height") != null) continue;
                    System.out.println("Warning: <applet> tag requires height attribute.");
                    hashtable = null;
                    continue;
                }
                if (!string.equalsIgnoreCase("app")) continue;
                System.out.println("Warning: <app> tag no longer supported, use <applet> instead:");
                hashtable2 = this.scanTag(reader);
                string = (String)hashtable2.get("class");
                if (string != null) {
                    hashtable2.remove("class");
                    hashtable2.put("code", String.valueOf(string) + ".class");
                }
                if ((string = (String)hashtable2.get("src")) != null) {
                    hashtable2.remove("src");
                    hashtable2.put("codebase", string);
                }
                if (hashtable2.get("width") == null) {
                    hashtable2.put("width", "100");
                }
                if (hashtable2.get("height") != null) continue;
                hashtable2.put("height", "100");
                continue;
            }
            this.c = reader.read();
        }
        reader.close();
    }

    String getTag(Hashtable hashtable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print("<applet");
        String string = (String)hashtable.get("zipbase");
        if (string != null) {
            printStream.print(" zipbase=\"" + string + "\"");
        }
        if ((string = (String)hashtable.get("codebase")) != null) {
            printStream.print(" codebase=\"" + string + "\"");
        }
        if ((string = (String)hashtable.get("code")) == null) {
            string = "applet.class";
        }
        printStream.print(" code=\"" + string + "\"");
        string = (String)hashtable.get("width");
        if (string == null) {
            string = "150";
        }
        printStream.print(" width=" + string);
        string = (String)hashtable.get("height");
        if (string == null) {
            string = "100";
        }
        printStream.print(" height=" + string);
        string = (String)hashtable.get("name");
        if (string != null) {
            printStream.print(" name=\"" + string + "\"");
        }
        printStream.println(">");
        int n = hashtable.size();
        String[] stringArray = new String[n];
        n = 0;
        Enumeration enumeration = hashtable.keys();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n2 = 0;
            while (n2 < knownStrings.length) {
                if (string2.equals(knownStrings[n2])) continue block0;
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                if (stringArray[n3].compareTo(string2) >= 0) break;
                ++n3;
            }
            System.arraycopy(stringArray, n3, stringArray, n3 + 1, n - n3);
            stringArray[n3] = string2;
            ++n;
        }
        int n4 = 0;
        while (n4 < n) {
            printStream.println("\t<param name=\"" + stringArray[n4] + "\" value=\"" + (String)hashtable.get(stringArray[n4]) + "\">");
            ++n4;
        }
        printStream.println("</applet>");
        return byteArrayOutputStream.toString();
    }

    public int countApplets() {
        return this.itsAttrs.size();
    }

    public URL getURL() {
        return this.itsDoc;
    }

    public Hashtable getAppletAttrs(int n) {
        return (Hashtable)this.itsAttrs.elementAt(n);
    }

    public String getTag(int n) {
        return this.getTag(this.getAppletAttrs(n));
    }

    public String getName(int n) {
        Hashtable hashtable = this.getAppletAttrs(n);
        if (hashtable == null) {
            return null;
        }
        String string = (String)hashtable.get("name");
        if (string == null) {
            string = (String)hashtable.get("code");
        }
        return string;
    }

    public Dimension getDimensions(int n) {
        String string;
        Hashtable hashtable = this.getAppletAttrs(n);
        int n2 = hashtable == null || (string = (String)hashtable.get("width")) == null ? 100 : Integer.parseInt(string);
        int n3 = hashtable == null || (string = (String)hashtable.get("height")) == null ? 100 : Integer.parseInt(string);
        return new Dimension(n2, n3);
    }
}

