/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.memory.MemoryObject;

public class ByteObject
extends MemoryObject {
    protected byte[] bytes;

    protected ByteObject(int n) {
        this.init(n);
    }

    protected void init() {
        this.init(0);
    }

    protected void init(int n) {
        this.bytes = new byte[n];
    }

    protected ByteObject(byte[] byArray) {
        this.bytes = byArray;
    }

    protected ByteObject(int n, MemoryObject memoryObject) {
        this.init();
        this.setBytesAt(0, this.getSize(), memoryObject, n);
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getSize() {
        return this.bytes.length;
    }

    public final byte getByteAt(int n) {
        return this.bytes[n];
    }

    public final short getShortAt(int n) {
        return ByteObject.getShortAt(this.bytes, n);
    }

    public final int getIntAt(int n) {
        return ByteObject.getIntAt(this.bytes, n);
    }

    public final long getLongAt(int n) {
        return ByteObject.getLongAt(this.bytes, n);
    }

    public final float getFloatAt(int n) {
        return ByteObject.getFloatAt(this.bytes, n);
    }

    public final double getDoubleAt(int n) {
        return ByteObject.getDoubleAt(this.bytes, n);
    }

    public final void setByteAt(int n, byte by) {
        this.bytes[n] = by;
    }

    public final void setShortAt(int n, short s) {
        ByteObject.setShortAt(this.bytes, n, s);
    }

    public final void setIntAt(int n, int n2) {
        ByteObject.setIntAt(this.bytes, n, n2);
    }

    public final void setLongAt(int n, long l) {
        ByteObject.setLongAt(this.bytes, n, l);
    }

    public final void setFloatAt(int n, float f) {
        ByteObject.setFloatAt(this.bytes, n, f);
    }

    public final void setDoubleAt(int n, double d) {
        ByteObject.setDoubleAt(this.bytes, n, d);
    }

    private static native short getShortAt(byte[] var0, int var1);

    private static native int getIntAt(byte[] var0, int var1);

    private static native long getLongAt(byte[] var0, int var1);

    private static native float getFloatAt(byte[] var0, int var1);

    private static native double getDoubleAt(byte[] var0, int var1);

    private static native void setShortAt(byte[] var0, int var1, short var2);

    private static native void setIntAt(byte[] var0, int var1, int var2);

    private static native void setLongAt(byte[] var0, int var1, long var2);

    private static native void setFloatAt(byte[] var0, int var1, float var2);

    private static native void setDoubleAt(byte[] var0, int var1, double var2);
}

