/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.Ptr;
import com.apple.MacOS.StringPtr;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.VoiceSpec;
import com.apple.NativeObject;
import com.apple.memory.Disposeable;

public class SpeechChannel
implements NativeObject,
Disposeable {
    private static String[] kNativeLibraryNames = new String[]{"SpeechLib"};
    private int channelRef;
    private Ptr oldTextPtr = null;

    public static synchronized void SpeakString(String string) throws MacOSError {
        MacOSError.CheckResult(SpeechChannel.SpeakString(new StringPtr(string).getBytes()));
    }

    public SpeechChannel() throws MacOSError {
        int[] nArray = new int[1];
        MacOSError.CheckResult(SpeechChannel.NewSpeechChannel(null, nArray));
        this.channelRef = nArray[0];
    }

    public SpeechChannel(VoiceSpec voiceSpec) throws MacOSError {
        int[] nArray = new int[1];
        MacOSError.CheckResult(SpeechChannel.NewSpeechChannel(voiceSpec, nArray));
        this.channelRef = nArray[0];
    }

    public void SpecifyVoice(VoiceSpec voiceSpec) throws MacOSError {
        this.Dispose();
        int[] nArray = new int[1];
        MacOSError.CheckResult(SpeechChannel.NewSpeechChannel(voiceSpec, nArray));
        this.channelRef = nArray[0];
    }

    public void Dispose() {
        if (this.channelRef != 0) {
            SpeechChannel.DisposeSpeechChannel(this.channelRef);
            this.channelRef = 0;
        }
        if (this.oldTextPtr != null) {
            this.oldTextPtr.Dispose();
            this.oldTextPtr = null;
        }
    }

    public synchronized void SpeakText(byte[] byArray, int n) throws MacOSError {
        Ptr ptr = new Ptr(byArray);
        MacOSError.CheckResult(SpeechChannel.SpeakText(this.channelRef, ptr.getPointer(), n));
        if (this.oldTextPtr != null) {
            this.oldTextPtr.Dispose();
        }
        this.oldTextPtr = ptr;
    }

    public void SpeakText(byte[] byArray) throws MacOSError {
        this.SpeakText(byArray, byArray.length);
    }

    public void SpeakText(String string) throws MacOSError {
        int n = string.length();
        byte[] byArray = TranslateString.asBytes(string);
        this.SpeakText(byArray, n);
    }

    public static boolean IsSpeechBusy() {
        return SpeechChannel.SpeechBusy() != 0;
    }

    public static boolean IsSpeechBusySystemWide() {
        return SpeechChannel.SpeechBusySystemWide() != 0;
    }

    protected void finalize() {
        if (this.channelRef != 0) {
            this.Dispose();
        }
    }

    private static native short SpeakString(byte[] var0);

    private static native short NewSpeechChannel(VoiceSpec var0, int[] var1);

    private static native void DisposeSpeechChannel(int var0);

    private static native short SpeakText(int var0, int var1, int var2);

    private static native short SpeechBusy();

    private static native short SpeechBusySystemWide();
}

