/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.SystemPointer;
import com.apple.memory.StdCLib;

public class SoundHeader
extends SystemPointer {
    public static final int rate44khz = -1404829696;
    public static final int rate22050hz = 1445068800;
    public static final int rate22khz = 1458473891;
    public static final int rate11khz = 729236945;
    public static final int rate11025hz = 722534400;
    public static final int rate8khz = 524288000;
    public static final int sizeOfSoundHeader = 22;

    public SoundHeader(byte[] byArray, int n, int n2, int n3, int n4) {
        super(22 + n, false);
        this.setSamplePtr(0);
        this.setLength(n);
        this.setSampleRate(n2);
        this.setLoopStart(n3);
        this.setLoopEnd(n4);
        this.setEncode((byte)0);
        this.setBaseFrequency((byte)60);
        if (byArray != null) {
            StdCLib.memcpy(this.pointer + 22, byArray, n);
        }
    }

    public SoundHeader(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, 0, n - 1);
    }

    public SoundHeader(int n, int n2) {
        this(null, n, n2, 0, n - 1);
    }

    public void setSamples(byte[] byArray, int n) {
        this.setLength(n);
        this.setLoopEnd(n - 1);
        StdCLib.memcpy(this.pointer + 22, byArray, n);
    }

    public final int getSamplePtr() {
        return this.getIntAt(0);
    }

    final void setSamplePtr(int n) {
        this.setIntAt(0, n);
    }

    public final int getLength() {
        return this.getIntAt(4);
    }

    public final void setLength(int n) {
        this.setIntAt(4, n);
    }

    public final int getSampleRate() {
        return this.getIntAt(8);
    }

    public final void setSampleRate(int n) {
        this.setIntAt(8, n);
    }

    public final void setLoopStart(int n) {
        this.setIntAt(12, n);
    }

    public final void setLoopEnd(int n) {
        this.setIntAt(16, n);
    }

    public final void setEncode(byte by) {
        this.setByteAt(20, by);
    }

    public final void setBaseFrequency(byte by) {
        this.setByteAt(21, by);
    }
}

