/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.Pattern;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.RgnHandle;
import com.apple.MacOS.Shape;
import com.apple.NativeObject;
import com.apple.memory.HandleObject;

public class Region
implements NativeObject,
Shape {
    private HandleObject handle;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public Region() {
        this.handle = new RgnHandle();
    }

    public Region(Rect rect) {
        this();
        this.SetRect(rect);
    }

    Region(HandleObject handleObject) {
        this.handle = handleObject;
    }

    public Region(int n) {
        this(new HandleObject(n));
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[bounds '" + this.Bounds() + "]";
    }

    public Rect Bounds() {
        return MemoryUtils.RectAt(this.handle, 2);
    }

    public void Copy(Region region) {
        Region.CopyRgn(region.getHandle(), this.getHandle());
    }

    public void SetRect(Rect rect) {
        Region.RectRgn(this.getHandle(), rect);
    }

    public void Diff(Region region, Region region2) {
        Region.DiffRgn(this.getHandle(), region.getHandle(), region2.getHandle());
    }

    public void Diff(Region region) {
        this.Diff(region, this);
    }

    public void Sect(Region region, Region region2) {
        Region.SectRgn(this.getHandle(), region.getHandle(), region2.getHandle());
    }

    public void Sect(Region region) {
        this.Sect(region, this);
    }

    public void Union(Region region, Region region2) {
        Region.UnionRgn(this.getHandle(), region.getHandle(), region2.getHandle());
    }

    public void Union(Region region) {
        this.Union(region, this);
    }

    public boolean Contains(Point point) {
        return Region.PtInRgn(point.toInt(), this.getHandle()) != 0;
    }

    public boolean Contains(Rect rect) {
        return Region.RectInRgn(rect, this.getHandle()) != 0;
    }

    public boolean Equal(Region region) {
        return Region.EqualRgn(this.getHandle(), region.getHandle()) != 0;
    }

    public boolean Empty() {
        return Region.EmptyRgn(this.getHandle()) != 0;
    }

    public void MoveTo(short s, short s2) {
        Rect rect = this.Bounds();
        Region.OffsetRgn(this.getHandle(), (short)(s - rect.getLeft()), (short)(s2 - rect.getTop()));
    }

    public void Offset(short s, short s2) {
        Region.OffsetRgn(this.getHandle(), s, s2);
    }

    public void Frame() {
        Region.FrameRgn(this.getHandle());
    }

    public void Paint() {
        Region.PaintRgn(this.getHandle());
    }

    public void Fill(Pattern pattern) {
        Region.FillRgn(this.getHandle(), pattern);
    }

    public void Invert() {
        Region.InvertRgn(this.getHandle());
    }

    public void Erase() {
        Region.EraseRgn(this.getHandle());
    }

    final int getHandle() {
        return this.handle.getHandle();
    }

    private static native void CopyRgn(int var0, int var1);

    private static native void SetEmptyRgn(int var0);

    private static native void SetRectRgn(int var0, short var1, short var2, short var3, short var4);

    private static native void RectRgn(int var0, Rect var1);

    private static native void OffsetRgn(int var0, short var1, short var2);

    private static native void InsetRgn(int var0, short var1, short var2);

    private static native void SectRgn(int var0, int var1, int var2);

    private static native void UnionRgn(int var0, int var1, int var2);

    private static native void DiffRgn(int var0, int var1, int var2);

    private static native void XorRgn(int var0, int var1, int var2);

    private static native short PtInRgn(int var0, int var1);

    private static native short RectInRgn(Rect var0, int var1);

    private static native short EqualRgn(int var0, int var1);

    private static native short EmptyRgn(int var0);

    private static native void FrameRgn(int var0);

    private static native void PaintRgn(int var0);

    private static native void FillRgn(int var0, Pattern var1);

    private static native void InvertRgn(int var0);

    private static native void EraseRgn(int var0);
}

