/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.Pattern;
import com.apple.MacOS.Point;
import com.apple.MacOS.Shape;
import com.apple.memory.MemoryObject;
import com.apple.memory.StructObject;
import java.awt.Rectangle;

public class Rect
extends StructObject
implements Shape {
    public short top;
    public short left;
    public short bottom;
    public short right;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public final short getTop() {
        return this.top;
    }

    public final short getLeft() {
        return this.left;
    }

    public final short getBottom() {
        return this.bottom;
    }

    public final short getRight() {
        return this.right;
    }

    public final void setTop(short s) {
        this.top = s;
    }

    public final void setLeft(short s) {
        this.left = s;
    }

    public final void setBottom(short s) {
        this.bottom = s;
    }

    public final void setRight(short s) {
        this.right = s;
    }

    public final void setTop(int n) {
        this.setTop((short)n);
    }

    public final void setLeft(int n) {
        this.setLeft((short)n);
    }

    public final void setBottom(int n) {
        this.setBottom((short)n);
    }

    public final void setRight(int n) {
        this.setRight((short)n);
    }

    public Rect() {
    }

    public Rect(int n, int n2, int n3, int n4) {
        Rect.SetRect(this, (short)n, (short)n2, (short)n3, (short)n4);
    }

    public Rect(Point point, Point point2) {
        Rect.SetRect(this, point.getH(), point.getV(), point2.getH(), point2.getV());
    }

    public Rect(Rect rect) {
        Rect.SetRect(this, rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public Rect(Rectangle rectangle) {
        Rect.SetRect(this, (short)rectangle.x, (short)rectangle.y, (short)(rectangle.width + rectangle.x), (short)(rectangle.y + rectangle.height));
    }

    public Rectangle asRectangle() {
        return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
    }

    protected Rect(MemoryObject memoryObject) {
        Rect.SetRect(this, memoryObject.getShortAt(2), memoryObject.getShortAt(0), memoryObject.getShortAt(6), memoryObject.getShortAt(4));
    }

    protected void CopyValue(int n, MemoryObject memoryObject) {
        memoryObject.setShortAt(n + 2, this.left);
        memoryObject.setShortAt(n, this.top);
        memoryObject.setShortAt(n + 6, this.right);
        memoryObject.setShortAt(n + 4, this.bottom);
    }

    public void Set(short s, short s2, short s3, short s4) {
        Rect.SetRect(this, s, s2, s3, s4);
    }

    public void Set(Rect rect) {
        Rect.SetRect(this, rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public void Set(Rectangle rectangle) {
        Rect.SetRect(this, (short)rectangle.x, (short)rectangle.y, (short)(rectangle.width + rectangle.x), (short)(rectangle.y + rectangle.height));
    }

    public Point topLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    public Point topRight() {
        return new Point(this.getRight(), this.getTop());
    }

    public Point bottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    public Point bottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    public short Width() {
        return (short)(this.getRight() - this.getLeft());
    }

    public short Height() {
        return (short)(this.getBottom() - this.getTop());
    }

    private boolean between(short s, short s2, short s3) {
        return s <= s2 && s2 <= s3;
    }

    public boolean Touches(Rect rect) {
        return !(!this.between(this.getTop(), rect.getTop(), this.getBottom()) && !this.between(this.getTop(), rect.getBottom(), this.getBottom()) || !this.between(this.getLeft(), rect.getLeft(), this.getRight()) && !this.between(this.getLeft(), rect.getRight(), this.getRight()));
    }

    public boolean Contains(Point point) {
        return Rect.PtInRect(point.toInt(), this) != 0;
    }

    public void MoveTo(short s, short s2) {
        Rect.OffsetRect(this, (short)(s - this.getLeft()), (short)(s2 - this.getTop()));
    }

    public void Offset(short s, short s2) {
        Rect.OffsetRect(this, s, s2);
    }

    public void Inset(short s, short s2) {
        Rect.InsetRect(this, s, s2);
    }

    public boolean Sect(Rect rect, Rect rect2) {
        return Rect.SectRect(this, rect, rect2);
    }

    public boolean Sect(Rect rect) {
        return this.Sect(rect, this);
    }

    public void Union(Rect rect, Rect rect2) {
        Rect.UnionRect(this, rect, rect2);
    }

    public void Union(Rect rect) {
        this.Union(rect, this);
    }

    public boolean Equal(Rect rect) {
        return Rect.EqualRect(this, rect);
    }

    public boolean Empty() {
        return Rect.EmptyRect(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [l " + this.left + ", t " + this.top + ", r " + this.right + ", b " + this.bottom + "]";
    }

    public void Frame() {
        Rect.FrameRect(this);
    }

    public void Paint() {
        Rect.PaintRect(this);
    }

    public void Fill(Pattern pattern) {
        Rect.FillRect(this, pattern);
    }

    public void Erase() {
        Rect.EraseRect(this);
    }

    public void Invert() {
        Rect.InvertRect(this);
    }

    public void Frame(short s, short s2) {
        Rect.FrameRoundRect(this, s, s2);
    }

    public void Paint(short s, short s2) {
        Rect.PaintRoundRect(this, s, s2);
    }

    public void Fill(short s, short s2, Pattern pattern) {
        Rect.FillRoundRect(this, s, s2, pattern);
    }

    public void Erase(short s, short s2) {
        Rect.EraseRoundRect(this, s, s2);
    }

    public void Invert(short s, short s2) {
        Rect.InvertRoundRect(this, s, s2);
    }

    private static native short PtInRect(int var0, Rect var1);

    private static native void OffsetRect(Rect var0, short var1, short var2);

    private static native void InsetRect(Rect var0, short var1, short var2);

    private static native void SetRect(Rect var0, short var1, short var2, short var3, short var4);

    private static native void FrameRect(Rect var0);

    private static native void PaintRect(Rect var0);

    private static native void FillRect(Rect var0, Pattern var1);

    private static native void EraseRect(Rect var0);

    private static native void InvertRect(Rect var0);

    private static native void FrameRoundRect(Rect var0, short var1, short var2);

    private static native void PaintRoundRect(Rect var0, short var1, short var2);

    private static native void FillRoundRect(Rect var0, short var1, short var2, Pattern var3);

    private static native void EraseRoundRect(Rect var0, short var1, short var2);

    private static native void InvertRoundRect(Rect var0, short var1, short var2);

    private static native boolean SectRect(Rect var0, Rect var1, Rect var2);

    private static native void UnionRect(Rect var0, Rect var1, Rect var2);

    private static native boolean EqualRect(Rect var0, Rect var1);

    private static native boolean EmptyRect(Rect var0);
}

