/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FontInfo;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.TextUtilities;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.WindowRef;
import com.apple.NativeObject;

public class QuickdrawFont
implements NativeObject {
    short font;
    short style;
    short size;
    FontInfo fontInfo;
    static QuickdrawFont SystemFont = new QuickdrawFont(0, 0, 0);
    static QuickdrawFont ApplicationFont = new QuickdrawFont(1, 0, 0);
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public QuickdrawFont(String string, short s, short s2) {
        Short s3 = new Short(0);
        QuickdrawFont.GetFNum(TranslateString.asPascalBytes(string), s3);
        this.font = s3;
        this.style = s;
        this.size = s2;
    }

    public QuickdrawFont(short s, short s2, short s3) {
        this.font = s;
        this.style = s2;
        this.size = s3;
    }

    public FontInfo GetFontInfo() {
        if (this.fontInfo == null) {
            this.fontInfo = new FontInfo(this);
        }
        return this.fontInfo;
    }

    public static QuickdrawFont SystemFont() {
        return SystemFont;
    }

    public static QuickdrawFont ApplicationFont() {
        return ApplicationFont;
    }

    public int TextWidth(String string, short s, short s2) {
        return this.TextWidth(TranslateString.asBytes(string), s, s2);
    }

    public int TextWidth(char[] cArray, short s, short s2) {
        return this.TextWidth(TranslateString.asBytes(cArray), s, s2);
    }

    public int TextWidth(byte[] byArray, short s, short s2) {
        WindowRef windowRef = WindowRef.GetFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.CurrentFont();
        this.install();
        short s3 = TextUtilities.TextWidth(byArray, s, s2);
        quickdrawFont.install();
        return s3;
    }

    public void MeasureText(short s, byte[] byArray, byte[] byArray2) {
        WindowRef windowRef = WindowRef.GetFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.CurrentFont();
        this.install();
        TextUtilities.MeasureText(s, byArray, byArray2);
        quickdrawFont.install();
    }

    public void Draw(byte[] byArray, short s, short s2) {
        WindowRef windowRef = WindowRef.GetFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.CurrentFont();
        this.install();
        TextUtilities.Draw(byArray, s, s2);
        quickdrawFont.install();
    }

    public short ascent() {
        return this.GetFontInfo().ascent;
    }

    public short descent() {
        return this.GetFontInfo().descent;
    }

    public short widMax() {
        return this.GetFontInfo().widMax;
    }

    public short leading() {
        return this.GetFontInfo().leading;
    }

    public short height() {
        return this.GetFontInfo().height();
    }

    public void install() {
        QuickdrawFont.TextFont(this.font);
        QuickdrawFont.TextFace(this.style);
        QuickdrawFont.TextSize(this.size);
    }

    private static native void TextFont(short var0);

    private static native void TextFace(short var0);

    private static native void TextMode(short var0);

    private static native void TextSize(short var0);

    private static native void GetFNum(byte[] var0, Short var1);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [font=" + this.font + ",style=" + this.style + ",size=" + this.size + "]";
    }
}

