/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.ProcessSerialNumber;
import com.apple.MacOS.StringPtr;
import com.apple.NativeObject;
import com.apple.memory.PointerObject;

public final class OSUtils
implements NativeObject {
    public static ProcessSerialNumber thisProcess;
    public static final int cTextFileType = 0x54455854;
    public static final int cJavaClassType = 1313836139;
    public static final String cJavaSrcFileExtension = ".java";
    public static final String cJavaClassFileExtension = ".class";
    public static final String cJavaProjectFileExtension = ".jproj";
    private static String[] kNativeLibraryNames;
    public static final short kOnSystemDisk = Short.MIN_VALUE;

    private OSUtils() {
    }

    private static native int LMGetCurApName();

    public static String getAppName() {
        PointerObject pointerObject = new PointerObject(OSUtils.LMGetCurApName(), 256);
        return pointerObject.PStringAt(0);
    }

    public static void DebugStr(String string) {
        new StringPtr(string).DebugStr();
    }

    public static native void Debugger();

    public static final int makeOSType(char c, char c2, char c3, char c4) {
        return c << 24 | c2 << 16 | c3 << 8 | c4;
    }

    public static final int makeOSType(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        int n = byArray.length >= 4 ? 4 : byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2++];
        }
        if (byArray.length < 4) {
            int n3 = byArray.length;
            while (n3 < 4) {
                byArray2[n3++] = 0;
            }
        }
        return byArray2[0] << 24 | byArray2[1] << 16 | byArray2[2] << 8 | byArray2[3];
    }

    public static final int makeOSType(String string) {
        return OSUtils.makeOSType(string.charAt(0), string.charAt(1), string.charAt(2), string.charAt(3));
    }

    public static final String osTypeToString(int n) {
        char[] cArray = new char[4];
        int n2 = 0;
        while (n2 < 4) {
            cArray[3 - n2] = (char)(n & 0xFF);
            n >>= 8;
            ++n2;
        }
        return new String(cArray, 0, 4);
    }

    public static native int Gestalt(int var0, int[] var1);

    public static int gestalt(String string) throws MacOSError {
        return OSUtils.gestalt(OSUtils.makeOSType(string));
    }

    public static int gestalt(int n) throws MacOSError {
        int[] nArray = new int[1];
        MacOSError.CheckResult(OSUtils.Gestalt(n, nArray));
        return nArray[0];
    }

    private static native short FindFolder(short var0, int var1, boolean var2, short[] var3, int[] var4);

    public static FSSpec findFolder(short s, int n, boolean bl) {
        short[] sArray = new short[]{s};
        int[] nArray = new int[]{2};
        MacOSError.CheckResult(OSUtils.FindFolder(s, n, bl, sArray, nArray));
        return new FSSpec(sArray[0], nArray[0]);
    }

    private static native int LMGetDoubleTime();

    public static int getDoubleClickTicks() {
        return OSUtils.LMGetDoubleTime();
    }

    static {
        kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;
        thisProcess = new ProcessSerialNumber();
    }
}

