/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import java.io.IOException;
import java.io.InputStream;

public class HandleInputStream
extends InputStream {
    Handle itsHandle;
    int itsSize;
    int itsOffset;
    int itsMark;

    public HandleInputStream(Handle handle) {
        this.itsHandle = handle;
        this.itsSize = this.itsHandle.getSize();
        this.itsOffset = 0;
        this.itsMark = 0;
    }

    public synchronized void close() {
        if (this.itsHandle != null) {
            this.itsHandle.Dispose();
            this.itsHandle = null;
        }
    }

    public synchronized int read() {
        int n = -1;
        if (this.itsOffset < this.itsSize) {
            n = this.itsHandle.getByteAt(this.itsOffset++);
            n &= 0xFF;
        }
        return n;
    }

    public void reset() {
        this.itsOffset = this.itsMark;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.itsSize - this.itsOffset;
        if (n2 > n3) {
            n2 = n3;
        }
        this.itsHandle.getBytes(this.itsOffset, byArray, n, n2);
        this.itsOffset += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = (int)(l & 0xFFFFFFFFEFFFFFFFL);
        this.itsOffset += n;
        return n;
    }

    public int available() throws IOException {
        return this.itsSize - this.itsOffset;
    }

    public void mark(int n) {
        this.itsMark = n;
    }

    public boolean markSupported() {
        return true;
    }
}

