/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.EventManager;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.OSType;
import com.apple.MacOS.Point;
import com.apple.MacOS.Ptr;
import com.apple.MacOS.Region;
import com.apple.MacOS.WindowRef;
import com.apple.memory.MemoryObject;
import com.apple.memory.StructObject;

public class EventRecord
extends StructObject
implements EventManager {
    short what;
    int message;
    int when;
    int where;
    short modifiers;
    private static Ptr myTransData = null;
    private static int[] myState = new int[1];
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public EventRecord() {
    }

    public EventRecord(MemoryObject memoryObject) {
        this.load(memoryObject, 0);
    }

    public EventRecord(MemoryObject memoryObject, int n) {
        this.load(memoryObject, n);
    }

    public void load(MemoryObject memoryObject, int n) {
        this.what = memoryObject.getShortAt(n);
        this.message = memoryObject.getIntAt(n + 2);
        this.when = memoryObject.getIntAt(n + 6);
        this.where = memoryObject.getIntAt(n + 10);
        this.modifiers = memoryObject.getShortAt(n + 14);
    }

    public void store(MemoryObject memoryObject, int n) {
        memoryObject.setShortAt(n, this.what);
        memoryObject.setIntAt(n + 2, this.message);
        memoryObject.setIntAt(n + 6, this.when);
        memoryObject.setIntAt(n + 10, this.where);
        memoryObject.setShortAt(n + 14, this.modifiers);
    }

    public static boolean cmdKeyDown(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean shiftKeyDown(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean optionKeyDown(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean controlKeyDown(int n) {
        return (n & 0x1000) != 0;
    }

    public static boolean activeFlag(int n) {
        return (n & 1) != 0;
    }

    public short getWhat() {
        return this.what;
    }

    public int getMessage() {
        return this.message;
    }

    public int getWhen() {
        return this.when;
    }

    public Point getWhere() {
        return new Point(this.where);
    }

    public OSType getEventID() {
        return new OSType(this.where);
    }

    public short getModifiers() {
        return this.modifiers;
    }

    public final char getCharCode() {
        return (char)(this.getMessage() & 0xFF);
    }

    public final char getKeyCode() {
        return (char)((this.getMessage() & 0xFF00) >> 8);
    }

    public boolean cmdKeyDown() {
        return EventRecord.cmdKeyDown(this.getModifiers());
    }

    public boolean shiftKeyDown() {
        return EventRecord.shiftKeyDown(this.getModifiers());
    }

    public boolean optionKeyDown() {
        return EventRecord.optionKeyDown(this.getModifiers());
    }

    public boolean controlKeyDown() {
        return EventRecord.controlKeyDown(this.getModifiers());
    }

    public boolean activeFlag() {
        return EventRecord.activeFlag(this.getModifiers());
    }

    public WindowRef GetWindowMessage() {
        return new WindowRef(this.getMessage());
    }

    public int FindWindow() {
        int[] nArray = new int[1];
        return EventRecord.FindWindow(this.where, nArray);
    }

    public int FindWindow(WindowRef windowRef) {
        return EventRecord.FindWindow(this.where, windowRef);
    }

    public final boolean WaitNextEvent(short s, int n, Region region) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventRecord.WaitNextEvent(s, this, n, region != null ? region.getHandle() : 0);
            Object var6_6 = null;
            return bl;
        }
    }

    public final boolean EventAvail(short s) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventRecord.EventAvail(s, this);
            Object var4_4 = null;
            return bl;
        }
    }

    public final boolean EventAvail() {
        return this.EventAvail((short)-1);
    }

    public final boolean GetNextEvent(short s) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventRecord.GetNextEvent(s, this);
            Object var4_4 = null;
            return bl;
        }
    }

    public final boolean GetNextEvent() {
        return this.GetNextEvent((short)-1);
    }

    public native void FlushEvents(short var1, short var2);

    public void SystemClick(WindowRef windowRef) {
        EventRecord.SystemClick(this, windowRef.getPointer());
    }

    public static native void SystemTask();

    public final boolean GetOSEvent(short s) {
        return EventRecord.GetOSEvent(s, this);
    }

    public final boolean GetOSEvent() {
        return EventRecord.GetOSEvent((short)-1, this);
    }

    public final boolean OSEventAvail(short s) {
        return EventRecord.OSEventAvail(s, this);
    }

    public final boolean OSEventAvail() {
        return EventRecord.OSEventAvail((short)-1, this);
    }

    public static native void SetEventMask(short var0);

    public static native short GetEventMask();

    public static int KeyTranslate(Ptr ptr, short s) {
        if (ptr != myTransData) {
            myTransData = ptr;
            EventRecord.myState[0] = 0;
        }
        return EventRecord.KeyTranslate(ptr, s, myState);
    }

    public static native int GetCaretTime();

    public static native int GetDblTime();

    public static native int TickCount();

    private static native boolean WaitNextEvent(short var0, EventRecord var1, int var2, int var3);

    private static native boolean GetNextEvent(short var0, EventRecord var1);

    private static native boolean EventAvail(short var0, EventRecord var1);

    private static native boolean GetOSEvent(short var0, EventRecord var1);

    private static native boolean OSEventAvail(short var0, EventRecord var1);

    private static native short FindWindow(int var0, int[] var1);

    private static native short FindWindow(int var0, MemoryObject var1);

    private static native int KeyTranslate(Ptr var0, short var1, int[] var2);

    private static native void SystemClick(EventRecord var0, int var1);
}

