/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.log.CFLogs;
import coldfusion.scheduling.CfSchedulerPathFilter;
import coldfusion.util.RB;

public class SchedulerValidator {
    private static final String RB_UNAUTHORIZED_PATH = "scheduler.unauthorized.path";
    private static final String RB_SECURITY_VIOLATION = "scheduler.security.violation";
    private static final String RB_PATH_VALIDATED = "scheduler.path.validated";
    private static final CfSchedulerPathFilter PATH_VALIDATOR = new CfSchedulerPathFilter();

    public static boolean isValidSchedulePath(String schedulePath) {
        boolean isValid = PATH_VALIDATOR.validatePath(schedulePath, true);
        if (!isValid) {
            String message = RB.getString(SchedulerValidator.class, (String)RB_UNAUTHORIZED_PATH, (Object[])new Object[]{schedulePath});
            CFLogs.SERVER_LOG.warn((Object)message);
        }
        return isValid;
    }

    public static void validateTaskPath(String taskName, String schedulePath) throws SecurityException {
        if (!SchedulerValidator.isValidSchedulePath(schedulePath)) {
            String message = RB.getString(SchedulerValidator.class, (String)RB_SECURITY_VIOLATION, (Object[])new Object[]{taskName, schedulePath, "schedulerexecutionpaths"});
            CFLogs.SERVER_LOG.error((Object)message);
            throw new SecurityException(message);
        }
        CFLogs.SERVER_LOG.debug((Object)RB.getString(SchedulerValidator.class, (String)RB_PATH_VALIDATED, (Object[])new Object[]{schedulePath}));
    }
}

