/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CollectionField;
import coldfusion.orm.mapping.CompositeID;
import coldfusion.orm.mapping.EmbeddedField;
import coldfusion.orm.mapping.Field;
import coldfusion.orm.mapping.IDField;
import coldfusion.orm.mapping.IDGenerator;
import coldfusion.orm.mapping.ManyToManyField;
import coldfusion.orm.mapping.ManyToOneField;
import coldfusion.orm.mapping.OneToManyField;
import coldfusion.orm.mapping.OneToOneField;
import coldfusion.orm.mapping.PropertyField;
import coldfusion.orm.mapping.RelationField;
import coldfusion.orm.mapping.TimeStampField;
import coldfusion.orm.mapping.VersionField;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.DBMetaData;
import coldfusion.util.XmlUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HBMBuilder {
    private static final String cfcStartIdentifier = "cfc.";
    private static Map<String, Set> keywordMap = new HashMap<String, Set>();
    private static Map<String, String> dbNameMap = new HashMap<String, String>();
    private CFCPersistenceMetadata cfc;
    private Document doc;
    private Element root;
    private String dbName;
    private Map<String, Integer> uniqueKeys;

    public HBMBuilder(CFCPersistenceMetadata cfc, DBMetaData dbMetaData) {
        this.cfc = cfc;
        if (dbMetaData != null) {
            this.dbName = dbNameMap.get(dbMetaData.getDatabaseName());
        }
    }

    private static void loadSQLKeyWords() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                File keywordFile = new File(ServiceFactory.getRuntimeService().getLibDir(), "sqlkeywords.properties");
                if (keywordFile.exists()) {
                    BufferedReader reader = null;
                    try {
                        String lineRead;
                        reader = new BufferedReader(new FileReader(keywordFile));
                        while ((lineRead = reader.readLine()) != null) {
                            lineRead = lineRead.trim();
                            int index = lineRead.indexOf(61);
                            String key = lineRead.substring(0, index);
                            String value = lineRead.substring(index + 1);
                            String[] keywords = value.split(",");
                            HashSet<String> keywordSet = new HashSet<String>();
                            for (String keyword : keywords) {
                                if ((keyword = keyword.trim()).length() <= 0) continue;
                                keywordSet.add(keyword);
                            }
                            keywordMap.put(key, keywordSet);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        });
    }

    public Document build() throws ParserConfigurationException {
        this.createDocument();
        this.addClassMapping();
        return this.doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    private void createDocument() throws ParserConfigurationException {
        this.doc = XmlUtils.createNewDocument();
        this.root = this.doc.createElement("hibernate-mapping");
        this.doc.appendChild(this.root);
    }

    private void addClassMapping() {
        Element classNode = this.createClassNode();
        if (classNode.getNodeName().equals("class")) {
            this.addCacheInfo(classNode);
            this.addId(classNode);
            this.addDiscriminatorColumn(classNode);
            this.addVersion(classNode);
            this.addTimeStamp(classNode);
        }
        this.buildUniqueKeys();
        this.addPropertyFields(classNode, this.cfc.getPropertyFields());
        this.addEmbeddedFields(classNode);
        this.addRelationFields(classNode, this.cfc.getRelationFields());
        this.addCollectionMappings(classNode, this.cfc.getCollectionFields());
        this.addJoinedPropertyFields(classNode);
    }

    private void buildUniqueKeys() {
        List<RelationField> relationFields;
        this.uniqueKeys = new HashMap<String, Integer>();
        List<PropertyField> propertyFields = this.cfc.getPropertyFields();
        if (propertyFields != null) {
            for (PropertyField field : propertyFields) {
                if (field.getUniqueKeyName() == null) continue;
                String keyName = field.getUniqueKeyName().toUpperCase();
                Integer counter = this.uniqueKeys.get(keyName);
                if (counter == null) {
                    counter = 0;
                }
                this.uniqueKeys.put(keyName, counter + 1);
            }
        }
        if ((relationFields = this.cfc.getRelationFields()) != null) {
            for (RelationField field : relationFields) {
                String keyName;
                if (!(field instanceof ManyToOneField) || (keyName = ((ManyToOneField)field).getUniqueKeyName()) == null) continue;
                Integer counter = this.uniqueKeys.get(keyName = keyName.toUpperCase());
                if (counter == null) {
                    counter = 0;
                }
                this.uniqueKeys.put(keyName, counter + 1);
            }
        }
    }

    private Element createClassNode() {
        Element classNode;
        CFCPersistenceMetadata parentCFCPmd = this.cfc.getParentCFCPmd();
        if (parentCFCPmd == null) {
            classNode = this.doc.createElement("class");
            this.addClassAttributes(classNode);
            this.addTableInfo(classNode);
            this.root.appendChild(classNode);
        } else {
            classNode = this.createClassNodeForInheritanceMapping(parentCFCPmd);
        }
        return classNode;
    }

    private Element createClassNodeForInheritanceMapping(CFCPersistenceMetadata parentCFCPmd) {
        if (this.cfc.getTableName().equalsIgnoreCase(parentCFCPmd.getTableName())) {
            return this.createClassNodeForTablePerHeirarchy();
        }
        if (this.cfc.getDiscriminatorValue() == null) {
            return this.createClassNodeForTablePerSubclass();
        }
        return this.createClassNodeForTablePerSubclassWithDiscriminator();
    }

    private Element createClassNodeForTablePerHeirarchy() {
        Element classNode = this.doc.createElement("subclass");
        this.root.appendChild(classNode);
        this.addClassAttributes(classNode);
        classNode.setAttribute("extends", cfcStartIdentifier + this.cfc.getParentCfcName());
        classNode.setAttribute("discriminator-value", this.cfc.getDiscriminatorValue());
        return classNode;
    }

    private Element createClassNodeForTablePerSubclass() {
        Element classNode = this.doc.createElement("joined-subclass");
        this.root.appendChild(classNode);
        this.addClassAttributes(classNode);
        classNode.setAttribute("extends", cfcStartIdentifier + this.cfc.getParentCfcName());
        this.addTableInfo(classNode);
        this.addJoinColumn(classNode, new String[]{this.cfc.getJoinColumn()}, null);
        return classNode;
    }

    private Element createClassNodeForTablePerSubclassWithDiscriminator() {
        Element classNode = this.createClassNodeForTablePerHeirarchy();
        this.createJoinNode(classNode, this.cfc.getJoinColumn());
        return classNode;
    }

    private void addJoinColumn(Element node, String[] joinColumns, String mappedBy) {
        Element keyNode = this.doc.createElement("key");
        node.appendChild(keyNode);
        if (mappedBy != null && mappedBy.length() > 0) {
            keyNode.setAttribute("property-ref", mappedBy);
        }
        this.setColumnsOnNode(keyNode, joinColumns);
    }

    private void addClassAttributes(Element classNode) {
        String cfcName = this.cfc.getCfcName();
        classNode.setAttribute("name", cfcStartIdentifier + cfcName);
        String entityName = this.cfc.getEntityName();
        if (entityName != null) {
            classNode.setAttribute("entity-name", entityName);
        }
        classNode.setAttribute("lazy", String.valueOf(this.cfc.isLazy()));
        if (this.cfc.isDynamicInsert()) {
            classNode.setAttribute("dynamic-insert", "true");
        }
        if (this.cfc.isDynamicUpdate()) {
            classNode.setAttribute("dynamic-update", "true");
        }
        if (this.cfc.getBatchSize() != 0) {
            classNode.setAttribute("batch-size", String.valueOf(this.cfc.getBatchSize()));
        }
        if (this.cfc.isSelectBeforeUpdate()) {
            classNode.setAttribute("select-before-update", "true");
        }
        if (classNode.getNodeName().equals("class")) {
            String whereStr;
            String rowId;
            String optimisticLock;
            if (this.cfc.isReadOnly()) {
                classNode.setAttribute("mutable", "false");
            }
            if ((optimisticLock = this.cfc.getOptimisticLock()) != null && optimisticLock.trim().length() > 0) {
                classNode.setAttribute("optimistic-lock", optimisticLock);
            }
            if ((rowId = this.cfc.getRowId()) != null && rowId.trim().length() > 0) {
                classNode.setAttribute("rowid", rowId);
            }
            if ((whereStr = this.cfc.getWhereString()) != null) {
                classNode.setAttribute("where", whereStr);
            }
        }
    }

    private void addTableInfo(Element classNode) {
        this.addTableInfo(classNode, this.cfc.getTableName(), this.cfc.getSchema(), this.cfc.getCatalog());
    }

    private void addTableInfo(Element node, String table, String schema, String catalog) {
        table = this.getDBEscapedName(table);
        node.setAttribute("table", table);
        if (schema != null && schema.length() > 0) {
            node.setAttribute("schema", schema);
        }
        if (catalog != null && catalog.length() > 0) {
            node.setAttribute("catalog", catalog);
        }
    }

    private String getDBEscapedName(String name) {
        if (name == null) {
            return null;
        }
        boolean escape = false;
        if (name.indexOf(32) != -1) {
            escape = true;
        } else {
            Set keywords;
            String nameUcase;
            Set ansiKeywords = keywordMap.get("ansi");
            if (ansiKeywords.contains(nameUcase = name.toUpperCase())) {
                escape = true;
            } else if (this.dbName != null && (keywords = keywordMap.get(this.dbName)) != null && keywords.contains(nameUcase)) {
                escape = true;
            }
        }
        if (escape) {
            char quote = '`';
            if (name.charAt(0) == quote && name.charAt(name.length() - 1) == quote) {
                return name;
            }
            return quote + name + quote;
        }
        return name;
    }

    private void addCacheInfo(Element classNode) {
        if (this.cfc.getCacheStrategy() != null) {
            Element cacheElem = (Element)classNode.appendChild(this.doc.createElement("cache"));
            cacheElem.setAttribute("usage", this.cfc.getCacheStrategy());
            if (this.cfc.getCacheName() != null) {
                cacheElem.setAttribute("region", this.cfc.getCacheName());
            }
        }
    }

    private void addId(Element classNode) {
        Object id = this.cfc.getIdField();
        if (id == null) {
            return;
        }
        if (id instanceof CompositeID) {
            this.addCompositeId(id, classNode);
        } else {
            this.addSimpleId(id, classNode);
        }
    }

    private void addCompositeId(Object id, Element classNode) {
        List<ManyToOneField> manyToOneFields;
        Node compositeNode = classNode.appendChild(this.doc.createElement("composite-id"));
        CompositeID compositeID = (CompositeID)id;
        List<IDField> fields = compositeID.getFields();
        if (fields != null) {
            for (IDField field : fields) {
                Element keyElem = (Element)compositeNode.appendChild(this.doc.createElement("key-property"));
                keyElem.setAttribute("name", field.getName());
                Element columnNode = (Element)keyElem.appendChild(this.doc.createElement("column"));
                columnNode.setAttribute("name", this.getDBEscapedName(field.getColumn()));
                if (field.getSqlType() != null) {
                    columnNode.setAttribute("sql-type", field.getSqlType());
                }
                if (field.getDataType() != null) {
                    keyElem.setAttribute("type", this.getHibernateType(field.getDataType()));
                }
                if (field.getLength() == 0) continue;
                columnNode.setAttribute("length", String.valueOf(field.getLength()));
            }
        }
        if ((manyToOneFields = compositeID.getManyToOneFields()) != null) {
            for (ManyToOneField manyToOneField : manyToOneFields) {
                Element manyToOneElem = (Element)compositeNode.appendChild(this.doc.createElement("key-many-to-one"));
                manyToOneElem.setAttribute("name", manyToOneField.getName());
                manyToOneElem.setAttribute("class", cfcStartIdentifier + manyToOneField.getTargetComponent());
                this.setColumnsOnNode(manyToOneElem, manyToOneField.getFkColumns());
                String lazy = manyToOneField.getLazy();
                if (lazy == null || lazy.trim().length() <= 0) continue;
                manyToOneElem.setAttribute("lazy", lazy);
            }
        }
    }

    private void addSimpleId(Object id, Element classNode) {
        IDGenerator idGenerator;
        IDField idField = (IDField)id;
        Element idNode = (Element)classNode.appendChild(this.doc.createElement("id"));
        idNode.setAttribute("name", idField.getName());
        Element columnNode = (Element)idNode.appendChild(this.doc.createElement("column"));
        columnNode.setAttribute("name", this.getDBEscapedName(idField.getColumn()));
        if (idField.getLength() != 0) {
            columnNode.setAttribute("length", String.valueOf(idField.getLength()));
        }
        if (idField.getSqlType() != null) {
            columnNode.setAttribute("sql-type", idField.getSqlType());
        }
        idNode.setAttribute("type", this.getHibernateType(idField.getDataType()));
        if (idField.getUnsavedValue() != null) {
            idNode.setAttribute("unsaved-value", idField.getUnsavedValue());
        }
        if ((idGenerator = idField.getGenerator()) != null) {
            Element generatorNode = (Element)idNode.appendChild(this.doc.createElement("generator"));
            generatorNode.setAttribute("class", idGenerator.getClassName());
            Map params = idGenerator.getParams();
            if (params != null) {
                for (Object o : params.keySet()) {
                    String param = (String)o;
                    String paramValue = (String)params.get(param);
                    Element paramNode = (Element)generatorNode.appendChild(this.doc.createElement("param"));
                    paramNode.setAttribute("name", param);
                    paramNode.appendChild(this.doc.createTextNode(paramValue));
                }
            }
        }
    }

    private void addDiscriminatorColumn(Element classNode) {
        String discriminatorCol = this.cfc.getDiscriminatorColumn();
        if (discriminatorCol != null && discriminatorCol.length() > 0) {
            Element discriminatorNode = this.doc.createElement("discriminator");
            discriminatorNode.setAttribute("column", discriminatorCol);
            classNode.appendChild(discriminatorNode);
        }
    }

    private void addVersion(Element classNode) {
        VersionField version = this.cfc.getVersion();
        if (version == null) {
            return;
        }
        Element versionNode = (Element)classNode.appendChild(this.doc.createElement("version"));
        versionNode.setAttribute("name", version.getName());
        if (version.getColumn() != null) {
            versionNode.setAttribute("column", this.getDBEscapedName(version.getColumn()));
        }
        if (version.getDataType() != null) {
            versionNode.setAttribute("type", this.getHibernateType(version.getDataType()));
        }
        if (version.isGenerated()) {
            versionNode.setAttribute("generated", "always");
        }
        if (!version.isInsertEnabled()) {
            versionNode.setAttribute("insert", "false");
        }
    }

    private void addTimeStamp(Element classNode) {
        TimeStampField timestamp = this.cfc.getTimestamp();
        if (timestamp == null) {
            return;
        }
        Element timestampNode = (Element)classNode.appendChild(this.doc.createElement("timestamp"));
        timestampNode.setAttribute("name", timestamp.getName());
        if (timestamp.getColumn() != null) {
            timestampNode.setAttribute("column", this.getDBEscapedName(timestamp.getColumn()));
        }
        if (timestamp.getSource() != null) {
            timestampNode.setAttribute("source", timestamp.getSource());
        }
        String genString = timestamp.isGenerated() ? "always" : "never";
        timestampNode.setAttribute("generated", genString);
    }

    private void addPropertyFields(Element classNode, List<PropertyField> propertyFields) {
        Element joinNode;
        if (propertyFields == null) {
            return;
        }
        if (classNode.getNodeName().equals("subclass") && (joinNode = this.getSubclassJoinNode(classNode)) != null) {
            classNode = joinNode;
        }
        for (PropertyField field : propertyFields) {
            this.addPropertyField(field, classNode);
        }
    }

    private Element getSubclassJoinNode(Element classNode) {
        NodeList joins = classNode.getElementsByTagName("join");
        if (joins.getLength() > 0) {
            return (Element)joins.item(0);
        }
        return null;
    }

    private void addEmbeddedFields(Element classNode) {
        List<EmbeddedField> embeddedFields = this.cfc.getEmbeddedFields();
        if (embeddedFields == null) {
            return;
        }
        for (EmbeddedField field : embeddedFields) {
            Element componentNode = this.doc.createElement("component");
            classNode.appendChild(componentNode);
            componentNode.setAttribute("name", field.getName());
            componentNode.setAttribute("class", cfcStartIdentifier + field.getCfcName());
            this.addPropertyFields(componentNode, field.getPropertyFields());
            this.addRelationFields(componentNode, field.getRelationFields());
            this.addCollectionMappings(componentNode, field.getCollectionFields());
        }
    }

    private void addJoinedPropertyFields(Element classNode) {
        Map<String, List<Field>> joinedPropertyFields = this.cfc.getJoinedFields();
        if (joinedPropertyFields == null) {
            return;
        }
        for (String joinedTable : joinedPropertyFields.keySet()) {
            List<Field> fields = joinedPropertyFields.get(joinedTable);
            if (fields.size() == 0) continue;
            String[] joinColumns = null;
            String schema = null;
            String catalog = null;
            String mappedBy = null;
            Field field = fields.get(0);
            if (field instanceof PropertyField) {
                PropertyField propField = (PropertyField)field;
                joinColumns = new String[]{propField.getJoinColumn()};
                schema = propField.getSchema();
                catalog = propField.getCatalog();
                mappedBy = propField.getMappedBy();
            } else if (field instanceof RelationField) {
                RelationField relField = (RelationField)field;
                joinColumns = relField.getFkColumns();
                schema = relField.getLinkTableSchema();
                catalog = relField.getLinkTableCatalog();
            }
            if (joinColumns == null) {
                return;
            }
            Element joinNode = this.createJoinNode(classNode, joinedTable, schema, catalog, joinColumns, mappedBy);
            for (Field joinField : fields) {
                if (joinField instanceof PropertyField) {
                    this.addPropertyField((PropertyField)joinField, joinNode);
                    continue;
                }
                if (!(joinField instanceof RelationField)) continue;
                RelationField relField = (RelationField)joinField;
                if ((relField instanceof OneToOneField || relField instanceof ManyToOneField) && relField.isInverse()) {
                    joinNode.setAttribute("inverse", "true");
                }
                this.addRelationField(relField, joinNode);
            }
        }
    }

    private Element createJoinNode(Element classNode, String table, String schema, String catalog, String[] joinColumns, String mappedBy) {
        Element joinNode = this.doc.createElement("join");
        this.addTableInfo(joinNode, table, schema, catalog);
        classNode.appendChild(joinNode);
        this.addJoinColumn(joinNode, joinColumns, mappedBy);
        return joinNode;
    }

    private Element createJoinNode(Element classNode, String joinColumn) {
        Element joinNode = this.doc.createElement("join");
        this.addTableInfo(joinNode);
        classNode.appendChild(joinNode);
        this.addJoinColumn(joinNode, new String[]{joinColumn}, null);
        return joinNode;
    }

    private void addPropertyField(PropertyField field, Element classNode) {
        Element propertyNode = (Element)classNode.appendChild(this.doc.createElement("property"));
        propertyNode.setAttribute("name", field.getName());
        propertyNode.setAttribute("type", this.getHibernateType(field.getDataType()));
        Element columnNode = null;
        String formula = field.getFormula();
        if (formula != null && formula.trim().length() > 0) {
            propertyNode.setAttribute("formula", "(" + formula + ")");
        } else {
            columnNode = (Element)propertyNode.appendChild(this.doc.createElement("column"));
            columnNode.setAttribute("name", this.getDBEscapedName(field.getColumn()));
        }
        if (columnNode != null) {
            String sqlType;
            String defaultVal;
            String index;
            String uniqueKey;
            String length = "";
            if (field.getLength() != 0) {
                length = String.valueOf(field.getLength());
                columnNode.setAttribute("length", length);
            }
            if (field.getPrecision() != -1) {
                columnNode.setAttribute("precision", String.valueOf(field.getPrecision()));
            }
            if (field.getScale() != -1) {
                columnNode.setAttribute("scale", String.valueOf(field.getScale()));
            }
            if (field.isNotNull()) {
                columnNode.setAttribute("not-null", "true");
            }
            if (field.isUnique()) {
                columnNode.setAttribute("unique", "true");
            }
            if (!((uniqueKey = field.getUniqueKeyName()) == null || uniqueKey.trim().length() <= 0 || field.isUnique() && this.uniqueKeys.get(uniqueKey.toUpperCase()) <= 1)) {
                columnNode.setAttribute("unique-key", uniqueKey);
            }
            if ((index = field.getIndexName()) != null && index.trim().length() > 0) {
                columnNode.setAttribute("index", index);
            }
            if ((defaultVal = field.getDefault()) != null) {
                columnNode.setAttribute("default", defaultVal);
            }
            if ((sqlType = field.getSqlType()) != null) {
                if (sqlType.indexOf("(") == -1 && length.length() > 0) {
                    sqlType = sqlType + "(" + length + ")";
                }
                columnNode.setAttribute("sql-type", sqlType);
            }
        }
        if (!field.isInsertable()) {
            propertyNode.setAttribute("insert", "false");
        }
        if (!field.isUpdatable()) {
            propertyNode.setAttribute("update", "false");
        }
        if (!field.isOptimisticLock()) {
            propertyNode.setAttribute("optimistic-lock", "false");
        }
        if (field.getLazy()) {
            propertyNode.setAttribute("lazy", "true");
        }
        if (field.getGenerated() != null) {
            propertyNode.setAttribute("generated", field.getGenerated());
        }
    }

    private void addRelationFields(Element classNode, List<RelationField> relationFields) {
        if (relationFields == null) {
            return;
        }
        for (RelationField field : relationFields) {
            this.addRelationField(field, classNode);
        }
    }

    private void addRelationField(RelationField field, Element classNode) {
        if (field instanceof OneToOneField) {
            this.addOneToOneRelation((OneToOneField)field, classNode);
        } else if (field instanceof ManyToOneField) {
            this.addManyToOneRelation((ManyToOneField)field, classNode);
        } else if (field instanceof ManyToManyField) {
            this.addManyToManyRelation((ManyToManyField)field, classNode);
        } else {
            this.addOneToManyRelation((OneToManyField)field, classNode);
        }
    }

    private void addOneToOneRelation(OneToOneField oneToOneField, Element classNode) {
        String foreignKeyName;
        String mappedBy;
        String elmtName = "one-to-one";
        boolean unique = false;
        if (oneToOneField.getFkColumns() != null || oneToOneField.getLinkTable() != null) {
            Element joinNode;
            elmtName = "many-to-one";
            unique = true;
            if (classNode.getNodeName().equals("subclass") && (joinNode = this.getSubclassJoinNode(classNode)) != null) {
                classNode = joinNode;
            }
        }
        Element oneToOneNode = (Element)classNode.appendChild(this.doc.createElement(elmtName));
        if (oneToOneField.getLinkTable() != null) {
            this.setColumnsOnNode(oneToOneNode, oneToOneField.getInverseJoinColumn());
        } else if (oneToOneField.getFkColumns() != null) {
            this.setColumnsOnNode(oneToOneNode, oneToOneField.getFkColumns(), oneToOneField);
        }
        if (unique) {
            oneToOneNode.setAttribute("unique", "true");
            if (oneToOneField.isMissingRowIgnored()) {
                oneToOneNode.setAttribute("not-found", "ignore");
            }
        }
        oneToOneNode.setAttribute("class", cfcStartIdentifier + oneToOneField.getTargetComponent());
        String entityName = oneToOneField.getEntityName();
        if (entityName != null && entityName.trim().length() != 0) {
            oneToOneNode.setAttribute("entity-name", entityName);
        }
        this.setRelationAttributes(oneToOneField, oneToOneNode);
        if (oneToOneField.isConstrained()) {
            oneToOneNode.setAttribute("constrained", "true");
        }
        if ((mappedBy = oneToOneField.getMappedBy()) != null && mappedBy.trim().length() != 0) {
            oneToOneNode.setAttribute("property-ref", mappedBy);
        }
        if ((foreignKeyName = oneToOneField.getForeignKeyName()) != null && foreignKeyName.trim().length() != 0) {
            oneToOneNode.setAttribute("foreign-key", foreignKeyName);
        }
    }

    private void setRelationAttributes(RelationField relationField, Element relationNode) {
        String lazyString;
        relationNode.setAttribute("name", relationField.getName());
        if (relationField.getCascade() != null) {
            relationNode.setAttribute("cascade", relationField.getCascade());
        }
        if (relationField.getFetch() != null) {
            relationNode.setAttribute("fetch", relationField.getFetch());
        }
        if ((lazyString = relationField.getLazy()) != null) {
            relationNode.setAttribute("lazy", lazyString);
        }
    }

    private void addManyToOneRelation(ManyToOneField manyToOneField, Element classNode) {
        String foreignKeyName;
        String uniqueKeyName;
        String indexName;
        String mappedBy;
        Element joinNode;
        if (classNode.getNodeName().equals("subclass") && (joinNode = this.getSubclassJoinNode(classNode)) != null) {
            classNode = joinNode;
        }
        Element manyToOneNode = (Element)classNode.appendChild(this.doc.createElement("many-to-one"));
        this.setRelationAttributes(manyToOneField, manyToOneNode);
        if (manyToOneField.getLinkTable() != null) {
            this.setColumnsOnNode(manyToOneNode, manyToOneField.getInverseJoinColumn());
        } else {
            this.setColumnsOnNode(manyToOneNode, manyToOneField.getFkColumns(), manyToOneField);
        }
        manyToOneNode.setAttribute("class", cfcStartIdentifier + manyToOneField.getTargetComponent());
        String entityName = manyToOneField.getEntityName();
        if (entityName != null && entityName.trim().length() != 0) {
            manyToOneNode.setAttribute("entity-name", entityName);
        }
        if (!manyToOneField.isInsertable()) {
            manyToOneNode.setAttribute("insert", "false");
        }
        if (!manyToOneField.isUpdatable()) {
            manyToOneNode.setAttribute("update", "false");
        }
        if ((mappedBy = manyToOneField.getMappedBy()) != null && mappedBy.trim().length() != 0) {
            manyToOneNode.setAttribute("property-ref", mappedBy);
        }
        if (manyToOneField.isUnique()) {
            manyToOneNode.setAttribute("unique", "true");
        }
        if (manyToOneField.isNotNull()) {
            manyToOneNode.setAttribute("not-null", "true");
        }
        if (!manyToOneField.isOptimisticLock()) {
            manyToOneNode.setAttribute("optimistic-lock", "false");
        }
        if (manyToOneField.isMissingRowIgnored()) {
            manyToOneNode.setAttribute("not-found", "ignore");
        }
        if ((indexName = manyToOneField.getIndexName()) != null && indexName.trim().length() > 0) {
            manyToOneNode.setAttribute("index", indexName);
        }
        if (!((uniqueKeyName = manyToOneField.getUniqueKeyName()) == null || uniqueKeyName.trim().length() == 0 || manyToOneField.isUnique() && this.uniqueKeys.get(uniqueKeyName.toUpperCase()) <= 1)) {
            manyToOneNode.setAttribute("unique-key", uniqueKeyName);
        }
        if ((foreignKeyName = manyToOneField.getForeignKeyName()) != null && foreignKeyName.trim().length() != 0) {
            manyToOneNode.setAttribute("foreign-key", foreignKeyName);
        }
    }

    private void setColumnsOnNode(Element node, String[] columns) {
        if (columns.length == 1) {
            node.setAttribute("column", this.getDBEscapedName(columns[0]));
        } else {
            for (int i = 0; i < columns.length; ++i) {
                Element columnNode = (Element)node.appendChild(this.doc.createElement("column"));
                String inverseJoinColumn = columns[i];
                columnNode.setAttribute("name", this.getDBEscapedName(inverseJoinColumn));
            }
        }
    }

    private void setColumnsOnNode(Element node, String[] columns, RelationField field) {
        if (columns.length == 1 && field.getSqlType() == null) {
            node.setAttribute("column", this.getDBEscapedName(columns[0]));
        } else {
            String[] sqlTypes = new String[]{""};
            if (field.getSqlType() != null) {
                sqlTypes = field.getSqlType().split(",");
            }
            for (int i = 0; i < columns.length; ++i) {
                Element columnNode = (Element)node.appendChild(this.doc.createElement("column"));
                String inverseJoinColumn = columns[i];
                columnNode.setAttribute("name", this.getDBEscapedName(inverseJoinColumn));
                if (i >= sqlTypes.length) continue;
                columnNode.setAttribute("sql-type", sqlTypes[i]);
            }
        }
    }

    private void addOneToManyRelation(OneToManyField oneToManyField, Element classNode) {
        Element oneToManyNode;
        String linkTable;
        Element collectionElement = this.addCollectionNodeForRelation(oneToManyField, classNode);
        String orderByStr = oneToManyField.getOrderBy();
        if (orderByStr != null && orderByStr.length() > 0) {
            collectionElement.setAttribute("order-by", orderByStr);
        }
        if ((linkTable = oneToManyField.getLinkTable()) != null) {
            String linkTableCatalog;
            collectionElement.setAttribute("table", this.getDBEscapedName(linkTable));
            String linkTableSchema = oneToManyField.getLinkTableSchema();
            if (linkTableSchema != null && linkTableSchema.length() > 0) {
                collectionElement.setAttribute("schema", linkTableSchema);
            }
            if ((linkTableCatalog = oneToManyField.getLinkTableCatalog()) != null && linkTableCatalog.length() > 0) {
                collectionElement.setAttribute("catalog", linkTableCatalog);
            }
            oneToManyNode = (Element)collectionElement.appendChild(this.doc.createElement("many-to-many"));
            oneToManyNode.setAttribute("unique", "true");
            if (oneToManyField.getInverseJoinColumn() != null) {
                this.setColumnsOnNode(oneToManyNode, oneToManyField.getInverseJoinColumn());
            }
        } else {
            oneToManyNode = (Element)collectionElement.appendChild(this.doc.createElement("one-to-many"));
        }
        oneToManyNode.setAttribute("class", cfcStartIdentifier + oneToManyField.getTargetComponent());
        String entityName = oneToManyField.getEntityName();
        if (entityName != null && entityName.trim().length() != 0) {
            oneToManyNode.setAttribute("entity-name", entityName);
        }
    }

    private Element addCollectionNodeForRelation(OneToManyField oneToManyField, Element classNode) {
        String collectionType = oneToManyField.getCollectionType();
        Element joinNode = null;
        if (classNode.getNodeName().equals("subclass")) {
            joinNode = this.getSubclassJoinNode(classNode);
        }
        Element collectionElement = collectionType.equals("struct") ? this.doc.createElement("map") : this.doc.createElement("bag");
        if (joinNode == null) {
            classNode.appendChild(collectionElement);
        } else {
            classNode.insertBefore(collectionElement, joinNode);
        }
        this.setRelationAttributes(oneToManyField, collectionElement);
        if (oneToManyField.isReadOnly()) {
            collectionElement.setAttribute("mutable", "false");
        }
        if (oneToManyField.isInverse()) {
            collectionElement.setAttribute("inverse", "true");
        }
        if (oneToManyField.getBatchSize() != 1) {
            collectionElement.setAttribute("batch-size", String.valueOf(oneToManyField.getBatchSize()));
        }
        if (!oneToManyField.isOptimisticLock()) {
            collectionElement.setAttribute("optimistic-lock", "false");
        }
        if (oneToManyField.getCacheStrategy() != null) {
            Element cacheElem = (Element)collectionElement.appendChild(this.doc.createElement("cache"));
            cacheElem.setAttribute("usage", oneToManyField.getCacheStrategy());
            if (oneToManyField.getCacheName() != null) {
                cacheElem.setAttribute("region", oneToManyField.getCacheName());
            }
        }
        if (oneToManyField.getFkColumns() != null) {
            String onDelete;
            Element keyElem = (Element)collectionElement.appendChild(this.doc.createElement("key"));
            this.setColumnsOnNode(keyElem, oneToManyField.getFkColumns());
            if (oneToManyField.getMappedBy() != null) {
                keyElem.setAttribute("property-ref", oneToManyField.getMappedBy());
            }
            if ((onDelete = oneToManyField.getOnDelete()) != null) {
                keyElem.setAttribute("on-delete", onDelete);
            }
        }
        if (collectionType.equals("struct") && oneToManyField.getStructKeyColumn() != null) {
            Element mapKeyColumn = (Element)collectionElement.appendChild(this.doc.createElement("map-key"));
            mapKeyColumn.setAttribute("column", oneToManyField.getStructKeyColumn());
            mapKeyColumn.setAttribute("type", oneToManyField.getStructKeyDataType());
        }
        if (oneToManyField.getWhereString() != null) {
            collectionElement.setAttribute("where", oneToManyField.getWhereString());
        }
        return collectionElement;
    }

    private void addManyToManyRelation(ManyToManyField manyToManyField, Element classNode) {
        String mappedBy;
        String orderByStr;
        String linkTableCatalog;
        Element collectionElement = this.addCollectionNodeForRelation(manyToManyField, classNode);
        String linkTable = manyToManyField.getLinkTable();
        collectionElement.setAttribute("table", this.getDBEscapedName(linkTable));
        String linkTableSchema = manyToManyField.getLinkTableSchema();
        if (linkTableSchema != null && linkTableSchema.length() > 0) {
            collectionElement.setAttribute("schema", linkTableSchema);
        }
        if ((linkTableCatalog = manyToManyField.getLinkTableCatalog()) != null && linkTableCatalog.length() > 0) {
            collectionElement.setAttribute("catalog", linkTableCatalog);
        }
        Element manyToManyNode = (Element)collectionElement.appendChild(this.doc.createElement("many-to-many"));
        manyToManyNode.setAttribute("class", cfcStartIdentifier + manyToManyField.getTargetComponent());
        String entityName = manyToManyField.getEntityName();
        if (entityName != null && entityName.trim().length() != 0) {
            manyToManyNode.setAttribute("entity-name", entityName);
        }
        if (manyToManyField.getInverseJoinColumn() != null) {
            this.setColumnsOnNode(manyToManyNode, manyToManyField.getInverseJoinColumn());
        }
        if ((orderByStr = manyToManyField.getOrderBy()) != null && orderByStr.length() > 0) {
            manyToManyNode.setAttribute("order-by", orderByStr);
        }
        if ((mappedBy = manyToManyField.getMappedBy()) != null && mappedBy.trim().length() != 0) {
            manyToManyNode.setAttribute("property-ref", mappedBy);
        }
        if (manyToManyField.isMissingRowIgnored()) {
            manyToManyNode.setAttribute("not-found", "ignore");
        }
    }

    private void addCollectionMappings(Element classElement, List<CollectionField> collectionFields) {
        if (collectionFields == null) {
            return;
        }
        for (CollectionField field : collectionFields) {
            this.addCollectionMapping(field, classElement);
        }
    }

    private void addCollectionMapping(CollectionField collectionField, Element classNode) {
        String orderByStr;
        String catalog;
        String collectionType = collectionField.getCollectionType();
        Element joinNode = null;
        if (classNode.getNodeName().equals("subclass")) {
            joinNode = this.getSubclassJoinNode(classNode);
        }
        Element collectionElement = collectionType.equals("struct") ? this.doc.createElement("map") : this.doc.createElement("bag");
        if (joinNode == null) {
            classNode.appendChild(collectionElement);
        } else {
            classNode.insertBefore(collectionElement, joinNode);
        }
        collectionElement.setAttribute("name", collectionField.getName());
        String table = collectionField.getTable();
        collectionElement.setAttribute("table", this.getDBEscapedName(table));
        String schema = collectionField.getSchema();
        if (schema != null && schema.length() > 0) {
            collectionElement.setAttribute("schema", schema);
        }
        if ((catalog = collectionField.getCatalog()) != null && catalog.length() > 0) {
            collectionElement.setAttribute("catalog", catalog);
        }
        if (collectionField.isReadOnly()) {
            collectionElement.setAttribute("mutable", "false");
        }
        if ((orderByStr = collectionField.getOrderBy()) != null && orderByStr.length() > 0) {
            collectionElement.setAttribute("order-by", orderByStr);
        }
        if (collectionField.getBatchSize() != 1) {
            collectionElement.setAttribute("batch-size", String.valueOf(collectionField.getBatchSize()));
        }
        if (!collectionField.isOptimisticLock()) {
            collectionElement.setAttribute("optimistic-lock", "false");
        }
        if (collectionField.getCacheStrategy() != null) {
            Element cacheElem = (Element)collectionElement.appendChild(this.doc.createElement("cache"));
            cacheElem.setAttribute("usage", collectionField.getCacheStrategy());
            if (collectionField.getCacheName() != null) {
                cacheElem.setAttribute("region", collectionField.getCacheName());
            }
        }
        if (collectionField.getColumn() != null) {
            Element keyElem = (Element)collectionElement.appendChild(this.doc.createElement("key"));
            keyElem.setAttribute("column", this.getDBEscapedName(collectionField.getColumn()));
            if (collectionField.getMappedBy() != null) {
                keyElem.setAttribute("property-ref", collectionField.getMappedBy());
            }
        }
        if (collectionType.equals("struct") && collectionField.getStructKeyColumn() != null) {
            Element mapKeyColumn = (Element)collectionElement.appendChild(this.doc.createElement("map-key"));
            mapKeyColumn.setAttribute("column", collectionField.getStructKeyColumn());
            mapKeyColumn.setAttribute("type", collectionField.getStructKeyDataType());
        }
        if (collectionField.getElementColumn() != null) {
            Element elementNode = (Element)collectionElement.appendChild(this.doc.createElement("element"));
            elementNode.setAttribute("column", collectionField.getElementColumn());
            elementNode.setAttribute("type", collectionField.getElementDataType());
        }
    }

    private String getHibernateType(String javaType) {
        if (javaType.equals("java.lang.String") || javaType.equalsIgnoreCase("string")) {
            return "string";
        }
        if (javaType.equals("byte[]")) {
            return "binary";
        }
        if (javaType.equals("java.io.InputStream")) {
            return "binary";
        }
        if (javaType.equals("java.sql.Clob") || javaType.equalsIgnoreCase("clob") || javaType.equals("java.sql.NClob") || javaType.equalsIgnoreCase("nclob") || javaType.equals("java.sql.SQLXML") || javaType.equalsIgnoreCase("sqlxml")) {
            return "text";
        }
        if (javaType.equals("java.sql.Blob") || javaType.equalsIgnoreCase("blob")) {
            return "binary";
        }
        return javaType;
    }

    static {
        HBMBuilder.loadSQLKeyWords();
        dbNameMap.put("Oracle", "oracle");
        dbNameMap.put("Apache Derby", "derby");
        dbNameMap.put("Microsoft SQL Server Database", "sqlserver");
        dbNameMap.put("Microsoft SQL Server", "sqlserver");
        dbNameMap.put("DB2/NT", "db2");
        dbNameMap.put("DB2/LINUX", "db2");
        dbNameMap.put("DB2/6000", "db2");
        dbNameMap.put("DB2/HPUX", "db2");
        dbNameMap.put("DB2/SUN", "db2");
        dbNameMap.put("DB2/LINUX390", "db2");
        dbNameMap.put("DB2/AIX64", "db2");
        dbNameMap.put("MySQL", "mysql");
    }
}

