/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.tagext.net.exchange.CalendarConstants;
import coldfusion.tagext.net.exchange.CalendarTagHelper;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;

public class ExchangeCalendarTag
extends ExchangeTag
implements ExchangeFilterable,
CalendarConstants {
    private static final long serialVersionUID = 1L;
    private Map event = null;
    private String responseType = null;
    private String message = null;
    private String folderPath = null;
    private String folderId = null;
    private String pathDelimiter = "/";
    private static HashMap<String, String> validFilterAttributes = new HashMap();
    private static HashMap<String, String> validEventAttributes = new HashMap();
    AppointmentFilterInfo filterInfo = new AppointmentFilterInfo();
    private String emailAddress;
    private String attendees;
    private Date startDate;
    private Date endDate;
    private AvailabilityData dataRequestType;
    private boolean rOccurrence = false;
    private String timeZone;

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    AppointmentFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangecalendar");
        }
        Object value = values.get("value");
        if (attribName.equalsIgnoreCase("StartTime")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromStartTime(fromDate);
                this.filterInfo.setToStartTime(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("StartTime");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("EndTime")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromEndTime(fromDate);
                this.filterInfo.setToEndTime(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("EndTime");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("lastModified")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromLastModifiedDate(fromDate);
                this.filterInfo.setToLastModifiedDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("lastModified");
            }
            return;
        }
        if (value == null || value.toString().length() == 0) {
            ExchangeExceptions.throwEmptyAttributeValueException(attribName);
        }
        if (!(value instanceof String)) {
            ExchangeExceptions.throwInvalidStringValueException(attribName);
        }
        if (attribName.equalsIgnoreCase("AllDayEvent")) {
            this.filterInfo.setIsAllDay(ExchangeTag.castBoolean(value, "AllDayEvent"));
        } else if (attribName.equalsIgnoreCase("HasAttachment")) {
            this.filterInfo.setHasAttachment(ExchangeTag.castBoolean(value, "HasAttachment"));
        } else if (attribName.equalsIgnoreCase("Importance")) {
            if (!this.validateImportance(value.toString())) {
                ExchangeExceptions.throwInvalidImportanceException("Importance");
            }
            this.filterInfo.setImportance(value.toString());
        } else if (attribName.equalsIgnoreCase("IsRecurring")) {
            boolean isRecurring = ExchangeTag.castBoolean(value, "IsRecurring");
            this.filterInfo.setRecurringSeries(isRecurring ? 1 : 0);
        } else if (attribName.equalsIgnoreCase("Location")) {
            this.filterInfo.setLocation(value.toString());
        } else if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt = ExchangeTag.castInt(value, "MaxRows");
            if (tmpInt <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(tmpInt);
        } else if (attribName.equalsIgnoreCase("Message")) {
            this.filterInfo.setMessage(value.toString());
        } else if (attribName.equalsIgnoreCase("OptionalAttendees")) {
            this.filterInfo.setOptionalAttendees(value.toString());
        } else if (attribName.equalsIgnoreCase("Organizer")) {
            this.filterInfo.setOrganizer(value.toString());
        } else if (attribName.equalsIgnoreCase("RequiredAttendees")) {
            this.filterInfo.setRequiredAttendees(value.toString());
        } else if (attribName.equalsIgnoreCase("Resources")) {
            this.filterInfo.setResources(value.toString());
        } else if (attribName.equalsIgnoreCase("Sensitivity")) {
            if (!this.validateSensitivity(value.toString())) {
                ExchangeExceptions.throwInvalidSensitivityException("Sensitivity");
            }
            this.filterInfo.setSensitivity(value.toString());
        } else if (attribName.equalsIgnoreCase("Subject")) {
            this.filterInfo.setSubject(value.toString());
        } else if (attribName.equalsIgnoreCase("FromId")) {
            this.filterInfo.setFromId(value.toString());
        } else if (attribName.equalsIgnoreCase("Duration")) {
            this.filterInfo.setDuration(ExchangeTag.castInt(value, "Duration"));
        } else if (attribName.equalsIgnoreCase("uid")) {
            if (value == null || value.toString().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            this.filterInfo.setUids(value.toString());
        } else if (attribName.equalsIgnoreCase("Categories")) {
            this.filterInfo.setCategories(value.toString());
        } else if (attribName.equalsIgnoreCase("Label")) {
            int tmpInt = CalendarTagHelper.getLabelCode(value.toString());
            if (tmpInt < 0) {
                ExchangeExceptions.throwInvalidLabelException("Label");
            }
            this.filterInfo.setLabel(new Integer(tmpInt));
        } else if (attribName.equalsIgnoreCase("recurrenceid")) {
            String recurrenceIdValue = value.toString();
            if (recurrenceIdValue != null) {
                recurrenceIdValue = recurrenceIdValue.trim();
                recurrenceIdValue = recurrenceIdValue.replace("T", " ");
                recurrenceIdValue = recurrenceIdValue.replace("t", " ");
                recurrenceIdValue = recurrenceIdValue.replace("Z", "");
                recurrenceIdValue = recurrenceIdValue.replace("z", "");
            }
            this.filterInfo.setRecurrenceId(recurrenceIdValue);
        } else if (attribName.equalsIgnoreCase("recurrenceidrange")) {
            String recurrenceIdRangeValue = value.toString();
            if (recurrenceIdRangeValue != null) {
                recurrenceIdRangeValue = recurrenceIdRangeValue.trim();
                recurrenceIdRangeValue = recurrenceIdRangeValue.replace("T", " ");
                recurrenceIdRangeValue = recurrenceIdRangeValue.replace("t", " ");
                recurrenceIdRangeValue = recurrenceIdRangeValue.replace("Z", "");
                recurrenceIdRangeValue = recurrenceIdRangeValue.replace("z", "");
            }
            this.filterInfo.setRecurrenceIdRange(recurrenceIdRangeValue);
        }
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        if ((this.action.equalsIgnoreCase("create") || this.action.equalsIgnoreCase("modify")) && this.getEvent() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "event");
        }
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase("get")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            if (this.folderId != null) {
                this.filterInfo.setCalendarFolderId(this.folderId);
            } else if (this.folderPath != null) {
                this.filterInfo.setCalendarFolderPath(this.folderPath);
                this.filterInfo.setPathDelimitter(this.pathDelimiter);
            }
            CalendarTagHelper.getCalendarEvents(this);
        } else if (this.action.equalsIgnoreCase("create")) {
            CalendarTagHelper.saveCalendarEvent(this, this.getEvent(), true);
        } else if (this.action.equalsIgnoreCase("modify")) {
            CalendarTagHelper.saveCalendarEvent(this, this.getEvent(), false);
        } else if (this.action.equalsIgnoreCase("delete")) {
            CalendarTagHelper.deleteCalendarEvents(this);
        } else if (this.action.equalsIgnoreCase("respond")) {
            CalendarTagHelper.respondCalendarEvent(this);
        } else if (this.action.equalsIgnoreCase("getAttachments")) {
            this.getAttachments(1);
        } else if (this.action.equalsIgnoreCase("deleteAttachments")) {
            this.deleteAttachments(1);
        } else if (this.action.equalsIgnoreCase("getroomlist")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            CalendarTagHelper.getRoomList(this);
        } else if (this.action.equalsIgnoreCase("getrooms")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            CalendarTagHelper.getRooms(this);
        } else if (this.action.equalsIgnoreCase("getuseravailability")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            CalendarTagHelper.getUserAvailability(this);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    public Map getEvent() {
        return this.event;
    }

    public void setEvent(Map event) {
        this.validateStruct(event, validEventAttributes, "cfexchangecalendar", "event");
        this.validateRecurrenceValues(event);
        this.event = event;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void release() {
        super.release();
        this.event = null;
        this.filterInfo = new AppointmentFilterInfo();
        this.message = null;
        this.responseType = null;
    }

    private void validateRecurrenceValues(Map event) {
        String rType = (String)event.get("RecurrenceType");
        if (rType != null && "DAILY | WEEKLY | MONTHLY | YEARLY".indexOf(rType.toUpperCase().trim()) == -1) {
            ExchangeExceptions.throwInvalidRecurrenceTypeException("RecurrenceType");
        }
        if ((rType = (String)event.get("RecurrenceDay")) != null && "MON, TUE, WED, THU, FRI, SAT, SUN".indexOf(rType.toUpperCase().trim()) == -1) {
            ExchangeExceptions.throwInvalidExchangeDayValue("RecurrenceDay");
        }
        if ((rType = (String)event.get("RecurrenceWeek")) != null && "FIRST | SECOND | THIRD | FOURTH | LAST".indexOf(rType.toUpperCase().trim()) == -1) {
            ExchangeExceptions.throwInvalidExchangeWeekValue("RecurrenceWeek");
        }
        if ((rType = (String)event.get("RecurrenceMonth")) != null && "JAN, FEB, MAR, APR, MAY, JUN, JUL, AUG, SEP, OCT, NOV, DEC".indexOf(rType.toUpperCase().trim()) == -1) {
            ExchangeExceptions.throwInvalidExchangeMonthValue("RecurrenceMonth");
        }
        if ((rType = (String)event.get("RecurrenceDays")) != null) {
            StringTokenizer st = new StringTokenizer(rType, ",");
            while (st.hasMoreTokens()) {
                if ("MON, TUE, WED, THU, FRI, SAT, SUN".indexOf(st.nextToken().toUpperCase()) != -1) continue;
                ExchangeExceptions.throwInvalidExchangeDaysValue("RecurrenceDays");
            }
        }
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setAttendees(String attendees) {
        this.attendees = attendees;
    }

    public String getAttendees() {
        return this.attendees;
    }

    public void setGetOccurrence(boolean rOccurrence) {
        this.rOccurrence = rOccurrence;
    }

    public boolean getGetOccurrence() {
        return this.rOccurrence;
    }

    public void setStartDate(String startDate) {
        this.startDate = ExchangeTag.castDate(startDate, "StartDate");
        if (null == this.startDate) {
            ExchangeExceptions.throwInvalidAttributeValueException("StartDate");
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = ExchangeTag.castDate(endDate, "EndDate");
        if (null == this.endDate) {
            ExchangeExceptions.throwInvalidAttributeValueException("EndDate");
        }
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setDataRequestType(String dataRequestType) {
        if (null == dataRequestType || 0 == dataRequestType.trim().length()) {
            ExchangeExceptions.throwInvalidAttributeValueException("DataRequestType");
        }
        if (dataRequestType.trim().equalsIgnoreCase(AvailabilityData.FreeBusy.toString())) {
            this.dataRequestType = AvailabilityData.FreeBusy;
        } else if (dataRequestType.trim().equalsIgnoreCase(AvailabilityData.FreeBusyAndSuggestions.toString())) {
            this.dataRequestType = AvailabilityData.FreeBusyAndSuggestions;
        } else if (dataRequestType.trim().equalsIgnoreCase(AvailabilityData.Suggestions.toString())) {
            this.dataRequestType = AvailabilityData.Suggestions;
        } else {
            ExchangeExceptions.throwInvalidAttributeValueException("DataRequestType");
        }
    }

    public AvailabilityData getDataRequestType() {
        return this.dataRequestType;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        if (StringUtils.isBlank((String)folderPath)) {
            ExchangeExceptions.throwInvalidAttributeValueException("folderPath");
        }
        this.folderPath = folderPath;
    }

    public String getPathDelimiter() {
        return this.pathDelimiter;
    }

    public void setPathDelimiter(String pathDelimiter) {
        if (StringUtils.isBlank((String)pathDelimiter)) {
            ExchangeExceptions.throwInvalidAttributeValueException("pathDelimiter");
        }
        this.pathDelimiter = pathDelimiter.trim();
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        if (StringUtils.isBlank((String)folderId)) {
            ExchangeExceptions.throwInvalidAttributeValueException("folderId");
        }
        this.folderId = folderId.trim();
    }

    static {
        validEventAttributes.put("StartTime".toUpperCase(), "StartTime".toUpperCase());
        validEventAttributes.put("EndTime".toUpperCase(), "EndTime".toUpperCase());
        validEventAttributes.put("TimeZone".toUpperCase(), "TimeZone".toUpperCase());
        validEventAttributes.put("Duration".toUpperCase(), "Duration".toUpperCase());
        validEventAttributes.put("Subject".toUpperCase(), "Subject".toUpperCase());
        validEventAttributes.put("Message".toUpperCase(), "Message".toUpperCase());
        validEventAttributes.put("Location".toUpperCase(), "Location".toUpperCase());
        validEventAttributes.put("RequiredAttendees".toUpperCase(), "RequiredAttendees".toUpperCase());
        validEventAttributes.put("OptionalAttendees".toUpperCase(), "OptionalAttendees".toUpperCase());
        validEventAttributes.put("Organizer".toUpperCase(), "Organizer".toUpperCase());
        validEventAttributes.put("reminder".toUpperCase(), "reminder".toUpperCase());
        validEventAttributes.put("Importance".toUpperCase(), "Importance".toUpperCase());
        validEventAttributes.put("Sensitivity".toUpperCase(), "Sensitivity".toUpperCase());
        validEventAttributes.put("IsRecurring".toUpperCase(), "IsRecurring".toUpperCase());
        validEventAttributes.put("AllDayEvent".toUpperCase(), "AllDayEvent".toUpperCase());
        validEventAttributes.put("RecurrenceType".toUpperCase(), "RecurrenceType".toUpperCase());
        validEventAttributes.put("RecurrenceNoEndDate".toUpperCase(), "RecurrenceNoEndDate".toUpperCase());
        validEventAttributes.put("RecurrenceCount".toUpperCase(), "RecurrenceCount".toUpperCase());
        validEventAttributes.put("RecurrenceEndDate".toUpperCase(), "RecurrenceEndDate".toUpperCase());
        validEventAttributes.put("RecurrenceFrequency".toUpperCase(), "RecurrenceFrequency".toUpperCase());
        validEventAttributes.put("RecurEveryWeekDay".toUpperCase(), "RecurEveryWeekDay".toUpperCase());
        validEventAttributes.put("RecurrenceDays".toUpperCase(), "RecurrenceDays".toUpperCase());
        validEventAttributes.put("RecurrenceWeek".toUpperCase(), "RecurrenceWeek".toUpperCase());
        validEventAttributes.put("RecurrenceDay".toUpperCase(), "RecurrenceDay".toUpperCase());
        validEventAttributes.put("RecurrenceMonth".toUpperCase(), "RecurrenceMonth".toUpperCase());
        validEventAttributes.put("attachments".toUpperCase(), "attachments".toUpperCase());
        validEventAttributes.put("FromId".toUpperCase(), "FromId".toUpperCase());
        validEventAttributes.put("Resources".toUpperCase(), "Resources".toUpperCase());
        validEventAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validEventAttributes.put("Label".toUpperCase(), "Label".toUpperCase());
        validEventAttributes.put("TimeZone", "TimeZone".toUpperCase());
        validFilterAttributes.put("StartTime".toUpperCase(), "StartTime".toUpperCase());
        validFilterAttributes.put("TimeZone".toUpperCase(), "TimeZone".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
        validFilterAttributes.put("EndTime".toUpperCase(), "EndTime".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("AllDayEvent".toUpperCase(), "AllDayEvent".toUpperCase());
        validFilterAttributes.put("HasAttachment".toUpperCase(), "HasAttachment".toUpperCase());
        validFilterAttributes.put("Importance".toUpperCase(), "Importance".toUpperCase());
        validFilterAttributes.put("IsRecurring".toUpperCase(), "IsRecurring".toUpperCase());
        validFilterAttributes.put("Location".toUpperCase(), "Location".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
        validFilterAttributes.put("Message".toUpperCase(), "Message".toUpperCase());
        validFilterAttributes.put("OptionalAttendees".toUpperCase(), "OptionalAttendees".toUpperCase());
        validFilterAttributes.put("Organizer".toUpperCase(), "Organizer".toUpperCase());
        validFilterAttributes.put("RequiredAttendees".toUpperCase(), "RequiredAttendees".toUpperCase());
        validFilterAttributes.put("Resources".toUpperCase(), "Resources".toUpperCase());
        validFilterAttributes.put("Sensitivity".toUpperCase(), "Sensitivity".toUpperCase());
        validFilterAttributes.put("Subject".toUpperCase(), "Subject".toUpperCase());
        validFilterAttributes.put("FromId".toUpperCase(), "FromId".toUpperCase());
        validFilterAttributes.put("Duration".toUpperCase(), "Duration".toUpperCase());
        validFilterAttributes.put("uid".toUpperCase(), "uid".toUpperCase());
        validFilterAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validFilterAttributes.put("Label".toUpperCase(), "Label".toUpperCase());
        validFilterAttributes.put("lastModified".toUpperCase(), "lastModified".toUpperCase());
        validFilterAttributes.put("recurrenceid".toUpperCase(), "recurrenceid".toUpperCase());
        validFilterAttributes.put("recurrenceidrange".toUpperCase(), "recurrenceidrange".toUpperCase());
    }
}

