/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVLoginInfo;
import coldfusion.exchange.webservice.Exchange2007Exception;
import coldfusion.exchange.webservice.Exchange2007WebServiceHelper;
import coldfusion.exchange.webservice.ResponseNSPrefixResolver;
import coldfusion.wddx.Base64Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Exchange2007Manager {
    private WebDAVConnection con = null;
    private static final ResponseNSPrefixResolver nsResolver = new ResponseNSPrefixResolver();

    public Exchange2007Manager(WebDAVConnection con) {
        this.con = con;
    }

    protected String postExchangeRequest(String message) throws Exception {
        String proxyHost = null;
        String protocol = "https";
        int serverPort = -1;
        int proxyPort = 0;
        WebDAVLoginInfo loginInfo = (WebDAVLoginInfo)this.con.getLoginInfo();
        String serverName = loginInfo.getExchangeHost();
        if (loginInfo.getPort() > 0) {
            serverPort = loginInfo.getPort();
        }
        if (loginInfo.getProtocol() != null) {
            protocol = loginInfo.getProtocol();
        }
        if (loginInfo.getProxyHost() != null) {
            proxyHost = loginInfo.getProxyHost();
        }
        if (loginInfo.getProxyPort() > 0) {
            proxyPort = loginInfo.getProxyPort();
        }
        String userName = loginInfo.getMailId();
        String password = loginInfo.getUserPassword();
        StringBuilder builder = new StringBuilder();
        builder.append(protocol);
        builder.append("://");
        builder.append(serverName);
        if (-1 != serverPort) {
            builder.append(":");
            builder.append(serverPort);
        }
        builder.append("/ews/Exchange.asmx");
        String urlStr = builder.toString();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (proxyHost != null) {
            clientBuilder.setProxy(new HttpHost(proxyHost, proxyPort));
        }
        BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
        credProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
        HttpPost method = new HttpPost(urlStr);
        StringBuffer tmpBuf = new StringBuffer();
        tmpBuf.append(userName).append(":").append(password == null ? "" : password);
        String authValue = "Basic " + Base64Encoder.encode((byte[])tmpBuf.toString().getBytes());
        method.addHeader((Header)new BasicHeader("Authorization", authValue));
        method.addHeader((Header)new BasicHeader("Content-Type", "text/xml; charset=utf-8"));
        method.setEntity((HttpEntity)new StringEntity(message));
        CloseableHttpClient httpClient = clientBuilder.build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)method);
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new Exchange2007Exception(4, code, "Error executing HTTPS request");
        }
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            byte[] byteResponse = EntityUtils.toByteArray((HttpEntity)responseEntity);
            ByteArrayInputStream inStream = new ByteArrayInputStream(byteResponse);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
            String line = null;
            StringBuilder responseBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseBuffer.append(line + "\n");
            }
            inStream.close();
            return responseBuffer.toString();
        }
        return null;
    }

    protected static Document parseResponseXML(String xmlStr) throws Exception {
        StringReader reader = new StringReader(xmlStr);
        InputSource input = new InputSource(reader);
        DocumentBuilderFactory factory = Exchange2007Manager.getDocumentBuilderFactory();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(input);
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (System.getSecurityManager() == null) {
            return DocumentBuilderFactory.newInstance();
        }
        DocumentBuilderFactory dbf = (DocumentBuilderFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DocumentBuilderFactory.newInstance();
            }
        });
        return dbf;
    }

    protected static void validateResponse(Document doc) throws Exception {
        Exchange2007Manager.checkSOAPFault(doc);
        Exchange2007Manager.verifyResponseCode(doc);
    }

    private static String verifyResponseCode(Document doc) throws Exception {
        String responseCode = Exchange2007Manager.getNodeValue(doc, "soap:Envelope/*/*/*/*/m:ResponseCode");
        if (responseCode == null) {
            throw new Exchange2007Exception(1, "Response code is null");
        }
        if (!responseCode.equalsIgnoreCase("NoError")) {
            throw new Exchange2007Exception(3, "Error executing the request");
        }
        return responseCode;
    }

    private static void checkSOAPFault(Document doc) throws Exception {
        Object obj = Exchange2007Manager.searchNode(doc, "soap:Envelope/soap:Body/soap:Fault");
        if (obj == null) {
            return;
        }
        if (obj instanceof Node) {
            String faultString = Exchange2007Manager.getNodeValue((Node)obj, "soap:faultstring");
            String responseCode = Exchange2007Manager.getNodeValue((Node)obj, "detail/e:ResponseCode");
            String message = Exchange2007Manager.getNodeValue((Node)obj, "detail/e:Message");
            if (faultString != null && faultString != null) {
                throw new Exchange2007Exception(5, faultString + ":" + message);
            }
            throw new Exchange2007Exception(5, "SOAP Fault");
        }
        throw new Exchange2007Exception(2, "Response code is invalid");
    }

    protected static Object searchNode(Node startNode, String path) throws Exception {
        XObject xobj = XPathAPI.eval((Node)startNode, (String)path, (PrefixResolver)nsResolver);
        return Exchange2007Manager.getXObjectValue(xobj);
    }

    protected static String getNodeValue(Node startNode, String path) throws Exception {
        Node valueNode;
        Object faultDtls = Exchange2007Manager.searchNode(startNode, path);
        if (faultDtls != null && (valueNode = ((Node)faultDtls).getFirstChild()) != null) {
            return valueNode.getNodeValue();
        }
        return null;
    }

    private static Object getXObjectValue(XObject xobj) throws Exception {
        switch (xobj.getType()) {
            case 1: {
                return xobj.bool() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                NodeList nodes = xobj.nodelist();
                if (nodes.getLength() == 0) {
                    return null;
                }
                if (nodes.getLength() == 1) {
                    return nodes.item(0);
                }
                Node[] nodeArray = new Node[nodes.getLength()];
                for (int i = 0; i < nodes.getLength(); ++i) {
                    nodeArray[i] = nodes.item(i);
                }
                return nodeArray;
            }
            case -1: {
                return null;
            }
            case 2: {
                return new Double(xobj.num());
            }
            case 3: {
                return xobj.str();
            }
        }
        return null;
    }

    public static void printNodeList(NodeList nodes, int indent) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Exchange2007Manager.printNode(nodes.item(i), indent);
        }
    }

    public static void printNode(Node node, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println("Node = " + node.getNodeName() + " : " + node.getNodeValue());
        Exchange2007Manager.printNodeList(node.getChildNodes(), indent + 1);
    }

    protected String[] getSubFolderId(String folderPath) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(folderPath, "/");
        String rootFolder = "msgfolderroot";
        String currFolder = null;
        String folderId = null;
        String changeKey = null;
        while (tokenizer.hasMoreTokens()) {
            currFolder = tokenizer.nextToken();
            String[] ids = this.getFolderId(currFolder, rootFolder, folderId, changeKey);
            if (ids == null) {
                return null;
            }
            folderId = ids[0];
            changeKey = ids[1];
        }
        if (folderId == null) {
            return null;
        }
        return new String[]{folderId, changeKey};
    }

    private String[] getFolderId(String folderName, String rootFolder, String parentFolderId, String parentFolderChangeKey) throws Exception {
        String msg = Exchange2007WebServiceHelper.createFindFolderRequest(folderName, rootFolder, parentFolderId, parentFolderChangeKey, null);
        String response = this.postExchangeRequest(msg);
        Document doc = Exchange2007Manager.parseResponseXML(response);
        Exchange2007Manager.validateResponse(doc);
        String folderKeyPath = "soap:Envelope/soap:Body/m:FindFolderResponse/m:ResponseMessages/m:FindFolderResponseMessage/m:RootFolder/t:Folders/*/t:FolderId";
        Object msgObjs = Exchange2007Manager.searchNode(doc, folderKeyPath);
        if (msgObjs == null) {
            return null;
        }
        Node folderNode = null;
        if (msgObjs instanceof Node) {
            folderNode = (Node)msgObjs;
        } else if (msgObjs instanceof Node[]) {
            folderNode = ((Node[])msgObjs)[0];
        }
        if (folderNode != null) {
            NamedNodeMap attribMap = folderNode.getAttributes();
            String folderId = null;
            String changeKey = null;
            folderId = attribMap.getNamedItem("Id").getNodeValue();
            changeKey = attribMap.getNamedItem("ChangeKey").getNodeValue();
            return new String[]{folderId, changeKey};
        }
        return null;
    }
}

