/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.ContentLoaderFactory;
import ice.storm.ImageConnection;
import ice.storm.Pilot;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.ResourceOwner;
import ice.util.alg.Session;
import ice.util.net.URLResolver;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageCache
implements ResourceOwner {
    private static final Object ENTRY_KEY = new Object();
    private static final String IMAGECACHE_EXPIRY = "ice.storm.imageCacheTimeout";
    private static final HashArray proxyUrlToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
    private static long proxyCounter = 0L;
    private static boolean useImageConnection = true;
    private static Method imageIOMethod = null;
    private static Method imageIOStreamMethod = null;
    private Session session;
    private int toUnload = 0;
    protected HashArray uriToEntry;
    protected HashArray imageToEntry;
    protected int timeout = 30;
    static final int NUMBER_OF_LOADER_THREADS = 4;
    private int animImageCounter = 0;
    private Toolkit awtToolkit;
    private boolean forceReload;
    static /* synthetic */ Class class$java$io$InputStream;

    protected ImageCache(Session session) {
        this.session = session;
        this.uriToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.imageToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.awtToolkit = Toolkit.getDefaultToolkit();
    }

    public static ImageCache get(Session session) {
        int newExpireVal;
        ImageCache x = (ImageCache)session.getEntry(ENTRY_KEY);
        if (x == null && (newExpireVal = Defs.sysPropertyInt(IMAGECACHE_EXPIRY, (x = ImageCache.set(session, new ImageCache(session))).getExpire())) != x.getExpire()) {
            x.setExpire(newExpireVal);
        }
        return x;
    }

    public static ImageCache set(Session session, ImageCache cache) {
        return (ImageCache)session.initEntry(ENTRY_KEY, cache);
    }

    public void setReload(boolean flag) {
        this.forceReload = flag;
    }

    public Toolkit getAwtToolkit() {
        return this.awtToolkit;
    }

    public void setExpire(int t) {
        this.timeout = t;
    }

    public int getExpire() {
        return this.timeout;
    }

    public void dispose() {
        this.disposeResources();
    }

    public void disposeResources() {
        this.flushImages(true);
    }

    public Image getImage(URL u) {
        return this.getImage(u.toExternalForm());
    }

    public Image getImage(String url) {
        return this.getImage(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String url, Pilot pilot) {
        Entry e;
        URL urlForToolkit = null;
        boolean doReload = false;
        Image forcedImageFlush = null;
        Object object = this;
        synchronized (object) {
            e = (Entry)this.uriToEntry.get(url);
            if (this.forceReload && e != null && e.image != null) {
                forcedImageFlush = this.disconnectEntry(e);
                e = null;
            }
            if (e == null) {
                e = new Entry();
                e.url = url;
                e.realUrlObj = URLResolver.newURL(url);
                if (e.realUrlObj == null) {
                    return null;
                }
                this.uriToEntry.put(url, (Object)e);
                ++e.ref;
                urlForToolkit = this.initProxyURL(e) ? e.proxyUrlObj : e.realUrlObj;
            } else if (e.image != null) {
                this.increaseRef(e);
                return e.image;
            }
        }
        if (forcedImageFlush != null) {
            forcedImageFlush.flush();
        }
        if (urlForToolkit != null) {
            if (e.initializedImage) {
                Debug.bug();
            }
            Image img = this.getImageFromToolkit(urlForToolkit, pilot);
            Object object2 = this;
            synchronized (object2) {
                if (img != null) {
                    e.image = img;
                    this.imageToEntry.put(e.image, (Object)e);
                } else {
                    --e.ref;
                    this.uriToEntry.remove(e.url);
                    this.clearProxyURL(e);
                }
            }
            object2 = e;
            synchronized (object2) {
                e.initializedImage = true;
                e.notifyAll();
            }
        }
        object = e;
        synchronized (object) {
            if (!e.initializedImage) {
                try {
                    e.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        object = this;
        synchronized (object) {
            if (e.image != null) {
                this.increaseRef(e);
            }
        }
        return e.image;
    }

    private void increaseRef(Entry e) {
        e.stopped = false;
        if (e.flushBeforeReload) {
            e.flushBeforeReload = false;
            e.image.flush();
        }
        if (e.ref == 0) {
            --this.toUnload;
        }
        ++e.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading(Image img) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry e = (Entry)this.imageToEntry.get(img);
            if (e == null) {
                return;
            }
            ImageConnection ic = e.ic;
            e.ic = null;
            if (ic != null) {
                e.flushBeforeReload = ic.reqToStop();
            } else {
                e.stopped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Image img) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry e = (Entry)this.imageToEntry.get(img);
            if (e != null) {
                --e.ref;
                if (e.ref == 0) {
                    ++this.toUnload;
                    e.dieTime = System.currentTimeMillis() + (long)(this.timeout * 1000);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushImages(boolean all) {
        if (!all && this.toUnload == 0) {
            return;
        }
        Vector<Entry> toFlush = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            long tt = System.currentTimeMillis();
            HashArray.Iterator iter = this.uriToEntry.newIterator();
            iter.start();
            while (!iter.done()) {
                Entry e = (Entry)iter.value();
                if (all || e.ref == 0 && e.dieTime <= tt) {
                    if (toFlush == null) {
                        toFlush = new Vector<Entry>();
                    }
                    toFlush.addElement(e);
                }
                iter.next();
            }
            if (toFlush != null) {
                int N = toFlush.size();
                for (int i = 0; i != N; ++i) {
                    Entry e = (Entry)toFlush.elementAt(i);
                    Image img = this.disconnectEntry(e);
                    toFlush.setElementAt((Entry)((Object)img), i);
                }
            }
        }
        if (toFlush != null) {
            int N = toFlush.size();
            for (int i = 0; i != N; ++i) {
                Image img = (Image)toFlush.elementAt(i);
                if (img == null) continue;
                try {
                    img.flush();
                    continue;
                }
                catch (NullPointerException exception) {
                    if (!Debug.ex) continue;
                    Debug.ex(exception);
                }
            }
        }
    }

    private Image disconnectEntry(Entry entry) {
        Image img;
        this.uriToEntry.remove(entry.url);
        this.clearProxyURL(entry);
        if (entry.ref == 0) {
            --this.toUnload;
        }
        if ((img = entry.image) != null) {
            this.imageToEntry.remove(img);
            entry.image = null;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForAnimatedImagesBug() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            ++this.animImageCounter;
            if (Debug.trace) {
                Debug.trace("animImageCounter==" + this.animImageCounter);
            }
            if (this.animImageCounter >= 4) {
                block9: {
                    try {
                        if (Debug.trace) {
                            Debug.trace("--> Initiating recovery");
                        }
                        URL u = this.getClass().getResource("resources/dummyimage.gif");
                        Image tmp = this.getImageFromToolkit(u, null);
                        this.awtToolkit.prepareImage(tmp, -1, -1, null);
                        tmp.flush();
                    }
                    catch (Exception ex) {
                        if (!Debug.ex) break block9;
                        Debug.ex(ex);
                    }
                }
                if (Debug.trace) {
                    Debug.trace("--> --> Recovery done");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImageFromToolkit(final URL url, final Pilot pilot) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            --this.animImageCounter;
            if (this.animImageCounter < 0) {
                this.animImageCounter = 0;
            }
        }
        return (Image)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                if (pilot == null) {
                    return ImageCache.this.factoryGetImage(url);
                }
                return ImageCache.this.factoryGetImage(url, pilot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Image factoryGetImage(URL url, Pilot pilot) {
        if (pilot != null && imageIOStreamMethod != null) {
            InputStream inputStream;
            block15: {
                String imageType;
                ContentLoaderFactory contentLoaderFactory = pilot.getStorm().getContentLoaderFactory();
                ContentLoader loader = contentLoaderFactory.createContentLoader(url, "image/jpeg");
                inputStream = null;
                URLConnection urlConnection = loader.openConnection(url);
                inputStream = urlConnection.getInputStream();
                String urlStr = url.toExternalForm();
                int index = urlStr.lastIndexOf(46);
                if (index == -1 || !(imageType = urlStr.substring(index + 1)).equalsIgnoreCase("png")) break block15;
                Image image = this.readPNGImage(inputStream);
                Object var12_12 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return image;
            }
            Image image = (Image)imageIOStreamMethod.invoke(null, inputStream);
            Object var12_13 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return image;
            catch (Throwable e) {
                try {
                    Object var12_14 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {}
            }
        }
        return this.factoryGetImage(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image readPNGImage(InputStream inputStream) throws IOException {
        ImageReader reader = this.getPNGImageReader();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        reader.setInput(imageInputStream, true, true);
        try {
            BufferedImage bufferedImage = reader.read(0);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    private ImageReader getPNGImageReader() {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("png");
        ImageReader reader = null;
        while (iter.hasNext() && (reader = iter.next()).getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader")) {
        }
        return reader;
    }

    protected Image factoryGetImage(URL url) {
        if (imageIOMethod != null) {
            Object[] args = new Object[]{url};
            try {
                Image img = (Image)imageIOMethod.invoke(null, args);
                return img;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.awtToolkit.getImage(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initProxyURL(Entry entry) {
        if (useImageConnection) {
            HashArray hashArray = proxyUrlToEntry;
            synchronized (hashArray) {
                URL proxy;
                String proxyName = "image:" + ++proxyCounter;
                try {
                    proxy = new URL(proxyName);
                }
                catch (MalformedURLException ex) {
                    useImageConnection = true;
                    proxy = null;
                }
                if (proxy != null) {
                    entry.proxyUrlObj = proxy;
                    proxyUrlToEntry.put(proxy, (Object)entry);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProxyURL(Entry e) {
        URL proxy = e.proxyUrlObj;
        if (proxy != null) {
            HashArray hashArray = proxyUrlToEntry;
            synchronized (hashArray) {
                proxyUrlToEntry.remove(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL setImageConnection(URL proxy, ImageConnection ic) {
        Entry e;
        HashArray hashArray = proxyUrlToEntry;
        synchronized (hashArray) {
            e = (Entry)proxyUrlToEntry.get(proxy);
        }
        if (e != null) {
            e.ic = ic;
            if (e.stopped) {
                e.flushBeforeReload = true;
                return null;
            }
            return e.realUrlObj;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Defs.sysPropertyBoolean("ice.storm.use14")) {
            try {
                Class<?> imageIO = Class.forName("javax.imageio.ImageIO");
                Class[] args = new Class[1];
                URL dummy = new URL("http://dummy.org");
                args[0] = dummy.getClass();
                imageIOMethod = imageIO.getMethod("read", args);
                imageIOStreamMethod = imageIO.getMethod("read", class$java$io$InputStream == null ? (class$java$io$InputStream = ImageCache.class$("java.io.InputStream")) : class$java$io$InputStream);
            }
            catch (Throwable t) {
                Debug.trace("ImageCache: Java 1.4 Imaging subsystem not found.");
                imageIOMethod = null;
            }
        }
    }

    private class Entry {
        boolean initializedImage;
        Image image;
        String url;
        int ref;
        long dieTime;
        URL proxyUrlObj;
        URL realUrlObj;
        ImageConnection ic;
        volatile boolean flushBeforeReload = false;
        volatile boolean stopped = false;

        private Entry() {
        }
    }
}

