/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.dom.html.TableCaptionElement;
import ice.dom.html.TableRowElement;
import ice.dom.html.TableSectionElement;
import ice.dom.html.VectorCollection;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class TableElement
extends DefaultHTMLElement
implements HTMLTableElement {
    private static final int Field_caption = 1;
    private static final int Field_rows = 2;
    private static final int Field_tBodies = 3;
    private static final int Field_tFoot = 4;
    private static final int Field_tHead = 5;
    private static final int Method_createCaption = -1;
    private static final int Method_createTFoot = -2;
    private static final int Method_createTHead = -3;
    private static final int Method_deleteCaption = -4;
    private static final int Method_deleteRow = -5;
    private static final int Method_deleteTFoot = -6;
    private static final int Method_deleteTHead = -7;
    private static final int Method_insertRow = -8;

    public TableElement(DDocument doc, int id) {
        super(doc, id);
    }

    public HTMLTableCaptionElement getCaption() {
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            DNode child = (DNode)list.item(i);
            if (!(child instanceof HTMLTableCaptionElement)) continue;
            return (HTMLTableCaptionElement)((Object)child);
        }
        return null;
    }

    public void setCaption(HTMLTableCaptionElement value) {
        HTMLTableCaptionElement old = this.getCaption();
        if (old != null) {
            this.replaceChild(value, old);
        } else {
            this.insertBefore(value, this.first);
        }
    }

    public HTMLTableSectionElement getTHead() {
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            DNode child = (DNode)list.item(i);
            if (!(child instanceof HTMLTableSectionElement) || child.getNameId() != 85) continue;
            return (HTMLTableSectionElement)((Object)child);
        }
        return null;
    }

    private void do_insertTHead(HTMLTableSectionElement value) {
        HTMLTableSectionElement foot = this.getTFoot();
        if (foot != null) {
            this.insertBefore(value, foot);
        } else {
            this.insertBefore(value, this.getTBodies().item(0));
        }
    }

    public void setTHead(HTMLTableSectionElement value) {
        HTMLTableSectionElement old = this.getTHead();
        if (old != null) {
            this.replaceChild(value, old);
        } else {
            this.do_insertTHead(value);
        }
    }

    public HTMLTableSectionElement getTFoot() {
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            DNode child = (DNode)list.item(i);
            if (!(child instanceof HTMLTableSectionElement) || child.getNameId() != 83) continue;
            return (HTMLTableSectionElement)((Object)child);
        }
        return null;
    }

    public void setTFoot(HTMLTableSectionElement value) {
        HTMLTableSectionElement old = this.getTFoot();
        if (old != null) {
            this.replaceChild(value, old);
        } else {
            this.insertBefore(value, this.getTBodies().item(0));
        }
    }

    public HTMLCollection getRows() {
        Vector<HTMLCollection> v = new Vector<HTMLCollection>();
        NodeList rows = this.getChildNodes();
        for (int i = 0; i < rows.getLength(); ++i) {
            Node n = rows.item(i);
            if (!(n instanceof HTMLTableSectionElement)) continue;
            v.addElement(((HTMLTableSectionElement)n).getRows());
        }
        return new VectorCollection(v);
    }

    public HTMLCollection getTBodies() {
        Vector<DNode> v = new Vector<DNode>();
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            DNode child = (DNode)list.item(i);
            if (!(child instanceof HTMLTableSectionElement) || child.getNameId() != 80) continue;
            v.addElement(child);
        }
        return new VectorCollection(v);
    }

    public HTMLElement createTHead() {
        HTMLTableSectionElement head = this.getTHead();
        if (head == null) {
            head = new TableSectionElement(this.doc, 85);
            this.do_insertTHead(head);
        }
        return head;
    }

    public void deleteTHead() {
        HTMLTableSectionElement head = this.getTHead();
        if (head != null) {
            this.removeChild(head);
        }
    }

    public HTMLElement createTFoot() {
        HTMLTableSectionElement foot = this.getTFoot();
        if (foot == null) {
            foot = new TableSectionElement(this.doc, 83);
            this.insertBefore(foot, this.getTBodies().item(0));
        }
        return foot;
    }

    public void deleteTFoot() {
        HTMLTableSectionElement foot = this.getTFoot();
        if (foot != null) {
            this.removeChild(foot);
        }
    }

    public HTMLElement createCaption() {
        HTMLTableCaptionElement cap = this.getCaption();
        if (cap == null) {
            cap = new TableCaptionElement(this.doc, 16);
            this.insertBefore(cap, this.first);
        }
        return cap;
    }

    public void deleteCaption() {
        HTMLTableCaptionElement cap = this.getCaption();
        if (cap != null) {
            this.removeChild(cap);
        }
    }

    public HTMLElement insertRow(int index) {
        HTMLCollection rows = this.getRows();
        int sz = rows.getLength();
        if (index > sz || index < 0) {
            return null;
        }
        TableRowElement newNode = new TableRowElement(this.doc, 87);
        if (sz == 0) {
            if (this.getNameId() == 79) {
                TableSectionElement body = new TableSectionElement(this.doc, 80);
                body.appendChild(newNode);
                this.appendChild(body);
            } else {
                this.appendChild(newNode);
            }
        } else if (sz == index) {
            rows.item(sz - 1).getParentNode().appendChild(newNode);
        } else {
            Node ref = rows.item(index);
            ref.getParentNode().insertBefore(newNode, ref);
        }
        return newNode;
    }

    public void deleteRow(int index) {
        HTMLCollection rows = this.getRows();
        int sz = rows.getLength();
        if (index >= sz || index < 0) {
            return;
        }
        Node n = rows.item(index);
        n.getParentNode().removeChild(n);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = TableElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = TableElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = TableElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getCaption();
            }
            case 2: {
                return this.getRows();
            }
            case 3: {
                return this.getTBodies();
            }
            case 4: {
                return this.getTFoot();
            }
            case 5: {
                return this.getTHead();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setCaption((HTMLTableCaptionElement)env.toNative(value));
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                this.setTFoot((HTMLTableSectionElement)env.toNative(value));
                return 1;
            }
            case 5: {
                this.setTHead((HTMLTableSectionElement)env.toNative(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.createCaption();
            }
            case -2: {
                return this.createTFoot();
            }
            case -3: {
                return this.createTHead();
            }
            case -4: {
                this.deleteCaption();
                break;
            }
            case -5: {
                this.deleteRow(env.toInt(args, 0));
                break;
            }
            case -6: {
                this.deleteTFoot();
                break;
            }
            case -7: {
                this.deleteTHead();
                break;
            }
            case -8: {
                return this.insertRow(env.toInt(args, 0));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                guess = "rows";
                id = 2;
                break;
            }
            case 5: {
                char c = s.charAt(1);
                if (c == 'F') {
                    guess = "tFoot";
                    id = 4;
                    break;
                }
                if (c != 'H') break;
                guess = "tHead";
                id = 5;
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "caption";
                    id = 1;
                    break;
                }
                if (c != 't') break;
                guess = "tBodies";
                id = 3;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "deleteRow";
                    id = -5;
                    break;
                }
                if (c != 'i') break;
                guess = "insertRow";
                id = -8;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    c = s.charAt(10);
                    if (c == 'd') {
                        guess = "createTHead";
                        id = -3;
                        break;
                    }
                    if (c != 't') break;
                    guess = "createTFoot";
                    id = -2;
                    break;
                }
                if (c != 'd') break;
                c = s.charAt(10);
                if (c == 'd') {
                    guess = "deleteTHead";
                    id = -7;
                    break;
                }
                if (c != 't') break;
                guess = "deleteTFoot";
                id = -6;
                break;
            }
            case 13: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "createCaption";
                    id = -1;
                    break;
                }
                if (c != 'd') break;
                guess = "deleteCaption";
                id = -4;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

