/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph.osgi;

import coldfusion.graph.ChartImageTagTemplate;
import coldfusion.graph.osgi.cache.InteractiveChartCacheManager;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.NeoException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.GraphingService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceListener;
import coldfusion.server.ServiceMetaData;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.CFFileServlet;
import coldfusion.util.IOUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.vfs.VFSFileFactory;
import com.zingchart.ZingChartComponentD;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class InteractiveGraphingServiceImpl
extends ServiceBase
implements GraphingService {
    private static final Logger logger = CFLogs.SERVER_LOG;
    private long CHART_TIMEOUT = Long.valueOf(System.getProperty("coldfusion.chart.serverside.timeout", "3000"));
    private int status = 16;
    private File configFile;
    private boolean isBase64;
    private ConfigMap _settings = null;
    private static long uniqueID = 100000L;
    private static Random randomID = new Random();
    private InteractiveChartCacheManager interactiveChartCacheManager = InteractiveChartCacheManager.getInstance();
    private ThreadLocal<ZingChartComponentD> detachedZCComponent = new ThreadLocal();
    private static Timer timer = new Timer();

    public InteractiveGraphingServiceImpl(File f) {
        this.configFile = f;
    }

    public byte[] generateBytes(String graphType, String height, String width, String url, String xmlStyle, String graphJSON) throws IOException {
        return this.generateBytes(graphType, height, width, url, xmlStyle, graphJSON, false);
    }

    public byte[] generateBytes(String graphType, String height, String width, String url, String xmlStyle, String graphJSON, boolean isNewCharting) throws IOException {
        Ehcache ehCache = this.interactiveChartCacheManager.getChartsCache("CF_Chart_CacheManager");
        Element imgElement = ehCache.get((Serializable)((Object)(graphJSON + "height:" + height + ";width:" + width + ";format:" + graphType)));
        if (imgElement != null) {
            return (byte[])imgElement.getObjectValue();
        }
        byte[] imageBytes = this.generateBytes(null, graphType, height, width, url, xmlStyle, graphJSON, isNewCharting);
        ehCache.put(new Element((Serializable)((Object)(graphJSON + "height:" + height + ";width:" + width + ";format:" + graphType)), (Serializable)imageBytes));
        return imageBytes;
    }

    public String generateGraph(String graphType, String height, String width, String contextPath, String url, String xmlStyle, String graphJSON, boolean newFormat) {
        String imgTemplateCacheKey = this.getImgCacheKey(graphJSON, height, width, graphType);
        Ehcache ehCache = this.interactiveChartCacheManager.getChartsCache("CF_Chart_CacheManager");
        LockManager lockManager = LockManager.get();
        Element imageTagElement = ehCache.get((Serializable)((Object)imgTemplateCacheKey));
        if (imageTagElement == null) {
            try {
                lockManager.requestNamedLock("__cf_cck__" + imgTemplateCacheKey, false, this.CHART_TIMEOUT);
                imageTagElement = ehCache.get((Serializable)((Object)imgTemplateCacheKey));
                String string = this.getCachedImageTag(imageTagElement).orElse(this.generateImageTag(imageTagElement, graphType, height, width, contextPath, url, xmlStyle, graphJSON));
                return string;
            }
            catch (InterruptedException e) {
                logger.error((Object)"InterruptionException while acquiring lock");
                throw new GraphingEngineException(e);
            }
            finally {
                lockManager.releaseNamedLock("__cf_cck__" + imgTemplateCacheKey, false);
            }
        }
        return this.getCachedImageTag(imageTagElement).orElse(this.generateImageTag(imageTagElement, graphType, height, width, contextPath, url, xmlStyle, graphJSON));
    }

    private Optional<String> getCachedImageTag(Element imageTagElement) {
        if (Objects.isNull(imageTagElement)) {
            return Optional.empty();
        }
        ChartImageTagTemplate imageTemplate = (ChartImageTagTemplate)imageTagElement.getObjectValue();
        if (this.isBase64) {
            return Optional.of(imageTemplate.getImgTag());
        }
        String cachedFileName = imageTemplate.getImageServletPath().substring(imageTemplate.getImageServletPath().lastIndexOf("/") + 1);
        File tempImageFile = VFSFileFactory.getFileObject((String)(this.getCachePath() + File.separator + cachedFileName));
        if (tempImageFile.exists()) {
            return Optional.of(imageTemplate.getImgTag());
        }
        return Optional.empty();
    }

    private String generateImageTag(Element imageTagElement, String graphType, String height, String width, String contextPath, String url, String xmlStyle, String graphJSON) {
        byte[] imageBytes;
        ZingChartComponentD zc;
        ChartImageTagTemplate imageTemplate;
        String path = this.getServletPathString(contextPath, "CFFileServlet/_cf_chart");
        String id = this.getID();
        String imgTemplateCacheKey = this.getImgCacheKey(graphJSON, height, width, graphType);
        String fileName = id + "." + graphType;
        Ehcache ehCache = this.interactiveChartCacheManager.getChartsCache("CF_Chart_CacheManager");
        if (imageTagElement != null) {
            imageTemplate = (ChartImageTagTemplate)imageTagElement.getObjectValue();
            if (this.isBase64) {
                return imageTemplate.getImgTag();
            }
            String cachedFileName = imageTemplate.getImageServletPath().substring(imageTemplate.getImageServletPath().lastIndexOf("/") + 1);
            File tempImageFile = VFSFileFactory.getFileObject((String)(this.getCachePath() + File.separator + cachedFileName));
            if (tempImageFile.exists()) {
                return imageTemplate.getImgTag();
            }
        }
        try {
            zc = this.getZCComponent(id, height, width, graphJSON);
            imageBytes = this.generateBytes(zc, graphType, height, width, url, xmlStyle, graphJSON, false);
        }
        catch (IOException ioex) {
            throw new RuntimeWrapper((Throwable)ioex);
        }
        imageTemplate = this.isBase64 ? this.constructImageTag(zc, imageBytes, id) : this.constructImageTag(zc, path, id, fileName);
        byte[] tmpImageBytes = imageBytes;
        AccessController.doPrivileged(() -> {
            this.imageCreationAndScheduledDelete(this.isBase64, fileName, tmpImageBytes, ehCache, imgTemplateCacheKey);
            return true;
        });
        ehCache.put(new Element((Serializable)((Object)imgTemplateCacheKey), (Serializable)imageTemplate));
        return imageTemplate.getImgTag();
    }

    private void imageCreationAndScheduledDelete(final boolean isBase64, String fileName, byte[] tmpImageBytes, final Ehcache ehCache, final String imgTemplateCacheKey) {
        try {
            final String tempFile = this.getCachePath() + File.separator + fileName;
            if (!isBase64) {
                FileUtils.writeFile((String)tempFile, (Object)tmpImageBytes, null);
            }
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!isBase64) {
                        IOUtils.delete((File)new File(tempFile));
                    }
                    ehCache.remove((Serializable)((Object)imgTemplateCacheKey));
                }
            }, this.interactiveChartCacheManager.getTimeToLive() * 1000);
        }
        catch (Throwable th) {
            throw new GraphingEngineException(th);
        }
    }

    private ZingChartComponentD getZCComponent(String id, String height, String width, String graphJSON) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("license", "192d37510b591051,Adobe");
        if (id != null && !id.equals("")) {
            attrs.put("id", id);
        }
        attrs.put("width", String.valueOf(width));
        attrs.put("height", String.valueOf(height));
        attrs.put("data", graphJSON);
        try {
            ZingChartComponentD detachedZCComponent = this.getZCComponent();
            detachedZCComponent.render(attrs);
            return detachedZCComponent;
        }
        catch (Exception ex) {
            throw new GraphingEngineException(ex);
        }
    }

    private ZingChartComponentD getZCComponent() throws Exception {
        ZingChartComponentD temp = this.detachedZCComponent.get();
        if (temp == null) {
            temp = new ZingChartComponentD();
            this.detachedZCComponent.set(temp);
        }
        return temp;
    }

    private byte[] generateBytes(ZingChartComponentD zc, String graphType, String height, String width, String url, String xmlStyle, String graphJSON, boolean b) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            if (zc == null) {
                zc = this.getZCComponent(null, height, width, graphJSON);
            }
            BufferedImage bimage = (BufferedImage)zc.getImage();
            if (graphType.equalsIgnoreCase("png")) {
                ImageIO.write((RenderedImage)bimage, "png", byteStream);
            } else if (graphType.equalsIgnoreCase("jpg")) {
                BufferedImage bimagejpg = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 1);
                bimagejpg.createGraphics().drawImage(bimage, 0, 0, Color.WHITE, null);
                ImageIO.write((RenderedImage)bimagejpg, "jpg", byteStream);
            }
        }
        catch (Exception ex) {
            throw new GraphingEngineException(ex);
        }
        return byteStream.toByteArray();
    }

    private String getImgCacheKey(String graphJSON, String height, String width, String graphType) {
        return graphJSON + "height:" + height + ";width:" + width + ";format:" + graphType + "-chartImageTemplate";
    }

    public String generateGraph(String graphType, String height, String width, String contextPath, String url, String xmlStyle, String xmlContents) {
        return null;
    }

    public String getCachePath() {
        return this.interactiveChartCacheManager.getCachePath();
    }

    public int getCacheSize() {
        return this.interactiveChartCacheManager.getCacheSize();
    }

    public int getTimeToLive() {
        return this.interactiveChartCacheManager.getTimeToLive();
    }

    public byte[] getGraphData(String graphID, ServletContext context, boolean useNewCache) throws IOException {
        if (this.getStatus() == 16) {
            throw new GraphingServiceUnavailableException();
        }
        try {
            final String tmpGraphID = graphID;
            final String cachepath = this.getCachePath();
            byte[] imgBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        int index = tmpGraphID.indexOf("/");
                        if (index == -1) {
                            throw new ForbiddenOperationException();
                        }
                        String filePath = tmpGraphID.substring(index + 1).trim();
                        File imageFile = new File(cachepath, filePath);
                        String imageRealPath = imageFile.getCanonicalPath();
                        if (filePath.equals("") || !imageRealPath.startsWith(InteractiveGraphingServiceImpl.this.getCachePath()) || !imageFile.exists()) {
                            throw new ForbiddenOperationException();
                        }
                        return FileUtils.readBinaryFile((String)imageRealPath);
                    }
                    catch (Throwable th) {
                        throw new GraphingEngineException(th);
                    }
                }
            });
            return imgBytes;
        }
        catch (Throwable th) {
            throw new GraphingEngineException(th);
        }
    }

    public int getMaxEngines() {
        return 1;
    }

    public Map getSettings() {
        return this._settings;
    }

    public int getCacheType() {
        return this.interactiveChartCacheManager.getCacheType();
    }

    public void setUpWatermark() {
    }

    public void addServiceListener(ServiceListener listener) {
    }

    public ServiceMetaData getMetaData() {
        return null;
    }

    public Object getProperty(String name) {
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public void restart() throws ServiceException {
        this.stop();
        this.start();
    }

    public void setProperty(String name, Object value) {
    }

    public void setBase64(boolean isBase64) {
        this.isBase64 = isBase64;
    }

    public void start() throws ServiceException {
        this.load();
        CFFileServlet.cleanupTempCache((File)new File(this.getCachePath()), (int)5);
        this.status = 4;
    }

    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.configFile);
            this._settings = (ConfigMap)v.elementAt(0);
            this._settings.init((Service)this, "settings");
            this._settings.setConfigMapListener((ConfigMapListener)this);
            String cachePath = ServiceFactory.getRuntimeService().getTempCacheDirectory() + File.separator + "CFFileServlet" + File.separator + "_cf_chart";
            this.interactiveChartCacheManager.setCachePath(cachePath);
            this.setCacheType(((Number)this._settings.get((Object)"CacheType")).intValue(), cachePath);
            this.interactiveChartCacheManager.setCacheSize(((Number)this._settings.get((Object)"CacheSize")).intValue());
            this.interactiveChartCacheManager.setTimeToLive(((Number)this._settings.get((Object)"TimeToLive")).intValue());
        }
        catch (Exception ex) {
            logger.error((Object)("Error in load() method of " + ((Object)((Object)this)).getClass().getName()), (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    public void store() throws ServiceException {
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this._settings);
        this.serialize(v, this.configFile);
        this.setCacheType(((Number)this._settings.get((Object)"CacheType")).intValue(), this.getCachePath());
        this.interactiveChartCacheManager.setCacheSize(((Number)this._settings.get((Object)"CacheSize")).intValue());
        this.interactiveChartCacheManager.setTimeToLive(((Number)this._settings.get((Object)"TimeToLive")).intValue());
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("settings.keys", "CacheType,CacheSize,TimeToLive,MaxEngines,ServletName,CachePath");
            this.rb.put("settings.types", "java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.String,java.lang.String");
            this.rb.put("settings.formats", "coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    private void setCacheType(int cacheType, String cachePath) {
        this.interactiveChartCacheManager.setCacheType(cacheType);
        switch (cacheType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new UnknownCacheTypeException(cacheType);
            }
        }
    }

    public void stop() throws ServiceException {
        this.status = 16;
    }

    private String getServletPathString(String contextPath, String extraInfo) {
        StringBuffer servletPath = new StringBuffer();
        if (contextPath == null) {
            throw new NullContextPathException();
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            servletPath.append("/");
        }
        servletPath.append(contextPath);
        servletPath.append("/");
        servletPath.append(extraInfo);
        return servletPath.toString();
    }

    private ChartImageTagTemplate constructImageTag(ZingChartComponentD zc, String path, String id, String fileName) {
        ChartImageTagTemplate imageTemplate = new ChartImageTagTemplate();
        imageTemplate.setHtmlArea(zc.getHtmlArea());
        imageTemplate.setNodeInfo(zc.getNodeInfo());
        imageTemplate.setId(id);
        imageTemplate.setImageServletPath(this.getImageSrc(path, fileName));
        return imageTemplate;
    }

    private ChartImageTagTemplate constructImageTag(ZingChartComponentD zc, byte[] imageBytes, String id) {
        String imgSrc = "data:image/png;base64,".concat(Base64.getEncoder().encodeToString(imageBytes));
        ChartImageTagTemplate imageTemplate = new ChartImageTagTemplate();
        imageTemplate.setHtmlArea(zc.getHtmlArea());
        imageTemplate.setNodeInfo(zc.getNodeInfo());
        imageTemplate.setId(id);
        imageTemplate.setImageServletPath(imgSrc);
        return imageTemplate;
    }

    public String getImageSrc(String path, String fileName) {
        return path + "/" + fileName;
    }

    public String getID() {
        long l = (long)randomID.nextInt(1000000000) * 10000000L;
        long l1 = l + uniqueID++;
        StringBuilder sb = new StringBuilder(32);
        String id = sb.append(l1).toString();
        return id;
    }

    public void setBase64(GraphingService graphService, boolean isBase64) {
        if (graphService instanceof InteractiveGraphingServiceImpl) {
            ((InteractiveGraphingServiceImpl)graphService).setBase64(isBase64);
        }
    }

    public void reset() {
        this.interactiveChartCacheManager.closeCacheMgr();
    }

    public static class ForbiddenOperationException
    extends NeoException {
        ForbiddenOperationException() {
        }
    }

    public static class UnknownCacheTypeException
    extends NeoException {
        public int type;

        UnknownCacheTypeException(int t) {
            this.type = t;
        }
    }

    public static class NullContextPathException
    extends NeoException {
        NullContextPathException() {
        }
    }

    public static class GraphingServiceUnavailableException
    extends NeoException {
        GraphingServiceUnavailableException() {
        }
    }

    public class ChartingCacheException
    extends NeoException {
        public String cache;

        public ChartingCacheException(String cacheDir) {
            this.cache = cacheDir;
        }
    }

    public static class GraphingEngineException
    extends NeoException {
        GraphingEngineException(Throwable th) {
            super(th);
        }
    }
}

