/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.utils;

import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.AWSUtils;
import coldfusion.cloud.aws.dynamodb.CFDynamoAttributeDefsMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoAutoScalingPolicyUpdateMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoAutoScalingSettingsUpdateMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoAutoScalingTargetTrackingScalingPolicyConfigurationMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoDbServiceConfig;
import coldfusion.cloud.aws.dynamodb.CFDynamoGlobalSecondaryIndexesMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoGlobalTableGlobalSecondaryIndexSettingsUpdateMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoKeySchemaListMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoKeysAndAttributesMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoKeysAndAttributesWithTypeMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoLocalSecondaryIndexesMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoProjectionMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoProvisionedThroughputMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoReplicaGlobalSecondaryIndexSettingsMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoReplicaSettingsUpdateMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoSSESpecificationMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoStreamSpecificationMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoTagsMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoWriteRequestMetadata;
import coldfusion.cloud.aws.dynamodb.CFDynamoWriteWithTypeRequestMetadata;
import coldfusion.cloud.aws.dynamodb.attributes.CFDynamoDbAttributes;
import coldfusion.cloud.aws.dynamodb.utils.ValidatorFiller;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBigInteger;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.sql.QueryUtils;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.xml.XmlNodeList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class CFDynamoDbUtils
extends AWSUtils {
    public static final AttributeValue convertToAWSDataType(String key, Object value) {
        AttributeValue attrVal = null;
        if (value instanceof CFBigDecimal) {
            String bigDecimal = ((CFBigDecimal)value).toString();
            attrVal = (AttributeValue)AttributeValue.builder().s(bigDecimal).build();
        } else if (value instanceof CFBigInteger) {
            String bigInteger = ((CFBigInteger)value).toString();
            attrVal = (AttributeValue)AttributeValue.builder().s(bigInteger).build();
        } else if (value instanceof Integer || value instanceof Number) {
            attrVal = (AttributeValue)AttributeValue.builder().n(String.valueOf(value)).build();
        } else if (value instanceof String) {
            if (value.equals("")) {
                value = "[empty string]";
            }
            attrVal = (AttributeValue)AttributeValue.builder().s(String.valueOf(value)).build();
        } else if (value instanceof Boolean) {
            attrVal = (AttributeValue)AttributeValue.builder().bool((Boolean)value).build();
        } else if (value instanceof CFBoolean) {
            attrVal = (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(((CFBoolean)value).value)).build();
        } else if (value instanceof TemplateProxy) {
            String serializeTemplateProxy = CFDynamoDbAttributes.SERIALIZE_CFC ? JSONUtils.serializeJSON((Object)value, (Object)"struct", (boolean)false, (boolean)true, (boolean)true) : JSONUtils.serializeJSON((Object)value, (Object)"struct");
            attrVal = (AttributeValue)AttributeValue.builder().s(serializeTemplateProxy).build();
        } else if (value instanceof Map) {
            Map<String, AttributeValue> valsMap = CFDynamoDbUtils.getAttributeValueMap((Map)value);
            attrVal = (AttributeValue)AttributeValue.builder().m(valsMap).build();
        } else if (value instanceof byte[]) {
            attrVal = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])((byte[])value))).build();
        } else if (value instanceof List) {
            boolean stringSet = false;
            boolean numberSet = false;
            boolean binarySet = false;
            boolean isList = false;
            if (value != null && ((List)value).size() > 0) {
                Object firstElement = ((List)value).get(0);
                if (firstElement instanceof Integer || firstElement instanceof Number) {
                    for (Object obj : (List)value) {
                        if (obj instanceof Integer || obj instanceof Number) continue;
                        isList = true;
                        break;
                    }
                    numberSet = true;
                } else if (firstElement instanceof String) {
                    for (Object obj : (List)value) {
                        if (obj instanceof String) continue;
                        isList = true;
                        break;
                    }
                    stringSet = true;
                } else if (firstElement instanceof byte[]) {
                    for (Object obj : (List)value) {
                        if (obj instanceof byte[]) continue;
                        isList = true;
                        break;
                    }
                    binarySet = true;
                } else {
                    isList = true;
                }
                if (isList) {
                    ArrayList<AttributeValue> valsList = new ArrayList<AttributeValue>();
                    for (Object obj : (List)value) {
                        valsList.add(CFDynamoDbUtils.convertToAWSDataType(null, obj));
                    }
                    attrVal = (AttributeValue)AttributeValue.builder().l(valsList).build();
                } else if (stringSet) {
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Object obj : (List)value) {
                        stringList.add((String)obj);
                    }
                    attrVal = (AttributeValue)AttributeValue.builder().ss(stringList).build();
                } else if (numberSet) {
                    ArrayList<String> numberList = new ArrayList<String>();
                    for (Object obj : (List)value) {
                        numberList.add(String.valueOf(obj));
                    }
                    attrVal = (AttributeValue)AttributeValue.builder().ns(numberList).build();
                } else if (binarySet) {
                    ArrayList<SdkBytes> binaryList = new ArrayList<SdkBytes>();
                    for (Object binObj : (List)value) {
                        binaryList.add(SdkBytes.fromByteArray((byte[])((byte[])binObj)));
                    }
                    attrVal = (AttributeValue)AttributeValue.builder().bs(binaryList).build();
                }
            } else if (value != null && ((List)value).size() == 0) {
                ArrayList valsList = new ArrayList();
                attrVal = (AttributeValue)AttributeValue.builder().l(valsList).build();
            }
        } else if (value == null) {
            attrVal = (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        } else if (value.getClass().getName().equals("coldfusion.image.Image")) {
            attrVal = CFDynamoDbUtils.imageSerializer(value);
        } else if (value instanceof XmlNodeList) {
            String xmlDoc = value.toString();
            attrVal = (AttributeValue)AttributeValue.builder().s(xmlDoc).build();
        } else if (value.getClass().getName().equals("coldfusion.xml.rpc.QueryBean")) {
            String serializeQueryBean = JSONUtils.serializeJSON((Object)value, (Object)"struct");
            attrVal = (AttributeValue)AttributeValue.builder().s(serializeQueryBean).build();
        } else if (value.getClass().getName().equals("coldfusion.sql.imq.imqTable")) {
            String serializeimqTable = JSONUtils.serializeJSON((Object)value, (Object)"struct");
            attrVal = (AttributeValue)AttributeValue.builder().s(serializeimqTable).build();
        } else if (value.getClass().getName().equals("coldfusion.runtime.xml.DocumentQueryBeanAdapter")) {
            String serializeDocumentQueryBeanAdapter = JSONUtils.serializeJSON((Object)value, (Object)"struct");
            attrVal = (AttributeValue)AttributeValue.builder().s(serializeDocumentQueryBeanAdapter).build();
        } else if (value.getClass().getName().equals("coldfusion.xml.rpc.DocumentQueryBean")) {
            String serializeDocumentQueryBean = JSONUtils.serializeJSON((Object)value, (Object)"struct");
            attrVal = (AttributeValue)AttributeValue.builder().s(serializeDocumentQueryBean).build();
        } else if (value.getClass().getName().equals("coldfusion.pdf.PDFDocWrapper")) {
            byte[] binaryData = Cast.ToBinary((Object)value);
            attrVal = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])binaryData)).build();
        } else if (value.getClass().getName().equals("coldfusion.excel.ExcelInfo")) {
            byte[] binaryData = Cast.ToBinary((Object)value);
            attrVal = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])binaryData)).build();
        } else if (value instanceof QueryTable) {
            List records = (List)QueryUtils.handleReturnType((Object)value, (Object)"array");
            ArrayList<AttributeValue> valsList = new ArrayList<AttributeValue>();
            for (Map map : records) {
                valsList.add(CFDynamoDbUtils.convertToAWSDataType(null, map));
            }
            attrVal = (AttributeValue)AttributeValue.builder().l(valsList).build();
        } else {
            attrVal = value instanceof Key ? (AttributeValue)AttributeValue.builder().s(((Key)value).toString()).build() : (AttributeValue)AttributeValue.builder().s(String.valueOf(value)).build();
        }
        return attrVal;
    }

    public static AttributeValue imageSerializer(Object imageObject) {
        byte[] byteArr = Cast._Binary((Object)imageObject);
        String srcFormat = ServiceFactory.getImageService().getSrcFormat(imageObject);
        if (srcFormat == null) {
            srcFormat = "jpeg";
        }
        HashMap<String, Object> byteMap = new HashMap<String, Object>();
        byteMap.put("format", srcFormat);
        byteMap.put("type", "binary");
        byteMap.put("data", byteArr);
        Map<String, AttributeValue> valsMap = CFDynamoDbUtils.getAttributeValueMap(byteMap);
        AttributeValue attrVal = (AttributeValue)AttributeValue.builder().m(valsMap).build();
        return attrVal;
    }

    public static List<SdkBytes> getDynamoDbBinarySet(List value) {
        ArrayList<SdkBytes> convertedList = new ArrayList<SdkBytes>();
        boolean isBinarySet = false;
        for (Object binObj : value) {
            isBinarySet = true;
            convertedList.add(SdkBytes.fromByteArray((byte[])((byte[])binObj)));
        }
        return convertedList;
    }

    public static final Map<String, AttributeValue> getDynamoDbMap(Map<String, Object> value) {
        HashMap<String, AttributeValue> convMap = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String key = entry.getKey();
            Object keyVal = entry.getValue();
            if (!(keyVal instanceof Map)) continue;
            convMap.put(key, CFDynamoDbUtils.getValWithDataType(entry.getKey(), (Map)keyVal));
        }
        return convMap;
    }

    public static final List<String> getDynamoDbSet(List value) {
        ArrayList<String> numbSet = new ArrayList<String>();
        for (Object obj : value) {
            numbSet.add(String.valueOf(obj));
        }
        return numbSet;
    }

    public static Map<String, AttributeValue> getAttributeValueMapWithDataType(Map<String, Map> value) {
        HashMap<String, AttributeValue> itemMap = new HashMap<String, AttributeValue>();
        value.forEach((key, val) -> itemMap.put((String)key, CFDynamoDbUtils.getValWithDataType(key, val)));
        return itemMap;
    }

    private static AttributeValue getValWithDataType(String key, Map<String, Object> value) {
        HashMap itemMap = new HashMap();
        Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            return CFDynamoDbUtils.convertToAttributeValue(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public static final AttributeValue convertToAttributeValue(String key, Object value) {
        String keyUpper;
        AttributeValue attrVal = null;
        if (key == null) {
            throw new FieldValidationFailedException(RB.getString(CFDynamoDbUtils.class, (String)"util.convertToAttributeValueException"));
        }
        switch (keyUpper = key.toUpperCase()) {
            case "B": {
                try {
                    attrVal = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])((byte[])value))).build();
                }
                catch (ClassCastException c) {
                    attrVal = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])((String)value).getBytes())).build();
                }
                break;
            }
            case "BS": {
                ArrayList<SdkBytes> binaryList = new ArrayList<SdkBytes>();
                for (Object obj : (List)value) {
                    try {
                        obj = SdkBytes.fromByteArray((byte[])((byte[])obj));
                    }
                    catch (ClassCastException c) {
                        obj = SdkBytes.fromByteArray((byte[])((String)obj).getBytes());
                    }
                    binaryList.add((SdkBytes)obj);
                }
                attrVal = (AttributeValue)AttributeValue.builder().bs(binaryList).build();
                break;
            }
            case "BOOL": {
                attrVal = (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(Cast._boolean((Object)value))).build();
                break;
            }
            case "L": {
                ArrayList<AttributeValue> valsList = new ArrayList<AttributeValue>();
                for (Object obj : (List)value) {
                    if (((Map)obj).size() <= 0) continue;
                    Iterator iterator = ((Map)obj).entrySet().iterator();
                    Map.Entry pair = iterator.next();
                    valsList.add(CFDynamoDbUtils.convertToAttributeValue((String)pair.getKey(), pair.getValue()));
                }
                attrVal = (AttributeValue)AttributeValue.builder().l(valsList).build();
                break;
            }
            case "M": {
                attrVal = (AttributeValue)AttributeValue.builder().m(CFDynamoDbUtils.getDynamoDbMap((Map)value)).build();
                break;
            }
            case "N": {
                attrVal = (AttributeValue)AttributeValue.builder().n(String.valueOf(value)).build();
                break;
            }
            case "NS": {
                attrVal = (AttributeValue)AttributeValue.builder().ns(CFDynamoDbUtils.getDynamoDbSet((List)value)).build();
                break;
            }
            case "NULL": {
                attrVal = (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(Cast._boolean((Object)true))).build();
                break;
            }
            case "S": {
                attrVal = (AttributeValue)AttributeValue.builder().s(String.valueOf(value)).build();
                break;
            }
            case "SS": {
                attrVal = (AttributeValue)AttributeValue.builder().ss(CFDynamoDbUtils.getDynamoDbSet((List)value)).build();
                break;
            }
            default: {
                attrVal = (AttributeValue)AttributeValue.builder().s(String.valueOf(value)).build();
            }
        }
        return attrVal;
    }

    public static final ProvisionedThroughput getProvisionedThroughput(Map map) {
        ProvisionedThroughput.Builder builder = ProvisionedThroughput.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, map, CFDynamoProvisionedThroughputMetadata.getInstance().getConsumerMap());
        return (ProvisionedThroughput)builder.build();
    }

    public static final Projection getProjection(Map map) {
        Projection.Builder builder = Projection.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, map, CFDynamoProjectionMetadata.getInstance().getConsumerMap());
        return (Projection)builder.build();
    }

    public static final GlobalSecondaryIndex getGlobalSecondaryIndex(Map value) {
        GlobalSecondaryIndex.Builder builder = GlobalSecondaryIndex.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, value, CFDynamoGlobalSecondaryIndexesMetadata.getInstance().getConsumerMap());
        return (GlobalSecondaryIndex)builder.build();
    }

    public static final LocalSecondaryIndex getLocalSecondaryIndex(Map value) {
        LocalSecondaryIndex.Builder builder = LocalSecondaryIndex.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, value, CFDynamoLocalSecondaryIndexesMetadata.getInstance().getConsumerMap());
        return (LocalSecondaryIndex)builder.build();
    }

    public static final SSESpecification getSSESpecification(Map value) {
        SSESpecification.Builder builder = SSESpecification.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, value, CFDynamoSSESpecificationMetadata.getInstance().getConsumerMap());
        return (SSESpecification)builder.build();
    }

    public static final StreamSpecification getStreamSpecification(Map value) {
        StreamSpecification.Builder builder = StreamSpecification.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, value, CFDynamoStreamSpecificationMetadata.getInstance().getConsumerMap());
        return (StreamSpecification)builder.build();
    }

    public static final Tag getTag(Map value) {
        Tag.Builder builder = Tag.builder();
        ValidatorFiller.INSTANCE.fillObject(builder, value, CFDynamoTagsMetadata.getInstance().getConsumerMap());
        return (Tag)builder.build();
    }

    public static final List getKeySchemaElementList(List list) {
        ArrayList elementList = new ArrayList();
        list.forEach(o -> {
            KeySchemaElement.Builder builder = KeySchemaElement.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)o, CFDynamoKeySchemaListMetadata.getInstance().getConsumerMap());
            elementList.add(builder.build());
        });
        return elementList;
    }

    public static final List getAttributeDefList(Object value) {
        List list = Cast._List((Object)value);
        ArrayList attrDefList = new ArrayList();
        list.forEach(o -> {
            AttributeDefinition.Builder builder = AttributeDefinition.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)o, CFDynamoAttributeDefsMetadata.getInstance().getConsumerMap());
            attrDefList.add(builder.build());
        });
        return attrDefList;
    }

    public static Map getKeyList(Map<String, Object> value) {
        HashMap keys = new HashMap();
        value.forEach((key, val) -> {
            if (val instanceof Map) {
                keys.put(key, CFDynamoDbUtils.convertToAWSDataType(key, CFDynamoDbUtils.getKeyList((Map)val)));
            } else {
                keys.put(key, CFDynamoDbUtils.convertToAWSDataType(key, val));
            }
        });
        return keys;
    }

    private static Map<String, AttributeValue> getKeys(Map<String, Object> map) {
        HashMap<String, AttributeValue> keys = new HashMap<String, AttributeValue>();
        map.forEach((key, val) -> {
            if (val instanceof Map) {
                keys.put((String)key, CFDynamoDbUtils.convertToAWSDataType(key, CFDynamoDbUtils.getKeys((Map)val)));
            } else {
                keys.put((String)key, CFDynamoDbUtils.convertToAWSDataType(key, val));
            }
        });
        return keys;
    }

    public static List<Map<String, AttributeValue>> getKeysList(List<Map<String, Object>> list) {
        ArrayList<Map<String, AttributeValue>> resultList = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, Object> value : list) {
            resultList.add(CFDynamoDbUtils.getKeys(value));
        }
        return resultList;
    }

    public static List<Map<String, AttributeValue>> getKeysWithTypeList(List<Map> list) {
        ArrayList<Map<String, AttributeValue>> resultList = new ArrayList<Map<String, AttributeValue>>();
        for (Map value : list) {
            Map<Object, Object> keys = new HashMap();
            keys = CFDynamoDbUtils.getAttributeValueMapWithDataType(value);
            resultList.add(keys);
        }
        return resultList;
    }

    public static Map<String, KeysAndAttributes> getRequestItemsMap(Map map) {
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        map.forEach((key, val) -> {
            KeysAndAttributes.Builder builder = KeysAndAttributes.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)val, CFDynamoKeysAndAttributesMetadata.getInstance().getConsumerMap(), true, "");
            requestItems.put((String)key, (KeysAndAttributes)builder.build());
        });
        return requestItems;
    }

    public static Map<String, List<WriteRequest>> getBWRequestItemsMap(Map map) {
        HashMap<String, List<WriteRequest>> requestItems = new HashMap<String, List<WriteRequest>>();
        map.forEach((key, val) -> {
            ArrayList<Object> wReqsList = new ArrayList<Object>();
            for (Map reqMap : (List)val) {
                WriteRequest.Builder builder = WriteRequest.builder();
                ValidatorFiller.INSTANCE.fillObject(builder, reqMap, CFDynamoWriteRequestMetadata.getInstance().getConsumerMap(), true, "");
                wReqsList.add(builder.build());
            }
            requestItems.put((String)key, wReqsList);
        });
        return requestItems;
    }

    public static Map<String, List<WriteRequest>> getBWRequestItemsWithTypeMap(Map map) {
        HashMap<String, List<WriteRequest>> requestItems = new HashMap<String, List<WriteRequest>>();
        map.forEach((key, val) -> {
            ArrayList<Object> wReqsList = new ArrayList<Object>();
            for (Map reqMap : (List)val) {
                WriteRequest.Builder builder = WriteRequest.builder();
                ValidatorFiller.INSTANCE.fillObject(builder, reqMap, CFDynamoWriteWithTypeRequestMetadata.getInstance().getConsumerMap(), true, "");
                wReqsList.add(builder.build());
            }
            requestItems.put((String)key, wReqsList);
        });
        return requestItems;
    }

    public static Map<String, KeysAndAttributes> getRequestItemsWithTypeMap(Map map) {
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        map.forEach((key, val) -> {
            KeysAndAttributes.Builder builder = KeysAndAttributes.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)val, CFDynamoKeysAndAttributesWithTypeMetadata.getInstance().getConsumerMap(), true, "");
            requestItems.put((String)key, (KeysAndAttributes)builder.build());
        });
        return requestItems;
    }

    public static Map<String, AttributeValue> getExprAttrValuesMap(Map<String, Object> value) {
        HashMap<String, AttributeValue> itemMap = new HashMap<String, AttributeValue>();
        value.forEach((key, val) -> {
            if (val instanceof Map) {
                itemMap.put((String)key, CFDynamoDbUtils.convertToAWSDataType(key, CFDynamoDbUtils.getExprAttrValuesMap((Map)val)));
            } else {
                itemMap.put((String)key, CFDynamoDbUtils.convertToAWSDataType(key, val));
            }
        });
        return itemMap;
    }

    public static final List<Tag> getTagList(List sourceList) {
        ArrayList<Tag> resultList = new ArrayList<Tag>();
        sourceList.forEach(o -> resultList.add(CFDynamoDbUtils.getTag((Map)o)));
        return resultList;
    }

    public static Map<String, AttributeValue> getAttributeValueMap(Map<String, Object> value) {
        HashMap<String, AttributeValue> itemMap = new HashMap<String, AttributeValue>();
        value.forEach((key, val) -> itemMap.put((String)key, CFDynamoDbUtils.convertToAWSDataType(key, val)));
        return itemMap;
    }

    public static Map replacePercentToHashInMap(Map<String, Object> value) {
        HashMap resMap = new HashMap();
        value.forEach((key, val) -> {
            if (key.startsWith("%")) {
                key = key.replaceFirst("%", "#");
            }
            resMap.put(key, val);
        });
        return resMap;
    }

    public static String replacePercentToHashInStr(String value) {
        return value.replaceAll("%", "#");
    }

    public static List<GlobalTableGlobalSecondaryIndexSettingsUpdate> getGlobalTableGlobalSecondaryIndexSettingsUpdate(List sourceList) {
        ArrayList<GlobalTableGlobalSecondaryIndexSettingsUpdate> elementList = new ArrayList<GlobalTableGlobalSecondaryIndexSettingsUpdate>();
        sourceList.forEach(o -> {
            GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder builder = GlobalTableGlobalSecondaryIndexSettingsUpdate.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)o, CFDynamoGlobalTableGlobalSecondaryIndexSettingsUpdateMetadata.getInstance().getConsumerMap());
            elementList.add((GlobalTableGlobalSecondaryIndexSettingsUpdate)builder.build());
        });
        return elementList;
    }

    public static AutoScalingSettingsUpdate getAutoScalingSettingsUpdate(Map map) {
        AutoScalingSettingsUpdate.Builder update = AutoScalingSettingsUpdate.builder();
        ValidatorFiller.INSTANCE.fillObject(update, map, CFDynamoAutoScalingSettingsUpdateMetadata.getInstance().getConsumerMap());
        return (AutoScalingSettingsUpdate)update.build();
    }

    public static AutoScalingPolicyUpdate getAutoScalingPolicyUpdate(Map map) {
        AutoScalingPolicyUpdate.Builder update = AutoScalingPolicyUpdate.builder();
        ValidatorFiller.INSTANCE.fillObject(update, map, CFDynamoAutoScalingPolicyUpdateMetadata.getInstance().getConsumerMap());
        return (AutoScalingPolicyUpdate)update.build();
    }

    public static AutoScalingTargetTrackingScalingPolicyConfigurationUpdate getTargetTrackingScalingPolicyConfiguration(Map map) {
        AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder update = AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.builder();
        ValidatorFiller.INSTANCE.fillObject(update, map, CFDynamoAutoScalingTargetTrackingScalingPolicyConfigurationMetadata.getInstance().getConsumerMap());
        return (AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)update.build();
    }

    public static List<ReplicaSettingsUpdate> getReplicaSettingsUpdate(List sourceList) {
        ArrayList<ReplicaSettingsUpdate> elementList = new ArrayList<ReplicaSettingsUpdate>();
        sourceList.forEach(o -> {
            ReplicaSettingsUpdate.Builder builder = ReplicaSettingsUpdate.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)o, CFDynamoReplicaSettingsUpdateMetadata.getInstance().getConsumerMap());
            elementList.add((ReplicaSettingsUpdate)builder.build());
        });
        return elementList;
    }

    public static List<ReplicaGlobalSecondaryIndexSettingsUpdate> getReplicaGlobalSecondaryIndexSettings(List sourceList) {
        ArrayList<ReplicaGlobalSecondaryIndexSettingsUpdate> elementList = new ArrayList<ReplicaGlobalSecondaryIndexSettingsUpdate>();
        sourceList.forEach(o -> {
            ReplicaGlobalSecondaryIndexSettingsUpdate.Builder builder = ReplicaGlobalSecondaryIndexSettingsUpdate.builder();
            ValidatorFiller.INSTANCE.fillObject(builder, (Map)o, CFDynamoReplicaGlobalSecondaryIndexSettingsMetadata.getInstance().getConsumerMap());
            elementList.add((ReplicaGlobalSecondaryIndexSettingsUpdate)builder.build());
        });
        return elementList;
    }

    public static final boolean honourType(Map options) {
        if (options == null) {
            return false;
        }
        if (options != null && options.get(Key.getInstance((String)"hasType")) == null) {
            return false;
        }
        return Cast._boolean(options.get(Key.getInstance((String)"hasType")));
    }

    public static final Map handleOptionsForDefault(Map options) {
        if (options == null) {
            options = new Struct();
            options.put(Key.getInstance((String)"hasType"), false);
            options.put(Key.getInstance((String)"customResponse"), false);
            options.put(Key.getInstance((String)"binaryFormat"), false);
            options.put("caseSensitiveReturn", false);
            return options;
        }
        if (options.isEmpty()) {
            options.put(Key.getInstance((String)"hasType"), false);
            options.put(Key.getInstance((String)"customResponse"), false);
            options.put(Key.getInstance((String)"binaryFormat"), false);
            options.put("caseSensitiveReturn", false);
            return options;
        }
        if (options.get(Key.getInstance((String)"hasType")) == null) {
            options.put(Key.getInstance((String)"hasType"), false);
        }
        if (options.get(Key.getInstance((String)"customResponse")) == null) {
            options.put(Key.getInstance((String)"customResponse"), false);
        }
        if (options.get(Key.getInstance((String)"binaryFormat")) == null) {
            options.put(Key.getInstance((String)"binaryFormat"), false);
        }
        if (options.get(Key.getInstance((String)"caseSensitiveReturn")) == null) {
            options.put(Key.getInstance((String)"caseSensitiveReturn"), false);
        }
        return options;
    }

    public static void configureDynamoClientBuilder(DynamoDbClientBuilder dynamoClientBuilder, Struct serviceConfig) {
        CFDynamoDbServiceConfig config = (CFDynamoDbServiceConfig)CFDynamoDbUtils.getAWSserviceConfig((Struct)serviceConfig);
        if (config != null && config.getClientOverrideConfiguration() != null) {
            dynamoClientBuilder.overrideConfiguration(config.getClientOverrideConfiguration());
        }
    }

    public static void configureDynamoClientBuilder(DynamoDbClientBuilder dynamoClientBuilder, CFDynamoDbServiceConfig config) {
        if (config != null) {
            if (config.getHttpClientBuilder() != null) {
                dynamoClientBuilder.httpClientBuilder((SdkHttpClient.Builder)config.getHttpClientBuilder());
            } else {
                dynamoClientBuilder.httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder());
            }
            if (config.getClientOverrideConfiguration() != null) {
                dynamoClientBuilder.overrideConfiguration(config.getClientOverrideConfiguration());
            }
        }
    }

    public static AwsCredentialsProvider getAWSCredential(final AWSCredential awsCred) {
        return new AwsCredentialsProvider(){

            public AwsCredentials resolveCredentials() {
                return new AwsCredentials(){

                    public String secretAccessKey() {
                        return awsCred.secretAccessKey();
                    }

                    public String accessKeyId() {
                        return awsCred.accessKeyId();
                    }
                };
            }
        };
    }

    public static AwsCredentialsProvider getAWSCredential(Struct credential) {
        if (credential.containsKey((Object)"AWS")) {
            final Struct awsCred = (Struct)credential.get((Object)"AWS");
            return new AwsCredentialsProvider(){

                public AwsCredentials resolveCredentials() {
                    return new AwsCredentials(){

                        public String secretAccessKey() {
                            return (String)awsCred.get((Object)"secretAccessKey");
                        }

                        public String accessKeyId() {
                            return (String)awsCred.get((Object)"accessKeyId");
                        }
                    };
                }
            };
        }
        return null;
    }
}

