/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.config.metadata;

import coldfusion.cloud.aws.dynamodb.config.metadata.AWSEqualJitterStrategyMetadata;
import coldfusion.cloud.aws.dynamodb.config.metadata.AWSFullJitterStrategyMetadata;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.awscore.retry.conditions.RetryOnErrorCodeCondition;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import software.amazon.awssdk.core.retry.conditions.MaxNumberOfRetriesCondition;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnStatusCodeCondition;

public class AWSRetryPolicyMetadata {
    static AWSRetryPolicyMetadata instance = null;
    ConsumerMap<RetryPolicy.Builder> consumerMap = new ConsumerMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWSRetryPolicyMetadata getInstance() {
        if (instance != null) return instance;
        Class<AWSRetryPolicyMetadata> clazz = AWSRetryPolicyMetadata.class;
        synchronized (AWSRetryPolicyMetadata.class) {
            instance = new AWSRetryPolicyMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AWSRetryPolicyMetadata() {
        this.consumerMap.put((Object)"numRetries", new ConsumerValidator((filler, val) -> filler.numRetries(Integer.valueOf(FieldTypecastUtil.INSTANCE.getIntegerProperty(val))), null));
        this.consumerMap.put((Object)"retryCondition", new ConsumerValidator((filler, val) -> {
            Map conditionMap = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            filler.retryCondition(this.formRetryCondition(conditionMap));
        }, null));
        this.consumerMap.put((Object)"backoffStrategy", new ConsumerValidator((filler, val) -> {
            Map map = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            filler.backoffStrategy(this.formBackoffStrategy(map));
        }, null));
        this.consumerMap.put((Object)"throttlingBackoffStrategy", new ConsumerValidator((filler, val) -> {
            Map map = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            filler.throttlingBackoffStrategy(this.formBackoffStrategy(map));
        }, null));
    }

    private BackoffStrategy formBackoffStrategy(Map<String, Object> map) {
        String strategyType = FieldTypecastUtil.INSTANCE.getStringProperty(map.get("type"));
        if ((map = (Map)map.get("strategy")) != null) {
            switch (strategyType) {
                case "fixedDelay": {
                    Duration duration = FieldTypecastUtil.INSTANCE.getDurationProperty(map.get("fixedDelay"));
                    if (duration == null) break;
                    return FixedDelayBackoffStrategy.create((Duration)duration);
                }
                case "fullJitter": {
                    FullJitterBackoffStrategy.Builder fullJitterStrategyBuilder = FullJitterBackoffStrategy.builder();
                    ValidatorFiller.INSTANCE.fillObject((Object)fullJitterStrategyBuilder, map, AWSFullJitterStrategyMetadata.getInstance().getConsumerMap());
                    return fullJitterStrategyBuilder.build();
                }
                case "equalJitter": {
                    EqualJitterBackoffStrategy.Builder equalJitterStrategyBuilder = EqualJitterBackoffStrategy.builder();
                    ValidatorFiller.INSTANCE.fillObject((Object)equalJitterStrategyBuilder, map, AWSEqualJitterStrategyMetadata.getInstance().getConsumerMap());
                    return equalJitterStrategyBuilder.build();
                }
            }
        }
        return null;
    }

    private final RetryCondition formRetryCondition(Map<String, Object> conditionMap) {
        String conditionType;
        Object condition = null;
        List conditionObjects = null;
        switch (conditionType = FieldTypecastUtil.INSTANCE.getStringProperty(conditionMap.get("type"))) {
            case "and": {
                conditionObjects = FieldTypecastUtil.INSTANCE.getListProperty(conditionMap.get("conditions"));
                ArrayList retryConditions = new ArrayList();
                if (conditionObjects == null) break;
                conditionObjects.forEach(object -> retryConditions.add(this.formRetryCondition(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(object))));
                return AndRetryCondition.create((RetryCondition[])this.getRetryConditionArrayProperty(retryConditions));
            }
            case "or": {
                conditionObjects = FieldTypecastUtil.INSTANCE.getListProperty(conditionMap.get("conditions"));
                ArrayList retryConditions = new ArrayList();
                if (conditionObjects == null) break;
                conditionObjects.forEach(object -> retryConditions.add(this.formRetryCondition(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(object))));
                return OrRetryCondition.create((RetryCondition[])this.getRetryConditionArrayProperty(retryConditions));
            }
            case "onStatusCode": {
                return RetryOnStatusCodeCondition.create((Integer[])FieldTypecastUtil.INSTANCE.getIntegerArrayProperty(conditionMap.get("statusCodes")));
            }
            case "onException": {
                return RetryOnExceptionsCondition.create(this.getExceptionsSetProperty(conditionMap.get("exceptions")));
            }
            case "onErrorCode": {
                return RetryOnErrorCodeCondition.create((Set)FieldTypecastUtil.INSTANCE.getStringSetProperty(conditionMap.get("errorCodes")));
            }
            case "maxNumberOfRetries": {
                return MaxNumberOfRetriesCondition.create((int)FieldTypecastUtil.INSTANCE.getIntegerProperty(conditionMap.get("retryCount")));
            }
        }
        return null;
    }

    public RetryCondition[] getRetryConditionArrayProperty(List val) {
        try {
            List list = Cast._List((Object)val);
            RetryCondition[] temp = new RetryCondition[list.size()];
            return list.toArray(temp);
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException(RB.getString(AWSRetryPolicyMetadata.class, (String)"Metadata.RetryConditionArrayPropertyExp"), (Throwable)ex);
        }
    }

    public Set<Class<? extends Exception>> getExceptionsSetProperty(Object val) {
        HashSet<Class<? extends Exception>> exceptions = new HashSet<Class<? extends Exception>>();
        List exceptionStrings = Cast._List((Object)val);
        if (exceptionStrings != null) {
            exceptionStrings.forEach(string -> {
                try {
                    Class<?> ex = Class.forName(string);
                    exceptions.add(ex);
                }
                catch (Throwable th) {
                    throw new FieldValidationFailedException(RB.getString(AWSRetryPolicyMetadata.class, (String)"Metadata.RetryConditionArrayPropertyExp"), th);
                }
            });
        }
        return exceptions;
    }

    public ConsumerMap<RetryPolicy.Builder> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<RetryPolicy.Builder> consumerMap) {
        this.consumerMap = consumerMap;
    }
}

