/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus.metadata;

import coldfusion.cloud.azure.servicebus.metadata.SBAuthorizationRuleMetadata;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.DurationFormatValidator;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.cloud.validator.IntegerRangeValidator;
import com.microsoft.azure.servicebus.management.AccessRights;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.management.SharedAccessAuthorizationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SBQueueMetadata {
    static SBQueueMetadata instance = null;
    ConsumerMap<QueueDescription> consumerMap = new ConsumerMap();
    String[] allowedValues = new String[]{"Active", "Disabled", "SendDisabled", "ReceiveDisabled", "Unknown"};
    Set<String> allowedEntityStatusValues = new HashSet<String>(Arrays.asList(this.allowedValues));
    AccessRights[] dummyArray = new AccessRights[]{AccessRights.Listen};
    List<AccessRights> dummyAccessRights = Arrays.asList(this.dummyArray);
    private String DUMMY_NAME = "dummyName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SBQueueMetadata getInstance() {
        if (instance != null) return instance;
        Class<SBQueueMetadata> clazz = SBQueueMetadata.class;
        synchronized (SBQueueMetadata.class) {
            instance = new SBQueueMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SBQueueMetadata() {
        this.consumerMap.put((Object)"autoDeleteOnIdle", new ConsumerValidator((filler, val) -> filler.setAutoDeleteOnIdle(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"defaultMessageTimeToLive", new ConsumerValidator((filler, val) -> filler.setDefaultMessageTimeToLive(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"duplicationDetectionHistoryTimeWindow", new ConsumerValidator((filler, val) -> filler.setDuplicationDetectionHistoryTimeWindow(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableBatchedOperations", new ConsumerValidator((filler, val) -> filler.setEnableBatchedOperations(FieldTypecastUtil.INSTANCE.getBooleanProperty(val).booleanValue()), null));
        this.consumerMap.put((Object)"enableDeadLetteringOnMessageExpiration", new ConsumerValidator((filler, val) -> filler.setEnableDeadLetteringOnMessageExpiration(FieldTypecastUtil.INSTANCE.getBooleanProperty(val).booleanValue()), null));
        this.consumerMap.put((Object)"enablePartitioning", new ConsumerValidator((filler, val) -> filler.setEnablePartitioning(FieldTypecastUtil.INSTANCE.getBooleanProperty(val).booleanValue()), null));
        this.consumerMap.put((Object)"authorizationRules", new ConsumerValidator((filler, val) -> {
            List rules = FieldTypecastUtil.INSTANCE.getListProperty(val);
            ArrayList authorizationRules = new ArrayList();
            if (rules != null) {
                rules.forEach(rule -> {
                    SharedAccessAuthorizationRule authRule = new SharedAccessAuthorizationRule(this.DUMMY_NAME, this.dummyAccessRights);
                    ValidatorFiller.INSTANCE.fillObject((Object)authRule, rule, SBAuthorizationRuleMetadata.getInstance().getConsumerMap());
                    authorizationRules.add(authRule);
                });
            }
            filler.setAuthorizationRules(authorizationRules);
        }, null));
        this.consumerMap.put((Object)"forwardTo", new ConsumerValidator((filler, val) -> filler.setForwardTo(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"forwardDeadLetteredMessagesTo", new ConsumerValidator((filler, val) -> filler.setForwardDeadLetteredMessagesTo(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"lockDuration", new ConsumerValidator((filler, val) -> filler.setLockDuration(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"maxDeliveryCount", new ConsumerValidator((filler, val) -> filler.setMaxDeliveryCount(FieldTypecastUtil.INSTANCE.getIntegerProperty(val)), Arrays.asList(new IntegerRangeValidator("maxDeliveryCount", Integer.valueOf(1), null))));
        this.consumerMap.put((Object)"maxSizeInMB", new ConsumerValidator((filler, val) -> filler.setMaxSizeInMB((long)FieldTypecastUtil.INSTANCE.getIntegerProperty(val)), null));
        this.consumerMap.put((Object)"requiresDuplicateDetection", new ConsumerValidator((filler, val) -> filler.setRequiresDuplicateDetection(FieldTypecastUtil.INSTANCE.getBooleanProperty(val).booleanValue()), null));
        this.consumerMap.put((Object)"userMetadata", new ConsumerValidator((filler, val) -> filler.setUserMetadata(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"entityStatus", new ConsumerValidator((filler, val) -> {
            String status;
            switch (status = FieldTypecastUtil.INSTANCE.getStringProperty(val)) {
                case "Active": {
                    filler.setEntityStatus(EntityStatus.Active);
                    break;
                }
                case "Disabled": {
                    filler.setEntityStatus(EntityStatus.Disabled);
                    break;
                }
                case "SendDisabled": {
                    filler.setEntityStatus(EntityStatus.SendDisabled);
                    break;
                }
                case "ReceiveDisabled": {
                    filler.setEntityStatus(EntityStatus.ReceiveDisabled);
                    break;
                }
                case "Unknown": {
                    filler.setEntityStatus(EntityStatus.Unknown);
                    break;
                }
            }
        }, Arrays.asList(new EnumValidator(this.allowedEntityStatusValues, "entityStatus"))));
    }

    public ConsumerMap<QueueDescription> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<QueueDescription> consumerMap) {
        this.consumerMap = consumerMap;
    }
}

