/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.ftp;

import coldfusion.util.CFDumpable;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.HashMap;

public class ChannelSftpWrapper
extends ChannelSftp
implements CFDumpable {
    private final String fileNameEncoding;

    public ChannelSftpWrapper(String fileNameEncoding) {
        this.fileNameEncoding = fileNameEncoding;
    }

    public String getFileNameEncoding() {
        return this.fileNameEncoding;
    }

    public String getLabel() {
        return "SFTPConnection";
    }

    public Object getMetadata() {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        try {
            Session s = this.getSession();
            mp.put("RemoteAddress", s.getHost());
            mp.put("RemotePort", new Integer(s.getPort()));
            mp.put("User", s.getUserName());
            mp.put("DefaultTimeout", new Integer(s.getTimeout()));
            mp.put("Connected", this.isConnected());
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
        return mp;
    }

    protected void finalize() throws Throwable {
        if (this.isConnected()) {
            try {
                this.quit();
                this.disconnect();
                this.getSession().disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

