/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.BrowserFontProvider;
import coldfusion.document.JPedalFontRegistry;
import coldfusion.document.OpenOfficeUNOHelper;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.PDFService;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.InvalidPathException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.DocumentService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.util.FastHashtable;
import coldfusion.util.Utils;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class DocumentServiceImpl
extends ServiceBase
implements DocumentService {
    private static final String JETTY_READ_ERROR = "JETTY_READ_ERROR";
    private static final String JETYXML_PATHPART = File.separator + "jetty" + File.separator + "etc" + File.separator + "jetty.xml";
    private File config_file = null;
    private File wmimagefile = null;
    private ConfigMap fontConfigMap = null;
    private ConfigMap userFontConfigMap = null;
    private ConfigMap localOpenOfficeConfig = null;
    private ConfigMap remoteOpenOfficeConfig = null;
    private ConfigMap pdfgServiceManagersConfig = null;
    private static Properties awtfontmapper = new Properties();
    private static Properties awtfontmapperbak = new Properties();
    private static Properties jpedalProperties = new Properties();
    private static Set systemFontDirs = new HashSet();
    private static Set<String> userFontDirs = new HashSet<String>();
    private boolean initialized = false;
    protected static String oldSeed = "4259E88029503E9F";
    private String serverId;
    private String officeLocation = "";
    private String hostname = "";
    private String port = "";
    private int expiryTime = 300;
    private String seed;

    public DocumentServiceImpl(File config_file, File wmimagefile, String _rootdir) {
        this.config_file = config_file;
        this.wmimagefile = wmimagefile;
        File fontpropeties = null;
        try {
            if (awtfontmapper.isEmpty()) {
                fontpropeties = this.getFontPropertiesFile(_rootdir, true);
                FileInputStream fis = new FileInputStream(fontpropeties);
                awtfontmapper.load(fis);
                fis.close();
                String defaultbasefont = awtfontmapper.getProperty("defaultbasefont");
                if (defaultbasefont != null && defaultbasefont.length() > 0) {
                    System.setProperty("ice.pilots.html4.baseFontFamily", defaultbasefont);
                }
            }
        }
        catch (IOException fis) {
            // empty catch block
        }
        try {
            if (awtfontmapperbak.isEmpty()) {
                FileInputStream fisbak;
                File fontpropertiesbak;
                if (SystemInfo.isWindows()) {
                    fontpropertiesbak = this.getFontPropertiesFile();
                    fisbak = new FileInputStream(fontpropertiesbak);
                    awtfontmapperbak.load(fisbak);
                    fisbak.close();
                } else {
                    fontpropertiesbak = this.getFontPropertiesFile(_rootdir, false);
                    if (fontpropeties != null && !fontpropeties.getName().equalsIgnoreCase(fontpropertiesbak.getName())) {
                        fisbak = new FileInputStream(fontpropertiesbak);
                        awtfontmapperbak.load(fisbak);
                        fisbak.close();
                    }
                }
            }
        }
        catch (IOException fontpropertiesbak) {
            // empty catch block
        }
        try {
            if (jpedalProperties.isEmpty()) {
                String propertyfilepath = _rootdir + File.separator + "lib" + File.separator + "jpedal.properties";
                FileInputStream fis = new FileInputStream(propertyfilepath);
                jpedalProperties.load(fis);
                fis.close();
                String fontmaps = jpedalProperties.getProperty("fontmaps");
                if (fontmaps != null && fontmaps.length() > 0) {
                    System.setProperty("org.jpedal.fontmaps", fontmaps);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setEnableWatch(true);
        this.setWatchFile(config_file);
    }

    public void start() throws ServiceException {
        super.start();
        if (SystemInfo.isMac()) {
            JPedalFontRegistry.init();
        }
        new Thread(){

            @Override
            public void run() {
                DocumentServiceImpl.this.initializeDocumentService();
            }
        }.start();
    }

    public void stop() throws ServiceException {
        new Thread(){

            @Override
            public void run() {
                if (File.separatorChar == '\\' && !System.getProperty("os.arch").contains("64") && OpenOfficeUNOHelper.isOOAvailable()) {
                    OpenOfficeUNOHelper.shutdownOffice();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDocumentService() {
        try {
            try {
                if (!SystemInfo.isMac()) {
                    JPedalFontRegistry.init();
                }
                FontFactory.registerDirectories();
                JPedalFontRegistry.registerDirectories();
                String sCFFontDir = ServiceFactory.getRuntimeService().getRootDir() + File.separator + "lib" + File.separator + "fonts";
                if (System.getProperty("os.name").startsWith("Mac OS")) {
                    sCFFontDir = sCFFontDir.concat(File.separator + "_macos");
                }
                FontFactory.registerDirectory((String)sCFFontDir);
                JPedalFontRegistry.registerDirectory(sCFFontDir);
                this.TransferSettingToConfigMap();
                this.registerUserFonts();
                if (!Boolean.getBoolean("coldfusion.disableassemblerfonts")) {
                    this.callAssemblerInitFonts();
                }
            }
            catch (Throwable e) {
                CFLogs.SERVER_LOG.error(e);
            }
            this.userFontConfigMap.setConfigMapListener((ConfigMapListener)this);
            this.userFontConfigMap.setChanged();
            this.localOpenOfficeConfig.setConfigMapListener((ConfigMapListener)this);
            this.localOpenOfficeConfig.setUnchanged();
            this.remoteOpenOfficeConfig.setConfigMapListener((ConfigMapListener)this);
            this.remoteOpenOfficeConfig.setUnchanged();
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(e);
        }
        DocumentServiceImpl documentServiceImpl = this;
        synchronized (documentServiceImpl) {
            this.initialized = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("neo_font.keys", "");
            this.rb.put("neo_font.types", "");
            this.rb.put("neo_font.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("neo_user_font.keys", "");
            this.rb.put("neo_user_font.types", "");
            this.rb.put("neo_user_font.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
        }
        return this.rb;
    }

    public void load() throws ServiceException {
        this.fontConfigMap = new ConfigMap();
        this.fontConfigMap.init((Service)this, "neo_font");
        try {
            try {
                Object configObject = this.deserialize(this.config_file);
                if (configObject instanceof Vector) {
                    Vector configObject2 = (Vector)configObject;
                    this.userFontConfigMap = (ConfigMap)configObject2.get(0);
                    this.localOpenOfficeConfig = (ConfigMap)configObject2.get(1);
                    this.remoteOpenOfficeConfig = (ConfigMap)configObject2.get(2);
                    if (configObject2.size() > 3) {
                        this.pdfgServiceManagersConfig = (ConfigMap)configObject2.get(3);
                    }
                } else {
                    this.userFontConfigMap = (ConfigMap)configObject;
                }
                if (this.localOpenOfficeConfig != null) {
                    this.officeLocation = (String)this.localOpenOfficeConfig.get((Object)"path");
                    if (this.officeLocation == null) {
                        this.officeLocation = "";
                    }
                } else {
                    this.localOpenOfficeConfig = new ConfigMap();
                }
                if (this.remoteOpenOfficeConfig != null) {
                    this.hostname = (String)this.remoteOpenOfficeConfig.get((Object)"hostname");
                    this.port = (String)this.remoteOpenOfficeConfig.get((Object)"port");
                    if (this.hostname == null) {
                        this.hostname = "";
                        this.port = "";
                    }
                } else {
                    this.remoteOpenOfficeConfig = new ConfigMap();
                }
                if (this.pdfgServiceManagersConfig == null) {
                    this.pdfgServiceManagersConfig = new ConfigMap();
                }
            }
            catch (Exception ex) {
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "Recovering from a corrupt neo-document.xml file", (Throwable)ex);
                this.userFontConfigMap = new ConfigMap();
                this.remoteOpenOfficeConfig = new ConfigMap();
                this.localOpenOfficeConfig = new ConfigMap();
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "Recovered from a corrupt neo-document.xml file");
            }
            this.userFontConfigMap.init((Service)this, "neo_user_font");
            this.localOpenOfficeConfig.init((Service)this, "openoffice_local_config");
            this.remoteOpenOfficeConfig.init((Service)this, "openoffice_remote_config");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException((Throwable)ex);
        }
    }

    public String getOfficeLocation() {
        return this.officeLocation;
    }

    public String getOpenOfficeRemoteHost() {
        return this.hostname;
    }

    public String getOpenOfficeRemotePort() {
        return this.port;
    }

    public void store() throws ServiceException {
        super.store();
        Vector<ConfigMap> settings = new Vector<ConfigMap>();
        settings.add(0, this.userFontConfigMap);
        settings.add(1, this.localOpenOfficeConfig);
        settings.add(2, this.remoteOpenOfficeConfig);
        settings.add(3, this.pdfgServiceManagersConfig);
        this.serialize(settings, this.config_file);
    }

    public boolean registerFontFile(String fontFileName) {
        boolean registered = this._registerFontFile(fontFileName);
        JPedalFontRegistry.register(fontFileName);
        if (!Boolean.getBoolean("coldfusion.disableassemblerfonts")) {
            this.callAssemblerInitFonts();
        }
        return registered;
    }

    private boolean _registerFontFile(String fontFileName) {
        boolean register = true;
        if (this.isFontPathRegistered(fontFileName)) {
            if (this.userFontConfigMap.containsValue((Object)fontFileName)) {
                register = false;
            } else {
                this.userFontConfigMap.put((Object)fontFileName, (Object)fontFileName);
            }
        } else {
            FontFactory.register((String)fontFileName);
            JPedalFontRegistry.register(fontFileName);
            this.userFontConfigMap.put((Object)fontFileName, (Object)fontFileName);
        }
        if (register) {
            int index = fontFileName.indexOf(",");
            if (index > 0) {
                userFontDirs.add(fontFileName.substring(0, index));
            } else {
                userFontDirs.add(fontFileName);
            }
        }
        return register;
    }

    public void FontDiscovery() {
        FontFactory.registerDirectories();
        JPedalFontRegistry.registerDirectories();
    }

    public boolean registerFontDirectory(String dir) {
        boolean retval = false;
        int num = 0;
        try {
            File file = new File(dir);
            if (!file.exists() || !file.isDirectory()) {
                return retval;
            }
            String[] files = file.list();
            if (files == null) {
                return retval;
            }
            this.userFontConfigMap.setConfigMapListener(null);
            for (int k = 0; k < files.length; ++k) {
                try {
                    file = new File(dir, files[k]);
                    String name = file.getPath().toLowerCase();
                    if (!name.endsWith(".ttf") && !name.endsWith(".afm") && !name.endsWith(".ttc") || !this._registerFontFile(file.getPath())) continue;
                    ++num;
                    continue;
                }
                catch (RuntimeException re) {
                    CFLogs.SERVER_LOG.applog("information", "DocumentService", "", (Throwable)re);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.userFontConfigMap.setConfigMapListener((ConfigMapListener)this);
            this.userFontConfigMap.setChanged();
            userFontDirs.add(dir);
            JPedalFontRegistry.registerDirectory(dir);
            if (!Boolean.getBoolean("coldfusion.disableassemblerfonts")) {
                this.callAssemblerInitFonts();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (num > 0) {
            retval = true;
        }
        return retval;
    }

    public Map getAvailableFontFamiles() {
        this.waitForInitialization();
        return BrowserFontProvider.getAvailableFontFamilies();
    }

    private Object _getAssemblerFontSet() {
        final PDFService pdfService = ServiceFactory.getPDFService();
        if (pdfService != null) {
            if (System.getSecurityManager() == null) {
                return pdfService.getAssemblerFontSet();
            }
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return pdfService.getAssemblerFontSet();
                }
            });
        }
        return null;
    }

    public Object getAssemblerFontSet() {
        this.waitForInitialization();
        return this._getAssemblerFontSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialization() {
        if (this.initialized) {
            return;
        }
        DocumentServiceImpl documentServiceImpl = this;
        synchronized (documentServiceImpl) {
            if (this.initialized) {
                return;
            }
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Map TransferSettingToConfigMap() {
        this.fontConfigMap.clear();
        Map FontMap = FontFactory.getFontFaces();
        Map FontProp = FontFactory.getFontProperties();
        for (String fontFamilyName : FontMap.keySet()) {
            List list = (List)FontMap.get(fontFamilyName);
            Iterator is = list.iterator();
            FastHashtable FontFaceMap = new FastHashtable();
            while (is.hasNext()) {
                String psName;
                String fontface = (String)is.next();
                StringBuffer fontfaceBuffer = new StringBuffer();
                for (int i = 0; i < fontface.length(); ++i) {
                    char c = fontface.charAt(i);
                    if (c == '\uffff' || c == '\ufffe') continue;
                    fontfaceBuffer.append(c);
                }
                String fontFaceName = fontfaceBuffer.toString();
                FastHashtable FontFaceDetail = new FastHashtable();
                FontFaceMap.put(fontFaceName, FontFaceDetail);
                String fontPath = (String)FontProp.get(fontface.toLowerCase());
                if (fontPath.equalsIgnoreCase(fontface)) {
                    FontFaceDetail.put("fonttype", "adobe-built-in");
                } else {
                    String fontExtension = fontPath.substring(fontPath.lastIndexOf(46)).toLowerCase();
                    if (fontExtension.startsWith(".otf")) {
                        FontFaceDetail.put("fonttype", "opentype");
                    } else if (fontExtension.startsWith(".ttf")) {
                        FontFaceDetail.put("fonttype", "truetype");
                    } else if (fontExtension.startsWith(".ttc")) {
                        FontFaceDetail.put("fonttype", "truetype-collection");
                    } else if (fontExtension.startsWith(".afm")) {
                        FontFaceDetail.put("fonttype", "adobe-type-manager");
                    } else if (fontExtension.startsWith(".pfm")) {
                        FontFaceDetail.put("fonttype", "adobe-type-manager");
                    } else {
                        FontFaceDetail.put("fonttype", "unknown");
                    }
                    int index = fontPath.indexOf(",");
                    if (index > 0) {
                        systemFontDirs.add(fontPath.substring(0, index));
                    } else {
                        systemFontDirs.add(fontPath);
                    }
                }
                FontFaceDetail.put("location", fontPath);
                FontFaceDetail.put("description", fontFaceName);
                try {
                    Object[] allNames = BaseFont.getAllFontNames((String)fontPath, (String)"Cp1252", null);
                    psName = (String)allNames[0];
                }
                catch (Exception e) {
                    psName = "";
                }
                FontFaceDetail.put("psname", psName);
            }
            StringBuffer fontFamilyBuffer = new StringBuffer();
            for (int i = 0; i < fontFamilyName.length(); ++i) {
                char c = fontFamilyName.charAt(i);
                if (c == '\uffff' || c == '\ufffe') continue;
                fontFamilyBuffer.append(c);
            }
            fontFamilyName = fontFamilyBuffer.toString();
            this.fontConfigMap.put((Object)fontFamilyName, (Object)FontFaceMap);
        }
        return this.fontConfigMap;
    }

    public Map getAvailableFontsForPDF() {
        this.waitForInitialization();
        return FontFactory.getFontProperties();
    }

    public Map getAvailableFontsForJDK() {
        this.waitForInitialization();
        return FontFactory.getFontProperties();
    }

    public Map getConfigMap() {
        return this.fontConfigMap;
    }

    public Map getUserConfigMap() {
        return this.userFontConfigMap;
    }

    private void registerUserFonts() {
        Enumeration keysEnum = this.userFontConfigMap.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            String path = (String)this.userFontConfigMap.get(key);
            File file = new File(path);
            try {
                if (file.isDirectory()) {
                    FontFactory.registerDirectory((String)path);
                    JPedalFontRegistry.registerDirectory(path);
                    userFontDirs.add(path);
                    continue;
                }
                FontFactory.register((String)path);
                JPedalFontRegistry.register(path);
                int index = path.indexOf(",");
                if (index > 0) {
                    userFontDirs.add(path.substring(0, index));
                    continue;
                }
                userFontDirs.add(path);
            }
            catch (RuntimeException e) {
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "", (Throwable)e);
                this.userFontConfigMap.remove(key);
            }
        }
    }

    public boolean isFontPathRegisteredAsUserFont(String path) {
        this.waitForInitialization();
        boolean retval = false;
        try {
            File inputfile = new File(path);
            path = inputfile.getCanonicalPath();
            Enumeration fontenum = this.userFontConfigMap.elements();
            while (fontenum.hasMoreElements()) {
                String userPath = (String)fontenum.nextElement();
                File fileToCompare = new File(userPath);
                if (!fileToCompare.exists()) continue;
                try {
                    String canonPath = fileToCompare.getCanonicalPath();
                    if (!path.equals(canonPath)) continue;
                    retval = true;
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (IOException ioe) {
            throw new InvalidPathException("isFontPathRegisteredAsUserFont", path);
        }
        return retval;
    }

    public boolean isFontPathRegistered(String path) {
        boolean retval;
        block6: {
            this.waitForInitialization();
            retval = false;
            Map map = FontFactory.getFontProperties();
            for (Map.Entry entry : map.entrySet()) {
                String fontPath = (String)entry.getValue();
                int index = fontPath.indexOf(",");
                if (index > 0) {
                    fontPath = fontPath.substring(0, index);
                }
                if (!path.equalsIgnoreCase(fontPath)) continue;
                retval = true;
                break;
            }
            try {
                if (retval) break block6;
                File inputfile = new File(path);
                path = inputfile.getCanonicalPath();
                for (Map.Entry entry : map.entrySet()) {
                    File fileToCompare;
                    String fontPath = (String)entry.getValue();
                    int index = fontPath.indexOf(",");
                    if (index > 0) {
                        fontPath = fontPath.substring(0, index);
                    }
                    if (!(fileToCompare = new File(fontPath)).exists() || !path.equals(fileToCompare.getCanonicalPath())) continue;
                    retval = true;
                    break;
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter((Exception)e);
            }
        }
        return retval;
    }

    public Map getFontInfoFromFile(String path) {
        FastHashtable FontFamilyMap = new FastHashtable();
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                int i;
                Object[] allNames = BaseFont.getAllFontNames((String)path, (String)"Cp1252", null);
                String fullName = null;
                String familyName = null;
                String[][] names = (String[][])allNames[2];
                for (i = 0; i < names.length; ++i) {
                    if (!"0".equals(names[i][2])) continue;
                    fullName = names[i][3];
                    break;
                }
                if (!FontFactory.isFontNameLegal(fullName)) {
                    for (i = 0; i < names.length; ++i) {
                        if (!"1033".equals(names[i][2])) continue;
                        fullName = names[i][3];
                        break;
                    }
                }
                if (FontFactory.isFontNameLegal(fullName)) {
                    names = (String[][])allNames[1];
                    for (i = 0; i < names.length; ++i) {
                        if (!"0".equals(names[i][2])) continue;
                        familyName = names[i][3];
                        break;
                    }
                    if (!FontFactory.isFontNameLegal((String)familyName)) {
                        for (i = 0; i < names.length; ++i) {
                            if (!"1033".equals(names[i][2])) continue;
                            familyName = names[i][3];
                            break;
                        }
                    }
                    if (!FontFactory.isFontNameLegal((String)familyName)) {
                        familyName = "Information not available";
                    }
                } else {
                    fullName = "Information not available";
                    familyName = "Information not available";
                }
                FastHashtable fontFaceMap = new FastHashtable();
                FastHashtable fontDetailMap = new FastHashtable();
                fontDetailMap.put((Object)"description", (Object)fullName);
                fontDetailMap.put((Object)"fonttype", (Object)"TRUETYPE");
                fontDetailMap.put((Object)"location", (Object)path);
                fontDetailMap.put((Object)"psname", allNames[0]);
                fontFaceMap.put((Object)fullName, (Object)fontDetailMap);
                FontFamilyMap.put((Object)familyName, (Object)fontFaceMap);
            } else if (path.toLowerCase().endsWith(".ttc")) {
                String[] names = BaseFont.enumerateTTCNames((String)path);
                for (int i = 0; i < names.length; ++i) {
                    Map m = this.getFontInfoFromFile(path + "," + i);
                    FontFamilyMap.putAll(m);
                }
            } else if (path.toLowerCase().endsWith(".afm")) {
                BaseFont bf = BaseFont.createFont((String)path, (String)"Cp1252", (boolean)false);
                FastHashtable fontFaceMap = new FastHashtable();
                FastHashtable fontDetailMap = new FastHashtable();
                fontDetailMap.put((Object)"description", (Object)bf.getFullFontName()[0][3]);
                fontDetailMap.put((Object)"fonttype", (Object)"adobe-built-in");
                fontDetailMap.put((Object)"location", (Object)bf.getFullFontName()[0][3]);
                fontDetailMap.put((Object)"psname", (Object)bf.getPostscriptFontName());
                fontFaceMap.put((Object)bf.getFullFontName()[0][3], (Object)fontDetailMap);
                FontFamilyMap.put((Object)bf.getFamilyFontName(), (Object)fontFaceMap);
            }
        }
        catch (DocumentException de) {
            CFLogs.SERVER_LOG.applog("information", "DocumentService", "", (Throwable)de);
            throw new ExceptionConverter((Exception)((Object)de));
        }
        catch (IOException ioe) {
            CFLogs.SERVER_LOG.applog("information", "DocumentService", "", (Throwable)ioe);
        }
        return FontFamilyMap;
    }

    public void waitForFontInitialization() {
        this.waitForInitialization();
    }

    public boolean isCommonFont(String fontname) {
        return false;
    }

    public Properties getAwtFontMapper() {
        return awtfontmapper;
    }

    public Properties getAwtFontMapperBak() {
        return awtfontmapperbak;
    }

    public File getWmimagefile() {
        return this.wmimagefile;
    }

    public File getWmimageFileWithChecksum() {
        if (this.wmimagefile != null && this.wmimagefile.isFile()) {
            if (Utils.getFileCheckSum((File)this.wmimagefile) != 1800847989L) {
                return null;
            }
            return this.wmimagefile;
        }
        return null;
    }

    public Image getWmimage() {
        Image image;
        if (this.wmimagefile != null && this.wmimagefile.isFile()) {
            if (Utils.getFileCheckSum((File)this.wmimagefile) != 1800847989L) {
                return null;
            }
            try {
                image = Toolkit.getDefaultToolkit().createImage(this.wmimagefile.toURL());
            }
            catch (MalformedURLException e) {
                return null;
            }
        } else {
            return null;
        }
        return image;
    }

    private File getFontPropertiesFile(String _rootdir, boolean bUseLocale) {
        File fontproperties;
        String lang = Locale.getDefault().getLanguage();
        String propertyfilepath = _rootdir + File.separator + "lib" + File.separator + "cffont.properties";
        String filename = propertyfilepath + "." + lang;
        if (bUseLocale) {
            fontproperties = new File(filename);
            if (!fontproperties.exists()) {
                fontproperties = new File(propertyfilepath);
            }
        } else {
            fontproperties = new File(propertyfilepath);
        }
        return fontproperties;
    }

    private File getFontPropertiesFile() {
        String lang = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
        String OS = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String javahome = System.getProperty("java.home");
        String propertyfilepath = javahome + File.separator + "lib" + File.separator + "font.properties";
        File fontproperties = null;
        String[] pattern1 = new String[]{lang + "_" + country + "_" + defaultEncoding, lang + "_" + country, lang + "_" + defaultEncoding, lang, defaultEncoding, ""};
        String[] pattern2 = new String[]{OS + version, OS, version, ""};
        boolean bFound = false;
        for (int i = 0; i < pattern1.length; ++i) {
            if (!pattern1[i].equals("")) {
                for (int j = 0; j < pattern2.length; ++j) {
                    String filename;
                    if (!pattern2[j].equals("")) {
                        filename = propertyfilepath + "." + pattern1[i] + "." + pattern2[j];
                        fontproperties = new File(filename);
                        if (!fontproperties.exists()) continue;
                        bFound = true;
                        break;
                    }
                    filename = propertyfilepath + "." + pattern1[i];
                    fontproperties = new File(filename);
                    if (!fontproperties.exists()) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) continue;
                break;
            }
            fontproperties = new File(propertyfilepath);
            break;
        }
        return fontproperties;
    }

    public void setOfficeLocation(String path) {
        this.officeLocation = path;
        this.localOpenOfficeConfig.put((Object)"path", (Object)path);
    }

    public void setOpenOfficeRemoteConfig(String hostname, String port) {
        this.hostname = hostname;
        this.port = port;
        this.remoteOpenOfficeConfig.put((Object)"hostname", (Object)hostname);
        this.remoteOpenOfficeConfig.put((Object)"port", (Object)port);
    }

    public int getPresentationExpiryTime() {
        return this.expiryTime;
    }

    public void setPresentationExpiryTime(int expiryTime) {
        this.expiryTime = expiryTime;
    }

    public void mapModified(ConfigMap map, Object key, Object value) {
        super.mapModified(map, key, value);
        BrowserFontProvider.initializeFontFamilies();
    }

    public void mapModified(ConfigMap map, Object key) {
        super.mapModified(map, key);
        BrowserFontProvider.initializeFontFamilies();
    }

    public void mapModified() {
        super.mapModified();
        BrowserFontProvider.initializeFontFamilies();
    }

    private void callAssemblerInitFonts() {
        Iterator<String> iter = userFontDirs.iterator();
        while (iter.hasNext()) {
            String path = iter.next();
            if (new File(path).exists()) continue;
            iter.remove();
        }
        PDFService pdfService = ServiceFactory.getPDFService();
        if (pdfService != null) {
            pdfService.initFonts(new LinkedList<String>(userFontDirs), null, new LinkedList(systemFontDirs));
        }
    }

    public boolean isInstanceOfDocumentTag(Object obj) {
        return obj instanceof DocumentTag;
    }

    public boolean isInstanceOfDocumentService(Object obj) {
        return obj != null && obj instanceof DocumentService;
    }

    public static class ServiceManagerExistsException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String host = "";
    }

    public static class LicenseRestrictionServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidLocalServiceManagerAddressException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String hostname;

        public InvalidLocalServiceManagerAddressException(String hostname) {
            this.hostname = hostname;
        }
    }

    public static class NoSuchServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String name = "";

        public NoSuchServiceManagerException() {
        }

        public NoSuchServiceManagerException(String name) {
            this.name = name;
        }
    }

    public static class LocalServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String action = "remove";

        public LocalServiceManagerException() {
        }

        public LocalServiceManagerException(String action) {
            this.action = action;
        }
    }
}

