/*
 * Decompiled with CFR 0.152.
 */
package ice.net.pac;

import ice.debug.Debug;
import ice.net.ConnectionRoute;
import ice.net.Direct;
import ice.net.pac.ConnectionRouteNotFoundException;
import ice.net.pac.PacCallback;
import ice.net.pac.PacScripter;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyResolver;
import ice.net.socks.Socks;
import ice.util.Defs;
import ice.util.UnsupportedOperationException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.JavaScriptException;

public class PacManager
implements ProxyResolver {
    private static final long DEFAULT_RETRY_INTERVAL = 1200000L;
    private static long retryInterval = Defs.sysPropertyInt((String)"ice.net.pac.proxiesRetryInterval", (int)1200000);
    private static final String DIRECTIVE_DIRECT = "DIRECT";
    private static final String DIRECTIVE_PROXY = "PROXY";
    private static final String DIRECTIVE_SOCKS = "SOCKS";
    private ConnectionRoute direct = new Direct();
    private int ignoreCounter = 0;
    private PacCallback pacCallback;
    private PacScripter pacScripter;
    private boolean proxiesEnabled = true;
    private Hashtable connectionRouteCache = new Hashtable();
    private long timestamp;
    private Object scriptLock = new Object();

    public PacManager() {
    }

    public PacManager(URL pacLocation) throws IllegalArgumentException {
        try {
            this.setPacLocation(pacLocation);
        }
        catch (IOException exception) {
            Debug.trace((String)"Error loading implementation or PAC script");
        }
        catch (JavaScriptException exception) {
            Debug.trace((String)"JavaScript error in implementation or PAC script");
        }
    }

    public boolean areProxiesEnabled() {
        if (this.pacCallback != null && !this.proxiesEnabled && this.timestamp < System.currentTimeMillis() - (retryInterval + (long)this.ignoreCounter * retryInterval)) {
            if (this.pacCallback.retryProxies()) {
                this.setProxiesEnabled(true);
            } else {
                ++this.ignoreCounter;
            }
        }
        return this.proxiesEnabled;
    }

    public Proxy[] findProxy(String url) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRoute findProxyForUrl(URL url) throws ConnectionRouteNotFoundException, IllegalArgumentException {
        int i;
        Vector _connectionRouteList;
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.pacScripter == null || !this.areProxiesEnabled()) {
                this.direct.setRequestedUrl(url);
                return this.direct;
            }
            try {
                _connectionRouteList = this.parse(this.pacScripter.findProxyForUrl(url));
            }
            catch (JavaScriptException exception) {
                Debug.trace((String)"JavaScript error in implementation or PAC script");
                Debug.ex((Throwable)exception);
                this.direct.setRequestedUrl(url);
                return this.direct;
            }
        }
        int _size = _connectionRouteList.size();
        if (_size == 0) {
            throw new ConnectionRouteNotFoundException("no connection route could be found for: " + url);
        }
        boolean _foundDirect = false;
        for (i = 0; i < _size; ++i) {
            ConnectionRoute _connectionRoute = (ConnectionRoute)_connectionRouteList.elementAt(i);
            if (_connectionRoute instanceof Direct) {
                _foundDirect = true;
            }
            if (_connectionRoute.getStatus() == 3) continue;
            _connectionRoute.setRequestedUrl(url);
            return _connectionRoute;
        }
        if (!_foundDirect && this.pacCallback != null) {
            if (this.pacCallback.ignoreProxies()) {
                for (i = 0; i < _size; ++i) {
                    ((ConnectionRoute)_connectionRouteList.elementAt(i)).setStatus(1);
                }
                this.setProxiesEnabled(false);
                this.direct.setRequestedUrl(url);
                return this.direct;
            }
        } else {
            for (i = 0; i < _size; ++i) {
                ((ConnectionRoute)_connectionRouteList.elementAt(i)).setStatus(1);
            }
        }
        throw new ConnectionRouteNotFoundException("no connection route could be found for: " + url);
    }

    public PacCallback getPacCallback() {
        return this.pacCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getPacLocation() {
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.pacScripter != null) {
                return this.pacScripter.getPacLocation();
            }
            return null;
        }
    }

    public void setPacCallback(PacCallback pacCallback) {
        this.pacCallback = pacCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPacLocation(URL pacLocation) throws IllegalArgumentException, IOException, JavaScriptException {
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.pacScripter != null) {
                this.pacScripter = null;
            }
            this.pacScripter = new PacScripter(pacLocation);
            this.setProxiesEnabled(true);
        }
        Debug.trace((String)("Loaded PAC file from: " + pacLocation));
    }

    void setProxiesEnabled(boolean proxiesEnabled) {
        this.proxiesEnabled = proxiesEnabled;
        if (this.pacCallback != null && !this.proxiesEnabled) {
            this.timestamp = System.currentTimeMillis();
        }
    }

    private Vector parse(String pac) {
        Vector<ConnectionRoute> _connectionRouteList = new Vector<ConnectionRoute>();
        StringTokenizer _stringTokenizer = new StringTokenizer(pac, ";");
        int _count = _stringTokenizer.countTokens();
        for (int i = 0; i < _count; ++i) {
            ConnectionRoute _connectionRoute = this.parseDirective(_stringTokenizer.nextToken());
            if (_connectionRoute == null) continue;
            _connectionRouteList.addElement(_connectionRoute);
        }
        return _connectionRouteList;
    }

    private ConnectionRoute parseDirective(String directive) {
        ConnectionRoute _connectionRoute = null;
        StringTokenizer _stringTokenizer = new StringTokenizer(directive, " ");
        String _firstToken = _stringTokenizer.nextToken();
        if (_firstToken.equalsIgnoreCase(DIRECTIVE_DIRECT)) {
            _connectionRoute = this.direct;
        } else if (_firstToken.equalsIgnoreCase(DIRECTIVE_PROXY)) {
            if (_stringTokenizer.hasMoreTokens()) {
                _connectionRoute = this.parseProxy(_stringTokenizer.nextToken());
            }
        } else if (_firstToken.equalsIgnoreCase(DIRECTIVE_SOCKS) && _stringTokenizer.hasMoreTokens()) {
            _connectionRoute = this.parseSocks(_stringTokenizer.nextToken());
        }
        return _connectionRoute;
    }

    private Proxy parseProxy(String proxy) {
        Proxy _proxy = null;
        if (this.connectionRouteCache.containsKey(proxy)) {
            _proxy = (Proxy)this.connectionRouteCache.get(proxy);
        } else {
            int _index = proxy.indexOf(58);
            if (_index != -1) {
                try {
                    _proxy = new Proxy(proxy.substring(0, _index), Integer.parseInt(proxy.substring(_index + 1)));
                    this.connectionRouteCache.put(proxy, _proxy);
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
            }
        }
        return _proxy;
    }

    private Socks parseSocks(String socks) {
        Socks _socks = null;
        if (this.connectionRouteCache.containsKey(socks)) {
            _socks = (Socks)this.connectionRouteCache.get(socks);
        } else {
            int _index = socks.indexOf(58);
            if (_index != -1) {
                try {
                    _socks = new Socks(socks.substring(0, _index), Integer.parseInt(socks.substring(_index + 1)));
                    this.connectionRouteCache.put(socks, _socks);
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
            }
        }
        return _socks;
    }
}

