/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.ConnectionManager;
import ice.net.ConnectionManagerSettings;
import ice.net.HttpSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class NonBlockingConnectionManager
extends ConnectionManager {
    private int timeout;

    public NonBlockingConnectionManager(int timeout, ConnectionManagerSettings connectionManagerSettings) {
        super(connectionManagerSettings);
        this.timeout = timeout;
    }

    public NonBlockingConnectionManager(int timeout, HttpSession httpSession) {
        super(httpSession);
        this.timeout = timeout;
    }

    protected Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        SocketStore _socketStore = new SocketStore();
        CreateSocketThread _createSocketThread = new CreateSocketThread();
        _createSocketThread.setValues(_socketStore, inetAddress, port);
        _createSocketThread.start();
        try {
            Thread.currentThread();
            Thread.sleep(this.timeout);
        }
        catch (InterruptedException exception) {
            // empty catch block
        }
        if (!_socketStore.done) {
            throw new IOException("Socket creation timed out: " + inetAddress + port);
        }
        if (_socketStore.exception != null) {
            throw _socketStore.exception;
        }
        _socketStore.socket.setSoTimeout(this.getSoTimeout());
        _socketStore.socket.setTcpNoDelay(!this.isNagleEnabled());
        return _socketStore.socket;
    }

    private class SocketStore {
        public Socket socket;
        public boolean done = false;
        public IOException exception = null;

        private SocketStore() {
        }
    }

    private class CreateSocketThread
    extends Thread {
        private SocketStore socketStore = null;
        private InetAddress inetAddress = null;
        private int port = -1;

        private CreateSocketThread() {
        }

        public void setValues(SocketStore socketStore, InetAddress inetAddress, int port) {
            this.socketStore = socketStore;
            this.inetAddress = inetAddress;
            this.port = port;
        }

        public void run() {
            try {
                this.socketStore.socket = new Socket(this.inetAddress, this.port);
            }
            catch (IOException exception) {
                this.socketStore.exception = exception;
            }
            this.socketStore.done = true;
        }
    }
}

