/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.AuthenticationManager;
import ice.net.CacheManager;
import ice.net.ConnectionManager;
import ice.net.ConnectionManagerSettings;
import ice.net.CookieManager;
import ice.net.HttpURLConnection;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.Settings;
import ice.util.memory.MemoryManager;
import ice.util.net.HeaderMap;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class HttpURLConnectionSettings
implements Serializable,
Settings {
    private static final String HTTP_VERSION_DEFAULT = "HTTP/1.1";
    private static final String HTTP_VERSION_KEY = "ice.net.httpVersion";
    private static final boolean REDIRECTS_ENABLED_DEFAULT = true;
    private static final String REDIRECTS_ENABLED_KEY = "ice.net.redirectsEnabled";
    private static final boolean RETRY_BROKEN_CONNECTIONS_DEFAULT = true;
    private static final String RETRY_BROKEN_CONNECTIONS_KEY = "ice.net.retryBrokenConnections";
    private Vector acceptLanguageList;
    private AuthenticationManager authenticationManager;
    private CacheManager cacheManager;
    private ConnectionManager connectionManager;
    private CookieManager cookieManager;
    protected String httpVersion;
    private MemoryManager memoryManager;
    private ProxyResolver proxyResolver;
    private boolean redirectsEnabled;
    private HeaderMap requestHeaders = new HeaderMap();
    private boolean retryBrokenConnections;

    public HttpURLConnectionSettings() {
        this.initialize();
    }

    public static boolean areDefaultRedirectsEnabled() {
        return Defs.sysPropertyBoolean((String)REDIRECTS_ENABLED_KEY, (boolean)true);
    }

    public boolean areRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean equals(Object object) {
        return object instanceof HttpURLConnectionSettings && ((HttpURLConnectionSettings)object).acceptLanguageList.equals(this.acceptLanguageList) && ((HttpURLConnectionSettings)object).authenticationManager.equals(this.authenticationManager) && ((HttpURLConnectionSettings)object).cacheManager.equals(this.cacheManager) && ((HttpURLConnectionSettings)object).connectionManager.equals(this.connectionManager) && ((HttpURLConnectionSettings)object).cookieManager.equals(this.cookieManager) && ((HttpURLConnectionSettings)object).httpVersion.equals(this.httpVersion) && ((HttpURLConnectionSettings)object).memoryManager.equals(this.memoryManager) && ((HttpURLConnectionSettings)object).proxyResolver.equals(this.proxyResolver) && ((HttpURLConnectionSettings)object).redirectsEnabled == this.redirectsEnabled && ((HttpURLConnectionSettings)object).requestHeaders.equals((Object)this.requestHeaders) && ((HttpURLConnectionSettings)object).retryBrokenConnections == this.retryBrokenConnections;
    }

    public Vector getAcceptLanguageList() {
        return this.acceptLanguageList;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public static String getDefaultHttpVersion() {
        return Defs.sysProperty((String)HTTP_VERSION_KEY, (String)HTTP_VERSION_DEFAULT);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ProxyResolver getProxyResolver() {
        return this.proxyResolver;
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public void resetToDefault() {
        this.requestHeaders.clear();
        this.authenticationManager = null;
        this.cacheManager = null;
        this.cookieManager = null;
        this.memoryManager = null;
        this.proxyResolver = null;
        this.initialize();
    }

    public void setAcceptLanguageList(Vector acceptLanguageList) {
        if (this.acceptLanguageList == null && acceptLanguageList != null || this.acceptLanguageList != null && !this.acceptLanguageList.equals(acceptLanguageList)) {
            this.acceptLanguageList = acceptLanguageList;
            HttpURLConnection.updateAcceptLanguage(this.requestHeaders, this.acceptLanguageList);
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        if (connectionManager == null) {
            throw new IllegalArgumentException("connectionManager is null");
        }
        this.connectionManager = connectionManager;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public static void setDefaultHttpVersion(String httpVersion) throws IllegalArgumentException {
        HttpURLConnectionSettings.checkHttpVersion(httpVersion);
        Defs.setSystemProperty((String)HTTP_VERSION_KEY, (String)httpVersion);
    }

    public static void setDefaultRedirectsEnabled(boolean redirectsEnabled) throws SecurityException {
        HttpURLConnectionSettings.checkSet();
        Defs.setSystemProperty((String)REDIRECTS_ENABLED_KEY, (String)new Boolean(redirectsEnabled).toString());
    }

    public static void setDefaultRetryBrokenConnections(boolean retryBrokenConnections) {
        Defs.setSystemProperty((String)RETRY_BROKEN_CONNECTIONS_KEY, (String)new Boolean(retryBrokenConnections).toString());
    }

    public void setHttpVersion(String httpVersion) throws IllegalArgumentException {
        HttpURLConnectionSettings.checkHttpVersion(httpVersion);
        this.httpVersion = httpVersion;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public void setProxyResolver(ProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) throws SecurityException {
        HttpURLConnectionSettings.checkSet();
        this.redirectsEnabled = redirectsEnabled;
    }

    public void setRequestHeaders(HeaderMap requestHeaders) {
        if (requestHeaders != null) {
            this.requestHeaders = requestHeaders;
        }
    }

    public void setRetryBrokenConnections(boolean retryBrokenConnections) {
        this.retryBrokenConnections = retryBrokenConnections;
    }

    public static boolean shouldDefaultRetryBrokenConnections() {
        return Defs.sysPropertyBoolean((String)RETRY_BROKEN_CONNECTIONS_KEY, (boolean)true);
    }

    public boolean shouldRetryBrokenConnections() {
        return this.retryBrokenConnections;
    }

    public String toString() {
        return "HttpURLConnectionSettings [authenticationManager: " + this.authenticationManager + ", " + "cacheManager: " + this.cacheManager + ", " + "connectionManager: " + this.connectionManager + ", " + "cookieManager: " + this.cookieManager + ", " + "httpVersion: " + this.httpVersion + ", " + "memoryManager: " + this.memoryManager + ", " + "proxyResolver: " + this.proxyResolver + ", " + "redirectsEnabled: " + this.redirectsEnabled + ", " + "requestHeaders: " + this.requestHeaders + ", " + "retryBrokenConnections: " + this.retryBrokenConnections + "]";
    }

    protected static void checkHttpVersion(String httpVersion) throws IllegalArgumentException {
        if (httpVersion == null) {
            throw new IllegalArgumentException("httpVersion is null");
        }
        if (!httpVersion.equals("HTTP/1.0") && !httpVersion.equals(HTTP_VERSION_DEFAULT)) {
            throw new IllegalArgumentException("illegal httpVersion: " + httpVersion);
        }
    }

    private static void checkSet() throws SecurityException {
        SecurityManager _securityManager = System.getSecurityManager();
        if (_securityManager != null) {
            _securityManager.checkSetFactory();
        }
    }

    private void initialize() {
        this.requestHeaders.putHeader("Accept", "*/*");
        this.requestHeaders.putHeader("Accept-Encoding", "gzip");
        Vector<Locale> _acceptLanguageList = new Vector<Locale>();
        Locale _defaultLocale = Locale.getDefault();
        String _languageCode = _defaultLocale.getLanguage();
        String _countryCode = _defaultLocale.getCountry();
        if (_countryCode.length() > 0) {
            _acceptLanguageList.addElement(new Locale(_languageCode, _countryCode));
        }
        _acceptLanguageList.addElement(new Locale(_languageCode, ""));
        this.setAcceptLanguageList(_acceptLanguageList);
        this.connectionManager = new ConnectionManager(new ConnectionManagerSettings());
        this.httpVersion = HttpURLConnectionSettings.getDefaultHttpVersion();
        this.redirectsEnabled = HttpURLConnectionSettings.areDefaultRedirectsEnabled();
        this.retryBrokenConnections = HttpURLConnectionSettings.shouldDefaultRetryBrokenConnections();
    }
}

