/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.SimpleSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ClientSocket
implements SimpleSocket {
    private static final boolean USE_IP = true;
    private Socket socket;

    public ClientSocket(InetAddress inetAddress, int port) throws IOException, SecurityException {
        this.socket = new Socket(inetAddress, port);
    }

    public ClientSocket(InetAddress inetAddress, int port, boolean stream) throws IOException, SecurityException {
        this.socket = new Socket(inetAddress, port, stream);
    }

    public ClientSocket(InetAddress inetAddress, int port, InetAddress localInetAddress, int localPort) throws IOException, SecurityException {
        this.socket = new Socket(inetAddress, port, localInetAddress, localPort);
    }

    public ClientSocket(String host, int port) throws IOException, SecurityException, UnknownHostException {
        this.socket = new Socket(host, port);
    }

    public ClientSocket(String host, int port, boolean stream) throws IOException, SecurityException, UnknownHostException {
        this.socket = new Socket(host, port, stream);
    }

    public ClientSocket(String host, int port, InetAddress localInetAddress, int localPort) throws IOException, SecurityException, UnknownHostException {
        this.socket = new Socket(host, port, localInetAddress, localPort);
    }

    public ClientSocket(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        this.socket = socket;
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setReceiveBufferSize(int size) throws IllegalArgumentException, SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws IllegalArgumentException, SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws IllegalArgumentException, SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws IllegalArgumentException, SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public boolean useIp() {
        return true;
    }
}

