/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.ICEException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class ChunkDecoderInputStream {
    private int startindex;
    private int lastreadindex;
    private boolean error;
    private boolean chunkFinished = false;
    private boolean streamFinished = false;
    private byte[] buf = null;
    private InputStream in;
    private Object bufferSynch = new Object();
    private byte[] leftoverArray = null;
    private int leftoverLength = -1;
    private int leftoverOffset = -1;
    private boolean dumpChunkedDataToFile = Defs.sysPropertyBoolean((String)"ice.net.debug.dumpchunked", (boolean)false);
    int lastReadChunkNumber = -1;
    FileOutputStream fos = null;

    public ChunkDecoderInputStream(Vector refByteArray, int firstUnprocessed, int unprocessedLength, InputStream is) {
        this.buf = (byte[])refByteArray.elementAt(0);
        this.startindex = firstUnprocessed;
        this.lastreadindex = this.startindex + unprocessedLength;
        this.in = is;
        if (this.dumpChunkedDataToFile) {
            try {
                System.out.println("Trying to log to " + new String(this.toString()));
                this.fos = new FileOutputStream(new String(this.toString()));
                if (unprocessedLength != 0) {
                    this.fos.write(this.buf, firstUnprocessed, unprocessedLength);
                }
            }
            catch (Throwable t) {
                System.out.println("Error during logging: " + t);
                this.fos = null;
            }
        }
    }

    public int read() {
        System.out.println("CDIP: AIEE!");
        return -1;
    }

    public int read(byte[] buffer, int offset, int requestLength) throws ICEException {
        if (this.leftoverArray != null) {
            if (this.leftoverLength <= requestLength) {
                System.arraycopy(this.leftoverArray, this.leftoverOffset, buffer, offset, this.leftoverLength);
                int tmp = this.leftoverLength;
                this.leftoverArray = null;
                this.leftoverOffset = -1;
                this.leftoverLength = -1;
                return tmp;
            }
            System.arraycopy(this.leftoverArray, this.leftoverOffset, buffer, offset, requestLength);
            this.leftoverOffset += requestLength;
            this.leftoverLength -= requestLength;
            return requestLength;
        }
        byte[] tmp = this.getChunk();
        if (tmp == null) {
            return -1;
        }
        this.lastReadChunkNumber = tmp.length;
        if (tmp.length <= requestLength) {
            System.arraycopy(tmp, 0, buffer, offset, tmp.length);
            return tmp.length;
        }
        System.arraycopy(tmp, 0, buffer, offset, requestLength);
        this.leftoverArray = tmp;
        this.leftoverOffset = requestLength;
        this.leftoverLength = tmp.length - requestLength;
        return requestLength;
    }

    private byte[] getChunk() throws ICEException {
        if (this.streamFinished) {
            return null;
        }
        this.error = false;
        this.chunkFinished = false;
        int[] results = new int[2];
        while (!this.chunkFinished && !this.error) {
            int byteCount;
            int val = this.detectChunk(this.startindex, this.lastreadindex, results);
            if (this.streamFinished) {
                return null;
            }
            if (val > 0 || val >= 0 && this.chunkFinished) {
                byte[] ret = new byte[results[1] - results[0]];
                System.arraycopy(this.buf, results[0], ret, 0, results[1] - results[0]);
                this.startindex = results[1];
                int resultFromRead = 0;
                if (this.lastreadindex - this.startindex >= 100 || (resultFromRead = this.readMore(16000, false)) <= 0) {
                    // empty if block
                }
                this.startindex += 2;
                return ret;
            }
            if (val == 0 && !this.error && !this.chunkFinished) {
                if (this.startindex != this.lastreadindex) {
                    if (this.startindex - 2 == this.lastreadindex) {
                        int b = 0;
                        try {
                            b = this.in.read(this.buf, 0, this.buf.length);
                            if (this.dumpChunkedDataToFile && b != -1) {
                                try {
                                    this.fos.write(this.buf, 0, b);
                                }
                                catch (Throwable t) {}
                            }
                        }
                        catch (IOException ie) {
                            return null;
                        }
                        if (b == -1) {
                            return null;
                        }
                        this.lastreadindex = b;
                        this.startindex = 2;
                    } else {
                        try {
                            this.increaseBuffer();
                        }
                        catch (ArrayIndexOutOfBoundsException AIOB) {
                            Debug.trace((String)"Warning! Chunk error found!(A)");
                            Debug.trace((String)("\tCE: startindex is " + this.startindex + " lastreadindex is " + this.lastreadindex));
                            Debug.trace((String)("\tCE: val is " + val + " last parsed chunksize is " + this.lastReadChunkNumber));
                        }
                        int bt = this.readMore(500);
                        if (bt == -1) {
                            return null;
                        }
                    }
                } else {
                    this.buf = new byte[4096];
                    byteCount = -1;
                    try {
                        this.lastreadindex = byteCount = this.in.read(this.buf, 0, 4096);
                        this.startindex = 0;
                        if (byteCount != -1 && this.dumpChunkedDataToFile) {
                            try {
                                this.fos.write(this.buf, 0, byteCount);
                            }
                            catch (Throwable t) {}
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (byteCount == -1) {
                        return null;
                    }
                }
            }
            if (val >= 0) continue;
            if (this.lastreadindex - val > this.buf.length) {
                try {
                    this.increaseBuffer();
                }
                catch (ArrayIndexOutOfBoundsException AIOB) {
                    Debug.trace((String)"Warning! Chunk error found!(A)");
                    Debug.trace((String)("\tCE: startindex is " + this.startindex + " lastreadindex is " + this.lastreadindex));
                    Debug.trace((String)("\tCE: val is " + val + " last parsed chunksize is " + this.lastReadChunkNumber));
                }
            }
            if ((byteCount = this.readMore(-val)) != -1) continue;
            return null;
        }
        return null;
    }

    private synchronized int detectChunk(int startIndex, int endindex, int[] chstend) {
        int i = startIndex;
        boolean found = false;
        if (startIndex == endindex - 1) {
            return 0;
        }
        if (endindex > this.buf.length) {
            this.error = true;
            return 0;
        }
        while (!found && i < this.buf.length - 1 && i < endindex - 1) {
            if (this.buf[i] == 13 && this.buf[i + 1] == 10) {
                found = true;
                continue;
            }
            ++i;
        }
        if (!found) {
            if (endindex - startIndex >= 8) {
                this.error = true;
            }
            return 0;
        }
        int bytesInNumber = i + 2 - startIndex;
        chstend[0] = i + 2;
        String theNumber = new String(this.buf, startIndex, i - startIndex);
        theNumber = theNumber.trim();
        int t = 0;
        try {
            t = Integer.valueOf(theNumber, 16);
        }
        catch (Exception e) {
            Debug.trace((String)e.toString());
        }
        if (t == 0) {
            this.streamFinished = true;
        }
        chstend[1] = i + 2 + t;
        int retur = (t - (endindex - (startIndex + bytesInNumber))) * -1;
        if (retur == 0) {
            this.chunkFinished = true;
        }
        if (t + i > this.startindex - endindex) {
            return retur;
        }
        return startIndex + t + bytesInNumber;
    }

    private void increaseBuffer() {
        byte[] tmp = new byte[this.buf.length * 2];
        System.arraycopy(this.buf, this.startindex, tmp, 0, this.lastreadindex - this.startindex);
        this.buf = tmp;
        this.lastreadindex -= this.startindex;
        this.startindex = 0;
    }

    private int readMore(int howMany) throws ICEException {
        return this.readMore(howMany, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMore(int howMany, boolean blocking) throws ICEException {
        int byteCount = -1;
        Object object = this.bufferSynch;
        synchronized (object) {
            while (howMany > this.buf.length - this.lastreadindex) {
                this.increaseBuffer();
            }
            try {
                if (!blocking) {
                    if (this.in.available() == 0) {
                        return -2;
                    }
                    if (howMany > this.in.available()) {
                        howMany = this.in.available();
                    }
                    if ((byteCount = this.in.read(this.buf, this.lastreadindex, howMany)) != -1) {
                        this.lastreadindex += byteCount;
                        if (this.dumpChunkedDataToFile) {
                            try {
                                this.fos.write(this.buf, this.lastreadindex, byteCount);
                            }
                            catch (Throwable t) {}
                        }
                    }
                } else {
                    byteCount = this.in.read(this.buf, this.lastreadindex, howMany);
                    if (byteCount != -1) {
                        this.lastreadindex += byteCount;
                        if (this.dumpChunkedDataToFile) {
                            try {
                                this.fos.write(this.buf, this.lastreadindex, byteCount);
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byteCount;
    }
}

