/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.authentication.DefaultAuthenticationManager;
import ice.authentication.basic.BasicAuthentication;
import ice.authentication.digest.DigestAuthentication;
import ice.net.Authentication;
import ice.net.AuthenticationEvent;
import ice.net.AuthenticationListener;
import ice.net.MyDigest;
import ice.util.net.HeaderMap;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AuthenticationManager
implements ice.authentication.AuthenticationListener {
    private ice.authentication.AuthenticationManager authenticationManager;
    private static boolean digestEnabled;
    private Vector authenticationListenerList = new Vector();
    private Hashtable realmToAuthenticationMap = new Hashtable();
    private Hashtable rootPathToRealmMap = new Hashtable();

    public AuthenticationManager() {
        this.authenticationManager = new DefaultAuthenticationManager();
    }

    public void acknowledgeAuthentication(Authentication authentication) {
        if (authentication == null) {
            return;
        }
        if (authentication.getType().equals("NTLM")) {
            this.authenticationManager.addAuthentication((ice.authentication.Authentication)((Object)authentication));
        } else {
            String _realm = authentication.getRealm();
            if (_realm != null) {
                URL _url;
                if (!authentication.isProxyAuth() && (_url = authentication.getUrl()) != null) {
                    this.rootPathToRealmMap.put(AuthenticationManager.getRootPath(_url), _realm);
                }
                this.realmToAuthenticationMap.put(_realm, authentication);
            }
        }
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        if (listener != null) {
            if (this.authenticationListenerList.size() == 0) {
                this.authenticationManager.addAuthenticationListener(this);
            }
            this.authenticationListenerList.addElement(listener);
        }
    }

    public synchronized Authentication applyAuthentication(URL url) {
        String _url = url.toString();
        Enumeration _keys = this.rootPathToRealmMap.keys();
        while (_keys.hasMoreElements()) {
            String _realm;
            String _key = (String)_keys.nextElement();
            if (!_url.startsWith(_key) || (_realm = (String)this.rootPathToRealmMap.get(_key)) == null) continue;
            return (Authentication)this.realmToAuthenticationMap.get(_realm);
        }
        return null;
    }

    public synchronized Authentication applyAuthentication(URL url, URLConnection urlConnection) {
        return this.applyAuthentication(url);
    }

    public Enumeration elements() {
        Authentication[] _authentications = this.getAllAuthentications();
        Vector<Authentication> _authenticationList = new Vector<Authentication>(_authentications.length);
        for (int i = 0; i < _authentications.length; ++i) {
            _authenticationList.addElement(_authentications[i]);
        }
        return _authenticationList.elements();
    }

    public synchronized Authentication extractAuthentication(URL url, URLConnection urlConnection) {
        return this.extractAuthentication(url, urlConnection, (HeaderMap.Header)null);
    }

    public synchronized Authentication extractAuthentication(URL url, URLConnection urlConnection, String authenticateFieldValue) {
        if (authenticateFieldValue == null) {
            return this.extractAuthentication(url, urlConnection, (HeaderMap.Header[])null);
        }
        return this.extractAuthentication(url, urlConnection, new HeaderMap.Header[]{new HeaderMap.Header("WWW-Authenticate", authenticateFieldValue)});
    }

    public synchronized Authentication extractAuthentication(URL url, URLConnection urlConnection, HeaderMap.Header authenticateHeader) {
        if (authenticateHeader == null) {
            return this.extractAuthentication(url, urlConnection, (HeaderMap.Header[])null);
        }
        return this.extractAuthentication(url, urlConnection, new HeaderMap.Header[]{authenticateHeader});
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Authentication extractAuthentication(URL url, URLConnection urlConnection, HeaderMap.Header[] authenticateHeaders) {
        void var7_7;
        Object[] _authenticateHeaders;
        Authentication _authentication = null;
        Vector<HeaderMap.Header> _authenticateHeaderList = new Vector<HeaderMap.Header>();
        int _index = 0;
        if (urlConnection != null) {
            String _fieldName;
            while ((_fieldName = urlConnection.getHeaderFieldKey(_index)) != null) {
                if (_fieldName.equalsIgnoreCase("WWW-Authenticate") || _fieldName.equalsIgnoreCase("Proxy-Authenticate")) {
                    _authenticateHeaderList.addElement(new HeaderMap.Header(_fieldName, urlConnection.getHeaderField(_index)));
                }
                ++_index;
            }
        }
        if (_authenticateHeaderList.size() != 0) {
            _authenticateHeaders = new HeaderMap.Header[_authenticateHeaderList.size()];
            _authenticateHeaderList.copyInto(_authenticateHeaders);
        } else if (authenticateHeaders != null && authenticateHeaders.length != 0) {
            _authenticateHeaders = authenticateHeaders;
        } else {
            return null;
        }
        String _userName = null;
        String _password = null;
        String _userInfo = url.getUserInfo();
        if (_userInfo != null) {
            _index = _userInfo.indexOf(":");
            if (_index != -1) {
                _userName = _userInfo.substring(0, _index);
                _password = _userInfo.substring(_index + 1);
            } else {
                _userName = _userInfo;
            }
        }
        for (int i = 0; i < ((void)var7_7).length; ++i) {
            String _challenge = var7_7[i].getFieldValue().toLowerCase();
            if (_challenge.startsWith("basic")) {
                String _realm = this.findRealm(url);
                if (_realm != null) {
                    _authentication = (Authentication)this.realmToAuthenticationMap.get(_realm);
                    break;
                }
                _realm = this.extractRealm(_challenge);
                _authentication = (Authentication)this.realmToAuthenticationMap.get(_realm);
                if (_authentication != null) break;
                _authentication = new BasicAuthentication(_realm, url);
                _authentication.setIsProxyAuth(var7_7[i].getFieldName().equalsIgnoreCase("Proxy-Authenticate"));
                if (_userName == null) {
                    this.fireAuthenticationEvent(_authentication);
                } else {
                    _authentication.setUserName(_userName);
                    _authentication.setPassword(_password);
                }
                if (!_authentication.isProxyAuth()) {
                    this.rootPathToRealmMap.put(AuthenticationManager.getRootPath(url), _realm);
                }
                this.realmToAuthenticationMap.put(_realm, _authentication);
                break;
            }
            if (_challenge.startsWith("digest")) {
                String _realm = this.findRealm(url);
                if (_realm != null) {
                    _authentication = (Authentication)this.realmToAuthenticationMap.get(_realm);
                    break;
                }
                _realm = this.extractRealm(_challenge);
                _authentication = (Authentication)this.realmToAuthenticationMap.get(_realm);
                if (_authentication != null) break;
                _authentication = new DigestAuthentication(_realm, url);
                _authentication.setIsProxyAuth(var7_7[i].getFieldName().equalsIgnoreCase("Proxy-Authenticate"));
                _authentication.setDigestEnabled(digestEnabled);
                _authentication.setNonce(this.extractNonce(_challenge));
                if (urlConnection != null) {
                    _authentication.setMethod(((HttpURLConnection)urlConnection).getRequestMethod());
                }
                if (digestEnabled) {
                    if (_userName == null) {
                        this.fireAuthenticationEvent(_authentication);
                    } else {
                        _authentication.setUserName(_userName);
                        _authentication.setPassword(_password);
                    }
                } else {
                    _authentication.setGiveUp(true);
                }
                if (!_authentication.isProxyAuth()) {
                    this.rootPathToRealmMap.put(AuthenticationManager.getRootPath(url), _realm);
                }
                this.realmToAuthenticationMap.put(_realm, _authentication);
                break;
            }
            if ((_challenge.startsWith("ntlm") || _challenge.startsWith("negotiate")) && (_authentication = (Authentication)((Object)this.authenticationManager.handleChallenge(var7_7[i].getFieldValue(), url, var7_7[i].getFieldName().equalsIgnoreCase("Proxy-Authenticate")))) != null) break;
        }
        return _authentication;
    }

    public Authentication[] getAllAuthentications() {
        ice.authentication.Authentication[] _abstractAuthentications = this.authenticationManager.getAllAuthentications();
        Authentication[] _ntlmAuthentications = new Authentication[_abstractAuthentications.length];
        for (int i = 0; i < _ntlmAuthentications.length; ++i) {
            _ntlmAuthentications[i] = (Authentication)((Object)_abstractAuthentications[i]);
        }
        Authentication[] _authentications = new Authentication[_ntlmAuthentications.length + this.realmToAuthenticationMap.size()];
        Enumeration _elements = this.realmToAuthenticationMap.elements();
        int _index = 0;
        while (_elements.hasMoreElements()) {
            _authentications[_index++] = (Authentication)_elements.nextElement();
        }
        for (int i = 0; i < _ntlmAuthentications.length; ++i) {
            _authentications[_index++] = _ntlmAuthentications[i];
        }
        return _authentications;
    }

    public Authentication getAuthentication(String realm) {
        return (Authentication)this.realmToAuthenticationMap.get(realm);
    }

    public void onAuthenticationEvent(ice.authentication.AuthenticationEvent event) {
        this.fireAuthenticationEvent((Authentication)((Object)event.getAuthentication()));
    }

    public synchronized void readAuthentications(ObjectInput objectInput) {
        try {
            this.rootPathToRealmMap = (Hashtable)objectInput.readObject();
            this.realmToAuthenticationMap = (Hashtable)objectInput.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllAuthenticationListeners() {
        this.authenticationListenerList.removeAllElements();
        this.authenticationManager.removeAuthenticationListener(this);
    }

    public void removeAllAuthentications() {
        this.authenticationManager.clearAuthentications();
        this.rootPathToRealmMap.clear();
        this.realmToAuthenticationMap.clear();
    }

    public synchronized void removeAuthentication(Authentication authentication) {
        if (authentication == null) {
            return;
        }
        if (authentication.getType().equals("NTLM")) {
            this.authenticationManager.removeAuthentication((ice.authentication.Authentication)((Object)authentication));
        } else {
            String _url;
            String _realm = authentication.getRealm();
            if (_realm != null && this.realmToAuthenticationMap.containsKey(_realm)) {
                this.realmToAuthenticationMap.remove(_realm);
            }
            if ((_url = AuthenticationManager.getRootPath(authentication.getUrl())) != null && this.rootPathToRealmMap.containsKey(_url)) {
                this.rootPathToRealmMap.remove(_url);
            }
        }
    }

    public void removeAuthentication(String realm) {
        this.realmToAuthenticationMap.remove(realm);
    }

    public void removeAuthenticationListener(AuthenticationListener listener) {
        if (listener != null) {
            this.authenticationListenerList.removeElement(listener);
            if (this.authenticationListenerList.size() == 0) {
                this.authenticationManager.removeAuthenticationListener(this);
            }
        }
    }

    public void removeBadAuthentication(Authentication authentication) {
        if (authentication == null || authentication.giveUp()) {
            return;
        }
        if (authentication.getType().equals("NTLM")) {
            this.authenticationManager.removeAuthentication((ice.authentication.Authentication)((Object)authentication));
        } else {
            String _rootPath;
            URL _url;
            String _realm = authentication.getRealm();
            if (_realm != null && this.realmToAuthenticationMap.containsKey(_realm)) {
                this.realmToAuthenticationMap.remove(authentication.getRealm());
            }
            if ((_url = authentication.getUrl()) != null && this.rootPathToRealmMap.containsKey(_rootPath = AuthenticationManager.getRootPath(_url))) {
                this.rootPathToRealmMap.remove(_rootPath);
            }
        }
    }

    public void setAuthentication(Authentication authentication) {
        if (authentication == null) {
            return;
        }
        if (authentication.getType().equals("NTLM")) {
            this.authenticationManager.addAuthentication((ice.authentication.Authentication)((Object)authentication));
        } else if (authentication.getLocation() != null && authentication.getRealm() != null) {
            if (!authentication.isProxyAuth()) {
                this.rootPathToRealmMap.put(AuthenticationManager.getRootPath(authentication.getUrl()), authentication.getRealm());
            }
            this.realmToAuthenticationMap.put(authentication.getRealm(), authentication);
        }
    }

    public synchronized void writeAuthentications(ObjectOutput objectOutput) {
        try {
            objectOutput.writeObject(this.rootPathToRealmMap);
            objectOutput.writeObject(this.realmToAuthenticationMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractNonce(String challenge) {
        int _index = challenge.indexOf("nonce");
        if (_index != -1) {
            try {
                _index = challenge.indexOf("\"", _index) + 1;
                return challenge.substring(_index, challenge.indexOf("\"", _index));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractRealm(String challenge) {
        int _index = challenge.indexOf("realm");
        if (_index != -1) {
            try {
                _index = challenge.indexOf("\"", _index) + 1;
                return challenge.substring(_index, challenge.indexOf("\"", _index));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    private String findRealm(URL url) {
        String _url = url.toString();
        Enumeration _keys = this.rootPathToRealmMap.keys();
        int _size = this.rootPathToRealmMap.size();
        for (int i = 0; i < _size; ++i) {
            String _key = (String)_keys.nextElement();
            if (!_url.startsWith(_key)) continue;
            return (String)this.rootPathToRealmMap.get(_key);
        }
        return null;
    }

    private void fireAuthenticationEvent(Authentication authentication) {
        AuthenticationEvent _event = new AuthenticationEvent(1, authentication, this);
        int _size = this.authenticationListenerList.size();
        for (int i = 0; i < _size; ++i) {
            ((AuthenticationListener)this.authenticationListenerList.elementAt(i)).onAuthenticationEvent(_event);
        }
    }

    private static String getRootPath(URL url) {
        URL _url = null;
        try {
            int _index;
            String _path = url.getFile();
            if (_path == null || _path.equals("")) {
                _path = "/";
            } else if (_path.length() > 1 && (_index = _path.lastIndexOf("/")) != _path.length() - 1) {
                _path = _path.substring(0, _index + 1);
            }
            _url = new URL(url.getProtocol(), url.getHost(), url.getPort(), _path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _url.toExternalForm();
    }

    static {
        try {
            ((MyDigest)Class.forName("ice.net.MyMessageDigest").newInstance()).getInstance("MD5");
            digestEnabled = true;
        }
        catch (ClassNotFoundException exception) {
            digestEnabled = false;
        }
        catch (InstantiationException exception) {
            digestEnabled = false;
        }
        catch (IllegalAccessException exception) {
            digestEnabled = false;
        }
        catch (Throwable throwable) {
            digestEnabled = false;
        }
    }
}

