/*
 * Decompiled with CFR 0.152.
 */
package ice.authentication.basic;

import ice.authentication.AbstractAuthentication;
import ice.authentication.Authentication;
import ice.util.encoding.Base64;
import java.net.URL;

public class BasicAuthentication
extends AbstractAuthentication
implements Authentication {
    public BasicAuthentication(String realm, URL requestUri) throws IllegalArgumentException {
        super(requestUri);
        this.setType(0);
        if (realm == null) {
            throw new IllegalArgumentException("realm is null");
        }
        this.setRealm(realm);
    }

    public String getCredentials() {
        if (this.userName == null || this.userName.trim().length() == 0 || this.password == null || this.password.trim().length() == 0) {
            return null;
        }
        return "Basic " + Base64.encode((String)(this.userName + ":" + this.password));
    }

    public String getScheme() {
        return "Basic";
    }

    public boolean isVolatile() {
        return false;
    }
}

