/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import com.lowagie.text.rtf.graphic.RtfShapePosition;
import com.lowagie.text.rtf.graphic.RtfShapeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class RtfShape
extends RtfAddableElement {
    public static final int SHAPE_PICTURE_FRAME = 75;
    public static final int SHAPE_FREEFORM = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_ROUND_RECTANGLE = 2;
    public static final int SHAPE_ELLIPSE = 3;
    public static final int SHAPE_DIAMOND = 4;
    public static final int SHAPE_TRIANGLE_ISOSCELES = 5;
    public static final int SHAPE_TRIANGLE_RIGHT = 6;
    public static final int SHAPE_PARALLELOGRAM = 7;
    public static final int SHAPE_TRAPEZOID = 8;
    public static final int SHAPE_HEXAGON = 9;
    public static final int SHAPE_OCTAGON = 10;
    public static final int SHAPE_STAR = 12;
    public static final int SHAPE_ARROW = 13;
    public static final int SHAPE_ARROR_THICK = 14;
    public static final int SHAPE_HOME_PLATE = 15;
    public static final int SHAPE_CUBE = 16;
    public static final int SHAPE_BALLOON = 17;
    public static final int SHAPE_SEAL = 18;
    public static final int SHAPE_ARC = 19;
    public static final int SHAPE_LINE = 20;
    public static final int SHAPE_CAN = 22;
    public static final int SHAPE_DONUT = 23;
    public static final int SHAPE_WRAP_NONE = 0;
    public static final int SHAPE_WRAP_TOP_BOTTOM = 1;
    public static final int SHAPE_WRAP_BOTH = 2;
    public static final int SHAPE_WRAP_LEFT = 3;
    public static final int SHAPE_WRAP_RIGHT = 4;
    public static final int SHAPE_WRAP_LARGEST = 5;
    public static final int SHAPE_WRAP_TIGHT_BOTH = 6;
    public static final int SHAPE_WRAP_TIGHT_LEFT = 7;
    public static final int SHAPE_WRAP_TIGHT_RIGHT = 8;
    public static final int SHAPE_WRAP_TIGHT_LARGEST = 9;
    public static final int SHAPE_WRAP_THROUGH = 10;
    private int shapeNr = 0;
    private int type = 0;
    private RtfShapePosition position = null;
    private HashMap properties = null;
    private int wrapping = 0;
    private String shapeText = "";

    public RtfShape(int n, RtfShapePosition rtfShapePosition) {
        this.type = n;
        this.position = rtfShapePosition;
        this.properties = new HashMap();
    }

    public void setProperty(RtfShapeProperty rtfShapeProperty) {
        this.properties.put(rtfShapeProperty.getName(), rtfShapeProperty);
    }

    public void setShapeText(String string) {
        this.shapeText = string;
    }

    public void setWrapping(int n) {
        this.wrapping = n;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        this.shapeNr = this.doc.getRandomInt();
        this.properties.put("ShapeType", new RtfShapeProperty("ShapeType", this.type));
        if (this.position.isShapeBelowText()) {
            this.properties.put("fBehindDocument", new RtfShapeProperty("fBehindDocument", true));
        }
        if (this.inTable) {
            this.properties.put("fLayoutInCell", new RtfShapeProperty("fLayoutInCell", true));
        }
        if (this.properties.containsKey("posh")) {
            this.position.setIgnoreXRelative(true);
        }
        if (this.properties.containsKey("posv")) {
            this.position.setIgnoreYRelative(true);
        }
        outputStream.write(OPEN_GROUP);
        outputStream.write("\\shp".getBytes());
        outputStream.write("\\shplid".getBytes());
        outputStream.write(this.intToByteArray(this.shapeNr));
        this.position.writeContent(outputStream);
        switch (this.wrapping) {
            case 0: {
                outputStream.write("\\shpwr3".getBytes());
                break;
            }
            case 1: {
                outputStream.write("\\shpwr1".getBytes());
                break;
            }
            case 2: {
                outputStream.write("\\shpwr2".getBytes());
                outputStream.write("\\shpwrk0".getBytes());
                break;
            }
            case 3: {
                outputStream.write("\\shpwr2".getBytes());
                outputStream.write("\\shpwrk1".getBytes());
                break;
            }
            case 4: {
                outputStream.write("\\shpwr2".getBytes());
                outputStream.write("\\shpwrk2".getBytes());
                break;
            }
            case 5: {
                outputStream.write("\\shpwr2".getBytes());
                outputStream.write("\\shpwrk3".getBytes());
                break;
            }
            case 6: {
                outputStream.write("\\shpwr4".getBytes());
                outputStream.write("\\shpwrk0".getBytes());
                break;
            }
            case 7: {
                outputStream.write("\\shpwr4".getBytes());
                outputStream.write("\\shpwrk1".getBytes());
                break;
            }
            case 8: {
                outputStream.write("\\shpwr4".getBytes());
                outputStream.write("\\shpwrk2".getBytes());
                break;
            }
            case 9: {
                outputStream.write("\\shpwr4".getBytes());
                outputStream.write("\\shpwrk3".getBytes());
                break;
            }
            case 10: {
                outputStream.write("\\shpwr5".getBytes());
                break;
            }
            default: {
                outputStream.write("\\shpwr3".getBytes());
            }
        }
        if (this.inHeader) {
            outputStream.write("\\shpfhdr1".getBytes());
        }
        if (this.doc.getDocumentSettings().isOutputDebugLineBreaks()) {
            outputStream.write(10);
        }
        outputStream.write(OPEN_GROUP);
        outputStream.write("\\*\\shpinst".getBytes());
        for (RtfShapeProperty rtfShapeProperty : this.properties.values()) {
            rtfShapeProperty.writeContent(outputStream);
        }
        if (!this.shapeText.equals("")) {
            outputStream.write(OPEN_GROUP);
            outputStream.write("\\shptxt".getBytes());
            outputStream.write(DELIMITER);
            outputStream.write(this.shapeText.getBytes());
            outputStream.write(CLOSE_GROUP);
        }
        outputStream.write(CLOSE_GROUP);
        if (this.doc.getDocumentSettings().isOutputDebugLineBreaks()) {
            outputStream.write(10);
        }
        outputStream.write(CLOSE_GROUP);
    }
}

