/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.PsdHeaderDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsdHeaderDescriptor
extends TagDescriptor<PsdHeaderDirectory> {
    public PsdHeaderDescriptor(@NotNull PsdHeaderDirectory psdHeaderDirectory) {
        super(psdHeaderDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getChannelCountDescription();
            }
            case 4: {
                return this.getBitsPerChannelDescription();
            }
            case 5: {
                return this.getColorModeDescription();
            }
            case 2: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getChannelCountDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(1);
            if (n == null) {
                return null;
            }
            return n + " channel" + (n == 1 ? "" : "s");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getBitsPerChannelDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(4);
            if (n == null) {
                return null;
            }
            return n + " bit" + (n == 1 ? "" : "s") + " per channel";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getColorModeDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(5);
            if (n == null) {
                return null;
            }
            switch (n) {
                case 0: {
                    return "Bitmap";
                }
                case 1: {
                    return "Grayscale";
                }
                case 2: {
                    return "Indexed";
                }
                case 3: {
                    return "RGB";
                }
                case 4: {
                    return "CMYK";
                }
                case 7: {
                    return "Multichannel";
                }
                case 8: {
                    return "Duotone";
                }
                case 9: {
                    return "Lab";
                }
            }
            return "Unknown color mode (" + n + ")";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getImageHeightDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(2);
            if (n == null) {
                return null;
            }
            return n + " pixel" + (n == 1 ? "" : "s");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getImageWidthDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(3);
            if (n == null) {
                return null;
            }
            return n + " pixel" + (n == 1 ? "" : "s");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

