/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentaxMakernoteDescriptor
extends TagDescriptor<PentaxMakernoteDirectory> {
    public PentaxMakernoteDescriptor(@NotNull PentaxMakernoteDirectory pentaxMakernoteDirectory) {
        super(pentaxMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getCaptureModeDescription();
            }
            case 2: {
                return this.getQualityLevelDescription();
            }
            case 3: {
                return this.getFocusModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getIsoSpeedDescription();
            }
            case 23: {
                return this.getColourDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getColourDescription() {
        return this.getIndexedDescription(23, 1, "Normal", "Black & White", "Sepia");
    }

    @Nullable
    public String getIsoSpeedDescription() {
        Integer n = ((PentaxMakernoteDirectory)this._directory).getInteger(20);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 10: {
                return "ISO 100";
            }
            case 16: {
                return "ISO 200";
            }
            case 100: {
                return "ISO 100";
            }
            case 200: {
                return "ISO 200";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(13, "Normal", "Low", "High");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(12, "Normal", "Low", "High");
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(11, "Normal", "Soft", "Hard");
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Float f = ((PentaxMakernoteDirectory)this._directory).getFloatObject(10);
        if (f == null) {
            return null;
        }
        if (f.floatValue() == 0.0f) {
            return "Off";
        }
        return Float.toString(f.floatValue());
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(7, "Auto", "Daylight", "Shade", "Tungsten", "Fluorescent", "Manual");
    }

    @Nullable
    public String getFlashModeDescription() {
        return this.getIndexedDescription(4, 1, "Auto", "Flash On", null, "Flash Off", null, "Red-eye Reduction");
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(3, 2, "Custom", "Auto");
    }

    @Nullable
    public String getQualityLevelDescription() {
        return this.getIndexedDescription(2, "Good", "Better", "Best");
    }

    @Nullable
    public String getCaptureModeDescription() {
        return this.getIndexedDescription(1, "Auto", "Night-scene", "Manual", null, "Multiple");
    }
}

