/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDescriptor;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlympusMakernoteDirectory
extends Directory {
    public static final int TAG_MAKERNOTE_VERSION = 0;
    public static final int TAG_CAMERA_SETTINGS_1 = 1;
    public static final int TAG_CAMERA_SETTINGS_2 = 3;
    public static final int TAG_COMPRESSED_IMAGE_SIZE = 64;
    public static final int TAG_MINOLTA_THUMBNAIL_OFFSET_1 = 129;
    public static final int TAG_MINOLTA_THUMBNAIL_OFFSET_2 = 136;
    public static final int TAG_MINOLTA_THUMBNAIL_LENGTH = 137;
    public static final int TAG_THUMBNAIL_IMAGE = 256;
    public static final int TAG_COLOUR_MODE = 257;
    public static final int TAG_IMAGE_QUALITY_1 = 258;
    public static final int TAG_IMAGE_QUALITY_2 = 259;
    public static final int TAG_BODY_FIRMWARE_VERSION = 260;
    public static final int TAG_SPECIAL_MODE = 512;
    public static final int TAG_JPEG_QUALITY = 513;
    public static final int TAG_MACRO_MODE = 514;
    public static final int TAG_BW_MODE = 515;
    public static final int TAG_DIGI_ZOOM_RATIO = 516;
    public static final int TAG_FOCAL_PLANE_DIAGONAL = 517;
    public static final int TAG_LENS_DISTORTION_PARAMETERS = 518;
    public static final int TAG_FIRMWARE_VERSION = 519;
    public static final int TAG_PICT_INFO = 520;
    public static final int TAG_CAMERA_ID = 521;
    public static final int TAG_IMAGE_WIDTH = 523;
    public static final int TAG_IMAGE_HEIGHT = 524;
    public static final int TAG_ORIGINAL_MANUFACTURER_MODEL = 525;
    public static final int TAG_PREVIEW_IMAGE = 640;
    public static final int TAG_PRE_CAPTURE_FRAMES = 768;
    public static final int TAG_WHITE_BOARD = 769;
    public static final int TAG_ONE_TOUCH_WB = 770;
    public static final int TAG_WHITE_BALANCE_BRACKET = 771;
    public static final int TAG_WHITE_BALANCE_BIAS = 772;
    public static final int TAG_SCENE_MODE = 1027;
    public static final int TAG_FIRMWARE = 1028;
    public static final int TAG_PRINT_IMAGE_MATCHING_INFO = 3584;
    public static final int TAG_DATA_DUMP_1 = 3840;
    public static final int TAG_DATA_DUMP_2 = 3841;
    public static final int TAG_SHUTTER_SPEED_VALUE = 4096;
    public static final int TAG_ISO_VALUE = 4097;
    public static final int TAG_APERTURE_VALUE = 4098;
    public static final int TAG_BRIGHTNESS_VALUE = 4099;
    public static final int TAG_FLASH_MODE = 4100;
    public static final int TAG_FLASH_DEVICE = 4101;
    public static final int TAG_BRACKET = 4102;
    public static final int TAG_SENSOR_TEMPERATURE = 4103;
    public static final int TAG_LENS_TEMPERATURE = 4104;
    public static final int TAG_LIGHT_CONDITION = 4105;
    public static final int TAG_FOCUS_RANGE = 4106;
    public static final int TAG_FOCUS_MODE = 4107;
    public static final int TAG_FOCUS_DISTANCE = 4108;
    public static final int TAG_ZOOM = 4109;
    public static final int TAG_MACRO_FOCUS = 4110;
    public static final int TAG_SHARPNESS = 4111;
    public static final int TAG_FLASH_CHARGE_LEVEL = 4112;
    public static final int TAG_COLOUR_MATRIX = 4113;
    public static final int TAG_BLACK_LEVEL = 4114;
    public static final int TAG_WHITE_BALANCE = 4117;
    public static final int TAG_RED_BIAS = 4119;
    public static final int TAG_BLUE_BIAS = 4120;
    public static final int TAG_COLOR_MATRIX_NUMBER = 4121;
    public static final int TAG_SERIAL_NUMBER = 4122;
    public static final int TAG_FLASH_BIAS = 4131;
    public static final int TAG_EXTERNAL_FLASH_BOUNCE = 4134;
    public static final int TAG_EXTERNAL_FLASH_ZOOM = 4135;
    public static final int TAG_EXTERNAL_FLASH_MODE = 4136;
    public static final int TAG_CONTRAST = 4137;
    public static final int TAG_SHARPNESS_FACTOR = 4138;
    public static final int TAG_COLOUR_CONTROL = 4139;
    public static final int TAG_VALID_BITS = 4140;
    public static final int TAG_CORING_FILTER = 4141;
    public static final int TAG_FINAL_WIDTH = 4142;
    public static final int TAG_FINAL_HEIGHT = 4143;
    public static final int TAG_COMPRESSION_RATIO = 4148;
    public static final int TAG_THUMBNAIL = 4149;
    public static final int TAG_THUMBNAIL_OFFSET = 4150;
    public static final int TAG_THUMBNAIL_LENGTH = 4151;
    public static final int TAG_CCD_SCAN_MODE = 4153;
    public static final int TAG_NOISE_REDUCTION = 4154;
    public static final int TAG_INFINITY_LENS_STEP = 4155;
    public static final int TAG_NEAR_LENS_STEP = 4156;
    public static final int TAG_EQUIPMENT = 8208;
    public static final int TAG_CAMERA_SETTINGS = 8224;
    public static final int TAG_RAW_DEVELOPMENT = 8240;
    public static final int TAG_RAW_DEVELOPMENT_2 = 8241;
    public static final int TAG_IMAGE_PROCESSING = 8256;
    public static final int TAG_FOCUS_INFO = 8272;
    public static final int TAG_RAW_INFO = 12288;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public OlympusMakernoteDirectory() {
        this.setDescriptor(new OlympusMakernoteDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Olympus Makernote";
    }

    @Override
    public void setByteArray(int n, @NotNull byte[] byArray) {
        if (n == 1 || n == 3) {
            this.processCameraSettings(byArray);
        } else {
            super.setByteArray(n, byArray);
        }
    }

    private void processCameraSettings(byte[] byArray) {
        SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
        sequentialByteArrayReader.setMotorolaByteOrder(true);
        int n = byArray.length / 4;
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = sequentialByteArrayReader.getInt32();
                this.setInt(61440 + i, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isIntervalMode() {
        Long l = this.getLongObject(61447);
        return l != null && l == 5L;
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    static {
        _tagNameMap.put(0, "Makernote Version");
        _tagNameMap.put(1, "Camera Settings");
        _tagNameMap.put(3, "Camera Settings");
        _tagNameMap.put(64, "Compressed Image Size");
        _tagNameMap.put(129, "Thumbnail Offset");
        _tagNameMap.put(136, "Thumbnail Offset");
        _tagNameMap.put(137, "Thumbnail Length");
        _tagNameMap.put(256, "Thumbnail Image");
        _tagNameMap.put(257, "Colour Mode");
        _tagNameMap.put(258, "Image Quality");
        _tagNameMap.put(259, "Image Quality");
        _tagNameMap.put(260, "Body Firmware Version");
        _tagNameMap.put(512, "Special Mode");
        _tagNameMap.put(513, "JPEG Quality");
        _tagNameMap.put(514, "Macro");
        _tagNameMap.put(515, "BW Mode");
        _tagNameMap.put(516, "DigiZoom Ratio");
        _tagNameMap.put(517, "Focal Plane Diagonal");
        _tagNameMap.put(518, "Lens Distortion Parameters");
        _tagNameMap.put(519, "Firmware Version");
        _tagNameMap.put(520, "Pict Info");
        _tagNameMap.put(521, "Camera Id");
        _tagNameMap.put(523, "Image Width");
        _tagNameMap.put(524, "Image Height");
        _tagNameMap.put(525, "Original Manufacturer Model");
        _tagNameMap.put(640, "Preview Image");
        _tagNameMap.put(768, "Pre Capture Frames");
        _tagNameMap.put(769, "White Board");
        _tagNameMap.put(770, "One Touch WB");
        _tagNameMap.put(771, "White Balance Bracket");
        _tagNameMap.put(772, "White Balance Bias");
        _tagNameMap.put(1027, "Scene Mode");
        _tagNameMap.put(1028, "Firmware");
        _tagNameMap.put(3584, "Print Image Matching (PIM) Info");
        _tagNameMap.put(3840, "Data Dump");
        _tagNameMap.put(3841, "Data Dump 2");
        _tagNameMap.put(4096, "Shutter Speed Value");
        _tagNameMap.put(4097, "ISO Value");
        _tagNameMap.put(4098, "Aperture Value");
        _tagNameMap.put(4099, "Brightness Value");
        _tagNameMap.put(4100, "Flash Mode");
        _tagNameMap.put(4101, "Flash Device");
        _tagNameMap.put(4102, "Bracket");
        _tagNameMap.put(4103, "Sensor Temperature");
        _tagNameMap.put(4104, "Lens Temperature");
        _tagNameMap.put(4105, "Light Condition");
        _tagNameMap.put(4106, "Focus Range");
        _tagNameMap.put(4107, "Focus Mode");
        _tagNameMap.put(4108, "Focus Distance");
        _tagNameMap.put(4109, "Zoom");
        _tagNameMap.put(4110, "Macro Focus");
        _tagNameMap.put(4111, "Sharpness");
        _tagNameMap.put(4112, "Flash Charge Level");
        _tagNameMap.put(4113, "Colour Matrix");
        _tagNameMap.put(4114, "Black Level");
        _tagNameMap.put(4117, "White Balance");
        _tagNameMap.put(4119, "Red Bias");
        _tagNameMap.put(4120, "Blue Bias");
        _tagNameMap.put(4121, "Color Matrix Number");
        _tagNameMap.put(4122, "Serial Number");
        _tagNameMap.put(4131, "Flash Bias");
        _tagNameMap.put(4134, "External Flash Bounce");
        _tagNameMap.put(4135, "External Flash Zoom");
        _tagNameMap.put(4136, "External Flash Mode");
        _tagNameMap.put(4137, "Contrast");
        _tagNameMap.put(4138, "Sharpness Factor");
        _tagNameMap.put(4139, "Colour Control");
        _tagNameMap.put(4140, "Valid Bits");
        _tagNameMap.put(4141, "Coring Filter");
        _tagNameMap.put(4142, "Final Width");
        _tagNameMap.put(4143, "Final Height");
        _tagNameMap.put(4148, "Compression Ratio");
        _tagNameMap.put(4149, "Thumbnail");
        _tagNameMap.put(4150, "Thumbnail Offset");
        _tagNameMap.put(4151, "Thumbnail Length");
        _tagNameMap.put(4153, "CCD Scan Mode");
        _tagNameMap.put(4154, "Noise Reduction");
        _tagNameMap.put(4155, "Infinity Lens Step");
        _tagNameMap.put(4156, "Near Lens Step");
        _tagNameMap.put(8208, "Equipment");
        _tagNameMap.put(8224, "Camera Settings");
        _tagNameMap.put(8240, "Raw Development");
        _tagNameMap.put(8241, "Raw Development 2");
        _tagNameMap.put(8256, "Image Processing");
        _tagNameMap.put(8272, "Focus Info");
        _tagNameMap.put(12288, "Raw Info");
        _tagNameMap.put(61442, "Exposure Mode");
        _tagNameMap.put(61443, "Flash Mode");
        _tagNameMap.put(61444, "White Balance");
        _tagNameMap.put(61445, "Image Size");
        _tagNameMap.put(61446, "Image Quality");
        _tagNameMap.put(61447, "Shooting Mode");
        _tagNameMap.put(61448, "Metering Mode");
        _tagNameMap.put(61449, "Apex Film Speed Value");
        _tagNameMap.put(61450, "Apex Shutter Speed Time Value");
        _tagNameMap.put(61451, "Apex Aperture Value");
        _tagNameMap.put(61452, "Macro Mode");
        _tagNameMap.put(61453, "Digital Zoom");
        _tagNameMap.put(61454, "Exposure Compensation");
        _tagNameMap.put(61455, "Bracket Step");
        _tagNameMap.put(61457, "Interval Length");
        _tagNameMap.put(61458, "Interval Number");
        _tagNameMap.put(61459, "Focal Length");
        _tagNameMap.put(61460, "Focus Distance");
        _tagNameMap.put(61461, "Flash Fired");
        _tagNameMap.put(61462, "Date");
        _tagNameMap.put(61463, "Time");
        _tagNameMap.put(61464, "Max Aperture at Focal Length");
        _tagNameMap.put(61467, "File Number Memory");
        _tagNameMap.put(61468, "Last File Number");
        _tagNameMap.put(61469, "White Balance Red");
        _tagNameMap.put(61470, "White Balance Green");
        _tagNameMap.put(61471, "White Balance Blue");
        _tagNameMap.put(61472, "Saturation");
        _tagNameMap.put(61473, "Contrast");
        _tagNameMap.put(61474, "Sharpness");
        _tagNameMap.put(61475, "Subject Program");
        _tagNameMap.put(61476, "Flash Compensation");
        _tagNameMap.put(61477, "ISO Setting");
        _tagNameMap.put(61478, "Camera Model");
        _tagNameMap.put(61479, "Interval Mode");
        _tagNameMap.put(61480, "Folder Name");
        _tagNameMap.put(61481, "Color Mode");
        _tagNameMap.put(61482, "Color Filter");
        _tagNameMap.put(61483, "Black and White Filter");
        _tagNameMap.put(61484, "Internal Flash");
        _tagNameMap.put(61485, "Apex Brightness Value");
        _tagNameMap.put(61486, "Spot Focus Point X Coordinate");
        _tagNameMap.put(61487, "Spot Focus Point Y Coordinate");
        _tagNameMap.put(61488, "Wide Focus Zone");
        _tagNameMap.put(61489, "Focus Mode");
        _tagNameMap.put(61490, "Focus Area");
        _tagNameMap.put(61491, "DEC Switch Position");
    }

    public static final class CameraSettings {
        private static final int OFFSET = 61440;
        public static final int TAG_EXPOSURE_MODE = 61442;
        public static final int TAG_FLASH_MODE = 61443;
        public static final int TAG_WHITE_BALANCE = 61444;
        public static final int TAG_IMAGE_SIZE = 61445;
        public static final int TAG_IMAGE_QUALITY = 61446;
        public static final int TAG_SHOOTING_MODE = 61447;
        public static final int TAG_METERING_MODE = 61448;
        public static final int TAG_APEX_FILM_SPEED_VALUE = 61449;
        public static final int TAG_APEX_SHUTTER_SPEED_TIME_VALUE = 61450;
        public static final int TAG_APEX_APERTURE_VALUE = 61451;
        public static final int TAG_MACRO_MODE = 61452;
        public static final int TAG_DIGITAL_ZOOM = 61453;
        public static final int TAG_EXPOSURE_COMPENSATION = 61454;
        public static final int TAG_BRACKET_STEP = 61455;
        public static final int TAG_INTERVAL_LENGTH = 61457;
        public static final int TAG_INTERVAL_NUMBER = 61458;
        public static final int TAG_FOCAL_LENGTH = 61459;
        public static final int TAG_FOCUS_DISTANCE = 61460;
        public static final int TAG_FLASH_FIRED = 61461;
        public static final int TAG_DATE = 61462;
        public static final int TAG_TIME = 61463;
        public static final int TAG_MAX_APERTURE_AT_FOCAL_LENGTH = 61464;
        public static final int TAG_FILE_NUMBER_MEMORY = 61467;
        public static final int TAG_LAST_FILE_NUMBER = 61468;
        public static final int TAG_WHITE_BALANCE_RED = 61469;
        public static final int TAG_WHITE_BALANCE_GREEN = 61470;
        public static final int TAG_WHITE_BALANCE_BLUE = 61471;
        public static final int TAG_SATURATION = 61472;
        public static final int TAG_CONTRAST = 61473;
        public static final int TAG_SHARPNESS = 61474;
        public static final int TAG_SUBJECT_PROGRAM = 61475;
        public static final int TAG_FLASH_COMPENSATION = 61476;
        public static final int TAG_ISO_SETTING = 61477;
        public static final int TAG_CAMERA_MODEL = 61478;
        public static final int TAG_INTERVAL_MODE = 61479;
        public static final int TAG_FOLDER_NAME = 61480;
        public static final int TAG_COLOR_MODE = 61481;
        public static final int TAG_COLOR_FILTER = 61482;
        public static final int TAG_BLACK_AND_WHITE_FILTER = 61483;
        public static final int TAG_INTERNAL_FLASH = 61484;
        public static final int TAG_APEX_BRIGHTNESS_VALUE = 61485;
        public static final int TAG_SPOT_FOCUS_POINT_X_COORDINATE = 61486;
        public static final int TAG_SPOT_FOCUS_POINT_Y_COORDINATE = 61487;
        public static final int TAG_WIDE_FOCUS_ZONE = 61488;
        public static final int TAG_FOCUS_MODE = 61489;
        public static final int TAG_FOCUS_AREA = 61490;
        public static final int TAG_DEC_SWITCH_POSITION = 61491;
    }
}

