/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.pdf;

import coldfusion.pdf.AttachmentObject;
import coldfusion.pdf.PDFDocOperation;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFFileNotFoundException;
import coldfusion.pdf.PDFParamInfo;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.Array;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.pdf.PDFTag;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.redaction.impl.WordMatchingCriteria;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class PDFParamTag
extends ChildTag {
    private Object source;
    private String pages;
    private String password;
    private PDFTag pdfTag;
    private Map args = null;
    private PDFDocOperation pdfOperation;
    private String calledSource;
    private String iconName;
    private String content;
    private String filename;
    private String description;
    private String mimetype;
    private String encoding = "UTF-8";
    private int posCoordinate;
    private static List<String> iconNameList = new ArrayList<String>();
    private List wordstoredact;
    private int rotation = 0;
    private int opacity = -1;
    private String wordMatchingCriteria = WordMatchingCriteria.MARKWHOLEWORD.name();
    private boolean ignorecase;
    private int[][] coordinate = new int[][]{{0}, {0}, {0}, {0}, {0}};

    public PDFParamTag() {
        super(PDFTag.class);
    }

    public void setAncestor(Tag ancestor) {
        this.pdfTag = (PDFTag)ancestor;
    }

    public void setAttributecollection(Map map) {
        if (map instanceof CaseInsensitiveMap) {
            try {
                this.args = ((CaseInsensitiveMap)map).duplicate();
            }
            catch (IllegalAccessException e) {
                this.args = map;
            }
        } else {
            this.args = map;
        }
    }

    public void setSource(String source) {
        if (source == null || "".equals(source.trim()) || "true".equalsIgnoreCase(source)) {
            throw new PDFException.EmptyAttributeException("source", "CFPDFPARAM");
        }
        this.calledSource = source;
        this.source = this.validateSource(source);
    }

    public String getSource() {
        return this.calledSource;
    }

    private Object validateSource(String source) {
        this.pdfOperation = new PDFDocOperation();
        Object value = null;
        if (null != this.pageContext) {
            try {
                value = this.pageContext.findAttribute(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value != null) {
            if (value instanceof byte[]) {
                this.pdfOperation.getPdfDocHandler().removeBackground = true;
                return value;
            }
            if (!(value instanceof PDFDocWrapper)) {
                throw new PDFException.EmptyAttributeException("source", "CFPDFPARAM");
            }
            return value;
        }
        File tempFile = VFSFileFactory.getFileObject((String)(source = Utils.getFileFullPath((String)source.trim(), (PageContext)this.pageContext, (boolean)true)));
        if (!tempFile.exists() || tempFile.isDirectory()) {
            throw new PDFFileNotFoundException("source", source, "CFPDFPARAM");
        }
        return source;
    }

    public String getPages() {
        return this.pages;
    }

    public void setPages(String value) {
        if ("".equals(value = value.trim())) {
            throw new PDFException.EmptyAttributeException("pages", "CFPDFPARAM");
        }
        this.pages = value;
    }

    public void setPassword(String password) {
        if (password == null || "".equals(password.trim())) {
            throw new PDFException.EmptyAttributeException("password", "CFPDFPARAM");
        }
        this.password = password;
    }

    public void setIconName(String iconName) {
        if (iconName == null || "".equals(iconName.trim())) {
            throw new PDFException.EmptyAttributeException("iconName", "CFPDFPARAM");
        }
        if ((iconName = iconName.trim()).equalsIgnoreCase("Approved")) {
            this.iconName = "Approved";
        } else if (iconName.equalsIgnoreCase("Draft")) {
            this.iconName = "Draft";
        } else if (iconName.equalsIgnoreCase("Experimental")) {
            this.iconName = "Experimental";
        } else if (iconName.equalsIgnoreCase("NotApproved")) {
            this.iconName = "NotApproved";
        } else if (iconName.equalsIgnoreCase("AsIs")) {
            this.iconName = "AsIs";
        } else if (iconName.equalsIgnoreCase("Sold")) {
            this.iconName = "Sold";
        } else if (iconName.equalsIgnoreCase("Final")) {
            this.iconName = "Final";
        } else if (iconName.equalsIgnoreCase("Confidential")) {
            this.iconName = "Confidential";
        } else if (iconName.equalsIgnoreCase("NotForPublicRelease")) {
            this.iconName = "NotForPublicRelease";
        } else if (iconName.equalsIgnoreCase("Expired")) {
            this.iconName = "Expired";
        } else if (iconName.equalsIgnoreCase("Departmental")) {
            this.iconName = "Departmental";
        } else if (iconName.equalsIgnoreCase("ForComment")) {
            this.iconName = "ForComment";
        } else if (iconName.equalsIgnoreCase("TopSecret")) {
            this.iconName = "TopSecret";
        } else if (iconName.equalsIgnoreCase("ForPublicRelease")) {
            this.iconName = "ForPublicRelease";
        } else {
            throw new PDFException.IconNameException();
        }
    }

    public void setNote(String content) {
        if (content == null || "".equals(content.trim())) {
            throw new PDFException.EmptyAttributeException("content", "CFPDFPARAM");
        }
        this.content = content;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setDescription(String description) {
        if (description == null || "".equals(description.trim())) {
            throw new PDFException.EmptyAttributeException("description", "CFPDFPARAM");
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMimetype(String mimetype) {
        if (mimetype == null || "".equals(mimetype.trim())) {
            throw new PDFException.EmptyAttributeException("mimetype", "CFPDFPARAM");
        }
        this.mimetype = mimetype;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List getWordstoredact() {
        return this.wordstoredact;
    }

    public void setWordstoredact(Object wordstoredact) {
        Array wordstoredactArray = null;
        if (wordstoredact != null && wordstoredact instanceof Array) {
            wordstoredactArray = (Array)wordstoredact;
            if (wordstoredactArray.isEmpty()) {
                throw new PDFException.EmptyAttributeException("WORDSTOREDACT", "CFPDFPARAM");
            }
        } else {
            throw new PDFException.EmptyAttributeException("WORDSTOREDACT", "CFPDFPARAM");
        }
        this.wordstoredact = wordstoredactArray;
    }

    public boolean isIgnorecase() {
        return this.ignorecase;
    }

    public void setIgnorecase(boolean ignorecase) {
        this.ignorecase = ignorecase;
    }

    public String getWordMatchingCriteria() {
        return this.wordMatchingCriteria;
    }

    public void setWordMatchingCriteria(String wordMatchingCriteria) {
        if (!(wordMatchingCriteria != null && wordMatchingCriteria.equalsIgnoreCase(WordMatchingCriteria.MARKWHOLEWORD.name()) || wordMatchingCriteria.equalsIgnoreCase(WordMatchingCriteria.MATCHPARTIALWORD_MARKPARTIALWORD.name()) || wordMatchingCriteria.equalsIgnoreCase(WordMatchingCriteria.MATCHPARTIALWORD_MARKWHOLEWORD.name()))) {
            throw new PDFException.InvalidAttributeValueException("WORDMATCHINGCRITERIA", "CFPDFPARAM", "MARKWHOLEWORD,MATCHPARTIALWORD_MARKPARTIALWORD,MATCHPARTIALWORD_MARKWHOLEWORD");
        }
        this.wordMatchingCriteria = wordMatchingCriteria;
    }

    private boolean isWordtoRedactpresent() {
        return this.wordstoredact != null && !this.wordstoredact.isEmpty();
    }

    public int[][] getCoordinates() {
        return this.coordinate;
    }

    public void setCoordinates(String coordinate) {
        if ((coordinate = coordinate.trim()).length() == 0) {
            throw new PDFException.EmptyAttributeException("COORDINATE", "CFPDFPARAM");
        }
        boolean pos = false;
        boolean end = false;
        this.posCoordinate = 0;
        boolean i = false;
        boolean flag = false;
        String[] tempStr = coordinate.split(",");
        int[] tempInt = new int[4];
        if (tempStr.length != 4) {
            throw new PDFException.EmptyAttributeException("COORDINATE", "CFPDFPARAM");
        }
        try {
            for (int k = 0; k < tempStr.length; ++k) {
                tempInt[k] = Integer.parseInt(tempStr[k].trim());
            }
        }
        catch (NumberFormatException nfe) {
            throw new PDFException.EmptyAttributeException("COORDINATE", "CFPDFPARAM");
        }
        this.coordinate[this.posCoordinate] = tempInt;
        ++this.posCoordinate;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setOpacity(int opacity) {
        if (opacity <= 0 || 10 <= opacity) {
            throw new PDFException.PDFInvalidOpacityException("" + opacity);
        }
        this.opacity = opacity;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (!("MERGE".equalsIgnoreCase(this.pdfTag.getAction()) || "REDACT".equalsIgnoreCase(this.pdfTag.getAction()) || "ADDSTAMP".equalsIgnoreCase(this.pdfTag.getAction()) || "ADDATTACHMENTS".equalsIgnoreCase(this.pdfTag.getAction()))) {
            throw new PDFException.PDFMissingParentTagException();
        }
        if ("MERGE".equalsIgnoreCase(this.pdfTag.getAction())) {
            if (this.source == null) {
                throw new PDFException.PDFMissingSourceAttribute("source", "MERGE");
            }
            if (this.pdfTag.getSource() != null) {
                throw new PDFException.PDFNoSourceException2("source", "MERGE");
            }
            if (this.pdfTag.getDirectory() != null) {
                throw new PDFException.PDFNoDirectoryException2("directory", "MERGE");
            }
            if (this.pdfTag.getName() == null && this.pdfTag.getDestination() == null) {
                throw new PDFException.PDFNameDestinationException("NAME", "destination", "MERGE");
            }
            if (!this.pdfTag.isPortfolio()) {
                if (this.args != null) {
                    throw new PDFException.PDFInvalidArgException();
                }
                PDFDocument pdfDocument = this.pdfOperation.merge(this.pdfTag.getPdfdoc(), this.source, this.password, this.pages, this.pdfTag.isKeepBookmark(), true);
                this.pdfTag.setPdfdoc(pdfDocument);
            } else {
                PDFDocWrapper pdfDoc;
                if (this.pages != null) {
                    throw new PDFException.PDFInvalidPageException2();
                }
                if (this.source instanceof String && !((String)this.source).endsWith("pdf")) {
                    pdfDoc = new PDFDocWrapper(this.source, this.password, null, this.args, this.calledSource);
                } else {
                    if (!this.calledSource.endsWith(".pdf")) {
                        this.calledSource = this.calledSource + ".pdf";
                    }
                    pdfDoc = new PDFDocWrapper(this.pdfOperation.read(this.password, this.source), this.password, null, this.args, this.calledSource);
                }
                this.pdfTag.addToPortfolio(pdfDoc);
            }
        } else if ("REDACT".equalsIgnoreCase(this.pdfTag.getAction())) {
            this.pdfOperation = new PDFDocOperation();
            if (this.pdfTag.getName() == null && this.pdfTag.getDestination() == null) {
                throw new PDFException.PDFNameDestinationException("NAME", "destination", "REDACT");
            }
            if (this.pages == null || this.pages.isEmpty()) {
                this.pages = "*";
            }
            if (this.pages != null) {
                PDFParamInfo paramInfo = new PDFParamInfo();
                paramInfo.setCoordinate(this.getCoordinates());
                paramInfo.setPages(this.getPages());
                paramInfo.setWordstoredact(this.getWordstoredact());
                paramInfo.setMatchingCriteria(WordMatchingCriteria.valueOf((String)this.wordMatchingCriteria));
                paramInfo.setIgnorecase(this.isIgnorecase());
                paramInfo.setPosCoordinate(this.posCoordinate);
                this.pdfTag.addParamtagsInfo(paramInfo);
            }
        } else if ("ADDATTACHMENTS".equalsIgnoreCase(this.pdfTag.getAction())) {
            if (this.pdfTag.getName() == null && this.pdfTag.getDestination() == null) {
                throw new PDFException.PDFNameDestinationException("NAME", "destination", "ADDATTACHMENTS");
            }
            if (this.source == null) {
                throw new PDFException.MissingAttributeException("source", "CFPDFPARAM", "ADDATTACHMENTS");
            }
            AttachmentObject object = new AttachmentObject(this.getFilename(), this.getMimetype(), this.getEncoding(), this.getDescription(), this.getSource());
            this.pdfTag.getList().add(object);
        } else {
            this.pdfOperation = new PDFDocOperation();
            if (this.pdfTag.getName() == null && this.pdfTag.getDestination() == null) {
                throw new PDFException.PDFNameDestinationException("NAME", "destination", "ADDSTAMP");
            }
            if (this.coordinate == null) {
                throw new PDFException.MissingAttributeException("COORDINATE", "CFPDFPARAM", "ADDSTAMP");
            }
            if (this.iconName == null || this.iconName.isEmpty()) {
                throw new PDFException.MissingAttributeException("ICONNAME", "CFPDFPARAM", "ADDSTAMP");
            }
            if (this.pages == null || this.pages.isEmpty()) {
                this.pages = "*";
            }
            try {
                if (this.pdfTag.getDestination() == null) {
                    File tempFile = File.createTempFile("tmp", ".pdf");
                    this.pdfTag.setDestination(tempFile.getAbsolutePath());
                }
                this.pdfOperation.addStamp(this.pdfTag.getDestination(), this.pdfTag.getSource(), this.pdfTag.getPassword(), this.pages, this.coordinate, this.iconName, this.content, this.posCoordinate, this.rotation, this.opacity);
                this.pdfTag.setSource(this.pdfTag.getDestination());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void release() {
        this.source = null;
        this.pages = null;
        this.password = null;
        this.pdfTag = null;
        this.args = null;
        this.calledName = null;
        this.pdfOperation = null;
        this.ignorecase = false;
        this.wordstoredact = null;
        this.coordinate = null;
        this.iconName = null;
        this.content = null;
        this.filename = null;
        this.description = null;
        this.mimetype = null;
        this.encoding = "UTF-8";
        this.opacity = -1;
        this.rotation = 0;
        this.wordMatchingCriteria = WordMatchingCriteria.MARKWHOLEWORD.name();
        super.release();
    }

    static {
        iconNameList.add("Approved");
        iconNameList.add("Draft");
        iconNameList.add("Experimental");
        iconNameList.add("NotApproved");
        iconNameList.add("AsIs");
        iconNameList.add("Expired");
        iconNameList.add("NotForPublicRelease");
        iconNameList.add("Confidential");
        iconNameList.add("Final");
        iconNameList.add("Sold");
        iconNameList.add("Departmental");
        iconNameList.add("ForComment");
        iconNameList.add("TopSecret");
        iconNameList.add("ForPublicRelease");
    }
}

