/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.io.PathSerializer;

public class Vector_Area
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private Area[] items = new Area[this.max_size];
    private int checkPoint = -1;

    public Vector_Area() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Area(int number) {
        this.max_size = number;
        this.items = new Area[this.max_size];
    }

    public final Area[] get() {
        return this.items;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final void addElement(Area value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            Area[] temp = this.items;
            this.items = new Area[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Area.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            Area nextObj = this.items[i];
            if (nextObj == null) {
                os.writeObject(null);
                continue;
            }
            PathIterator pathIterator = nextObj.getPathIterator(new AffineTransform());
            PathSerializer.serializePath(os, pathIterator);
        }
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Area[size];
        for (int i = 0; i < size; ++i) {
            GeneralPath path = PathSerializer.deserializePath(os);
            this.items[i] = path == null ? null : new Area(path);
        }
    }

    public void trim() {
        Area[] newItems = new Area[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }
}

