/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.jpedal.PdfDecoderInt;
import org.jpedal.objects.PdfPageData;

public class PdfPageFormat {
    private static Set<PageFormat> availablePaper;

    public PdfPageFormat() {
        throw new AssertionError((Object)"PdfPageFormat cannot be instanced.  Use factory methods.");
    }

    public static final PageFormat createPdfPageFormat(MediaSizeName mediaSizeName, PrintService printingDevice) {
        OrientationRequested or;
        if (printingDevice == null) {
            printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        }
        PageFormat pdfPageFormat = new PageFormat();
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        if (mediaSize == null) {
            mediaSize = MediaSize.getMediaSizeForName(PdfPageFormat.getDefaultMediaSizeName(printingDevice));
        }
        Paper pdfPaper = new Paper();
        if (mediaSize != null) {
            float xSize = mediaSize.getX(25400) * 72.0f;
            float ySize = mediaSize.getY(25400) * 72.0f;
            pdfPaper.setSize(xSize, ySize);
            if (printingDevice != null) {
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                attributes.add(mediaSizeName);
                MediaPrintableArea[] areas = (MediaPrintableArea[])printingDevice.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes);
                if (areas != null) {
                    int i;
                    int useArea = 0;
                    if (areas[useArea] == null) {
                        i = 0;
                        while (i != areas.length && areas[useArea] == null) {
                            useArea = i++;
                        }
                    }
                    float[] imagable = areas[useArea].getPrintableArea(25400);
                    i = 0;
                    while (i < 4) {
                        int n = i++;
                        imagable[n] = imagable[n] * 72.0f;
                    }
                    if (imagable[2] + imagable[0] > xSize) {
                        imagable[2] = xSize - imagable[0];
                    }
                    if (imagable[3] + imagable[1] > ySize) {
                        imagable[3] = ySize - imagable[1];
                    }
                    pdfPaper.setImageableArea(imagable[0], imagable[1], imagable[2], imagable[3]);
                }
            }
        }
        pdfPageFormat.setPaper(pdfPaper);
        if (printingDevice != null && (or = (OrientationRequested)printingDevice.getDefaultAttributeValue(OrientationRequested.class)) != null) {
            switch (or.getValue()) {
                case 3: {
                    pdfPageFormat.setOrientation(1);
                    break;
                }
                case 4: {
                    pdfPageFormat.setOrientation(0);
                    break;
                }
                case 5: {
                    pdfPageFormat.setOrientation(2);
                    break;
                }
                case 6: {
                    pdfPageFormat.setOrientation(1);
                    break;
                }
                default: {
                    pdfPageFormat.setOrientation(1);
                }
            }
        }
        return pdfPageFormat;
    }

    private static PageFormat getDefaultPage() {
        PrintService printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        return PdfPageFormat.createPdfPageFormat(PdfPageFormat.getDefaultMediaSizeName(printingDevice), printingDevice);
    }

    public static MediaSizeName getDefaultMediaSizeName(PrintService printingDevice) {
        MediaSizeName size = null;
        if (printingDevice != null) {
            size = (MediaSizeName)printingDevice.getDefaultAttributeValue(MediaSizeName.class);
        }
        if (size == null || MediaSize.getMediaSizeForName(size) == null) {
            Locale locale = Locale.getDefault();
            size = locale.equals(Locale.UK) ? MediaSizeName.ISO_A4 : (locale.equals(Locale.US) ? MediaSizeName.NA_LETTER : MediaSizeName.ISO_A4);
        }
        return size;
    }

    private static void findPrinterPapers() {
        availablePaper = new HashSet<PageFormat>();
        PrintService printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        if (printingDevice != null) {
            Media[] res;
            for (Media m : res = (Media[])printingDevice.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
                MediaSize size;
                if (!(m instanceof MediaSizeName) || (size = MediaSize.getMediaSizeForName((MediaSizeName)m)) == null) continue;
                availablePaper.add(PdfPageFormat.createPdfPageFormat((MediaSizeName)m, printingDevice));
            }
        }
    }

    public static PageFormat getPageFormat(int p, PdfDecoderInt pdfDecoder) {
        PdfPageData pageData = pdfDecoder.getPdfPageData();
        float cropW = pageData.getCropBoxWidth(p);
        float cropH = pageData.getCropBoxHeight(p);
        return PdfPageFormat.getAppropriatePageFormat(cropW, cropH);
    }

    private static PageFormat getAppropriatePageFormat(float cropW, float cropH) {
        if (availablePaper == null) {
            PdfPageFormat.findPrinterPapers();
        }
        PageFormat result = null;
        for (PageFormat pf : availablePaper) {
            result = PdfPageFormat.getClosestPageFormat(result, pf, cropW, cropH);
        }
        if (result == null) {
            result = PdfPageFormat.getDefaultPage();
        }
        return result;
    }

    private static PageFormat getClosestPageFormat(PageFormat original, PageFormat newFormat, float cropW, float cropH) {
        double cropShortSide;
        double newLongSide = newFormat.getHeight() > newFormat.getWidth() ? newFormat.getHeight() : newFormat.getWidth();
        double newShortSide = newFormat.getHeight() < newFormat.getWidth() ? newFormat.getHeight() : newFormat.getWidth();
        double cropLongSide = cropH > cropW ? (double)cropH : (double)cropW;
        double d = cropShortSide = cropH < cropW ? (double)cropH : (double)cropW;
        if (newShortSide >= cropShortSide && newLongSide >= cropLongSide) {
            double origShortSide;
            if (original == null) {
                return (PageFormat)newFormat.clone();
            }
            double origLongSide = original.getHeight() > original.getWidth() ? original.getHeight() : original.getWidth();
            double d2 = origShortSide = original.getHeight() < original.getWidth() ? original.getHeight() : original.getWidth();
            if (origLongSide + origShortSide > newShortSide + newLongSide) {
                return (PageFormat)newFormat.clone();
            }
        }
        return original;
    }
}

