/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;

public class RenderUtils {
    public static boolean OLD_RENDERING_MODE;

    static BufferedImage invertImageBeforeSave(BufferedImage image, boolean horizontal) {
        AffineTransform image_at2 = new AffineTransform();
        if (horizontal) {
            image_at2.scale(-1.0, 1.0);
            image_at2.translate(-image.getWidth(), 0.0);
        } else {
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -image.getHeight());
        }
        AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
        if (image.getType() == 12) {
            BufferedImage source = image;
            image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
            invert3.filter(source, image);
        } else {
            image = invert3.filter(image, null);
        }
        return image;
    }

    static float[] checkSize(float[] array, int currentItem) {
        int size = array.length;
        if (size <= currentItem) {
            int newSize = size * 2;
            float[] newArray = new float[newSize];
            System.arraycopy(array, 0, newArray, 0, size);
            array = newArray;
        }
        return array;
    }

    public static void renderClip(Area clip, Rectangle dirtyRegion, Shape defaultClip, Graphics2D g2) {
        if (OLD_RENDERING_MODE) {
            if (clip != null) {
                g2.setClip(clip);
                if (dirtyRegion != null) {
                    g2.clip(dirtyRegion);
                }
            } else if (g2 != null) {
                g2.setClip(defaultClip);
            }
            return;
        }
        if (g2 != null) {
            if (clip != null) {
                Area aClip;
                if (defaultClip != null) {
                    aClip = new Area(defaultClip);
                    aClip.intersect(clip);
                } else {
                    aClip = (Area)clip.clone();
                }
                if (dirtyRegion != null) {
                    aClip.intersect(new Area(dirtyRegion.getBounds2D()));
                }
                g2.setClip(aClip);
            } else {
                g2.setClip(defaultClip);
            }
        }
    }

    static Rectangle getAreaForGlyph(float[][] trm) {
        int w = (int)Math.sqrt(trm[0][0] * trm[0][0] + trm[1][0] * trm[1][0]);
        int h = (int)Math.sqrt(trm[1][1] * trm[1][1] + trm[0][1] * trm[0][1]);
        float xDiff = 0.0f;
        float yDiff = 0.0f;
        if (trm[0][0] < 0.0f) {
            xDiff = trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            xDiff = trm[1][0];
        }
        if (trm[1][1] < 0.0f) {
            yDiff = trm[1][1];
        } else if (trm[0][1] < 0.0f) {
            yDiff = trm[0][1];
        }
        return new Rectangle((int)(trm[2][0] + xDiff), (int)(trm[2][1] + yDiff), w, h);
    }

    public static boolean rectangleContains(int[] area, int x, int y) {
        int temp;
        int lowX = area[0];
        int hiX = area[0] + area[2];
        int lowY = area[1];
        int hiY = area[1] + area[3];
        boolean containsPoint = false;
        if (lowX > hiX) {
            temp = lowX;
            lowX = hiX;
            hiX = temp;
        }
        if (lowY > hiY) {
            temp = lowY;
            lowY = hiY;
            hiY = temp;
        }
        if (lowY < y && y < hiY && lowX < x && x < hiX) {
            containsPoint = true;
        }
        return containsPoint;
    }

    public static void setDisplayOptions(DynamicVectorRenderer currentDisplay, DecoderOptions options) {
        if (currentDisplay.isHTMLorSVG()) {
            currentDisplay.setValue(5, 0);
            currentDisplay.setValue(9, 0);
        } else {
            if (options.getTextColor() != null) {
                currentDisplay.setValue(2, options.getTextColor().getRGB());
                if (options.getChangeTextAndLine()) {
                    currentDisplay.setValue(3, 1);
                } else {
                    currentDisplay.setValue(3, 0);
                }
                currentDisplay.setValue(4, options.getReplacementColorThreshold());
            }
            if (options.isEnhanceFractionalLines()) {
                currentDisplay.setValue(5, 1);
            } else {
                currentDisplay.setValue(5, 0);
            }
            if (options.isUseSoftclipForShapes()) {
                currentDisplay.setValue(9, 1);
            } else {
                currentDisplay.setValue(9, 0);
            }
            if (options.isUseConvolution()) {
                currentDisplay.setValue(10, 1);
            } else {
                currentDisplay.setValue(10, 0);
            }
        }
    }

    public static Object restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        ObjectInputStream os = new ObjectInputStream(bis);
        return os.readObject();
    }

    public static void writeToStream(ByteArrayOutputStream bos, Object obj) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(obj);
        os.close();
    }
}

