/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.ClipUtils;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.utils.ShapeUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public abstract class BaseDisplay
implements DynamicVectorRenderer {
    private boolean useConvolution;
    Vector_Int objectType;
    static final int defaultSize = 5000;
    protected int type;
    boolean isType3Font;
    protected int currentTokenNumber = -1;
    protected boolean addBackground = true;
    protected Vector_Rectangle_Int areas;
    protected ObjectStore objectStoreRef;
    int currentItem = -1;
    int itemToRender = -1;
    int endItem = -1;
    Area lastClip;
    boolean hasClips;
    int blendMode = 1111314299;
    boolean colorsLocked;
    Graphics2D g2;
    String rawKey;
    PdfPaint fillCol;
    PdfPaint strokeCol;
    public int rawPageNumber;
    public boolean fromPattern;
    public static boolean invertHighlight;
    boolean isPrinting;
    private ImageHandler customImageHandler;
    ColorHandler customColorHandler;
    double cropX;
    double cropH;
    float scaling = 1.0f;
    float lastScaling;
    Vector_Object pageObjects;
    final Map<Integer, String> imageIDtoName = new HashMap<Integer, String>(10);
    int w;
    int h;
    protected Color backgroundColor = Color.WHITE;
    Color textColor;
    private static int colorThresholdToReplace;
    private static boolean enhanceFractionalLines;
    boolean useSoftclipForShapes;
    boolean changeLineArtAndText;
    private final Composite softClipComposite = new Composite(){
        final CompositeContext softClipContext = new SoftClipContext();

        @Override
        public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
            return this.softClipContext;
        }

        class SoftClipContext
        implements CompositeContext {
            SoftClipContext() {
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int width = dstIn.getWidth();
                int height = dstIn.getHeight();
                int[] srcRow = new int[width];
                int[] dstRow = new int[width];
                for (int y = 0; y < height; ++y) {
                    src.getDataElements(0, y, width, 1, srcRow);
                    dstIn.getDataElements(0, y, width, 1, dstRow);
                    for (int x = 0; x < width; ++x) {
                        int s = srcRow[x];
                        int d = dstRow[x];
                        int a = s >> 24 & 0xFF;
                        int da = d >> 24 & 0xFF;
                        int dr = d >> 16 & 0xFF;
                        int dg = d >> 8 & 0xFF;
                        int db = d & 0xFF;
                        dstRow[x] = da * (a / 255) << 24 | dr << 16 | dg << 8 | db;
                    }
                    dstOut.setDataElements(0, y, width, 1, dstRow);
                }
            }

            @Override
            public void dispose() {
                softClipContext.dispose();
            }
        }
    };
    public static RenderingHints userHints;
    private static final float PI_FLOAT = (float)Math.PI;
    private static final float PI_FLOAT2 = 9.869605f;

    @Override
    public void setG2(Graphics2D g2) {
        this.g2 = g2;
        if (userHints != null) {
            this.g2.setRenderingHints(userHints);
        }
    }

    @Override
    public void init(int width, int height, Color backgroundColor) {
        this.w = width;
        this.h = height;
        this.backgroundColor = backgroundColor;
    }

    void paintBackground(Shape dirtyRegion) {
        if (this.addBackground && this.g2 != null) {
            this.g2.setColor(this.backgroundColor);
            if (dirtyRegion == null) {
                this.g2.fill(new Rectangle(0, 0, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                this.g2.fill(dirtyRegion);
            }
        }
    }

    static boolean checkColorThreshold(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        return r <= colorThresholdToReplace && g <= colorThresholdToReplace && b <= colorThresholdToReplace;
    }

    void renderEmbeddedText(int text_fill_type, Object rawglyph, int glyphType, AffineTransform glyphAT, PdfPaint strokePaint, PdfPaint fillPaint, float strokeOpacity, float fillOpacity, int lineWidth) {
        this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        float strokeOnlyLine = 0.0f;
        if (text_fill_type == 1 && (double)lineWidth >= 1.0) {
            strokeOnlyLine = lineWidth;
        }
        PdfGlyph glyph = (PdfGlyph)rawglyph;
        AffineTransform at = this.g2.getTransform();
        double[] affValues = new double[6];
        at.getMatrix(affValues);
        if (glyph != null) {
            this.g2.transform(glyphAT);
            Composite comp = this.g2.getComposite();
            if ((text_fill_type & 2) == 2) {
                if (this.textColor != null && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && BaseDisplay.checkColorThreshold(fillPaint.getRGB())) {
                    fillPaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                fillPaint.setScaling(this.cropX, this.cropH, this.scaling, (float)glyphAT.getTranslateX(), (float)glyphAT.getTranslateY());
                float[][] gtm = new float[][]{{(float)glyphAT.getScaleX(), (float)glyphAT.getShearX(), 0.0f}, {(float)glyphAT.getShearY(), (float)glyphAT.getScaleY(), 0.0f}, {(float)glyphAT.getTranslateX(), (float)glyphAT.getTranslateY(), 1.0f}};
                if (glyph.hasHinting()) {
                    float[] fArray = gtm[0];
                    fArray[0] = fArray[0] / 100.0f;
                    float[] fArray2 = gtm[1];
                    fArray2[1] = fArray2[1] / 100.0f;
                }
                fillPaint.setGlyphMatrix(gtm);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, fillPaint, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, fillPaint, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(fillPaint);
                }
                this.renderComposite(fillOpacity);
                if (glyphType == 6 && !glyph.ignoreColors()) {
                    glyph.setT3Colors(strokePaint, fillPaint, false);
                }
                glyph.render(2, this.g2, this.scaling, false);
                this.g2.setComposite(comp);
                fillPaint.setGlyphMatrix(null);
            }
            if (text_fill_type == 1) {
                glyph.setStrokedOnly(true);
            }
            if (!(DecoderOptions.isRunningOnMac && this.isPrinting && text_fill_type == 3 || (text_fill_type & 1) != 1)) {
                if (strokePaint != null) {
                    if (this.textColor != null && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && BaseDisplay.checkColorThreshold(strokePaint.getRGB())) {
                        strokePaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                    }
                    strokePaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                }
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(strokePaint);
                }
                this.renderComposite(strokeOpacity);
                try {
                    glyph.render(1, this.g2, strokeOnlyLine, false);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                this.g2.setComposite(comp);
            }
            this.g2.setTransform(at);
            this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        }
    }

    void renderShape(Shape defaultClip, int fillType, PdfPaint strokeCol, PdfPaint fillCol, Stroke shapeStroke, Shape currentShape, float strokeOpacity, float fillOpacity) {
        Shape clip = this.g2.getClip();
        Composite comp = this.g2.getComposite();
        if (this.type == 1 && !this.isPrinting && currentShape.getBounds().getWidth() * (double)this.scaling == 1.0 && currentShape.getBounds().getHeight() * (double)this.scaling == 1.0 && ((BasicStroke)shapeStroke).getLineWidth() * this.scaling < 1.0f) {
            currentShape = new Rectangle(currentShape.getBounds().x, currentShape.getBounds().y, 1, 1);
        }
        if (this.useSoftclipForShapes && clip != null && clip.getBounds().getWidth() != 0.0 && clip.getBounds().getHeight() != 0.0 && clip.getBounds().equals(currentShape.getBounds())) {
            AffineTransform origTrans = this.g2.getTransform();
            this.renderShapeWithSoftClip(currentShape, clip, defaultClip, fillType, shapeStroke, strokeOpacity, fillType);
            this.g2.setTransform(origTrans);
            this.g2.setComposite(comp);
            this.g2.setClip(clip);
        } else {
            if (fillType == 2 || fillType == 3) {
                this.fillShape(this.g2, fillOpacity, fillCol, currentShape);
                this.g2.setComposite(comp);
            }
            if (fillType == 1 || fillType == 3) {
                Stroke currentStroke = this.g2.getStroke();
                float[] dashArray = ((BasicStroke)shapeStroke).getDashArray();
                if (dashArray != null) {
                    boolean removeSmallGaps = false;
                    float totalGapLength = 0.0f;
                    for (int i = 0; i != dashArray.length; ++i) {
                        if (i % 2 != 1 || !((double)(dashArray[i] * this.scaling) < 0.75)) continue;
                        dashArray[i] = 0.0f;
                        totalGapLength = dashArray[i] * this.scaling;
                        removeSmallGaps = true;
                    }
                    if (removeSmallGaps) {
                        shapeStroke = BaseDisplay.getStrokeWithoutSmallGaps((BasicStroke)shapeStroke, totalGapLength, dashArray);
                    }
                    currentShape = BaseDisplay.convertShapeToDashSafeShape(currentShape);
                }
                this.strokeShape(this.g2, strokeOpacity, shapeStroke, strokeCol, clip, defaultClip, currentShape);
                this.g2.setStroke(currentStroke);
                this.g2.setComposite(comp);
            }
        }
        this.g2.setClip(clip);
    }

    private static Stroke getStrokeWithoutSmallGaps(BasicStroke shapeStroke, float totalGapLength, float[] dashArray) {
        BasicStroke newStroke;
        if (totalGapLength == 0.0f) {
            newStroke = new BasicStroke(shapeStroke.getLineWidth(), shapeStroke.getEndCap(), shapeStroke.getLineJoin(), shapeStroke.getMiterLimit());
        } else {
            ArrayList<Float> newDashList = new ArrayList<Float>();
            float currentValue = 0.0f;
            for (int i = 0; i != dashArray.length; ++i) {
                if (i % 2 == 1 && dashArray[i] != 0.0f) {
                    newDashList.add(Float.valueOf(currentValue));
                    newDashList.add(Float.valueOf(dashArray[i]));
                    currentValue = 0.0f;
                }
                currentValue += dashArray[i];
            }
            if (currentValue != 0.0f) {
                newDashList.add(Float.valueOf(currentValue));
            }
            float[] newDashArray = new float[newDashList.size()];
            for (int i = 0; i != newDashList.size(); ++i) {
                newDashArray[i] = ((Float)newDashList.get(i)).floatValue();
            }
            newStroke = new BasicStroke(shapeStroke.getLineWidth(), shapeStroke.getEndCap(), shapeStroke.getLineJoin(), shapeStroke.getMiterLimit(), newDashArray, shapeStroke.getDashPhase());
        }
        return newStroke;
    }

    private void renderShapeWithSoftClip(Shape currentShape, Shape clip, Shape defaultClip, int fillType, Stroke shapeStroke, float strokeOpacity, int fillOpacity) {
        GraphicsConfiguration gc = this.g2.getDeviceConfiguration();
        int width = (int)((float)clip.getBounds().width * this.scaling) + 1;
        int height = (int)((float)clip.getBounds().height * this.scaling) + 1;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        BufferedImage softClipImage = gc.createCompatibleImage(width, height, 3);
        Graphics2D localG2 = softClipImage.createGraphics();
        localG2.scale(this.scaling, this.scaling);
        localG2.translate(-clip.getBounds().x, -clip.getBounds().y);
        localG2.setComposite(AlphaComposite.Clear);
        localG2.fillRect(0, 0, softClipImage.getWidth(), softClipImage.getHeight());
        localG2.setComposite(AlphaComposite.Src);
        localG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (fillType == 2 || fillType == 3) {
            this.fillShape(localG2, fillOpacity, this.fillCol, currentShape);
            localG2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (fillType == 1 || fillType == 3) {
            Stroke currentStroke = localG2.getStroke();
            this.strokeShape(localG2, strokeOpacity, shapeStroke, this.strokeCol, clip, defaultClip, currentShape);
            localG2.setStroke(currentStroke);
            localG2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        localG2.setComposite(this.softClipComposite);
        localG2.setColor(Color.WHITE);
        localG2.fill(clip);
        Rectangle2D clipBounds = clip.getBounds2D();
        float clipX1 = (float)clipBounds.getX() - 2.0f;
        float clipY1 = (float)clipBounds.getY() - 2.0f;
        float clipX2 = (float)(clipBounds.getX() + clipBounds.getWidth() + 4.0);
        float clipY2 = (float)(clipBounds.getY() + clipBounds.getHeight() + 4.0);
        Area inverse = new Area(new Rectangle((int)clipX1, (int)clipY1, (int)(clipX2 - clipX1), (int)(clipY2 - clipY1)));
        inverse.subtract(new Area(clip));
        localG2.setComposite(AlphaComposite.Clear);
        localG2.fill(inverse);
        this.g2.setClip(null);
        this.g2.translate(clip.getBounds().x, clip.getBounds().y);
        this.g2.scale(1.0f / this.scaling, 1.0f / this.scaling);
        RenderingHints hints = this.g2.getRenderingHints();
        this.g2.setRenderingHints(new RenderingHints(null));
        this.g2.drawImage((Image)softClipImage, 0, 0, null);
        this.g2.setRenderingHints(hints);
        this.g2.scale(this.scaling, this.scaling);
        this.g2.translate(-clip.getBounds().x, -clip.getBounds().y);
    }

    private static Shape convertShapeToDashSafeShape(Shape currentShape) {
        PathIterator pathIterator = currentShape.getPathIterator(new AffineTransform());
        float[] coords = new float[6];
        Point2D.Float startPoint = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float currentPoint = new Point2D.Float(0.0f, 0.0f);
        Path2D.Float finalPath = new Path2D.Float();
        while (!pathIterator.isDone()) {
            int segmentType = pathIterator.currentSegment(coords);
            Path2D.Float path = new Path2D.Float();
            path.moveTo(((Point2D)currentPoint).getX(), ((Point2D)currentPoint).getY());
            switch (segmentType) {
                case 4: {
                    path.lineTo(((Point2D)startPoint).getX(), ((Point2D)startPoint).getY());
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 3: {
                    path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            currentPoint.setLocation(path.getCurrentPoint());
            if (segmentType == 0) {
                startPoint.setLocation(currentPoint);
            }
            finalPath.append(path, segmentType != 0);
            pathIterator.next();
        }
        return finalPath;
    }

    private void strokeShape(Graphics2D localG2, float strokeOpacity, Stroke shapeStroke, PdfPaint strokeCol, Shape clip, Shape defaultClip, Shape currentShape) {
        if (enhanceFractionalLines && ((BasicStroke)shapeStroke).getLineWidth() * this.scaling < 1.0f && !this.isPrinting && this.type != 9) {
            localG2.setStroke(new BasicStroke(1.0f / this.scaling, ((BasicStroke)shapeStroke).getEndCap(), ((BasicStroke)shapeStroke).getLineJoin(), ((BasicStroke)shapeStroke).getMiterLimit(), ((BasicStroke)shapeStroke).getDashArray(), ((BasicStroke)shapeStroke).getDashPhase()));
        } else {
            localG2.setStroke(shapeStroke);
        }
        if (this.changeLineArtAndText && this.textColor != null && !strokeCol.isPattern() && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && BaseDisplay.checkColorThreshold(strokeCol.getRGB())) {
            strokeCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
        }
        strokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
        if (this.customColorHandler != null) {
            this.customColorHandler.setPaint(localG2, strokeCol, this.rawPageNumber, this.isPrinting);
        } else if (DecoderOptions.Helper != null) {
            DecoderOptions.Helper.setPaint(localG2, strokeCol, this.rawPageNumber, this.isPrinting);
        } else {
            localG2.setPaint(strokeCol);
        }
        this.renderComposite(strokeOpacity);
        if (!this.isPrinting && clip != null && clip.getBounds2D().getWidth() % 1.0 > (double)0.65f && clip.getBounds2D().getHeight() % 1.0 > (double)0.1f && currentShape.getBounds().getWidth() == clip.getBounds().getWidth()) {
            localG2.setClip(ClipUtils.convertPDFClipToJavaClip(new Area(clip)));
        }
        if (!this.isPrinting && clip != null) {
            Double height = clip.getBounds2D().getHeight();
            Double width = clip.getBounds2D().getWidth();
            if (height < 1.0 && height > 0.0 || width < 1.0 && width > 0.0) {
                localG2.setClip(defaultClip);
            }
        }
        localG2.draw(currentShape);
    }

    private void fillShape(Graphics2D localG2, float fillOpacity, PdfPaint fillCol, Shape currentShape) {
        if (fillCol != null) {
            if (fillCol.getRGB() != -1 && this.changeLineArtAndText && this.textColor != null && !fillCol.isPattern() && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && BaseDisplay.checkColorThreshold(fillCol.getRGB())) {
                fillCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
            }
            fillCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
        }
        if (this.customColorHandler != null) {
            this.customColorHandler.setPaint(localG2, fillCol, this.rawPageNumber, this.isPrinting);
        } else if (DecoderOptions.Helper != null) {
            DecoderOptions.Helper.setPaint(localG2, fillCol, this.rawPageNumber, this.isPrinting);
        } else {
            localG2.setPaint(fillCol);
        }
        this.renderComposite(fillOpacity);
        try {
            double iw = currentShape.getBounds2D().getWidth();
            double ih = currentShape.getBounds2D().getHeight();
            if ((ih == 0.0 || iw == 0.0) && ((BasicStroke)localG2.getStroke()).getLineWidth() <= 1.0f) {
                localG2.fillRect(currentShape.getBounds().x, currentShape.getBounds().y, currentShape.getBounds().width, currentShape.getBounds().height);
            } else {
                localG2.fill(currentShape);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " filling shape");
        }
    }

    void renderImage(AffineTransform imageAf, BufferedImage img, float alpha, GraphicsState currentGraphicsState, float x, float y) {
        BufferedImage newImage;
        boolean useCustomRenderer;
        AffineTransform upside_down;
        boolean renderDirect;
        BufferedImage image = img;
        boolean bl = renderDirect = currentGraphicsState != null;
        if (image == null || this.g2 == null) {
            return;
        }
        AffineTransform before = this.g2.getTransform();
        Composite c = this.g2.getComposite();
        this.renderComposite(alpha);
        float[][] CTM = new float[3][3];
        if (currentGraphicsState != null) {
            CTM = currentGraphicsState.CTM;
        } else {
            double[] values = new double[6];
            imageAf.getMatrix(values);
            CTM[0][0] = (float)values[0];
            CTM[0][1] = (float)values[1];
            CTM[1][0] = (float)values[2];
            CTM[1][1] = (float)values[3];
            CTM[2][0] = x;
            CTM[2][1] = y;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        double[] values = new double[]{CTM[0][0] / (float)w, CTM[0][1] / (float)w, -CTM[1][0] / (float)h, -CTM[1][1] / (float)h, 0.0, 0.0};
        double sx = Math.abs(before.getScaleX());
        double sy = Math.abs(before.getScaleY());
        int dw = (int)Math.round(Math.abs((double)CTM[0][0] * sx));
        int dh = (int)Math.round(Math.abs((double)CTM[1][1] * sy));
        RenderingHints rh = this.g2.getRenderingHints();
        if ((this.fromPattern || this.useConvolution) && values[1] == 0.0 && values[2] == 0.0 && dw > 4 && dh > 4 && Math.abs(values[0]) < 0.5 && Math.abs(values[3]) < 0.5) {
            image = BaseDisplay.getScaledImage(image, dw, dh);
            values = new double[]{(double)(CTM[0][0] / Math.abs(CTM[0][0])) / sx, 0.0, 0.0, (double)(-CTM[1][1] / Math.abs(CTM[1][1])) / sy, 0.0, 0.0};
            upside_down = new AffineTransform(values);
            this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else {
            upside_down = new AffineTransform(values);
        }
        this.g2.translate(CTM[2][0] + CTM[1][0], CTM[2][1] + CTM[1][1]);
        boolean bl2 = useCustomRenderer = this.customImageHandler != null;
        if (useCustomRenderer && (useCustomRenderer = this.customImageHandler.drawImageOnscreen(image, 0, upside_down, null, this.g2, renderDirect, this.objectStoreRef, this.isPrinting))) {
            this.g2.setComposite(c);
            return;
        }
        if (this.customColorHandler != null) {
            newImage = this.customColorHandler.processImage(image, this.rawPageNumber, this.isPrinting);
            if (newImage != null) {
                image = newImage;
            }
        } else if (DecoderOptions.Helper != null && (newImage = DecoderOptions.Helper.processImage(image, this.rawPageNumber, this.isPrinting)) != null) {
            image = newImage;
        }
        Shape g2clip = this.g2.getClip();
        if (g2clip != null) {
            boolean isSimpleOutline;
            double cy = g2clip.getBounds2D().getY();
            double ch = g2clip.getBounds2D().getHeight();
            double diff = (double)image.getHeight() - ch;
            if (diff < 0.0) {
                diff = -diff;
            }
            if (diff > 0.0 && diff < 1.0 && cy < 0.0 && image.getHeight() > 1 && image.getHeight() < 10 && (isSimpleOutline = ShapeUtils.isSimpleOutline(g2clip))) {
                double cx = g2clip.getBounds2D().getX();
                double cw = g2clip.getBounds2D().getWidth();
                this.g2.setClip(new Rectangle((int)cx, (int)cy, (int)cw, (int)ch));
            }
        }
        this.g2.drawImage(image, upside_down, null);
        this.g2.setTransform(before);
        this.g2.setComposite(c);
        this.g2.setRenderingHints(rh);
    }

    @Override
    public void setScalingValues(double cropX, double cropH, float scaling) {
        this.cropX = cropX;
        this.cropH = cropH;
        this.scaling = scaling;
    }

    @Override
    public byte[] serializeToByteArray(Set<String> fontsAlreadyOnClient) throws IOException {
        return new byte[0];
    }

    @Override
    public void drawShape(PdfShape pdfShape, GraphicsState currentGraphicsState, int cmd) {
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] at, String glyf, PdfFont currentFontData, float glyfWidth) {
    }

    @Override
    public void paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int previousUse) {
        return -1;
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
    }

    @Override
    public void setGraphicsState(int fillType, float value, int BM) {
    }

    @Override
    public void drawTR(int value) {
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean alwaysDraw) {
    }

    @Override
    public void writeCustom(int key, Object value) {
        switch (key) {
            case 7: {
                this.customImageHandler = (ImageHandler)value;
                break;
            }
            case 8: {
                this.customColorHandler = (ColorHandler)value;
                break;
            }
            case 41: {
                this.paintBackground((Shape)value);
            }
        }
    }

    @Override
    public void setValue(int key, int i) {
        switch (key) {
            case 1: {
                this.backgroundColor = new Color(i);
                break;
            }
            case 2: {
                this.textColor = new Color(i);
                break;
            }
            case 3: {
                this.changeLineArtAndText = i > 0;
                break;
            }
            case 4: {
                colorThresholdToReplace = i;
                break;
            }
            case 5: {
                enhanceFractionalLines = i != 0;
                break;
            }
            case 6: {
                this.currentTokenNumber = i;
                break;
            }
            case 9: {
                this.useSoftclipForShapes = i != 0;
                break;
            }
            case 10: {
                this.useConvolution = i != 0;
            }
        }
    }

    @Override
    public int getValue(int key) {
        switch (key) {
            case 6: {
                return this.currentTokenNumber;
            }
        }
        return -1;
    }

    @Override
    public boolean getBooleanValue(int key) {
        return false;
    }

    @Override
    public void saveAdvanceWidth(int fontObjID, String s, int potentialWidth) {
    }

    @Override
    public void drawShape(Object currentShape, GraphicsState currentGraphicsState) {
        System.out.println("drawShape in BaseDisplay Should never be called");
    }

    @Override
    public void eliminateHiddenText(Shape currentShape, GraphicsState gs, int count, boolean ignoreScaling) {
    }

    void renderComposite(float alpha) {
        BaseDisplay.renderComposite(this.g2, alpha, this.blendMode);
    }

    private static void renderComposite(Graphics2D localG2, float alpha, int localBM) {
        if (localBM == 1111314299 || localBM == 1987215544) {
            if (alpha != 1.0f) {
                localG2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
        } else {
            BlendMode comp = new BlendMode(localBM, alpha);
            localG2.setComposite(comp);
        }
    }

    @Override
    public boolean isHTMLorSVG() {
        return false;
    }

    private static BufferedImage getScaledImage(BufferedImage srcImage, int destWidth, int destHeight) {
        int sw = srcImage.getWidth();
        int sh = srcImage.getHeight();
        ColorModel cm = srcImage.getColorModel();
        int nComp = cm.getNumComponents();
        if (destWidth == sw && destHeight == sh) {
            return srcImage;
        }
        if (destHeight < 4 || destWidth < 4 || sw < 4 || sh < 4) {
            return BaseDisplay.getCubicScaled(srcImage, destWidth, destHeight);
        }
        switch (srcImage.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, srcImage.getType());
                int[] inPixels = ((DataBufferInt)srcImage.getRaster().getDataBuffer()).getData();
                int[] outPixels = ((DataBufferInt)destImage.getRaster().getDataBuffer()).getData();
                BaseDisplay.doIntFilter(inPixels, outPixels, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
            case 5: 
            case 6: 
            case 10: {
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, srcImage.getType());
                byte[] inBytes = ((DataBufferByte)srcImage.getRaster().getDataBuffer()).getData();
                byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
                BaseDisplay.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
            case 12: {
                BufferedImage grayImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 10);
                grayImage.createGraphics().drawImage((Image)srcImage, 0, 0, null);
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, grayImage.getType());
                byte[] inBytes = ((DataBufferByte)grayImage.getRaster().getDataBuffer()).getData();
                byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
                nComp = 1;
                BaseDisplay.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
        }
        BufferedImage colImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 6);
        colImage.createGraphics().drawImage((Image)srcImage, 0, 0, null);
        BufferedImage destImage = new BufferedImage(destWidth, destHeight, colImage.getType());
        byte[] inBytes = ((DataBufferByte)colImage.getRaster().getDataBuffer()).getData();
        byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
        nComp = 4;
        BaseDisplay.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
        return destImage;
    }

    private static BufferedImage getCubicScaled(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, 3);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }

    private static void doIntFilter(int[] inPixels, int[] outPixels, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp) {
        WeightBox horizontalBox = BaseDisplay.generateWeightBox(srcWidth, dstWidth);
        WeightBox verticalBox = BaseDisplay.generateWeightBox(srcHeight, dstHeight);
        BaseDisplay.doIntScaling(inPixels, outPixels, srcWidth, srcHeight, dstWidth, dstHeight, nComp, horizontalBox, verticalBox);
    }

    private static void doByteFilter(byte[] inBytes, byte[] outBytes, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp) {
        WeightBox horizontalBox = BaseDisplay.generateWeightBox(srcWidth, dstWidth);
        WeightBox verticalBox = BaseDisplay.generateWeightBox(srcHeight, dstHeight);
        BaseDisplay.doByteScaling(inBytes, outBytes, srcWidth, srcHeight, dstWidth, dstHeight, nComp, horizontalBox, verticalBox);
    }

    private static WeightBox generateWeightBox(int srcSize, int dstSize) {
        int[] pixels;
        float[] weights;
        int nContr;
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = 3.0f;
        if (scale < 1.0f) {
            float width = 3.0f / scale;
            nContr = (int)(width * 2.0f + 2.0f);
            weights = new float[dstSize * nContr];
            pixels = new int[dstSize * nContr];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / 3.0));
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * nContr;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (int j = left; j <= right; ++j) {
                    float weight = BaseDisplay.apply((center - (float)j) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k2 = arrN[i];
                    int n2 = i;
                    arrN[n2] = arrN[n2] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    pixels[subindex + k2] = n;
                    weights[subindex + k2] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += weights[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    weights[n] = weights[n] / tot;
                }
            }
        } else {
            float width = 3.0f * scale;
            nContr = (int)(width * 2.0f + 2.0f);
            weights = new float[dstSize * nContr];
            pixels = new int[dstSize * nContr];
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * nContr;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - 3.0f);
                int right = (int)Math.ceil(center + 3.0f);
                for (int j = left; j < right; ++j) {
                    float weight = BaseDisplay.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k3 = arrN[i];
                    int n3 = i;
                    arrN[n3] = arrN[n3] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    pixels[subindex + k3] = n;
                    weights[subindex + k3] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += weights[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    weights[n] = weights[n] / tot;
                }
            }
        }
        return new WeightBox(arrN, pixels, weights, nContr);
    }

    private static void doIntScaling(int[] inPixels, int[] outPixels, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nc, WeightBox horizontalBox, WeightBox verticalBox) {
        int sDim = srcWidth * srcHeight;
        int dDim = dstWidth * dstHeight;
        byte[] srcBytes = new byte[srcWidth * srcHeight];
        byte[] dstBytes = new byte[dstWidth * dstHeight];
        for (int i = 0; i < nc; ++i) {
            int j;
            int shift = 8 * (nc - i - 1);
            for (j = 0; j < sDim; ++j) {
                srcBytes[j] = (byte)(inPixels[j] >> shift & 0xFF);
            }
            BaseDisplay.doByteScaling(srcBytes, dstBytes, srcWidth, srcHeight, dstWidth, dstHeight, 1, horizontalBox, verticalBox);
            for (j = 0; j < dDim; ++j) {
                int n = j;
                outPixels[n] = outPixels[n] | (dstBytes[j] & 0xFF) << shift;
            }
        }
    }

    private static void doByteScaling(byte[] inBytes, byte[] outBytes, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp, WeightBox horizontalBox, WeightBox verticalBox) {
        int[] tempPixels = new int[srcWidth];
        byte[] srcPixels = new byte[srcWidth * nComp];
        int stripLen = dstWidth * nComp;
        byte[] dstPixels = new byte[dstWidth * nComp];
        byte[] workPixels = new byte[srcHeight * dstWidth * nComp];
        byte[] hasVisited = new byte[srcHeight];
        for (int dstY = 0; dstY < dstHeight; ++dstY) {
            int pos;
            long sample;
            int nc;
            int j;
            int yTimesNumContributors = dstY * verticalBox.numContributors;
            int max = verticalBox.ns[dstY];
            int index = yTimesNumContributors;
            for (j = 0; j < max; ++j) {
                int vLoc = verticalBox.pixels[index++];
                if (hasVisited[vLoc] != 0) continue;
                hasVisited[vLoc] = 1;
                int vsnc = vLoc * stripLen;
                BaseDisplay.getBytePixels(inBytes, vLoc, srcWidth, srcPixels, nComp);
                for (nc = 0; nc < nComp; ++nc) {
                    BaseDisplay.getHorizontalCompsBytes(srcPixels, nc, tempPixels, nComp);
                    for (int i = 0; i < dstWidth; ++i) {
                        int hMax = horizontalBox.ns[i];
                        sample = 0L;
                        int hIndex = i * horizontalBox.numContributors;
                        for (int jj = 0; jj < hMax; ++jj) {
                            sample += (long)tempPixels[horizontalBox.pixels[hIndex]] * horizontalBox.weights[hIndex];
                            ++hIndex;
                        }
                        pos = vsnc + i * nComp + nc;
                        BaseDisplay.clamp(workPixels, pos, sample);
                    }
                }
            }
            for (int x = 0; x < dstWidth; ++x) {
                int xLoc = x * nComp;
                for (nc = 0; nc < nComp; ++nc) {
                    sample = 0L;
                    int ix = yTimesNumContributors;
                    for (j = 0; j < max; ++j) {
                        pos = verticalBox.pixels[ix] * stripLen + xLoc + nc;
                        sample += (long)(workPixels[pos] & 0xFF) * verticalBox.weights[ix];
                        ++ix;
                    }
                    pos = nc + xLoc;
                    BaseDisplay.clamp(dstPixels, pos, sample);
                }
            }
            BaseDisplay.setBytePixels(dstPixels, outBytes, dstY, dstWidth, nComp);
        }
    }

    private static void clamp(byte[] image, int pos, long sample) {
        image[pos] = (byte)((sample /= 0xFFFFFFFFFFL) < 0L ? 0 : (byte)(sample > 255L ? -1 : (byte)sample));
    }

    private static void getHorizontalCompsBytes(byte[] src, int channel, int[] dest, int nComp) {
        int nc = channel;
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = src[nc] & 0xFF;
            nc += nComp;
        }
    }

    private static void getBytePixels(byte[] inPixels, int y, int w, byte[] array, int nComp) {
        int bp = y * w * nComp;
        System.arraycopy(inPixels, bp, array, 0, array.length);
    }

    private static void setBytePixels(byte[] dstPixels, byte[] outPixels, int dstY, int dstWidth, int nComp) {
        int dstPointer = dstY * dstWidth * nComp;
        System.arraycopy(dstPixels, 0, outPixels, dstPointer, dstWidth * nComp);
    }

    private static float apply(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            float pv = (float)Math.PI * value;
            return (float)(3.0 * Math.sin(pv) * Math.sin((double)pv / 3.0) / (double)(9.869605f * value * value));
        }
        return 0.0f;
    }

    static {
        colorThresholdToReplace = 255;
        enhanceFractionalLines = true;
    }

    private static final class WeightBox {
        private final int[] ns;
        private final int[] pixels;
        private final long[] weights;
        private final int numContributors;

        private WeightBox(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors) {
            this.ns = arrN;
            this.pixels = arrPixel;
            this.weights = new long[arrWeight.length];
            this.numContributors = numContributors;
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = (long)((double)arrWeight[i] * 1.0 * 1.099511627775E12);
            }
        }
    }
}

